#include <stream.h>
#include <fcntl.h>
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSP/sysconst.h"
#include "ObjProDSP/sysintfc.h"
#include "ObjProGui/yacintfc.h"
#include "ObjProDSPcom/vocstrf.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/vocstr.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * VoiceStripOutNodeList = 0 ;
static InteractiveEntity * IntEntVoiceStripOut ;
void VoiceStripOutNodesInit();
VoiceStripOut::VoiceStripOut (const char * Name, const char * FileName):
	DisplayNodeStr(Name, 1, 1, 
	 new StreamStr(SizeVariable , SizeVariable , ArithType::ArithCapabilityAny), TimingTypeLinear)
,
	FileName_1(FileName)
{
	if (!VoiceStripOutNodeList) VoiceStripOutNodesInit() ;
	VoiceStripOutNodeList->Append(MakeDeclaredEntity(this, IntEntVoiceStripOut)) ;
	InitArithType(TheArithType);
	NewMenuItem("VoiceStripOut",GetName());
#line 75 "../vocstr.usr"
 
	to_delete = 0 ;
	TheOutputFile = 0 ;
	TheOutputFile = new VoiceStripOutputFile(GetName(),GetFileName());
	if (!TheOutputFile->CreateOK()) {
		delete TheOutputFile ;
		TheOutputFile = 0 ;
		FileName_1 = (GetFileName() ? GetFileName() : GetName()) ;
		node_state = OK ;
		return ;
	}
	FileName_1 = TheOutputFile->get_file_name();
	node_state = OK ;
#line 48 "../vocstr.cxx"
} // end constructor

ErrCode VoiceStripOut::EmitStaticCtorParameters(OutTokens& Out)
{
	ostream& Outs = *(Out.GetStream());
	Outs << ",\n\tVoiceStripOutStaticInitbinary_read_flag_" << GetName() << "";
	return OK;
}

ErrCode VoiceStripOut::EmitStaticInit(OutTokens& Out)
{
	ostream& Outs = *(Out.GetStream());
	Outs << "static int VoiceStripOutStaticInitbinary_read_flag_" << GetName() << " = ";	
	OutStringStaticValue(Outs,"int", &(binary_read_flag)) ;

	Outs << ";\n";
	return OK;
}

VoiceStripOut::~VoiceStripOut()
{
	TheMenuServer->DeleteMenuItem("VoiceStripOut",GetName());
	VoiceStripOutNodeList->Delete(GetName()) ;
#line 90 "../vocstr.usr"
 
	delete TheOutputFile ;
	// LogOut << "outputfile deleted\n" ;
	delete to_delete ;
#line 77 "../vocstr.cxx"
} // end destructor

int VoiceStripOut::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

double VoiceStripOut::TimeFirst( DfNodeInLink * , DfNodeOutLink * )
{
#line 127 "../vocstr.usr"
	return 0.0;
	// timing is irrelevant for a node with no output channels
#line 92 "../vocstr.cxx"
} // end timing code

VoiceStripOut * VoiceStripOutDef;

ErrCode VoiceStripOut::DoNode(int32 k)
{
#line 131 "../vocstr.usr"
 
	if (node_state >= EndOfData) return node_state ;
	if (!TheOutputFile) {
		TheOutputFile = new VoiceStripOutputFile(GetName(),GetFileName());
		if (!TheOutputFile->CreateOK()) {
			delete TheOutputFile ;
			TheOutputFile = 0 ;
			return node_state = FatalError ;
		}
		FileName_1 = TheOutputFile->get_file_name();
	}
	for (int i = 0 ; i < k ; i++)
	 for (int b = 0 ; b < GetBlockSize(); b++)
	  for (int l = 0 ; l < GetInEltSize(); l++) {
		MachWord word  ;
		if (binary_read_flag) word = ReadInteger();
		else word = ReadWord();
		if (TheOutputFile->Write(word)!=OK)
		return node_state = FatalError ;
	}
	return OK ;
#line 121 "../vocstr.cxx"
} // end kernel code

static UserEntity * MakeVoiceStripOut(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int VoiceStripOut::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntVoiceStripOut->CppList(Out,Cmd,this);
}

void VoiceStripOut::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeVoiceStripOut(Out,EntityReqDescribeFull,*IntEntVoiceStripOut, (ArithType::ArithCapabilities) TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("FileName");
		Out.NextQuoteOut(GetFileName());
		Out.NextFillOut("is the file");
		Out.NextFillOut("to be created. If no default(0) is given");
		Out.NextFillOut("the node name will be used.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntVoiceStripOut->GetOneParameter("FileName")->
			StringP->CurrentValue = FileName_1;
		break;
	}
} // end  list entity switch

void VoiceStripOutNodesInit()
{
	if (VoiceStripOutNodeList)  return ;

	static StringParam VoiceStripOutNameParam =
		{"VoiceStripOut", MakeNewEntityName, 0, LegalEntityName};
	static StringParam VoiceStripOutFileNameParam = {
		 0, 0, 0};

	static OneParameter VoiceStripOutParArray[] = {
		{"Name", 0, "node name", 0, 0, &VoiceStripOutNameParam},
		{"FileName", 0, 
			"file to create",
			0, 0, &VoiceStripOutFileNameParam},
		{0}
	};

	VoiceStripOutNodeList = new EntityList;
	IntEntVoiceStripOut = new InteractiveEntity("VoiceStripOut", VoiceStripOutNodeList,
		MakeVoiceStripOut, InteractiveNode, "vocstr.h",
		0, "DisplayNodeStr");
	IntEntVoiceStripOut->SetParameters(new UserParameters(VoiceStripOutParArray));
	TheNodes->Append(IntEntVoiceStripOut);
} // end initalization

static UserEntity * MakeVoiceStripOut(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("VoiceStripOut");
		Out.NextFillOut("writes its input to disk file");
		Out.NextQuoteOut("FileName");
		Out.NextFillOut("in Creative Voice file format but with no header.");
		Out.NextFillOut("This format has one sample per");
		Out.NextFillOut("each byte in offset format, i. e. 128 is added");
		Out.NextFillOut("to each input sample. (After this sum any value < 0 is");
		Out.NextFillOut("set to 0 and any value > 255 is set to 255 producing");
		Out.NextFillOut("hard limit on overflows.");
		Out.NextFillOut("In the 16 bit integer simulator you will probably need");
		Out.NextFillOut("to rescale the data (most likely by dividing by 128)");
		Out.NextFillOut("before processing it.");
		Out.NextFillOut("Input can be");
		Out.NextFillOut("`MachWord'");
		Out.NextFillOut("or");
		Out.NextFillOut("`IntegerMachWord'");
		Out.NextFillOutConcat(". (");
		Out.NextFillOutConcat("`IntegerMachWord'");
		Out.NextFillOut("values");
		Out.NextFillOut("are treated as signed integers.)");
		Out.NextFillOut("Input have any value for");
		Out.NextFillOut("`BlockSize'");
		Out.NextFillOut("and sample size (");
		Out.NextFillOutConcat("`ElementSize'");
		Out.NextFillOutConcat(") but");
		Out.NextFillOut("these values will not be recorded in the file as they are");
		Out.NextFillOut("with");
		Out.NextFillOut("`OutputNode'");
		Out.NextFillOutConcat(".");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		const char * FileName =
			IntNode.GetStringParameterValue("FileName");
		return new VoiceStripOut(Name, FileName);

	}
	}
	return 0;
}

static InitObj LocalInit(VoiceStripOutNodesInit, "VoiceStripOut", "DisplayNodeStr");

