/*  fftutil.C   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "cxfft.h"
#include "ObjProArith/hrdarth.h"
#include "ObjProDSP/portable.h"
#include "ObjProComGui/cgidbg.h"
#include "ObjProGui/strmstr.h"
#include "ObjProUsr/cxfft.h"

#ifdef INTERACTIVE
StreamStr * CxFFT::FftStreamStr(int Elements, int LogSize,
	double CenterFreq, double Overlap)
{
	
	int32 Size = CxFFT::FftSize(LogSize);
	int32 IndexStart = CxFFT::index_start(Size,CenterFreq);

	double Lower = IndexStart - Size ;
	double Upper = Size - IndexStart + 1 ;
	// LogOut<<"FftStreamStr, Lower = "<<Lower<<", Upper = "<<Upper << "\n" ;
	double SampleRateFactor ;
	if (Overlap < 0.0) {
		// LogOut << "Negative Ovelap *******\n" ;
		SampleRateFactor = 1.0 ;
	} else
	if (Overlap >= 1.0) SampleRateFactor = double (Size - 1) / Size ;
	else SampleRateFactor =  1. - Overlap ;
	return new StreamStr(Elements,Size,Lower,Upper,SampleRateFactor);
}

#endif


CxMachWord CxFFT::ComplexToCxMachWord(complex& val)
{
	CxMachWord Return((MachWord) real(val), (MachWord) imag(val));
	return Return ;
}

int32 CxFFT::FftSize(int LogSize)
{
	return 1 << LogSize ;
}

int32 CxFFT::FftOverlap(double Overlap,int LogSize)
{
	int32 Size = FftSize(LogSize) ;
	if (Overlap >= 1.) return Size -1 ;
	int32 Return = (int32) (Overlap * Size) ;
	// LogOut << "FftOverlap:Return = " << Return << "\n" ;
	return Return ;
}


