#include <stream.h>
#include "ObjProGen/newaloc.h"
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSPint/netlnk.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/intrpol.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * InterpolateNodeList = 0 ;
static InteractiveEntity * IntEntInterpolate ;
void InterpolateNodesInit();
Interpolate::Interpolate (const char * Name, int16 DeltaIn, int16 DeltaOut):
	ProcessNodeStr(Name, 1, 1,  new StreamStr(StreamNotSet), 
	new StreamStr(StreamNotSet), 0, DeltaIn, DeltaOut, 1, 0, TimingTypeLinear)
,
	DeltaIn_1(DeltaIn),
	DeltaOut_2(DeltaOut)
{
	if (!InterpolateNodeList) InterpolateNodesInit() ;
	InterpolateNodeList->Append(MakeDeclaredEntity(this, IntEntInterpolate)) ;
	InitArithType(TheArithType);
	NewMenuItem("Interpolate",GetName());
#line 52 "../intrpol.usr"
 
	ctor();
#line 35 "../intrpol.cxx"
} // end constructor

Interpolate::~Interpolate()
{
	TheMenuServer->DeleteMenuItem("Interpolate",GetName());
	InterpolateNodeList->Delete(GetName()) ;
#line 56 "../intrpol.usr"
 
	dtor();
#line 45 "../intrpol.cxx"
} // end destructor

int Interpolate::CheckSafeDelete()
{
	int Safe_Check_Return = UserEntity::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

Interpolate * InterpolateDef;

ErrCode Interpolate::DoNode(int32 k)
{
#line 75 "../intrpol.usr"
 
	return kernel(k) ;
#line 62 "../intrpol.cxx"
} // end kernel code

static UserEntity * MakeInterpolate(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int Interpolate::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntInterpolate->CppList(Out,Cmd,this);
}

void Interpolate::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeInterpolate(Out,EntityReqDescribeFull,*IntEntInterpolate, (ArithType::ArithCapabilities) TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("DeltaIn");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetDeltaIn()));
		Out.NextFillOut(")");
		Out.NextFillOut("is the number of input samples");
		Out.NextFillOut("for");
		Out.NextQuoteOut("DeltaOut");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetDeltaOut()));
		Out.NextFillOut(")");
		Out.NextFillOut("output samples.");
		Out.NextQuoteOut("DeltaOut");
		Out.NextFillOut("is the number of output samples");
		Out.NextFillOut("generated from");
		Out.NextQuoteOut("DeltaIn");
		Out.NextFillOut("input samples.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntInterpolate->GetOneParameter("DeltaIn")->
			IntP->CurrentValue = DeltaIn_1;
		IntEntInterpolate->GetOneParameter("DeltaOut")->
			IntP->CurrentValue = DeltaOut_2;
		break;
	}
} // end  list entity switch

void InterpolateNodesInit()
{
	if (InterpolateNodeList)  return ;

	static StringParam InterpolateNameParam =
		{"Interpolate", MakeNewEntityName, 0, LegalEntityName};
	static IntParam InterpolateDeltaInParam = {
		 1, 0,  0,  1, 0, 32767};
	static IntParam InterpolateDeltaOutParam = {
		 1, 0,  0,  1, 0, 32767};

	static OneParameter InterpolateParArray[] = {
		{"Name", 0, "node name", 0, 0, &InterpolateNameParam},
		{"DeltaIn", 0, 
			"input samples for each `DeltaOut' outputs",
			&InterpolateDeltaInParam},
		{"DeltaOut", 0, 
			"output samples for each `DeltaIn' inputs",
			&InterpolateDeltaOutParam},
		{0}
	};

	InterpolateNodeList = new EntityList;
	IntEntInterpolate = new InteractiveEntity("Interpolate", InterpolateNodeList,
		MakeInterpolate, InteractiveNode, "intrpol.h",
		0, "ProcessNodeStr");
	IntEntInterpolate->SetParameters(new UserParameters(InterpolateParArray));
	TheNodes->Append(IntEntInterpolate);
} // end initalization

static UserEntity * MakeInterpolate(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("Interpolate");
		Out.NextFillOut("does linear interpolation and sample rate conversion.");
		Out.NextFillOut("Each element in a sample is interpolated independently, i. e. for");
		Out.NextFillOut("a complex data stream the real and imaginary parts are interpolated");
		Out.NextFillOut("independently.");
		Out.NextFillOut("For every");
		Out.NextQuoteOut("DeltaIn");
		Out.NextFillOut("input samples");
		Out.NextQuoteOut("DeltaOut");
		Out.NextFillOut("output samples are written.");
		Out.NextFillOut("Output samples that fall between input samples are computed by linear");
		Out.NextFillOut("interpolation between the two nearest neighbors.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		int16 DeltaIn =
			IntNode.GetIntParameterValue("DeltaIn");
		int16 DeltaOut =
			IntNode.GetIntParameterValue("DeltaOut");
		return new Interpolate(Name, DeltaIn, DeltaOut);

	}
	}
	return 0;
}

static InitObj LocalInit(InterpolateNodesInit, "Interpolate", "ProcessNodeStr");

