#include <complex.h>
#include <signal.h>
#include "ObjProDSP/portable.h"
#include "ObjProComGui/usercom.h"
#include "ObjProArith/hrdarth.h"
#include "ObjProArithGen/arthfnc.h"
#include "ObjProComGui/cgidbg.h"
#include "ObjProArithGen/artherr.h"
#include "ObjProDSPint/netlnk.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/toint.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * ToIntegerNodeList = 0 ;
static InteractiveEntity * IntEntToInteger ;
void ToIntegerNodesInit();
ToInteger::ToInteger (const char * Name):
	ProcessNodeStr(Name, 1, 1, new StreamStr(StreamNotSet), 
	 new StreamStr(SizeVariable , SizeVariable , (ArithType::ArithCapabilities)ArithType::ArithInt32), 0, 1, 1, 0, 0, TimingTypeLinear)

{
	if (!ToIntegerNodeList) ToIntegerNodesInit() ;
	ToIntegerNodeList->Append(MakeDeclaredEntity(this, IntEntToInteger)) ;
	InitArithType(TheArithType);
	NewMenuItem("ToInteger",GetName());
#line 29 "../toint.usr"
 
	const double over_max_32 =  0x7fffffff ;
    over_max = (int32) over_max_32 ;
    over_min = (int32)  -over_max ;
    // LogOut << "over_max = " << over_max << ", over_min = " << over_min << "\n" ;
#line 41 "../toint.cxx"
} // end constructor

ToInteger::~ToInteger()
{
	TheMenuServer->DeleteMenuItem("ToInteger",GetName());
	ToIntegerNodeList->Delete(GetName()) ;
} // end destructor

int ToInteger::CheckSafeDelete()
{
	int Safe_Check_Return = UserEntity::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
#line 37 "../toint.usr"
 
	return 1 ;
#line 57 "../toint.cxx"
} // end check safe delete

ToInteger * ToIntegerDef;

ErrCode ToInteger::DoNode(int32 k)
{
#line 54 "../toint.usr"
 
	int32 left = k * GetBlockSize() * GetEltSize();
	int32 in = 0 ;
	int32 out= 0 ;
	do {
		if (!in) in = GetContiguousAvailableData();
		const MachWord * pin = GetReadPtr();
		if (!out) out = GetContiguousSpace();
		BinMachWord * pout = GetBinWritePtr();
		int32 to_do =  left ;
		if (to_do > in) to_do = in ;
		if (to_do > out) to_do = out ;
		if (to_do < 1) break ;
		for (int32 i = 0 ; i < to_do; i++) {
			float temp = pin[i] ;
			int over_flow = 0 ;
            int sign = temp >= 0  ;
            float abs_temp = (sign ? temp : -temp)  ;
            if (abs_temp > over_max) over_flow = 1 ;
            if (!over_flow) {
                int32 val = (int32) (MachWordCast) abs_temp ;
                if (sign) pout[i] = val ;
                else pout[i] = -val ;
                continue ;
            }
            if (sign) pout[i] = over_max ;
            else pout[i] = over_min;
		}
		in -=to_do ;
		out -=to_do ;
		left -=to_do ;
		UpdateRead(to_do);
		UpdateWrite(to_do);
	} while (left);
	return OK ;
#line 100 "../toint.cxx"
} // end kernel code

static UserEntity * MakeToInteger(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int ToInteger::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntToInteger->CppList(Out,Cmd,this);
}

void ToInteger::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeToInteger(Out,EntityReqDescribeFull,*IntEntToInteger, (ArithType::ArithCapabilities) TheArithType);
		Out.NewLine();
		Out.NextFillOut("There are no parameters for the constructor of this class.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		break;
	}
} // end  list entity switch

void ToIntegerNodesInit()
{
	if (ToIntegerNodeList)  return ;

	static StringParam ToIntegerNameParam =
		{"ToInteger", MakeNewEntityName, 0, LegalEntityName};

	static OneParameter ToIntegerParArray[] = {
		{"Name", 0, "node name", 0, 0, &ToIntegerNameParam},
		{0}
	};

	ToIntegerNodeList = new EntityList;
	IntEntToInteger = new InteractiveEntity("ToInteger", ToIntegerNodeList,
		MakeToInteger, InteractiveNode, "toint.h",
		0, "ProcessNodeStr");
	IntEntToInteger->SetParameters(new UserParameters(ToIntegerParArray));
	TheNodes->Append(IntEntToInteger);
} // end initalization

static UserEntity * MakeToInteger(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("ToInteger");
		Out.NextFillOut("converts a MachWord data stream to integer format.");
		Out.NextFillOut("The inverse operation can be done with node `ToMachWord'.");
		Out.NextFillOut("This class is not available with the 16 bit arithmetic version");
		Out.NextFillOut("of ObjectProDSP. Saturated output is produced on overflow.");
		Out.NextFillOut("Overflows are not reported.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		return new ToInteger(Name);

	}
	}
	return 0;
}

static InitObj LocalInit(ToIntegerNodesInit, "ToInteger", "ProcessNodeStr");

