#include <stream.h>
#include <fcntl.h>
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSP/sysconst.h"
#include "ObjProDSP/sysintfc.h"
#include "ObjProGui/yacintfc.h"
#include "ObjProDSPcom/binfile.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/inword.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * InputWordNodeList = 0 ;
static InteractiveEntity * IntEntInputWord ;
void InputWordNodesInit();
InputWord::InputWord (const char * Name, const char * FileName, int16 FormatIn, 
		int16 IntegerOut, int32 InitialSkip, int16 ElementSize, 
		int32 BlockSize):
	SignalStr(Name, 1, 
	 new StreamStr(ElementSize , BlockSize , (ArithType::ArithCapabilities)(IntegerOut ? (TheArithType == ArithType::ArithInt16 ? ArithType::ArithInt16 : ArithType::ArithInt32) : TheArithType)), 1, TimingTypeLinear)
,
	FileName_1(FileName),
	FormatIn_2(FormatIn),
	IntegerOut_3(IntegerOut),
	InitialSkip_4(InitialSkip),
	ElementSize_5(ElementSize),
	BlockSize_6(BlockSize)
{
	if (!InputWordNodeList) InputWordNodesInit() ;
	InputWordNodeList->Append(MakeDeclaredEntity(this, IntEntInputWord)) ;
	InitArithType(TheArithType);
	NewMenuItem("InputWord",GetName());
#line 110 "../inword.usr"
 
	ctor();
#line 44 "../inword.cxx"
} // end constructor

ErrCode InputWord::EmitStaticCtorParameters(OutTokens& Out)
{
	ostream& Outs = *(Out.GetStream());
	Outs << ",\n\tInputWordStaticInitbinary_read_flag_" << GetName() << "";
	return OK;
}

ErrCode InputWord::EmitStaticInit(OutTokens& Out)
{
	ostream& Outs = *(Out.GetStream());
	Outs << "static int InputWordStaticInitbinary_read_flag_" << GetName() << " = ";	
	OutStringStaticValue(Outs,"int", &(binary_read_flag)) ;

	Outs << ";\n";
	return OK;
}

InputWord::~InputWord()
{
	TheMenuServer->DeleteMenuItem("InputWord",GetName());
	InputWordNodeList->Delete(GetName()) ;
#line 114 "../inword.usr"
 
	dtor();
#line 71 "../inword.cxx"
} // end destructor

int InputWord::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

InputWord * InputWordDef;

ErrCode InputWord::DoNode(int32 k)
{
#line 150 "../inword.usr"
 
	return kernel(k);
#line 88 "../inword.cxx"
} // end kernel code

static UserEntity * MakeInputWord(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int InputWord::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntInputWord->CppList(Out,Cmd,this);
}

void InputWord::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeInputWord(Out,EntityReqDescribeFull,*IntEntInputWord, (ArithType::ArithCapabilities) TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("FileName");
		Out.NextQuoteOut(GetFileName());
		Out.NextFillOut("is the binary input file");
		Out.NextFillOut("to read. If no default(0) is given");
		Out.NextFillOut("the node name will be used.");
		Out.NextQuoteOut("FormatIn");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetFormatIn()));
		Out.NextFillOut(")");
		Out.NextFillOut("is the binary input format.");
		Out.NextFillOut("The options are:");
		Out.NextFillOut("`MachWord'");
		Out.NextFillOutConcat("(0),");
		Out.NextFillOut("`int8'");
		Out.NextFillOutConcat("(1),");
		Out.NextFillOut("`int16'");
		Out.NextFillOutConcat("(2),");
		Out.NextFillOut("`int32'");
		Out.NextFillOutConcat("(3),");
		Out.NextFillOut("`float'");
		Out.NextFillOutConcat("(4),");
		Out.NextFillOut("`double'");
		Out.NextFillOutConcat("(5). Integer words are written in two's compliment");
		Out.NextFillOut("format. Integer input values (");
		Out.NextFillOutConcat("`IntegerMachWord'");
		Out.NextFillOutConcat(") are treated as signed.");
		Out.NextFillOut("If overflow occurs the data is hard limited and a warning");
		Out.NextFillOut("is given. The input stream can have any value for sample size,");
		Out.NextFillOut("(");
		Out.NextFillOutConcat("`ElementSize'");
		Out.NextFillOutConcat(")");
		Out.NextFillOut("If");
		Out.NextQuoteOut("IntegerOut");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetIntegerOut()));
		Out.NextFillOut(")");
		Out.NextFillOut("is nonzero the output stream");
		Out.NextFillOut("is written as");
		Out.NextFillOut("`IntegerMachWord'");
		Out.NextFillOutConcat(". Otherwise it is written as");
		Out.NextFillOut("`MachWord'");
		Out.NextFillOutConcat(". If overflow occurs the data is hard limited");
		Out.NextFillOut("and a warning is given.");
		Out.NextFillOut("The first");
		Out.NextQuoteOut("InitialSkip");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetInitialSkip()));
		Out.NextFillOut(")");
		Out.NextFillOut("bytes of the file are ignored.");
		Out.NextQuoteOut("ElementSize");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetElementSize()));
		Out.NextFillOut(")");
		Out.NextFillOut("is the number of words per sample in");
		Out.NextFillOut("the input file.");
		Out.NextQuoteOut("BlockSize");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetBlockSize()));
		Out.NextFillOut(")");
		Out.NextFillOut("is the number of samples per block in the");
		Out.NextFillOut("input file.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntInputWord->GetOneParameter("FileName")->
			StringP->CurrentValue = FileName_1;
		IntEntInputWord->GetOneParameter("FormatIn")->
			IntP->CurrentValue = FormatIn_2;
		IntEntInputWord->GetOneParameter("IntegerOut")->
			IntP->CurrentValue = IntegerOut_3;
		IntEntInputWord->GetOneParameter("InitialSkip")->
			IntP->CurrentValue = InitialSkip_4;
		IntEntInputWord->GetOneParameter("ElementSize")->
			IntP->CurrentValue = ElementSize_5;
		IntEntInputWord->GetOneParameter("BlockSize")->
			IntP->CurrentValue = BlockSize_6;
		break;
	}
} // end  list entity switch

void InputWordNodesInit()
{
	if (InputWordNodeList)  return ;

	static StringParam InputWordNameParam =
		{"InputWord", MakeNewEntityName, 0, LegalEntityName};
	static StringParam InputWordFileNameParam = {
		 0, 0, 0};
	static IntParam InputWordFormatInParam = {
		 0, 0,  0,  0,  0,  5};
	static IntParam InputWordIntegerOutParam = {
		 0, 0,  0,  0,  0,  1};
	static IntParam InputWordInitialSkipParam = {
		 0, 0,  0,  0, 0, 2.14748e+09};
	static IntParam InputWordElementSizeParam = {
		 1, 0,  0,  1, 0, 32767};
	static IntParam InputWordBlockSizeParam = {
		 1, 0,  0,  1, 0, 2.14748e+09};

	static OneParameter InputWordParArray[] = {
		{"Name", 0, "node name", 0, 0, &InputWordNameParam},
		{"FileName", 0, 
			"binary input file to read",
			0, 0, &InputWordFileNameParam},
		{"FormatIn", 0, 
			"format: `MachWord'(0), `int8'(1), `int16'(2), `int32'(3), `float'(4), `double'(5)",
			&InputWordFormatInParam, 0, 0, 0, 0, 1},
		{"IntegerOut", 0, 
			"output format `MachWord'(0) or `IntegerMachWord'(1)",
			&InputWordIntegerOutParam, 0, 0, 0, 0, 1},
		{"InitialSkip", 0, 
			"bytes to skip at start of file",
			&InputWordInitialSkipParam, 0, 0, 0, 0, 1},
		{"ElementSize", 0, 
			"number of words per sample",
			&InputWordElementSizeParam, 0, 0, 0, 0, 1},
		{"BlockSize", 0, 
			"number of samples per block",
			&InputWordBlockSizeParam, 0, 0, 0, 0, 1},
		{0}
	};

	InputWordNodeList = new EntityList;
	IntEntInputWord = new InteractiveEntity("InputWord", InputWordNodeList,
		MakeInputWord, InteractiveNode, "inword.h",
		0, "SignalStr");
	IntEntInputWord->SetParameters(new UserParameters(InputWordParArray));
	TheNodes->Append(IntEntInputWord);
} // end initalization

static UserEntity * MakeInputWord(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("InputWord");
		Out.NextFillOut("reads words from a binary input file. It is intended");
		Out.NextFillOut("for importing data to other processes.");
		Out.NextFillOut("`OutputWord'");
		Out.NextFillOut("writes");
		Out.NextFillOut("files that can be read by");
		Out.NextQuoteOut("InputWord");
		Out.NextFillOutConcat(". However");
		Out.NextFillOut("`OutputNode'");
		Out.NextFillOut("and");
		Out.NextFillOut("`InputNode'");
		Out.NextFillOut("are better");
		Out.NextFillOut("for preserving data for later use in ObjecProDSP because these");
		Out.NextFillOut("retain sample rate, timing, block size and sample size information.");
		Out.NextFillOut("You can manually specify the sample and block size of the");
		Out.NextFillOut("data in the file with");
		Out.NextFillOut("parameters");
		Out.NextQuoteOut("ElementSize");
		Out.NextFillOut("and");
		Out.NextQuoteOut("BlockSize");
		Out.NextFillOutConcat(".");
		Out.NextFillOut("Each output word is read in a format determined by");
		Out.NextQuoteOut("FormatIn");
		Out.NextFillOutConcat(".");
		Out.NextFillOut("The options are:");
		Out.NextFillOut("`MachWord'");
		Out.NextFillOutConcat("(0),");
		Out.NextFillOut("`int8'");
		Out.NextFillOutConcat("(1),");
		Out.NextFillOut("`int16'");
		Out.NextFillOutConcat("(2),");
		Out.NextFillOut("`int32'");
		Out.NextFillOutConcat("(3),");
		Out.NextFillOut("`float'");
		Out.NextFillOutConcat("(4),");
		Out.NextFillOut("`double'");
		Out.NextFillOutConcat("(5). Integer words are assumed in two's compliment");
		Out.NextFillOut("format.  You can skip a header or initial segment of a");
		Out.NextFillOut("file by setting");
		Out.NextQuoteOut("InitialSkip");
		Out.NextFillOut("to the number bytes to skip.");
		Out.NextQuoteOut("IntegerOut");
		Out.NextFillOut("is nonzero the output stream");
		Out.NextFillOut("is written as");
		Out.NextFillOut("`IntegerMachWord'");
		Out.NextFillOutConcat(", otherwise it is written as");
		Out.NextFillOut("`MachWord'");
		Out.NextFillOutConcat(".");
		Out.NextFillOut("Integer output values (");
		Out.NextFillOutConcat("`IntegerMachWord'");
		Out.NextFillOutConcat(") are treated as signed.");
		Out.NextFillOut("If overflow occurs the data is hard limited and a warning");
		Out.NextFillOut("is given. The output stream can have any value for sample size,");
		Out.NextFillOut("(");
		Out.NextFillOutConcat("`ElementSize'");
		Out.NextFillOutConcat(") or");
		Out.NextFillOut("`BlockSize'");
		Out.NextFillOut("but these are not preserved in");
		Out.NextFillOut("the output file as they are with");
		Out.NextFillOut("`InputNode'");
		Out.NextFillOutConcat(".");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		const char * FileName =
			IntNode.GetStringParameterValue("FileName");
		int16 FormatIn =
			IntNode.GetIntParameterValue("FormatIn");
		int16 IntegerOut =
			IntNode.GetIntParameterValue("IntegerOut");
		int32 InitialSkip =
			IntNode.GetIntParameterValue("InitialSkip");
		int16 ElementSize =
			IntNode.GetIntParameterValue("ElementSize");
		int32 BlockSize =
			IntNode.GetIntParameterValue("BlockSize");
		return new InputWord(Name, FileName, FormatIn, IntegerOut, InitialSkip, ElementSize, BlockSize);

	}
	}
	return 0;
}

static InitObj LocalInit(InputWordNodesInit, "InputWord", "SignalStr");

