/*
 *  axslab.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  axslab.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */

#ifndef AXSLAB_DOT_H
#define AXSLAB_DOT_H
typedef const char * (*AxisLabelString)(double value) ;

class Graph ;

class AxisLabelBase {
	int MaxNoCharacters ; // max character in label entry for in tick
	double FirstTick ;
	double SizeInTicks ;
	AxisLabelString GetTickLabel ;
	Graph * ThePlotWindow ;
public:
	void Init();
	AxisLabelBase(Graph * Win) ;
	const char * GetNextLabel(int InitFlag) ; // 0 for initialize
	int GetMaxNoCharacters() {return MaxNoCharacters;}
	double GetFirstTick() {return FirstTick;}
	double GetSizeInTicks() {return SizeInTicks;}
	void SetPlotWindow (Graph * Win) {ThePlotWindow=Win;}
	void Check();
	// class Screen * GetScreen() ;
	virtual void SetTickSpacing() {}
	class DataPlot * GetDataPlot() ;
 	class DataPlotHeader * GetDataPlotHeader() ;
	Graph * GetPlotWindow() {return ThePlotWindow;}
	void SetTickParms(double first, double size) 
		{FirstTick =first; SizeInTicks = size;}
	void SetMaxNoCharacters(int Max) {MaxNoCharacters = Max;}
	void WriteLabelText( const char * Text, int32 X, int32 Y) ;
} ;

class AxisLabelX: public AxisLabelBase {
public:
	void Init();
	AxisLabelX(Graph * Win):AxisLabelBase(Win){Init();}
	virtual void SetTickSpacing() {}
/*
 *	AxisLabelX(int ch, double first, double inc, AxisLabelString getlab)
 *		{MaxNoCharacters = ch; FirstTick = first ;
 *			SizeInTicks = inc ; GetTickLabel = getlab;}
 */
	virtual void WriteLabel(int Ix, int32 x) ;
} ;

class AxisLabelY: public AxisLabelBase {
public:
	void Init();
	AxisLabelY(Graph * Win):AxisLabelBase(Win){Init();}
	virtual void SetTickSpacing() {}
/*
 *	AxisLabelY(int ch, double first, double inc, AxisLabelString getlab)
 *		{MaxNoCharacters = ch; FirstTick = first ;
 *			SizeInTicks = inc ; GetTickLabel = getlab;}
 */

	virtual void WriteLabel(int Ix, int32 y) ;
} ;

	

class AxisLabelingLinearY: public AxisLabelY {
	void Init();
public:
	AxisLabelingLinearY(Graph * Win):AxisLabelY(Win){Init();}
	virtual void SetTickSpacing() ;
	virtual void WriteLabel(int Ix, int32 y) ;
} ;

class AxisLabelingLogarithmicY: public AxisLabelY {
public:
	AxisLabelingLogarithmicY(Graph * Win):AxisLabelY(Win){}
	virtual void SetTickSpacing() ;
} ;

class AxisLabelingLinearX: public AxisLabelX {
	void Init();
public:
	AxisLabelingLinearX(Graph * Win):AxisLabelX(Win){Init();}
	double GetSampleRate() ;
	virtual void SetTickSpacing() ;
	virtual void WriteLabel(int Ix, int32 x) ;
	double GetDynamicSampleRateFactor() ;
} ;

class AxisLabelingLogarithmicX: public AxisLabelX {
public:
	AxisLabelingLogarithmicX(Graph * Win):AxisLabelX(Win){}
	virtual void SetTickSpacing() ;
} ;


#endif /* #ifdef AXSLAB_DOT_H */
