/*  guistate.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "callback.h"
#include "guistate.h"
#include "intfccomg.h"
// #include "winmgr.h"
#include "cgidbg.h"
// #include "valcon.h"
#include "callback.h"
#include "mkstr.h"
#include "xgui.h"
#include "xdrv.h"
#include "dsp_app.h"

GuiCommandState State;

GuiCommandState::GuiCommandState():
	the_arith_type(ArithType::ArithTypeUndefined),
	action_file_name(0)
{
	ReadFileName = "dsppp" ;
	FileSetFlag = 0;
	Interactive = 1;
}

int GuiCommandState::SaveInit(const char * NewFileName)
{
	if (FileSetFlag) return 0;
	FileSetFlag = 1 ;
	if (NewFileName) if (*NewFileName) {
		ReadFileName = NewFileName ;
		return 1 ;
	}
	ReadFileName = 0 ;
	return 1;
}

void GuiCommandState::ActionInit(const char * name)
{
	action_file_name = name ;
}

const char * GuiCommandState::GetFileName()
{
	return ReadFileName;
}

void GuiCommandState::ReadyForInitReadState(int ReturnId)
{
	// first check if there is a '.dspinit' file
	// TheWindowsManager->GetValidationControl()->ReadyForInitFileRead();
	// then check of there is a inital DSP file to read
	DspApplication::root_window()->ReadyForInitFileRead();
/*
 *	if (GetFileName()) LogOut << "InitReadState filename = " << GetFileName()
 *		<< "\n" ;
 *	else LogOut << "InitReadState null file name.\n" ;
 */
	if (GetFileName()) {
		DspApplication::state()->ReadStateBusy();
		InterfaceControl.SendPacket(DoActionSetSaveFileName,
			GetFileName());
		// LogOut << "Attempting file read.\n" ;
		DspApplication::root_window()->ReadStateCompletion(CallBackSuccess,
			Concatenate(GetFileName()));
/*
 *		TheWindowsManager->ReadyForInitReadState(ReturnId,
 *			GetFileName());
 */
		// DspState->ClearReadStateBusy();
		return ;
	}
	// LogOut << "Exiting with no file read attempted.\n" ;
	InterfaceControl.SendReturnPacket(ReturnId,InitReadFinished,0);
}

