/*  pack.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
// Routine to pack and unpack arbitrary data structures for
// transmission remotely

#include <string.h>
#include "shared.h"
#include "remcom.h"
#include "pack.h"

void PackAndSend::SendPacket()
{
	Head.DataSize = NextByte+1;
	WriteSeg->WritePacket(Head,Buf);
	NextByte=0;
}


void PackAndSend::AddBytes(char * Pt, int N)
{
	for (int i = 0 ; i < N ; i++) {
		if (NextByte >= MaxPacketSize) SendPacket();
		Buf[NextByte++] = *Pt++;
	}
}


void PackAndSend::AddItem(PackDesc& Desc, const void * Item)
{
	int N = Desc.NumItems ;
	if (!N) return ;
	int B = Desc.NumBytes ;
	if (N == -1) N = 1 ;
	if (B) AddBytes((char *)Item,B*N);
	else  {
		char ** Data = (char **) Item ;
		for (int i = 0 ; i < N ; i++)
			AddBytes(Data[i],strlen(Data[i])+1);
	}
}

	
