/*  spellfil.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <ctype.h>
#include <string.h>
#include <fstream.h>
#include "debug.h"
#include "spellfil.h"
#include "files.h"

static ostream * SpellFile = 0;
static int CharPosition = 0 ;

int IsWhiteSpace(const char * Text)
{
	for (const char * Ch = Text; *Ch ; Ch++) if (!isspace(*Ch)) return 0;
	return 1 ;
}

static void OpenSpellFile()
{
	if (!SpellFileName[0]) DbgError("OpenSpellFile", "no file name");
	// SpellFile = OpenFile(SpellFileName);
	SpellFile = new ofstream(SpellFileName);
}

void AddToSpellFile(const char * String)
{
	static int EndedInSpace = 1 ;
	if (!String) return ;
	if (!*String) return ;
	if (IsWhiteSpace(String)) return ;
	if (!SpellFile) OpenSpellFile();
	while (*String) {
		if (!isascii(*String)) {
			String++;
			continue;
		}
		if (isalpha(*String)) break ;
		String++;
	}
	int Length = strlen(String) ;
	if (!Length) return ;
	if (CharPosition + Length > 75) {
		*SpellFile << "\n" ;
		CharPosition = 0 ;
		EndedInSpace = 1;
	}
	if (!EndedInSpace) if (!isspace(*String)) {
		*SpellFile << " " ;
		CharPosition++ ;
	}
	*SpellFile << String ;
	CharPosition += Length ;
	EndedInSpace = isspace(String[Length-1]);
}


void CloseSpellFile()
{
	if (!SpellFile) return ;
	*SpellFile << "\n" ;
	delete SpellFile;
	SpellFile = 0 ;
}
