/*  text.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <stream.h>
#include <string.h>
#include <stdlib.h>
#include "stdyac.h"
#include "textfrag.h"
#include "text.h"
#include "spellfil.h"

TextFragmentList * TheText = 0 ;
static int BraceCount = 0;


TextFragmentList * CurrentText()
{
	TextFragmentList * Return = TheText ;
	TheText = 0;
	return Return ;
}

void AddEmbeddedName(const char * Nm)
{
	// cout << "Adding Embedded name: " << Nm << "\n" ;
	if (!TheText) TheText = new TextFragmentList ;
	int Line = -LineNumber ;
	if (!Line) Line = -1 ;
	TheText->Append( new TextFragment(Line,MakeName(Nm))) ;
}


void AddedText(const char * Text)
{
	// cout << "Adding text: " << Text << "\n" ;
	if (!TheText) TheText = new TextFragmentList ;
	TheText->Append( new TextFragment(LineNumber,MakeName(Text))) ;
}

void AddedChar(char Ch)
{
	char Dum[2];
	Dum[0] = Ch;
	Dum[1] = '\0' ;
	// cout << "Adding character `" << Dum << "'.\n" ;
	AddedText(Dum);
}



void BraceInit()
{
	// cout << "BraceInit called.\n" ;
	BraceCount = 0;
}

void LeftBrace()
{
	// cout << "LeftBrace called.\n" ;
	if (BraceCount) AddedChar('{');
	BraceCount++ ;
}

static void ExtraRight()
{
	cerr << "Extra right brace in C++ code at line " << LineNumber <<
		".\n" ;
}

int RightBrace()
{
	// cout << "RightBrace called.\n" ;
	if(BraceCount < 1) {
		ExtraRight() ;
		return 1 ;
	}
	if ( ! --BraceCount ) return 1 ;
	AddedChar('}');
	return 0 ;
}

