/*
 *  linlist.C from ObjectProDSP
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#include "linlist.h"

void ** AddToList (const void * Add, void ** const & TheList)
{
	void ** List = (void **) TheList ;
	int Size = 0 ;
	if (!List) List = new void * [2] ;
	else {
		for (Size = 0 ; List[Size] ; Size++);
		void ** NewList = new void * [Size + 2] ;
		for (int i = 0 ; i < Size ; i++) NewList[i] = List[i] ;
		delete List ;
		List = NewList ;
	}
	List[Size] = (void *) Add ;
	List[Size+1] = 0 ;
	void *** tmp = (void ***) (&TheList) ;
	return *tmp = List ;
}

int ListLength(const void ** TheList)
{
	int Count = 0 ;
	if (TheList) for (const void ** Ptr = TheList; *Ptr; Ptr++) Count++;
	return Count ;
}


void ** AddListToList (const void ** const Add, void ** const & TheList)
{
	void ** List = (void **) TheList ;
	void ** ToAdd = (void **) Add ;
	int Length = ListLength(Add) ;
	int Size = 0 ;
	if (!List) List = new void * [Length+1] ;
	else {
		for (Size = 0 ; List[Size] ; Size++);
		void ** NewList = new void * [Size + Length + 1] ;
		for (int i = 0 ; i < Size ; i++) NewList[i] = List[i] ;
		delete List ;
		List = NewList ;
	}
	for (int Index = 0; Index < Length; Index++)
		List[Size++] = ToAdd[Index] ;
	List[Size] = 0 ;
	void *** tmp = (void ***) &TheList ;
	return *tmp = List ;
}

void *** AddListToListOfLists (const void ** Add, void *** const& TheList)
{
	int Length = ListLength((const void **) TheList) ;
	void *** List = new void ** [Length+2] ;
	for (int i = 0 ; i < Length ; i++) List[i] = TheList[i] ;
	List[Length++] = (void **) Add ;
	List[Length] = 0 ;
	delete TheList ;
	void **** tmp = (void ****) &TheList ;
	return *tmp = List ;
}

