/*  mkstr.C   */
/*  Copyright 1991 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <string.h>
#include "mkstr.h"

char * Concatenate(const char * s1, const char * s2,
	const char * s3, const char * s4, const char * s5, const char * s6)
{
	if (!s1) return 0 ;
	if (!*s1 && (!s2 || !*s2)) return 0 ;
	const NumParam = 6 ;
	const char * Others[NumParam+1] ;
	int i = 0;
	Others[i++] = s1 ;
	Others[i++] = s2 ;
	Others[i++] = s3 ;
	Others[i++] = s4 ;
	Others[i++] = s5 ;
	Others[i++] = s6 ;
	Others[i++] = 0 ;
	int Length = 1;
	for (i= 0; Others[i];i++) Length += strlen(Others[i]);
	char * Result = new char[Length];
	Result[0]= '\0' ;
	for(i=0;Others[i];i++) strcat(Result,Others[i]);
	return Result ;
}
	
const char * FindSuffix(const char * Name, const char * Suffix)
{
	if (EmptyString(Name)) return 0 ;
	if (EmptyString(Suffix)) return 0 ;

	for (const char * Pt = Name + strlen(Name) - strlen(Suffix) ;
		Pt >=Name; Pt--)
			if (!strcmp(Suffix,Pt)) return Pt ;
	return 0;
}
	
const char * FindBase(const char * Name, const char * Base)
{
	int Length = strlen(Base);
	if (EmptyString(Name)) return 0 ;
	if (EmptyString(Base)) return 0 ;
	for (const char * Pt = Name + strlen(Name) - Length ; Pt >=Name;
		Pt--) if (!strncmp(Base,Pt,Length)) 
			if (!*(Pt+Length) || *(Pt+Length) == '.') return Pt ;
	return 0;
}

const char * FindLastDot(const char * Name)
{
	for (const char * Ptr = Name + strlen(Name) -1 ; Ptr >= Name ;
		Ptr--) if (*Ptr == '.') return Ptr + 1 ;
	return 0 ;
}

char * FindDirectory(const char * OriginalName)
{
	if (!OriginalName) return 0 ;
	int Length = strlen(OriginalName);
	if (!Length) return 0 ;
	for (const char * Pt = OriginalName + Length -1; Pt >= OriginalName;
		Pt--) if (*Pt == '/') break ;
	int OutLength = Pt - OriginalName ;
	if (OutLength <=0 ) return 0 ;
	char * buf = new char[OutLength+1] ;
	strncpy(buf,OriginalName,OutLength);
	buf[OutLength] = '\0' ;
	return buf ;
}

char * RemoveSuffix(const char * Base, const char * Suffix)
{
	if (EmptyString(Base)) return 0 ;
	if (EmptyString(Suffix)) return 0 ;
	const char * SuffixPosition = FindSuffix(Base,Suffix);
	if (!SuffixPosition) return NewCopyString(Base) ;
	int Length  = SuffixPosition - Base ;
	char * Return = new char[Length + 1] ;
	strncpy(Return,Base,Length);
	Return[Length] = '\0' ;
	return Return ;
}

char * AddSuffix(const char * Base, const char * Suffix)
{
	if (EmptyString(Base)) return 0 ;
	if (EmptyString(Suffix)) return 0 ;
	if (FindSuffix(Base,Suffix)) return NewCopyString(Base) ;
	char * Return = Concatenate(Base,Suffix);
	return Return ;
}

char * GetLowestDirectory(const char * name)
{
	if (EmptyString(name)) return 0 ;
	const char * end = name + strlen(name) - 1 ;
	const char * last_slash = 0 ;
	const char * second_slash = 0 ;
	for (const char * e = end ; e >=name; e--) {
		if (*e != '/') continue ;
		if (last_slash) {
			second_slash = e ;
			break ;
		}
		last_slash = e ;
	}
	if (!last_slash || last_slash == name) return 0 ;
	if (!second_slash) second_slash = name - 1 ;
	int length = last_slash - second_slash - 1 ;
	char * ret = new char[length+1] ;
	strncpy(ret,second_slash+1,length);
	ret[length] ='\0' ;
	return ret ;
}

char * ForceSuffix(const char * Base, const char * Suffix)
{
	if (EmptyString(Base)) return 0 ;
	if (EmptyString(Suffix)) return 0 ;
	if (FindSuffix(Base,Suffix)) return NewCopyString(Base);
	return AddSuffix(Base,Suffix) ;
}

char * RemoveLowestDirectory(const char * Name)
{
	if (EmptyString(Name)) return 0 ;
	int Length = strlen(Name) ;
	for (const char * Temp = Name + Length - 1 ; Temp >=Name ; Temp--)
		if (*Temp == '/') break ;
	if (*Temp != '/') return 0 ;
	int length = Temp - Name + 1 ;
	char * ret = new char[length] ;
	if (length > 1) strncpy(ret,Name,length-1);
	ret[length-1] ='\0' ;
	return ret ;
}

char * OpdRemoveDirectory(const char * Name)
{
	if (EmptyString(Name)) return 0 ;
	int Length = strlen(Name) ;
	for (const char * Temp = Name + Length - 1 ; Temp >=Name ; Temp--)
		if (*Temp == '/') break ;
	return NewCopyString(Temp+1);
}

char * AddSubDirectory(const char * Base, const char * Sub)
{
	int BaseEmpty = EmptyString(Base) ;
	int SubEmpty = EmptyString(Sub) ;
	if (BaseEmpty && SubEmpty) return 0 ;
	if (BaseEmpty) return Concatenate(Sub);
	if (SubEmpty) return Concatenate(Base);
	int BaseLength = strlen(Base);
	if (Base[BaseLength-1] == '/' && *Sub == '/')
		return Concatenate(Base,Sub+1);
	if (Base[BaseLength-1] == '/' || *Sub == '/')
		return Concatenate (Base, Sub);
	return Concatenate(Base, "/", Sub);
}

char * ReplaceDirectory(const char * DirName, const char * OriginalName)
{
	if (EmptyString(OriginalName)) return 0 ;
	char * Temp = OpdRemoveDirectory(OriginalName);
	if (!Temp) Temp = Concatenate(OriginalName) ;
	if (EmptyString(DirName)) return Temp ;

	char * BaseName ;
	if (DirName[strlen(DirName)-1] == '/')
		BaseName = Concatenate(DirName,Temp);
	else BaseName = Concatenate(DirName,"/",Temp); 
	delete Temp ;
	return BaseName ;
}

int EmptyString(const char * String)
{
	if (String) if (*String) return 0 ;
	return 1;
}

const char * StringAfterLastSlash(const char * name)
{
	if (EmptyString(name)) return 0 ;
	int length = strlen(name);
    for (const char * base = name + length - 1 ; base >= name; base--)
        if (*base == '/') break ;
	if (base < name) return name ;
    int error = 1 ;
    if (*base++) if (*base) error = 0  ;
	if (error) return 0  ;
	return base ;
}


char * top_version_name(const char * name)
{
	if (!name) return 0 ;
	if (!*name) return 0 ;
	char * directory = FindDirectory(name);
	char * base_remove = 0;
	const char * base = name ;
	if (directory) base = base_remove = OpdRemoveDirectory(name);
	const char * last_dot = FindLastDot(base);
	char * Return = 0 ;
	if (!last_dot) if (directory) Return = Concatenate(directory,"/",base,".0");
	else Return = Concatenate(base,".0");
	delete directory ;
	delete base_remove ;
	return Return ;
}

int is_version_name(const char * name)
{
	char * tmp = top_version_name(name);
	int Return = tmp != 0 ;
	delete tmp ;
	return Return ;
}
