/*  outfilnm.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <string.h>
#include <stream.h>
#include <stdlib.h>
#include "outfilnm.h"

const char * MakeOutFileName(const char * InputFile)
{
	const char * Start = InputFile ;
	const char * LastDot = InputFile+strlen(InputFile) ;
	for (const char * Ptr = InputFile; *Ptr; Ptr++) {
		if (*Ptr == '/') Start = Ptr+1;
		if (*Ptr == '.') LastDot = Ptr ;
	}
	int Length = LastDot-Start;
	if (Length < 1) {
		cerr << "Bad input file name `" << InputFile << "'.\n" ;
		exit(1);
	}
	char * Ret = new char[Length+1];
	strncpy(Ret,Start,Length);
	Ret[Length] = '\0' ;
	return Ret ;
}


