/*  cgidbg.C   */
/*  Copyright 1990 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "ObjProComGui/cgidbg.h"
#include "ObjProGen/mkstr.h"
#include <strstream.h>
#include <errno.h>
#include <stdlib.h>
#include <new.h>

void ExitOneWayOrAnother()
{
	exit(1);
}

#ifndef __NT_VC__
static void OutOfMemory()
{
	DbgError("No more memory","JOB TERMINATED");
}
#else
static int OutOfMemory(unsigned )
{
	DbgError("No more memory","JOB TERMINATED");
	return -1 ;
}
#endif
	
void SetNewHandler()
{
#ifdef __NT_VC__
	_set_new_handler(OutOfMemory);
#else
	set_new_handler(OutOfMemory);
#endif
}

void SystemErrorMessage(int LastLineFeed, char **ret)
{
    const char * message_is = "The system error message is:\n" ;
    const char * err_number = "error number: " ;
    const char * not_in = " which is not in the system error table" ;
    if (ret) {
        char * to_delete = 0 ;
        const char * sys_msg = 0 ;
        if (errno < sys_nerr) {
            const buf_size = 32 ;
            char buf[buf_size] ;
            ostrstream num(buf,buf_size);
            num << errno ;
            sys_msg = to_delete = Concatenate(err_number,buf,not_in);
        } sys_msg = sys_errlist[errno] ;
        *ret  = Concatenate(message_is,sys_msg,".");
        delete to_delete ;
        return ;
    }
    cerr << message_is ;
    if (errno < sys_nerr) *Output << sys_errlist[errno] ;
    else cerr  << err_number << errno << not_in ;
    cerr << "." ;
}


