/*  makedir.C   */
/*  Copyright 1990 Mountain Math Software  */
/*  All Rights Reserved					*/
#include <stream.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include "makedir.h"
#include "usercom.h"

#include "cgidbg.h"
#include "yacintfc.h"
#ifdef __NT_VC__
#include <direct.h>
#endif

int CheckSubDir(const char * Name)
{
	DIR * Directory = opendir((char *)Name) ;
	if (Directory) closedir(Directory) ;
	else {
#ifndef __NT_VC__
		int mode = S_IEXEC | S_IREAD | S_IROTH | S_IWRITE |
			S_IXGRP | S_IXOTH ;
		int status = mkdir(Name,mode);
#else
		int status = mkdir(Name);
#endif
		if (status != 0) {
			HelpOut << "Cannot create directory `" << Name << "'.\n" ;
			SystemErrorMessage();
			return 0 ;
		}
	}
	return 1 ;
}


