/*
 *  syssig.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <signal.h>

#include "sysintfc.h"
#include "syssig.h"

/*
 *	     SIGHUP	   01	   hangup
 *	     SIGINT	   02	   interrupt
 *	     SIGQUIT       03[1]   quit
 *	     SIGILL	   04[1]   illegal instruction (not reset when caught)
 *	     SIGTRAP       05[1]   trace trap (not reset when caught)
 *	     SIGIOT	   06[1]   IOT instruction
 *	     SIGABRT       06	   used	by abort, replaces SIG10T
 *	     SIGEMT	   07[1]   EMT instruction
 *	     SIGFPE	   08[1]   floating point exception
 *	     SIGKILL       09	   kill	(cannot	be caught or ignored)
 *	     SIGBUS	   10[1]   bus error
 *	     SIGSEGV       11[1]   segmentation	violation
 *	     SIGSYS	   12[1]   bad argument	to system call
 *	     SIGPIPE       13	   write on a pipe with	no one to read it
 *	     SIGALRM       14	   alarm clock
 *	     SIGTERM       15	   software termination	signal
 *	     SIGUSR1       16	   user-defined	signal 1
 *	     SIGUSR2       17	   user-defined	signal 2
 *	     SIGCLD	   18[2]   death of a child
 *	     SIGPWR	   19[2]   power fail
 *	     SIGPOLL       22[3]   selectable event pending
 *
 */


void SetCatchSignals(SigFunc SigHandle, SigFunc SigTerm,
	SigFunc SigUser1, SigFunc SigUser2)
{
	if (!SigUser2) SigUser2 = SigHandle ;
	if (!SigUser1) SigUser1 = SigHandle ;
	if (!SigTerm) SigTerm = SigHandle ;
#ifndef __NT_VC__
	signal(SIGHUP, SigHandle);
	signal(SIGINT, SigHandle);
	// signal(SIGQUIT, SigHandle);
	signal(SIGILL, SigHandle);
	signal(SIGTRAP, SigHandle);
	// signal(SIGIOT, SigHandle);
	// signal(SIGABRT, SigHandle);
#ifndef linux
	signal(SIGEMT, SigHandle);
#endif
	signal(SIGFPE, SigHandle);
	signal(SIGKILL, SigHandle);
#ifndef linux
	signal(SIGBUS, SigHandle);
#endif
	signal(SIGSEGV, SigHandle);
#ifndef linux
	signal(SIGSYS, SigHandle);
#else
	signal(SIGPIPE, SigHandle);
#endif
	signal(SIGALRM, SigHandle);
	signal(SIGTERM, SigTerm);
	signal(SIGUSR1, SigUser1);
	signal(SIGUSR2, SigUser2);
	// signal(SIGCLD, SigHandle);
#ifndef linux
	// signal(SIGPWR, SigHandle);
#endif
	signal(SIGPOLL, SigHandle);
#else /* ifdef __NT_VC__ */
	signal(SIGINT, SigHandle);
	signal(SIGFPE, SigHandle);
#endif
}
