/*  yacoper.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <string.h>
#include <stream.h>
#include "portable.h"
#include "yacoper.h"
#include "entabl.h"
#include "y.tab.h"
#include "stdyc.h"

char * MakeCompoundName(const char * Base, const char * a1,
	const char * a2, const char * a3, const char * a4)
{
	const char * a[5] ;
	int i = 0 ;
	a[i++] = a1;
	a[i++] = a2;
	a[i++] = a3;
	a[i++] = a4;
	a[i++] = 0;

	int Length = strlen(Base);

	for (const char ** b = a; *b ; b++) Length += strlen(*b);
	
	char * Return = new char[Length+1];
	strcpy(Return,Base);

	for (b = a ; *b ; b++) strcat(Return,*b);
	return Return ;
}

char * GetOperatorString(int Operator)
{
	static char CharacterOperator[2] = "X" ;
	char * OperatorString ;
	// cerr << "GetOperatorString(" << Operator << ")\n" ;
	if (Operator < 128) {
		CharacterOperator[0] = Operator ;
		OperatorString = CharacterOperator ;
	} else switch(Operator) {
case SHIFT_R:
		OperatorString = ">>" ; break ;
case SHIFT_L:
		OperatorString = "<<" ; break ;
case LEQ:
		OperatorString = "<=" ; break ;
case GEQ:
		OperatorString = ">=" ; break ;
case EQU:
		OperatorString = "==" ; break ;
case NEQ:
		OperatorString = "!=" ; break ;
case AND:
		OperatorString = "&&" ; break ;
case OR:
		OperatorString = "||" ; break ;
default :
		// cerr << "BAD\n" ;
		yyerror("MakeOperatorString::unknown operator");
		OperatorString = "ERROR" ;

	}
	return OperatorString ;
}

char * MakeOperatorString(int Operator)
{
	// cerr << "MakeOperatorString(" << Operator << ")\n" ;
	const char * OperatorString = GetOperatorString(Operator);
	char * Buf = new char[strlen(OperatorString)+1];
	strcpy(Buf,OperatorString);
	return Buf ;
}

char * MakeOperatorName(int Operator)
{
	return MakeCompoundName("operator",GetOperatorString(Operator));
}

char * GetOperatorName(int Oper)
{
	return GetOperatorName(GetOperatorString(Oper));
}

char * GetOperatorName(const char * OperatorString)
{
	static const char * Operator = "operator" ;
	const BufSize = 32 ;
	static char Buf[BufSize+1];
	if (strlen(Operator)+strlen(OperatorString) > BufSize) {
		yyerror("operator too long");
		OperatorString = "_ERROR_" ;
	}
	strcpy(Buf,Operator);
	strcat(Buf,OperatorString);	
	return Buf ;
}


static const char * Operator = "operator" ;
char * MakeOperatorName(const char * Base,const char * OperatorString)
{
	char * Return = MakeCompoundName(Base,Operator,OperatorString);
	return Return ;
}

char * MakeOperatorName(const char * OperatorString)
{
	char * Return = MakeCompoundName(Operator,OperatorString);
	return Return ;
}

