/*
 *  com_input.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef COM_INPUT_DOT_H
#define COM_INPUT_DOT_H
#include <InterViews/input.h>
class Window ;
class StringList ;
class ScrollFieldEditor ;
class MenuKeyboard ;


class FocusSelector {
	typedef void (FocusSelector::*generic_action)() ;
	const char * prompt_message ;
	Window * prompt_window ;
	const char * the_window_name ;
	int prompt_flag:1 ;
	int deletable:1 ;
	int raise_flag:1 ;
	int display_flag:1 ;
	int removed_flag:1 ;
	static generic_action the_generic_actions[];
	static const char * printing_window ;
protected:
	InputHandler * current_focus ;
	void clear_prompt()
			{prompt_flag = 0 ; prompt_message = 0;}
	FocusSelector();
	virtual ~FocusSelector();
	void print_window_check_prompt();
	void print_display_check_prompt();
public:
	virtual void request_focus(ScrollFieldEditor& editor);
	virtual void exit_window() ;
	void print_window_raise();
	void print_window();
	virtual void print_window_kernel(StringList * lst=0);
	void print_display();
	virtual int input_allowed(const InputHandler *) {return 1;}
	void set_prompt(const char * msg )
		{prompt_flag = 1 ; prompt_message = msg ; }

	static void generic_window_action(int act, const char * window);

	int can_delete() const {return deletable;}
    Window * window() const {return prompt_window;}
	void window(Window * win, MenuKeyboard * key, int del=1) ;
	static const char * generic_action_name ;
	const char * window_name() ;
	const char * name() const {return the_window_name;}
	void current_keystroke(ivEvent e);
	int common_keystroke(ivEvent e);
	virtual void edit_init() ;
	virtual void clear_focus();
	static void set_printing_window(const char * m)
		{ printing_window =m ;}
	static int currently_printing(int warn=1);
};


class DspInputHandler : public InputHandler, public FocusSelector {
public:
	DspInputHandler(Glyph * g, Style * s);
	virtual ~DspInputHandler() {}
	virtual int base_keystroke(const ivEvent&, FocusSelector *) {return 0;}
	virtual void keystroke(const Event&);
	const InputHandler * get_current_focus() const {return current_focus;}
};

class DspActiveHandler: public ActiveHandler, public FocusSelector {
public:
	DspActiveHandler(Glyph * g, Style * s);
	virtual ~DspActiveHandler() {}
	virtual int base_keystroke(const ivEvent&, FocusSelector *) {return 0;}
	virtual void keystroke(const Event&);
	const InputHandler * get_current_focus() const {return current_focus;}
};
	

#endif /* #ifdef COM_INPUT_DOT_H */
