/*
 *  flstatus.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  flstatus.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "portable.h"

struct ChangedLines ;

class FileStatus {
friend class TextFile ;
	class TextFile * FileLink ;
	int32 NextFileLine ;
	const char * Name ;
	int TheFile;
	long NextByteToRead ;
	long NextByteInFile ;
	int32 NextWriteLineInFile ;
	int MaxNumberChangedLines;
	int NextChangedLine ;
	ChangedLines * Updates ;
	int ChangedBufSize ;
	int NextFreeByteAtHead ;

	int FileLinesSize ;
	long * FileLines ; // gives byteaddress of every 10th line

	// Used only for write when window is not visible
	int NextXCharacter ;
	char * LineBuf ;
	unsigned LineBufSize ;

	void UpdateFileLines() ;
	void DoWriteLine(unsigned NumBytes,char * Data) ;
	void WriteLine(int32 LineIndex,char * Line);
	void SeekEnd();
	void SeekHead();
	int16 ReadUpdateLine(long ByteInFile, char * Dest) ;
	void CheckWrite(char * Buf,int N) ;

public:
	FileStatus(TextFile *);
	~FileStatus();
	int32 GetFileEnd() {return NextWriteLineInFile;}
} ;


const UpdateEnd = -2 ; 		// End of updated lines
const UpdateIgnore = -1 ;	// Out of date update to be ignored


