/*
 *  hot_button.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <IV-look/button.h>
#include <InterViews/action.h>
#include "blinker.h"

class MenuViewLine ;
class Allocation ;

class HotButton : public ivButton {
	MenuViewLine& menu_line ;
	int index ;
	int is_menu_selection ;
	ivGlyphIndex the_glyph_index ;
	const ivAllocation * the_allocation;
	Blinker * the_blinker ;
public:
	HotButton(Blinker * blinker, ivGlyph*, ivStyle*, ivTelltaleState*,
		MenuViewLine&, int ix);
	HotButton(HotButton *);
	virtual ~HotButton();
	virtual void enter();
   	virtual void leave();
   	virtual void local_leave(int call_base);
	virtual void press(const ivEvent&);
	virtual void release(const ivEvent&);
	virtual void down_state();
	void press();	// changes button appearance
	void release();	// changes button appearance
	virtual void allocate(ivCanvas *, const ivAllocation& alloc, ivExtension&);
	MenuViewLine& line() {return menu_line;}
	int get_index() const {return index;}
	ivGlyphIndex glyph_index() const {return the_glyph_index;}
	void glyph_index(ivGlyphIndex ix) {the_glyph_index=ix;}
	void unselect();
	void select(); 
	Blinker * blinker() {return the_blinker;}

	void do_command();
	void help_paragraph();
	void cond_help_paragraph();
	void help_file();

	void peel_off_menu();
	void raise_windows();
	void create_default();
	void create_instance();

	void set_menu_selection() {is_menu_selection=1;}
	void clear_menu_selection() {is_menu_selection=0;}
	int menu_selection() {return is_menu_selection;}
	const char * name();
};

class HotButtonMenuSelect : public HotButton {
public:
	HotButtonMenuSelect(ivGlyph*, ivStyle*, ivTelltaleState*, MenuViewLine&, int ix);
};

class DummyPushButtonAction : public ivAction {
public:
	DummyPushButtonAction(){}
	virtual ~DummyPushButtonAction(){}
	void virtual execute();
};


