/*  mendmp.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <stream.h>
#include "cgidbg.h"
#include "menu.h"

void Menu::Dump()
{
	TheLog << "Menu::Dump - " << Header << "\nMultipleUseFlag = 0x" <<
		hex(MultipleUseFlag) << "\n\tNoMenuItems = " << NoMenuItems
		<< "\nTotalMenuItems = " << TotalMenuItems << 
		", Init = 0x" << hex((long) Init) << ", NextLine = " <<
		NextLine << "\nExpandedMenu = " << ExpandedMenu <<
		", Parent = 0x" << hex((long) Parent) << "\n" ;
	int i = 0;
	for (MenuLine * TheLine = MenuItems ; TheLine->TheType ; TheLine++) {
		TheLog << "Dump of " << i++ << " from " << Header << "\n" ;
		TheLine->Dump();
	}
}

void MenuLine::Dump()
{
	TheLog << "MenuLine::Dump - Command = " << Command << ", Line:\n" <<
		Line << "\nTheType = " << TheType << ", TheObject = 0x" <<
		hex((long)TheObject) << "\n" ;
	if (Conflicts) {
		TheLog << "Conflicts are:\n " ;
		for (const char ** cf = Conflicts; *cf; cf++) TheLog
			<< "\t" << *cf << "\n" ;
	}
	TheLog << "Init = 0x" << hex((long) Init) << "\nHelpText :\n" ;
	if (HelpText) for (const char ** hp  = HelpText ; *hp ; hp++)
		TheLog << "\t" << *hp << "\n" ;
	if (HelpFileName) TheLog << "HelpFileName = " << HelpFileName <<
		"\nDump of Object :\n" ;
	ObjectDump();
}

void MenuLine::ObjectDump()
{
	switch (TheType) {
default:
		TheLog << "Unknown type\n" ;
		break ;
case MenuTypeInvalid:
		TheLog << "Invalid type\n" ;
		break ;
case MenuTypeCommand:
		TheLog << "TheCommand = 0x" << hex((long) GetDoCommand())
			<< "\n" ;
		break ;
case MenuTypeMenu:
		TheLog << "Dumping Submenu:\n" ;
		GetNewMenu()->Dump();
		break ;
case MenuTypeExtension:
		TheLog << "Dumping MenuExtension:\n" ;
		GetExtension()->Dump();
		break ;
case MenuTypeHelp:
		TheLog << "This is a help selection\n" ;
		break ;
	}
}

void MenuExtension::Dump()
{
	TheLog << "MenuExtension Dump, TotalMenuItems = " << TotalMenuItems
		<< ", NoMenuItems = " << NoMenuItems << "\n" ;
	for (int i = 0 ; i < NoMenuItems ; i++) {
		TheLog << "Dump of MenuExtension entry " << i << "\n" ;
		MenuItems[i].Dump();
	}
	
}
