/*
 *  xgui.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef XGUI_DOT_H
#define XGUI_DOT_H
/*  gui.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */

#include <InterViews/enter-scope.h>

#include "portable.h"
#include "examp.h"
#include "slist.h"

class Cursor ;

class DspProcessState {
	int ActiveReadRequest ;
	int ReadingState ;
	int QueuedMenuCommands ;
	int DspProcessId ;
	int GuiProcessId ;
	int PreviousBusyState ;
	StringList the_queued_cpp_lines ;

	void write_cpp(const char * str);
	void CheckChangeBusy() ;
	const char * the_init_action_file ;
public:
	DspProcessState(int gui, int dsp) ;
	void MenuCommandComplete() ;
	void MenuCommandSend();
	void ReadStateBusy();
	void ClearReadStateBusy();
	void ReadRequestActive();
	void ReadRequestInactive();
	Cursor * GetCursorType() ;
	int IsBusy() ;
	void KillAndExit() ;
	void TroubleKill() ;
	char * TroubleSignaling(const char * What) ;
	void TroubleAbort() ;
	void DoExit();
	void AbortAndExit() ;
	void DoSaveExit();
	void AbortAndSaveExit() ;
	void AbortDspExecution();
	int BusyAbort(const char * TryingWhat);
	int MakeDspSleepForever();
	int WakenDsp();
	int SignalSleep(const char * What);
	void write_cpp_line(const char * str);
	int lines_queued() const {return the_queued_cpp_lines.Size();}
	void init_action_file(const char * name);
};

// Calling this toggles between DSP sleeping and DSP not sleeping
extern DspProcessState * DspState ;
extern void com_setup(char **argv) ;
#include <InterViews/leave-scope.h>

#endif /* #ifdef XGUI_DOT_H */
