/*
 *  blinker.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef BLINKER_H
#define BLINKER_H

#include <InterViews/monoglyph.h>

class Patch;
class ShortTimer;
class Deck;
class LayoutKit;
class Style;

/*
 * Blinker --- switch between glyphs
 */
class Blinker : public MonoGlyph {
public:
    Blinker(Glyph * normal, Glyph * blink_to, Style*);
    virtual ~Blinker();
    
    void blink();
    void start();
    void stop();
    
private:
    ShortTimer* timer_;
    Patch* patch_;
    Deck* deck_;
};

declareActionCallback(Blinker)

#endif
