/*
 *  dskchnhd.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  dskchnhd.h   */
/*  Copyright 1990 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "ObjProDSP/portable.h"
#include "ObjProDSP/timenum.h"
#include "ObjProGen/usriotyp.h"

class TimingDescription ;
class StreamStr ;
class ostream ;

struct C30NodeOutChannelHeader ;

struct NodeOutChannelHeader {

	/* Begin Timing parameters */
	/***************************/
	int32 NumeratorSampling ;     
	int32 DenominatorSampling ;
	double SampleRate ;
	TimingType TheTimingType ;
	double FirstSample ;
	double ErrorTolerance ;
	double DeltaTimeBase ;
	/***************************/
	/* End Timing parameters */

	/* Begin StreamStr parameters */
	/***************************/
	int32 ElementSize ;
	int32 BlockSize ;
	double MinimumX ;
	double MaximumX ;
	double SampleRateFactor ;
	/***************************/
	/* End StreamStr parameters */
	void CheckTiming(int16 Flags=0);
#ifdef INTERACTIVE
	NodeOutChannelHeader(const TimingDescription& TheTiming,
		const StreamStr& TheStream);
#else
	NodeOutChannelHeader(class TargetNode& TheNode, int Chan);
#endif
	NodeOutChannelHeader(C30NodeOutChannelHeader& C30);
	NodeOutChannelHeader();

	void SetFromImage(const char *);
	void Display(OutputType Where);

	void DisplayHeader() {Display(OutputHelp);}
	double GetTimeFirst();
	void Dump(ostream&);
	TimingDescription * GetInitTiming();
	double GetTimingRatio();
	void Clear();
};


#ifdef TI_C30
#include "ObjProDSPcom/ieeeflt.h"
#define SET_FLOAT(Param) Param = FromIeeeFloat(*(uint32 *) &(Std.Param))
#else
#define SET_FLOAT(Param) Param = Std.Param
#endif

#define SET(Param) Param = Std.Param


struct C30NodeOutChannelHeader {

	/* Begin Timing parameters */
	/***************************/
	int32 NumeratorSampling ;     
	int32 DenominatorSampling ;
	float SampleRate ;
	int32 TheTimingType ;
	float FirstSample ;
	float ErrorTolerance ;
	float DeltaTimeBase ;
	/***************************/
	/* End Timing parameters */

	/* Begin StreamStr parameters */
	/***************************/
	int32 ElementSize ;
	int32 BlockSize ;
	float MinimumX ;
	float MaximumX ;
	float SampleRateFactor ;
	/***************************/
	/* End StreamStr parameters */
	C30NodeOutChannelHeader(NodeOutChannelHeader& Std) {
		SET(NumeratorSampling);
		SET(DenominatorSampling);
		SET_FLOAT(SampleRate);
		SET(TheTimingType);
		SET_FLOAT(FirstSample);
		SET_FLOAT(ErrorTolerance);
		SET_FLOAT(DeltaTimeBase);
		SET(ElementSize);
		SET(BlockSize);
		SET_FLOAT(MinimumX);
		SET_FLOAT(MaximumX);
		SET_FLOAT(SampleRateFactor);
	}
};

#undef SET_FLOAT
#undef SET 


#ifdef TI_C30
extern uint32 SetFloatTemp ;
#define SET_FLOAT(Param) { \
	SetFloatTemp = ToIeeeFloat(C30.Param) ; \
	Param = *(double *) &SetFloatTemp ; \
}
#else
#define SET_FLOAT(Param) Param = C30.Param
#endif


