/*
 *  blkpltstr.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef BLKPLTSTR_DOT_H
#define BLKPLTSTR_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/gpltstr.h"

class GenericBlockPlotStr: public GenericPlotStr {
	StreamStr* StreamIn_1;
	const char *  Caption_2;
	double  MinY_3;
	double  MaxY_4;
	double  MinX_5;
	double  MaxX_6;
	int16  NumberBlocks_7;
	int16  ScaleFlag_8;
	TimingType  TheTimingType_9;
	PlotDynType  DynamicType_10;
public:
	GenericBlockPlotStr (const char * Name, StreamStr*StreamIn, 
		const char * Caption, double MinY, double MaxY, double MinX, 
		double MaxX, int16 NumberBlocks, int16 ScaleFlag, 
		TimingType TheTimingType, PlotDynType DynamicType);
	virtual ~GenericBlockPlotStr();
	StreamStr*GetStreamIn() const {return StreamIn_1;}
	const char * GetCaption() const {return Caption_2;}
	double GetMinY() const {return MinY_3;}
	double GetMaxY() const {return MaxY_4;}
	double GetMinX() const {return MinX_5;}
	double GetMaxX() const {return MaxX_6;}
	int16 GetNumberBlocks() const {return NumberBlocks_7;}
	int16 GetScaleFlag() const {return ScaleFlag_8;}
	TimingType GetTheTimingType() const {return TheTimingType_9;}
	PlotDynType GetDynamicType() const {return DynamicType_10;}
	virtual int CheckSafeDelete() ;
};


#endif /* #ifdef BLKPLTSTR_DOT_H */
