/*
 *  compare.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef COMPARE_DOT_H
#define COMPARE_DOT_H
#include "ObjProArith/hrdarth.h"

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/dsplstr.h"

class CompareDisk: public DisplayNodeStr {
#line 114 "../compare.usr"
 
	void FileInit() ;
	static class InputFile * TempInputFile ;
#ifdef INTERACTIVE
	int InitAfterLinked();
private:
	virtual TimingDescription * GetInitTiming(int Channel);
#endif
	void NoFileError();
	int Channels ;
	// int32 * ElementSize ;
	// int32 GetElementSize(int channel) {return ElementSize[channel];}
	int CompareValue(MachWord FileWord, MachWord InputWord);
	ErrCode CompareSamples(int32 k);
	class InputFile * TheInputFile ;
	double * SampleRateRatio ;
	double * CumulativeBlocks ;
	int32 compare_count;
	int ErrorCount ;
	int DisplayHandle ;
	int FirstTime ;
	int WindowId ;
	int BadNode ;
	double Diff ;
	double RelDiff ;
	double max_abs_diff ;
	double max_rel_diff ;
	class ofstream * out_file ;
	ErrCode kernel(int32 k);
	void dtor();
	void ctor();
#line 53 "/dist/opd_2/opd-0.2/src/include/ObjProDSPint/ObjProUsr/compare.h"
	int binary_read_flag ;
	virtual ErrCode EmitStaticInit(OutTokens& Out);
	virtual ErrCode EmitStaticCtorParameters(OutTokens& Out);
	const char *  FileName_1;
	int32  MaxReport_2;
	double  Tolerance_3;
	const char *  ErrorFile_4;
public:
	CompareDisk (const char * Name, const char * FileName, int32 MaxReport, 
		double Tolerance, const char * ErrorFile);
	virtual ~CompareDisk();
	const char * GetFileName() const {return FileName_1;}
	int32 GetMaxReport() const {return MaxReport_2;}
	double GetTolerance() const {return Tolerance_3;}
	const char * GetErrorFile() const {return ErrorFile_4;}
	virtual int CheckSafeDelete() ;
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	void DisplayHeader ();
	void IgnoreHeaderCount ();
#line 146 "../compare.usr"
	virtual int window_id(){return WindowId;}
#line 77 "/dist/opd_2/opd-0.2/src/include/ObjProDSPint/ObjProUsr/compare.h"
};

extern CompareDisk * CompareDiskDef;


#endif /* #ifdef COMPARE_DOT_H */
