/*
 *  netcnt.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef NETCNT_DOT_H
#define NETCNT_DOT_H
/*  netcnt.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
// This file contains declarations for control of data flow processes

//
//	CheckComplete - checks that a data flow net does not have any loose
//		        ends i. e. output links connected to nothing.
//
//	AssignBuffers - assigns buffers to a complete network.
//
//      DoNet - Executes a net for the specified number of input elements.
//              In the case of a net with more than one input all data
//              sources generate the same number of elements.
//
//	Note: NetControl is a `friend' of class network.

#include "ObjProDSP/portable.h"
#include "ObjProDSP/arthtyp.h"
#include "ObjProGui/basic.h"

#include "ObjProNet/dfnode.h"
#include "ObjProUsr/network.h"
#include "ObjProDSP/entenm.h"

class NodeExecute {
	DfNode * Node ;
	int32 ExecuteTimes ;
public:
	NodeExecute(DfNode& Nd, int32 Ex) {Node = &Nd; ExecuteTimes = Ex;}
	DfNode * GetNode() {return Node;}
	int32 GetTimes() { return ExecuteTimes;}
	void DoneTimes(int32 Times)  { ExecuteTimes -= Times; }
} ;

class NodeExecuteList: public SingleList {
public:
	ErrCode Insert(NodeExecute *nt) {return SingleList::Insert(nt);}
	ErrCode Append(NodeExecute *nt) {return SingleList::Append(nt);}
	NodeExecute * Get()   {return (NodeExecute *) SingleList::Get();}
	NodeExecuteList(){;}
	NodeExecuteList(NodeExecute *nt):
		SingleList(nt) {}
	int Size(){return SingleList::Size();}
} ;


class NodeExecuteIterator: public SingleListIterator {
public:
	NodeExecuteIterator(NodeExecuteList& df):
		SingleListIterator((SingleList&) df){}
	NodeExecute * operator()()
		{return (NodeExecute *) Next();}
};

class NetControl:public UserEntity {
	ProcessNet * Net;
	int AssignOk ;
	int TimingOk ;
	int timing_error ; // timing assigned but could not be resolved
	int TimingError ;
	int InitAfterLinkedOk ;
	int NetComplete ;
	int Executing ;
	BufferDescript* TheBufferDescript ;
	int ExecuteHeads(NodeExecuteList& ExeList) ;
	int ExecuteTails(NodeExecuteList& ExeList) ;
	int CheckExecuting(const char * Msg) ;
	void DeassignBufferDescriptor();
public:
	NetControl(const char *Name, ProcessNet& net) ;
	virtual ~NetControl();
	virtual int check_safe_delete();
	virtual clear_buffer_descriptor(BufferDescript * to_clear);
	int CheckComplete() ;
	int is_complete() ; // no user error if incomplete
	int List(class OutTokens&, ListEntity ListNode);
	void set_buffer_descriptor(BufferDescript& des);
	void set_buffer_descriptor();
	int AssignBuffers(BufferDescript&);
	void node_reset();
	int AssignBuffers();
	int ClearBuffers();
	int DeleteAllLinks(class DfNodeList * List = 0);
	int DeleteNetwork();
	void DoNetNode(DfNode&, int32);
	int DoNetNodeList(NodeExecuteList&) ;
	void DoExecute(int32 k) ;
	void GraphDisplay(int Option) ;
	void EditNetwork(const char * TypeEditObject) ;
	BufferDescript * GetTheBufferDescript() {return TheBufferDescript;}
	virtual void ClearNetwork();
	void InitArithType(ArithType::ArithTypes type);
	int is_timing_error() const {return timing_error;}
	void set_timing_error() {timing_error =1 ;}
	int AssignResampling(ThreadList * BaseNodes);
	Thread * first_strand(Thread * thread);
} ;
void NetControlsInit() ;
	
#endif /* #ifdef NETCNT_DOT_H */
