/*
 *  packword.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef PACKWORD_DOT_H
#define PACKWORD_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/procstr.h"

class PackWord: public ProcessNodeStr {
#line 38 "../packword.usr"
 
	int32 Ratio ;
	uint32 Mask ;
	ErrCode err_state ;
#ifdef INTERACTIVE
	virtual void input_linked(int in_channel)
		{err_state=propagate_arith_type(in_channel,-GetInputWordSize()*
			GetInputsPerOutput());}
#endif
#line 30 "/dist/opd_2/opd-0.2/src/include/ObjProDSPint/ObjProUsr/packword.h"
	int16  InputWordSize_1;
	int16  InputsPerOutput_2;
public:
	PackWord (const char * Name, int16 InputWordSize, int16 InputsPerOutput);
	virtual ~PackWord();
	int16 GetInputWordSize() const {return InputWordSize_1;}
	int16 GetInputsPerOutput() const {return InputsPerOutput_2;}
	virtual int CheckSafeDelete() ;
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
};

extern PackWord * PackWordDef;


#endif /* #ifdef PACKWORD_DOT_H */
