/*
 *  unnoise.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef UNNOISE_DOT_H
#define UNNOISE_DOT_H
#define __DSP_PP_TARGET_CODE__

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProDSPcom/tarnod.h"
class UniformNoise: public TargetNode {
#line 83 "../unnoise.usr"
 
	enum {state_size=256};
	char * state;
#line 24 "/dist/opd_2/opd-0.2/src/include/ObjProDSPtar/ObjProUsr/unnoise.h"
	double  Maximum_1;
	double  Minimum_2;
	int16  ElementSize_3;
	int32  Seed_4;
public:
	UniformNoise (const char * Name, double Maximum, double Minimum, 
		int16 ElementSize, int32 Seed,
		DfNodeInLink* in_links, DfNodeOutLink* out_links,
		int ** exec_seq,  NodeExecuteType exec_type,
		int delay);
	virtual ~UniformNoise();
	double GetMaximum() const {return Maximum_1;}
	double GetMinimum() const {return Minimum_2;}
	int16 GetElementSize() const {return ElementSize_3;}
	int32 GetSeed() const {return Seed_4;}
	virtual ErrCode DoNode(int32);
	virtual double TimeFirst(DfNodeInLink *,DfNodeOutLink *);
	void SetMaximum(double  Maximum) { Maximum_1 = Maximum; parameter_changed(); }
	void SetMinimum(double  Minimum) { Minimum_2 = Minimum; parameter_changed(); }
};

extern UniformNoise * UniformNoiseDef;


#endif /* #ifdef UNNOISE_DOT_H */
