/*
 *  baseio.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  baseio.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#ifndef BASEIO_DOT_H
#define BASEIO_DOT_H

#include <complex.h>
#include "ObjProDSP/portable.h"
#include "ObjProGen/usriotyp.h"
struct NameOrNumber {char * Name; int Number;} ;

extern const char * GetName (const char * Prompt, InputType Typ=InputUndefined);

extern NameOrNumber GetNameOrNumber(InputType Typ=InputUndefined) ;
extern NameOrNumber GetNameOrNumber(const char * String);

extern char * GetRawBufLine(InputType Typ=InputUndefined) ;
extern void ReturnToContinue(OutputType Typ=OutputUndefined) ;
extern int ReturnOrQuit(OutputType Typ=OutputUndefined);
extern void EndOfFile(); // routine called on end of file
extern int GetDoubleValue(const char * Prompt, double& val,
	InputType Typ=InputUndefined) ;
extern int GetIntValue(const char * Prompt, int32& val,
	InputType Typ=InputUndefined) ;
extern int GetStringValue(const char * Prompt, const char ** val,
	InputType Typ=InputUndefined) ;
extern int GetComplexValue(const char * Prompt, complex * val,
	InputType Typ=InputUndefined) ;

const BufSize = 512;
const char * Dec(long V) ;

#endif /* #ifdef BASEIO_DOT_H */
