/*
 *  cgihead.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  cgihead.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */

#include "ObjProGen/cgitypes.h"
	
extern "C" {
	
	/* Clear workstation 3-8 4-1 */
	SINT16 v_clrwk(SINT16 dev_handle);
	
	/* Close workstation 3-9 4-1 */
	SINT16 v_clswk(SINT16 dev_handle) ;
	
	/* Display graphics input cursor 3-29 4-4 */
	SINT16 v_dspcur(SINT16 dev_handle,SINT16 x,SINT16 y);
	
	/* Enter Cursor Addressing Mode 3-31 4-5 */
	SINT16 v_enter_cur(SINT16 dev_handle) ;
	
	/* Exit Cursor Addressing Mode 3-36 4-5 */
	SINT16 v_exit_cur(SINT16 dev_handle) ;
	
	/* Inquire alpha text capabilites: 3-39 4-6 */
	SINT16 vqa_cap(SINT16 dev_handle, SINT16 alpha_cap[15]) ;
	
	/* Inquire alpha text font capability: 3-44 4-6 */
	SINT16 vqa_font(SINT16 dev_handle, SINT16 font_in, SINT16 size_in,
		SINT16 font_status[7]) ;
	
	/* Inquire alpha text string length: 3-48 4-7 */
	SINT16 vqa_length(SINT16 dev_handle, const char * string) ;
	
	/* Inquire color representation: 3-59 4-8 */
	SINT16 vq_color(SINT16 dev_handle, SINT16 ind_in, SINT16 set_flag,
		SINT16 rgb[3]);
	
	/* Inquire CGI error 3-56 4-8 */
	SINT16 vq_error();
	
	/* Inquire graphics input cursor 3-79 4-11 */
	SINT16 vqg_cursor(SINT16 dev_handle, SINT16 * cursor_handle);
	
	/* Inquire graphics text extent 3-80 4-11 */
	SINT16 vqt_extent(SINT16 dev_handle, SINT16 x_in, SINT16 y_in,
		char String[], SINT16 * xcon, SINT16 * ycon,
		SINT16 rectangle[/* 8 */], BOOLEAN bool[/* 5 */]);
	
	/* Inquire graphics text font character 3-83 4-11 */
	SINT16 vqt_character(SINT16 dev_handle, SINT16 character, SINT16 n,
		SINT16 metrics[/* 5 */]);
	
	/* Inquire graphics text font description 3-85 4-11 */
	SINT16 vqtf_description(SINT16 dev_handle, SINT16 n,
		SINT16 description[/* n */], char font_name[]);
	
	/* Inquire graphics text font metrics 3-88 4-12 */
	SINT16 vqtf_metrics(SINT16 dev_handle, SINT16 n, SINT16 metrics[/* n */]);
	
	/* Inquire graphics text representation 3-90 4-12 */
	SINT16 vqt_representation(SINT16 dev_handle, SINT16 n,
		SINT16 attrib[/* 20 */]);
	
	/* Inquire line representation 3-96 4-13 */
	SINT16 vql_representation(SINT16 dev_handle, SINT16 n,
		SINT16 attrib[/* n (6 maximum)*/]);
	
	/* Inquire marker representation 3-99 4-13 */
	SINT16 vqm_representation(SINT16 dev_handle, SINT16 n,
		SINT16 attrib[/* n (6 maximum)*/]);
	
	/* Open workstation 3-108 4-14 */
	SINT16 v_opnwk(const SINT16 work_in[19], SINT16 * dev_handle,
		SINT16 work_out[66]);
	
	/* Output alpha text 3-116 4-14 */
	SINT16 v_atext(SINT16 dev_handle, const char * string, SINT16 * x_out,
		SINT16 * y_out) ;
	
	/* Output filled area 3-143 4-17 */
	SINT16 v_fillarea(SINT16 dev_handle,SINT16 count,
		SINT16 xy[/* 2*count */]);
	
	/* Output graphics text 3-146 4-17 */
	SINT16 v_gtext(SINT16 dev_handle, SINT16 x, SINT16 y,
		const char * string) ;
	
	/* Output polyline 3-152 4-18 */
	SINT16 v_pline(SINT16 dev_handle, SINT16 count,
		SINT16 xy[/* 2*count */]);
	
	/* Output polymarker 3-155 4-18 */
	SINT16 v_pmarker(SINT16 dev_handle, SINT16 count,
		SINT16 xy[/* 2*count */]);
	
	/* Remove graphics input cursor 3-162  4-19 */
	SINT16 v_rmcur(SINT16 dev_handle) ;
	
	/* Select graphics input cursor 3-183 4-22 */
	SINT16 vsg_cursor(SINT16 dev_handle, SINT16 cursor_handle) ;
	
	/* Set alpha text color index 3-184 4-23 */
	SINT16 vsa_color(SINT16 dev_handle, SINT16 ind_in);
	
	/* Set alpha text font and size: 3-186 4-23 */
	SINT16 vsa_font(SINT16 dev_handle,SINT16 font_in,SINT16 size_in,
		SINT16 font_cap[8]);
	
	/* Set alpha text position 3-193 4-24 */
	SINT16 vsa_position(SINT16 dev_handle, SINT16 x_in, SINT16 y_in,
		SINT16 * x_out, SINT16 * y_out) ;
	
	/* Set background color index 3-199 4-25 */
	SINT16 vsb_color(SINT16 dev_handle,SINT16 ind_in) ;
	
	/* Set background mode 3-201 4-25 */
	SINT16 vsb_mode(SINT16 dev_handle, SINT16 mode);
	
	/* Set color representation 3-205 4-25 */
	SINT16 vs_color(SINT16 dev_handle,SINT16 ind_in, SINT16 rgb_in[3],
		SINT16 rgb_out[3]) ;
	
	/* Set color table 3-207 4-25 */
	SINT16 vsc_table(SINT16 dev_handle,SINT16 s_index, SINT16 n,
		SINT16 rgb[/* n */][3]) ;
	
	/* Set fill area representation 3-214 4-26 */
	SINT16 vsf_representation(SINT16 dev_handle, SINT16 n, SINT16 attrib[3]);
	
	/* Set graphics text alignment 3-227 4-27 */
	SINT16 vst_alignment(SINT16 dev_handle, SINT16 hor_in, SINT16 vert_in,
		SINT16 * hor_out, SINT16 * ver_out);
	
	/* Set graphics text character height 3-232 4-27 */
	SINT16 vst_height(SINT16 dev_handle, SINT16 rq_height, SINT16 * char_height,
		SINT16 * cell_width, SINT16 * cell_height);
	
	/* Set graphics text color index 3-235 4-27 */
	SINT16 vst_color(SINT16 dev_handle, SINT16 ind_in);
	
	/* Set graphics text font 3-237 4-27 */
	SINT16 vst_font(SINT16 dev_handle, SINT16 font_in);
	
	/* Set graphics text representation 3-239 4-28 */
	SINT16 vst_representation(SINT16 dev_handle, SINT16 n, SINT16 attrib);
	
	/* Set graphics text string baseline rotation 3-241 4-28 */
	SINT16 vst_rotation(SINT16 dev_handle, SINT16 ang_in);
	
	/* Set line color: 3-245 4-29 */
	SINT16 vsl_color(SINT16 dev_handle,SINT16 ind_in);
	
	/* Set line type: 3-253 4-30 */
	SINT16 vsl_type(SINT16 dev_handle,SINT16 type_in) ;
	
	/* Set line width: 3-255 4-30 */
	SINT16 vsl_width(SINT16 dev_handle,SINT16 width_in) ;

	/* Set marker color: 3-257 4-30 */
	SINT16 vsm_color(SINT16 dev_handle,SINT16 ind_in);

	/* Set marker height: 3-259 4-30 */
	SINT16 vsm_height(SINT16 dev_handle,SINT16 hgt_in) ;
	
	/* Set marker type: 3-262 4-31 */
	SINT16 vsm_type(SINT16 dev_handle,SINT16 type_in) ;
	
	/* Set line type: 3-265 4-31 */
	SINT16 vsul_type(SINT16 dev_handle, int32 pattern);
	
}
