/*
 *  basic.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  basic.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
// This file contains the base class on which
// all interactive accessible objects is based

#ifndef BASIC_DOT_H
#define BASIC_DOT_H

#include "ObjProDSP/arthtyp.h"
#include "ObjProGui/yachead.h"

#include "ObjProDSP/entenm.h"
class OutTokens ;
extern int UserState ;



class UserEntity {
public:
	enum TargetType {NormalTarget,DebugTarget};
	enum Flag {FlagClear=0, FlagCppListed = 1, FlagUnusedDefault = 2,
		FlagCppStateEmitted = 4, FlagCppTargetStateEmitted = 8,
		FlagDoNotDelete = 16} ;
private:
	TargetType TheTargetType ;
	ArithType::ArithCapabilities ObjArithType ;
	const char * Name ;
	ValueType ThisType ;
	Flag Flags ;
	int DoEmitState(OutTokens& Out) ;
	int DoEmitTargetState(OutTokens& Out) ;
protected:
	void DoSetTargetType(TargetType type) ;
	virtual void SetTargetType() {DoSetTargetType(NormalTarget);}
	void SetArithType(ArithType::ArithCapabilities type)
		{ObjArithType=type;}
	void SetArithType(ArithType::ArithTypes type)
		{ObjArithType=(ArithType::ArithCapabilities)type;}
	ArithType::ArithCapabilities GetEntityArithType() const
		{return ObjArithType;}
public:
	UserEntity (const char * Nm) ;
	virtual ~UserEntity();
	virtual void Describe(class OutTokens&, ListEntity) ;
	virtual int CheckSafeDelete() ;
	virtual int check_safe_delete(); // always called used for base class check
	int SaveState(OutTokens&, CppListCmds) ;
	virtual int CppList(OutTokens&, CppListCmds) ;
	virtual void Dump(OutTokens&,ValueTypeList * Lst) ;

	virtual const char * EmitTargetState(OutTokens&) ;
	virtual const char * EmitState(OutTokens&) ;
		// Must be called repeatedly until a null pointer is returned.
		// Values returned are names of entities that must have
		// their state emitted prior to the emition of this entity's
		// state.

	void SetClass(ValueType * Set) ;
	void SetUnusedDefault() {Flags = (Flag) (Flags | FlagUnusedDefault);}
	void SetDoNotDelete() ;
	ValueType * GetValue() {return &ThisType;} 
	IsDeleteable() {return !(Flags & FlagDoNotDelete);}
	int IsUnusedDefault() {return Flags & FlagUnusedDefault;}
	void ClearUnusedDefault() {Flags =(Flag) (Flags & ~FlagUnusedDefault);}
	const char * GetName() const ;
	int Delete();
	TargetType GetTargetType() const {return TheTargetType;}
	const char * GetClassName() const ;
	Flag GetFlags() const {return Flags;}
	InteractiveEntity * interactive_entity() const;
	virtual void parameter_changed() {}
};

UserEntity * MakeDeclaredEntity(UserEntity *,class InteractiveEntity *) ;
	// Call before adding an entity to any of the lists
	// of declared objects 

#endif /* #ifdef BASIC_DOT_H */
