/*
 *  bufstat.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  bufstat.h   */
/*  Copyright 1991 Mountain Math Software  */
/*  All Rights Reserved                    */

#ifndef BUFSTAT_DOT_H
#define BUFSTAT_DOT_H
/*
 *	Explanation of BufferStatus::Goal:
 *		ExistingSize - use existing buffer size
 *		FixedSequence - provide a fixed uniform execution count
 */

class BufferStatus {
	int32 DesiredSize ;
	int32 MaxAllowedSize ;
	int32 MinAllowedSize ; 
	TargetAdjustState State ;
	int32 TryLargerBuffer ; // Minimum size to try
	int ExecuteSequenceLength ;
	int InitSequenceLength ;
	int ExecutionSequenceIndex ;
	int ForwardFlag ;
	double MaxSamplingRatio ;
	int32 NumeratorMaxRatio ;
	int32 NumLeastCommonMul ;
	int32 DenominatorMaxRatio ;
	int32 DenLeastCommonMul ;
	int32 TotalInitExecCountHighestRateNode ;
	enum ProcessingState {PreInitState, PreInitMaxBufState,
		InitState, FlushState, MultipleState,
		CheckState, FinalState} TheState ;
public:
	enum Goal {ExistingSize,FixedSequence} TheGoal;
	enum SizeGoal {DesiredSizeUpperBound,DesiredSizeExact,
		DesiredSizeExactRequired,DesiredSizeLowerBound}TheSizeGoal;
private:
	int32 TotalSize ;
	int32 MaxSize ;
	ReasonForFailure * Reason ;
public:
	BufferStatus();
	BufferStatus(int32 desired, int32 max, int32 min, Goal goal, 
		SizeGoal size_goal) ;
	void Clear() ;
	void SetGoals(Goal goal, SizeGoal s_goal,int32 desired, int32 max,
		int32 min) ;
	int32 GetDesiredSize() const {return DesiredSize;}
	int32 GetMaxSize() const {return MaxAllowedSize;}
	int32 GetMinSize() const {return MinAllowedSize;}
	int32 GetTotalSize() const {return TotalSize;}

	Goal GetGoal() const {return TheGoal;}
	SizeGoal GetSizeGoal() const {return TheSizeGoal;}
	
	void IncrementTotalSize(int32 inc) {TotalSize+=inc;}
	void UpdateMaxSize(int size)
		{if (size > MaxSize) MaxSize=size;}

	void Explain(ostream& Out) const ;
	void Report(ostream& Out) const ;
	void SetReason(ReasonForFailure* reason){Reason=reason;}
	int IsFatal() const ;
	ReasonForFailure * GetReason() const {return Reason;}
	int IsFailure() const {return Reason != 0 ;}
	int CheckError() ;
	int32 AllowedSize(int32 minimum, int32 maximum) ;
	TargetAdjustState UpdateState(TargetAdjustState Check);
	TargetAdjustState GetState() const {return State;}
	void SetState(TargetAdjustState NewState) {State = NewState;}
	const char * BufferStatus::GoalToString(Goal goal) const ;
	const char * BufferStatus::SizeGoalToString(SizeGoal size_goal) const ;
	int32 GetTryLargerBuffer() const {return TryLargerBuffer;}
	void SetTryLargerBuffer(int32 val) {TryLargerBuffer= val;}
	int TryLarger() ;
	int GetExecuteSequenceLength() const {return ExecuteSequenceLength;}
	int GetInitSequenceLength() const {return InitSequenceLength;}
	int& GetExecuteSequenceLengthRef() {return ExecuteSequenceLength;}
	int& GetInitSequenceLengthRef() {return InitSequenceLength;}
	int GetExecutionSequenceIndex() const {return ExecutionSequenceIndex;}
	void SetExecutionSequenceIndex(int index)
		{ExecutionSequenceIndex = index;}
	void ClearExecutionSequences() ;
	int IsForwardFlag() const {return ForwardFlag;}
	void SetForwardFlag() {ForwardFlag=1;}
	void ClearForwardFlag() {ForwardFlag=0;}

	void SetInitState() {TheState = InitState ; }
	void SetPreInitState() {TheState = PreInitState ; }
	void SetPreInitMaxBufState() {TheState = PreInitMaxBufState ; }

	int AdvanceStateExecute() ;
	int AdvanceStateInit() ;

	int IsPreInitState() const {return TheState == PreInitState;}
	int IsPreInitMaxBufState() const {return TheState==PreInitMaxBufState;}
	int IsInitState() const {return TheState == InitState;}
	int IsFlushState() const {return TheState == FlushState;}
	int IsMultipleState() const {return TheState == MultipleState;}
	int IsCheckState() const {return TheState == CheckState;}

	const char * StateToString() ;
	TargetAdjustState NewResamplingForTerminalNode(int32 Num, int32 Denom);
	int32 GetMaxNum() const { return NumeratorMaxRatio ;}
	int32 GetMaxDen() const { return DenominatorMaxRatio ;}
	int32 GetNumLeastCommon() const { return NumLeastCommonMul;}
	int32 GetDenLeastCommon() const { return DenLeastCommonMul;}
	void SetTotalInitExecCountHighestRateNode(int32 total)
		{TotalInitExecCountHighestRateNode = total;}
	int32 GetTotalInitExecCountHighestRateNode() const
		{return TotalInitExecCountHighestRateNode;}
	double GetMaxSamplingRatio() const
		{ return ((double) NumeratorMaxRatio) / DenominatorMaxRatio; }

	double GetDoubMinBufInc() const ;
	int32 GetMinBufInc() const ;
};

#endif /* #ifdef BUFSTAT_DOT_H */
