/*
 *  shrbuf.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#include "ObjProDSP/portable.h"
class ostream ;

class SharedBuffer {
	int32 MaxSize ;
	int32 Allocated ;
	int32 Temp ;
	void CheckMax() {if (MaxSize < Allocated) MaxSize = Allocated;}
public:
	const char * Name ;
	SharedBuffer(const char * name):
		Allocated(0),
		MaxSize(0),
		Name(name)
	{}
	void Reset() {CheckMax(); Allocated = 0 ;}
	int32 GetMaxSize() {CheckMax(); return MaxSize;}
	int32 GetSpace(int Needed)
		{Temp=Allocated; Allocated+=Needed; return Temp;}
	void clear() {MaxSize=Allocated=0;}
	void declare_name(ostream&);
	void declare_space(ostream&);
};

extern SharedBuffer TheSharedBuffer ;

