/*
 *  hrdcmp.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  hrdcmp.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#ifndef HRDCMP_DOT_H
#define HRDCMP_DOT_H
#include "ObjProArith/hrdarth.h"
/****************************
	int operator<(AccMachWord);
	int operator>(AccMachWord);
	int operator<=(AccMachWord);
	int operator>=(AccMachWord);
	int operator==(AccMachWord);
	int operator!=(AccMachWord);
*******************/

#define DeclareMachWordOperators(MachWord,int16) 			\
inline void MachWord::operator+=(MachWord x) {value += (int16) x;}\
inline void MachWord::operator-=(MachWord x) {value -= (int16) x;}\
inline void MachWord::operator*=(MachWord x) {value *= (int16) x;}\
inline void MachWord::operator/=(MachWord x) {value /= (int16) x;}\
inline void MachWord::operator&=(MachWord x) {value &= (int16) x;}\
inline void MachWord::operator|=(MachWord x) {value |= (int16) x;}\
inline void MachWord::operator^=(MachWord x) {value ^= (int16) x;}\
inline void MachWord::operator%=(MachWord x) {value %= (int16) x;}\
inline int MachWord::operator<(MachWord x) const {return value < (int16) x;}\
inline int MachWord::operator>(MachWord x) const {return value > (int16) x;}\
inline int MachWord::operator<=(MachWord x) const {return value<=(int16) x;}\
inline int MachWord::operator>=(MachWord x) const {return value>=(int16) x;}\
inline int MachWord::operator==(MachWord x) const {return value==(int16) x;}\
inline int MachWord::operator!=(MachWord x) const {return value!=(int16) x;}\
inline void MachWord::operator<<=(int x) {value <<= x;}		\
inline void MachWord::operator>>=(int x) {value >>= x;}		\
inline MachWord operator+(MachWord a,MachWord b) 			\
	{return (int16) ((int16) a + (int16) b);}			\
inline MachWord operator-(MachWord a,MachWord b) 	 		\
	{return (int16) ((int16) a - (int16) b);}			\
inline MachWord operator*(MachWord a,MachWord b) 	 		\
	{return (int16) ((int16) a * (int16) b);}			\
inline MachWord operator/(MachWord a,MachWord b) 	 		\
	{return (int16) ((int16) a / (int16) b);}			\
inline MachWord operator&(MachWord a,MachWord b) 	 		\
	{return (int16) ((int16) a & (int16) b);}			\
inline MachWord operator|(MachWord a,MachWord b) 	 		\
	{return (int16) ((int16) a | (int16) b);}			\
inline MachWord operator^(MachWord a,MachWord b) 	 		\
	{return (int16) ((int16) a ^ (int16) b);}			\
inline MachWord operator%(MachWord a,MachWord b) 	 		\
	{return (int16) ((int16) a % (int16) b);}			\
inline MachWord operator<<(MachWord a,int b) 		 		\
	{return (int16) ((int16) a << (int16) b);}			\
inline MachWord operator>>(MachWord a,int b) 	 			\
	{return (int16) ((int16) a >> (int16) b);}			\

DeclareMachWordOperators(MachWord,int16);
DeclareMachWordOperators(AccMachWord,int32);


#define DeclareCxMachWordOperators(CxMachWord,MachWord)		\
CxMachWord operator+(const CxMachWord& a,const CxMachWord& b) ;		\
CxMachWord operator-(const CxMachWord& a,const CxMachWord& b) ;		\
CxMachWord operator*(const CxMachWord& a,const CxMachWord& b) ;		\
CxMachWord operator*(MachWord a,const CxMachWord& b) ;			\
CxMachWord operator*(const CxMachWord& a,MachWord b) ;			\
CxMachWord operator/(const CxMachWord& a,const CxMachWord& b) ;		\
CxMachWord operator/(const CxMachWord& a,MachWord b) ;			\
CxMachWord operator&(const CxMachWord& a,const CxMachWord& b) ;		\
CxMachWord operator|(const CxMachWord& a,const CxMachWord& b) ;		\
CxMachWord operator^(const CxMachWord& a,const CxMachWord& b) ;		\
CxMachWord operator%(const CxMachWord& a,const CxMachWord& b) ;		\
CxMachWord operator<<(const CxMachWord& a,int b) ;		\
CxMachWord operator>>(const CxMachWord& a,int b) ;		\

DeclareCxMachWordOperators(CxMachWord,MachWord) ;
DeclareCxMachWordOperators(CxAccMachWord,AccMachWord) ;



inline ostream& operator<<(ostream& o, MachWord v)    {return o << (int16) v;}
inline ostream& operator<<(ostream& o, AccMachWord v) {return o << (int32) v;}
inline ostream& operator<<(ostream& o, CxMachWord v)  {return o << (complex) v;}
inline ostream& operator<<(ostream& o, const CxAccMachWord& v)
		{return o << (complex) v;}


#endif /* #ifdef HRDCMP_DOT_H */
