/*
 *  menus.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  menus.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <stream.h>

#include "cgidbg.h"
#include "intfc.h"
#include "outtok.h"
#include "baseio.h"
#include "yacintfc.h"
#include "remmen.h"
#include "dspe_app.h"
// #include "dremmenu.h"
// #include "remdorem.h"

// #include "nodeincs.h"

static void node_trace_on()
{
	DspApplication::node_trace_on();
}

static void node_trace_off()
{
	DspApplication::node_trace_off();
}

static void heap_check_on()
{
	DspApplication::heap_check_on();
}

static void heap_check_off()
{
	DspApplication::heap_check_off();
}

static void set_report_overflow_limit()
{
	DspApplication::set_report_overflow_limit();
}


static void NotInYet()
{
	*Output + OutputHelp << "Not implemented yet.\n" ;
	ReturnToContinue() ;
}

static void ListSignals()
{
	NotInYet();
}

static void ListBuffers()
{
	NotInYet();
}

static void ListNets()
{
	NotInYet();
}

static void ClassesNodes()
{
	OutTokens Out(OutputHelp) ;
	TheNodes->Describe(Out,ListEntityClasses) ;
	ReturnToContinue() ;
}
static void MembersNodes()
{
	OutTokens Out(OutputHelp) ;
	TheNodes->Describe(Out,ListEntityMembers) ;
	ReturnToContinue() ;
}
static void SingleNode()
{
	OutTokens Out(OutputHelp) ;
	TheNodes->Describe(Out,ListSingleEntity) ;
}

static void CreateNodes()
{
	TheNodes->Create() ;
}

static void DeleteNodes()
{
	TheNodes->Delete() ;
}



static void ListObject() {State.ListObject();}
static void ListObjects() {State.ListObjects();}
static void ListClasses() {State.ListClasses();}
static void ListBaseClasses() {State.ListBaseClasses();}


static void ListInt() {State.ListInt();}
static void ListDouble() {State.ListDouble();}
static void ListComplex() {State.ListComplex();}
static void ListMachWord() {State.ListMachWord();}
static void ListAccMachWord() {State.ListAccMachWord();}
static void ListCxMachWord() {State.ListCxMachWord();}
static void ListCxAccMachWord() {State.ListCxAccMachWord();}

static void DoSaveExit()
{
	// LogOut << "DoSaveExit\n" ;
	if (!State.IsStateSaved()) State.Save() ;
	// LogOut << "After saved\n" ;
	ExitAndCleanUp();
}

static void DoExit()
{
	// LogOut << "DoExit\n" ;
	State.Exit();
	// LogOut << "After State.Exit\n" ;
}

static void DoSaveAs()
{
	State.SaveAs();
}

static void DoSave()
{
	State.Save() ;
}

static void DoSavePeriod()
{
	State.SavePeriod() ;
}

static void DisplaySaveFileName()
{
	State.DisplaySaveFileName() ;
}

static void SetStateSaveFile()
{
	State.SetSaveFileName() ;
}

// unknown


// #include "yacintfc.h"
static void LocCommandMain() {CommandMain();}

#include "defined.h"
