#include "portable.h"
#include "menexe.h"
#include "menutab.h"
static const char * HelpTextList_HelpMemberExecute[] = {
	"This executes the selected member function of an object.",
	0
};
static const char * HelpTextList_MemberHelp[] = {
	"This selects a menu for a member function.",
	"From this menu you can get information on or execute the function.",
	0
};
static const char * HelpTextList_MemberParamDescribeHelp[] = {
	"This describes a member function's parameters.",
	0
};
static const char * HelpTextList_MemberMenuHelp[] = {
	"This describes the member function and its",
	"calling sequence.",
	0
};
static const char * HelpTextList_NodeInstanceDescribeHelp[] = {
	"This describes the object and the parameters of its constructor.",
	0
};
static const char * HelpTextList_NodeParamHelp[] = {
	"This selects a menu of object parameters.",
	"Parameters that are also",
	"object variables can be changed at any time.",
	0
};
static const char * HelpTextList_NodeVariableHelp[] = {
	"This selects a menu of object variables.",
	"These values may be changed at any time from the menu tree or",
	"by calling NODE.SetNAME(new_value) where NODE is the object name,",
	"NAME is the parameter name and new_value is its desired value.",
	0
};
static const char * HelpTextList_NodeInstanceHelp[] = {
	"This selects a menu of instances of this object.",
	"You can view its definition,",
	"parameters and help information.",
	0
};
static const char * HelpTextList_NodeCreateHelp[] = {
	"Create an instance of this object.",
	"You will be prompted for each of its parameters.",
	0
};
static const char * HelpTextList_NodeCreateDefaultHelp[] = {
	"Create an instance of this object using default parameters.",
	0
};
static const char * HelpTextList_NodeDeleteHelp[] = {
	"This deletes an instance",
	"of this object.",
	"You will be prompted to confirm this action.",
	"You can only delete instances that have been defined interactively.",
	0
};
static const char * HelpTextList_ParamInstanceDescribeHelp[] = {
	"This describes the object parameters,",
	"including their default values and range.",
	0
};
static const char * HelpTextList_VariableInstanceDescribeHelp[] = {
	"This describes the object's changeable variables,",
	"including their use, default values and range.",
	0
};
static const char * HelpTextList_StateSavePeriodicHelp[] = {
	"You can specify that the state is to be saved",
	"periodically based on the number of user actions since",
	"the last state change. A user action is a operator",
	"or function call. One statement can have",
	"several actions.",
	0
};
static const char * HelpTextList_1[] = {
	"The",
	"`help'",
	"menu contains information organized by topics.",
	"It covers the ObjectProDSP language and describes the use",
	"of this program. It has information for the new user and is",
	"an on-line reference manual.",
	"You can control the amount of",
	"automatic help information from",
	"this menu.",
	0
};
static const char * HelpTextList_2[] = {
	"The",
	"`objects'",
	"menu provides tree structured access to the",
	"definitions and descriptions of objects. It allows objects",
	"to be created and destroyed.",
	0
};
static const char * HelpTextList_3[] = {
	"From the",
	"`setup'",
	"menu",
	"you may read and execute a ObjectProDSP state file created",
	"in a previous session or created manually. You may also read",
	"a plot file created in a previous session and control debugging",
	"options.",
	0
};
static const char * HelpTextList_4[] = {
	"In the",
	"`state'",
	"menu you can save the DSP++ program state",
	"to a disk file, set ObjectProDSP to automatically save the program state",
	"periodically and control and display the name of the file in which to",
	"save the state. You can also record and play back ObjectProDSP sessions.",
	0
};
static const char * HelpTextList_5[] = {
	"`save and exit'",
	"exits to the operating system.",
	"If you have not",
	"saved the state of objects since they were last changed",
	"the state will be saved before exiting.",
	"Use the",
	"`state'",
	"menu if you wish to exit without saving.",
	"If the DSP process is hung you may need to do this twice to get",
	"information about its state.",
	0
};
static const char * HelpTextList_6[] = {
	"The",
	"`introduction'",
	"help screen provides a general description of the",
	"ObjectProDSP system. It describes on the purpose,",
	"capabilities and general structure of this tool.",
	0
};
static const char * HelpTextList_7[] = {
	"Copyright 1994 Mountain Math Software, all rights reserved.",
	"This software is licensed for free use and distribution",
	"under version 2 of the GNU General Public License.",
	"You can use and distribute this software free of charge",
	"provided you do so in accord with the provisions of this license.",
	"The",
	"`copying'",
	"help screen contains the text of this",
	"license, a warranty notice (THERE IS NO WARRANTY)",
	"and information about support and other",
	"licensing arrangements.",
	0
};
static const char * HelpTextList_8[] = {
	"The",
	"`manual'",
	"menu is an online manual. It describes",
	"how to graphically create and edit DSP networks, the DSP++ language,",
	"and other capabilities of this tool.",
	0
};
static const char * HelpTextList_9[] = {
	"The",
	"`examples'",
	"menu demonstrates the construction and simulation",
	"of several DSP systems.",
	0
};
static const char * HelpTextList_10[] = {
	"From the",
	"`help levels'",
	"menu you can change the information",
	"displayed automatically. This includes descriptions such as this one",
	"of menu entries and the confirmation messages from most actions.",
	0
};
static const char * HelpTextList_11[] = {
	"The",
	"`about help'",
	"help screen describes the level of help available,",
	"how to access help information and how to control the information",
	"displayed automatically.",
	0
};
static const char * HelpTextList_12[] = {
	"The",
	"`DSP nets'",
	"help screen describe how to graphically create and edit",
	"DSP networks. It describes how to execute the networks and create a stand",
	"alone program that implements the network you built.",
	0
};
static const char * HelpTextList_13[] = {
	"The",
	"`DSP++'",
	"menu describes describes the main elements",
	"in the DSP++ language. It also contains information on validation suites.",
	0
};
static const char * HelpTextList_14[] = {
	"The",
	"`commands'",
	"help screen describes commands accessible",
	"through the menu data base and describes how to record and playback",
	"action files of commands and other user input.",
	0
};
static const char * HelpTextList_15[] = {
	"The",
	"`release'",
	"help screen displays the release notes for this version",
	"of ObjectProDSP. These include known limitations and describe things",
	"we would like to change and improve.",
	0
};
static const char * HelpTextList_16[] = {
	"Ths",
	"`network help'",
	"screen describes ObjectProDSP processing networks.",
	"Processing is done in a network of nodes or objects.",
	"The initial node or nodes are signal sources. The terminal node",
	"or nodes output to a window or disk file.",
	0
};
static const char * HelpTextList_17[] = {
	"The",
	"`object help'",
	"screen describes the ObjectProDSP processing objects.",
	0
};
static const char * HelpTextList_18[] = {
	"The",
	"`plot help'",
	"screen describes objects that plot their",
	"input.",
	0
};
static const char * HelpTextList_19[] = {
	"The",
	"`syntax'",
	"help screen gives an introduction ObjectProDSP",
	"language structure. You do not need to know",
	"this language but you may find it helpful especially if you are already",
	"familiar with C++. Often operations that you enter graphically",
	"are translated to DSP++ language statements which are scrolled in",
	"the main window.",
	0
};
static const char * HelpTextList_20[] = {
	"ObjectProDSP has facilities for automated validation.",
	0
};
static const char * HelpTextList_21[] = {
	"`help none'",
	"disables display of help",
	"information except for error messages.",
	0
};
static const char * HelpTextList_22[] = {
	"`help confirm'",
	"displays confirmation messages for most user",
	"actions. It disables the automatic display of the menu item",
	"descriptions such as this is. These descriptions can still be selected",
	"manually using mouse button three.",
	0
};
static const char * HelpTextList_23[] = {
	"`help all'",
	"enables all help displays including",
	"confirmation of user actions and descriptions of each menu selection.",
	0
};
static const char * HelpTextList_24[] = {
	"`read state'",
	"reads a text file of ObjectProDSP language",
	"statements created either automatically or manually.",
	"The objects defined in the",
	"file are added to",
	"existing objects. Existing",
	"objects will not be overwritten.",
	"If an error occurs processing will stop and the error and line number",
	"where it occurs will be displayed.",
	0
};
static const char * HelpTextList_25[] = {
	"`read over state'",
	"reads a text file of ObjectProDSP language",
	"statements created either automatically or manually.",
	"The objects defined in the",
	"file will be added to any objects already defined. If the",
	"file defines an existing object, it will be deleted and",
	"replaced by the object in the file.",
	"If an error occurs processing will stop and the error and line number",
	"where it occurs will be displayed.",
	0
};
static const char * HelpTextList_26[] = {
	"`read plot'",
	"reads and displays a plot file that was previously saved.",
	0
};
static const char * HelpTextList_27[] = {
	"The",
	"`debug'",
	"menu allows you to control network tracing, reporting",
	"of overflows and check dynamic memory allocation integrity.",
	0
};
static const char * HelpTextList_28[] = {
	"`trace'",
	"causes the name of each node to be output to the",
	"log file `dsp.messages' just before it is executed. If you",
	"are debugging multiple nodes and the program crashes this will",
	"allow you to determine the node in which the problem occurs.",
	0
};
static const char * HelpTextList_29[] = {
	"`trace off'",
	"disables the trace of node execution written to the",
	"log file `dsp.messages'.",
	0
};
static const char * HelpTextList_30[] = {
	"`heap ck'",
	"causes a check to be made on the heap integrity before",
	"and after each node execution. This can be helpful in tracking errors",
	"related to dynamic memory allocation that may not cause a problem",
	"immediately. This check is not certain to find all problems with the",
	"heap but in practice it seems to detect most of them and produce",
	"some system error. Turning this on also turns on trace. This",
	"option can significantly slow program execution.",
	0
};
static const char * HelpTextList_31[] = {
	"`heap ck off'",
	"turns off the heap integrity check.",
	"If you are turning this off you may also want to turn off",
	"tracing. Both these options are turned on by",
	"`heap ck'",
	"but",
	"this command only turns of heap checking.",
	0
};
static const char * HelpTextList_32[] = {
	"The first time overflows occur in a node they are reported in",
	"the help information window. Later overflow are reported",
	"every time the total number of new overflows exceeds a user",
	"specified limit.",
	"`over lim'",
	"sets this limit. If trace is",
	"enabled then the count of overflows in each node",
	"are written to the log file `dsp.messages'.",
	0
};
static const char * HelpTextList_33[] = {
	"`list int'",
	"displays the names and values of",
	"integer variables.",
	0
};
static const char * HelpTextList_34[] = {
	"`list float'",
	"displays the names and values of",
	"floating point double precision variables.",
	0
};
static const char * HelpTextList_35[] = {
	"`list mach'",
	"displays the names and values of",
	"MachWord variables. MachWord is the type",
	"for single precision objects in the machine being simulated.",
	0
};
static const char * HelpTextList_36[] = {
	"`list accmach'",
	"displays the names and values of",
	"AccMachWord variables.",
	"AccMachWord is the type for double precision (typically",
	"in the accumulator) objects in the machine being simulated.",
	0
};
static const char * HelpTextList_37[] = {
	"These objects do signal processing",
	"such as filtering, demodulation and resampling. The",
	"`dsp processing'",
	"menu",
	"displays object classes and object instances including",
	"those you have defined interactively.",
	0
};
static const char * HelpTextList_38[] = {
	"There are several ways in which test signals can be generated.",
	"The",
	"`signal'",
	"menu describes the signal generators and",
	"their parameters and instances of them.",
	0
};
static const char * HelpTextList_39[] = {
	"Frequently DSP output is most easily evaluated with a data plot.",
	"The",
	"`plot'",
	"menu lists the plotting objects their parameters and",
	"instances of them.",
	0
};
static const char * HelpTextList_40[] = {
	"It is often useful to provide numeric listings of DSP data",
	"streams. The",
	"`list'",
	"menu describes the listing",
	"objects their parameters and instances of them.",
	0
};
static const char * HelpTextList_41[] = {
	"Options in the",
	"`disk'",
	"menu support reading and writing",
	"of disk files. You can save the output from any node",
	"in a network to a disk file. You can use data",
	"in a disk file as a signal source. This menu describes",
	"these objects, their parameters and instances of them.",
	0
};
static const char * HelpTextList_42[] = {
	"This menu describes classes for networks and their controllers.",
	"It describes classes for building multiple network systems.",
	0
};
static const char * HelpTextList_43[] = {
	"The",
	"`variables'",
	"menu displays the simple variables (integer and double",
	"precision floating point).",
	0
};
static const char * HelpTextList_44[] = {
	"The",
	"`ascii'",
	"menu provides access to nodes for reading",
	"and writing ascii formatted files. From the",
	"`ascii'",
	"menu you can list",
	"the existing objects, describe their parameters, create",
	"new objects and delete existing ones.",
	0
};
static const char * HelpTextList_45[] = {
	"The",
	"`binary'",
	"menu provides access to nodes for reading and",
	"writing",
	"binary disk files. From the",
	"`binary'",
	"menu you can list",
	"the existing objects, describe their parameters, create",
	"new objects and delete existing ones.",
	0
};
static const char * HelpTextList_46[] = {
	"This executes the selected example. First a graphical display",
	"of the DSP network will appear. This will be followed by",
	"windows for each plot or listing object in the network. When",
	"execution completes you can edit the example network. You can",
	"only execute an example once because after that all the objects",
	"in the example will be defined and cannot be redefined",
	"with the execute command.",
	0
};
static const char * HelpTextList_47[] = {
	"This executes the selected example. First a graphical display",
	"of the DSP network will appear. This will be followed by windows",
	"for each plot or listing object in the network. When execution",
	"completes you can edit the example network.",
	"`execute over'",
	"overwrites any objects in the example that are already defined.",
	"You can execute this command as many times as you want but it can",
	"also overwrite objects you have defined.",
	"Be careful in using this option.",
	0
};
static const char * HelpTextList_48[] = {
	"Save the state to the latest version of the input file name",
	"(or the name last set by the `set name' command). The default name",
	"is `dsppp'. If the file name has a `.' in it then multiple",
	"backup versions will not be generated and the state will be saved",
	"to",
	"`stat.lxxxxx' where `l' is a letter and `x' a digit.",
	"Use `save as' if you want to be prompted",
	"for a file name with no support for multiple versions.",
	0
};
static const char * HelpTextList_49[] = {
	"Save the state to a file that you will be prompted for.",
	"If the file already exist you will be asked of you want to",
	"overwrite it.",
	0
};
static const char * HelpTextList_50[] = {
	"`set name'",
	"displays the current base name for saving DSP++ objects and",
	"the number of backups saved. You can change either of these.",
	"If the file name",
	"name does not contain a `.', the state will be saved in multiple",
	"versions called `NAME.0', `NAME.1', etc. The LOWEST numbered",
	"version is the most recent. Thus `NAME.0' will always be the",
	"current or last saved version. The default value for `NAME' is `dsppp'.",
	"If you specify a file name with a `.' the state will be saved to",
	"a unique name of the form `stat.XXXXX' where `XXXXX' is a string",
	"created by the system utility `mktemp'.",
	"The original file you specify as input will never be overwritten if",
	"it contains a `.'.",
	0
};
static const char * HelpTextList_51[] = {
	"The",
	"`session'",
	"menu allows you to record and play back entire ObjectProDSP",
	"sessions.",
	0
};
static const char * HelpTextList_52[] = {
	"`abort dsp'",
	"aborts execution of the DSP process",
	"by generating a user error. If the DSP process is not",
	"executing, this command has no effect.",
	0
};
static const char * HelpTextList_53[] = {
	"`plot err'",
	"displays the count of non numeric values (NAN and",
	"infinity) in all plot data streams. This should not happen",
	"unless you are debugging a node that generates such values.",
	"There is only limited protection against this. Such values",
	"can cause the system to crash with a floating point exception.",
	0
};
static const char * HelpTextList_54[] = {
	"`freeze'",
	"stops DSP process execution to temporarily reduce system load.",
	0
};
static const char * HelpTextList_55[] = {
	"`thaw'",
	"resumes DSP process execution after a",
	"`freeze'",
	".",
	0
};
static const char * HelpTextList_56[] = {
	"`exit'",
	"exits to the operating system. If you have not",
	"saved the state of since you last changed",
	"something, you will be asked if you wish to save the state.",
	"If the DSP process is hung you may need to do this twice to get",
	"information about its state.",
	0
};
static const char * HelpTextList_57[] = {
	"If you have previously been recoding and have not closed the file",
	"recording will continue in the same file. Otherwise you will",
	"be prompted for a file name.",
	0
};
static const char * HelpTextList_58[] = {
	"You can resume recording to the same file with this option.",
	0
};
static const char * HelpTextList_59[] = {
	"You can not resume recording to the same file after this selection.",
	0
};
static const char * HelpTextList_60[] = {
	"To abort playback hold the control key (Ctrl) down and hit the",
	"`Delete' key with the main ObjectProDSP window selected.",
	0
};
static const char * HelpTextList_61[] = {
	"`pause'",
	"prompts you for a delay in seconds between session commands.",
	"This allows you to view recorded ObjectProDSP sessions as a",
	"tutorial movie.",
	0
};
static const char * HelpTextList_AddMainHelpDefinition[] = {
	"`Add'",
	"sums",
	"`Channels'",
	"input channels into a single output channel.",
	"Each sample is multiplied by",
	"`Scale'",
	"before being added to the",
	"output channel. Overflows are prevented by clipping. The first",
	"time clipping occurs a help message is generated. A new help",
	"message is generated after every 400 clippings. Each sample",
	"consists of",
	"`ElementSize'",
	"words.",
	"`ElementSize'",
	"is usually one",
	"for real data streams and two for complex streams, but it can",
	"be any 16 bit positive integer and used for any purpose.",
	0
};
static const char * HelpTextList_62[] = {
	"`Channels'",
	"specifies the number of input channels",
	"to be added together in a single output channel.",
	0
};
static const char * HelpTextList_63[] = {
	"`ElementSize'",
	"specifies the sample size for",
	"each channel. The most common use of",
	"`ElementSize'",
	"is to",
	"set it to two for a complex data stream. All input data",
	"streams must have the same sample size. If set to 0",
	"`ElementSize'",
	"is set automatically based on its value for the first input node.",
	0
};
static const char * HelpTextList_64[] = {
	"`Scale'",
	"is a scale factor applied to each channel before",
	"it is added to the output channel. The channel addition",
	"will clip any data that would otherwise create an overflow",
	"and generate a help message. Only one help messages is",
	"generated, for every 400 input samples regardless of the",
	"number of overflows that may occur.",
	0
};
static const char * HelpTextList_65[] = {
	"`Scale'",
	"is a scale factor applied to each channel before",
	"it is added to the output channel. The channel addition",
	"will clip any data that would otherwise create an overflow",
	"and generate a help message. Only one help messages is",
	"generated, for every 400 input samples regardless of the",
	"number of overflows that may occur.",
	0
};
static const char * HelpTextList_66[] = {
	"`Channels'",
	"specifies the number of input channels",
	"to be added together in a single output channel.",
	0
};
static const char * HelpTextList_67[] = {
	"`ElementSize'",
	"specifies the sample size for",
	"each channel. The most common use of",
	"`ElementSize'",
	"is to",
	"set it to two for a complex data stream. All input data",
	"streams must have the same sample size. If set to 0",
	"`ElementSize'",
	"is set automatically based on its value for the first input node.",
	0
};
static const char * HelpTextList_68[] = {
	"`Scale'",
	"is a scale factor applied to each channel before",
	"it is added to the output channel. The channel addition",
	"will clip any data that would otherwise create an overflow",
	"and generate a help message. Only one help messages is",
	"generated, for every 400 input samples regardless of the",
	"number of overflows that may occur.",
	0
};
static const char * HelpTextList_69[] = {
	"`Scale'",
	"is a scale factor applied to each channel before",
	"it is added to the output channel. The channel addition",
	"will clip any data that would otherwise create an overflow",
	"and generate a help message. Only one help messages is",
	"generated, for every 400 input samples regardless of the",
	"number of overflows that may occur.",
	0
};
static const char * HelpTextList_70[] = {
	"`Scale'",
	"is a scale factor applied to each channel before",
	"it is added to the output channel. The channel addition",
	"will clip any data that would otherwise create an overflow",
	"and generate a help message. Only one help messages is",
	"generated, for every 400 input samples regardless of the",
	"number of overflows that may occur.",
	0
};
static const char * HelpTextList_AsciiFileMainHelpDefinition[] = {
	"`AsciiFile'",
	"writes an ascii file of the data sent to it.",
	"By default the data is grouped as one sample per line with",
	"the words in each sample separated by a space. If blocks",
	"are larger than one sample they are grouped in side curly brackets `",
	"{",
	"}",
	"'. This formatting information can be removed with the",
	"`NoGroup'",
	"option. The output format",
	"is accurate enough to fully represent the internal data value.",
	"`Hex'",
	"uses a hexadecimal format. (Values that",
	"do not fit in a 32 bit integer are hard limited and generate",
	"a warning with",
	"`Hex'",
	"format.)",
	"describes the data format and the data source. It can",
	"be omitted using the",
	"`NoHeader'",
	"option.",
	0
};
static const char * HelpTextList_71[] = {
	"`FileName'",
	"specifies the output ascii file name",
	"head of the listing. If no caption is specified",
	"(default 0) then the node name will be used.",
	0
};
static const char * HelpTextList_72[] = {
	"`Hex' , when set, writes output in hexadecimal format.",
	"If the value will not fit in a 32 bit integer it is hard",
	"limited and a warning is generated.",
	0
};
static const char * HelpTextList_73[] = {
	"`NoGroup' , if set, writes data one word per line.",
	"The default is to write the words in a sample",
	"on a single line (up to 20 words per sample) and to put brackets `",
	"{",
	"}",
	"' around blocks if the block size is larger then the",
	"sample size. If",
	"`NoGroup'",
	"is set then the data",
	"is written one per line with no grouping information.",
	0
};
static const char * HelpTextList_74[] = {
	"The default is to write a data header that describes",
	"the data format, the time it was created and gives",
	"the names of the creating node and network. If this",
	"option is set this header is omitted.",
	0
};
static const char * HelpTextList_75[] = {
	"`Hex' , when set, writes output in hexadecimal format.",
	"If the value will not fit in a 32 bit integer it is hard",
	"limited and a warning is generated.",
	0
};
static const char * HelpTextList_76[] = {
	"`FileName'",
	"specifies the output ascii file name",
	"head of the listing. If no caption is specified",
	"(default 0) then the node name will be used.",
	0
};
static const char * HelpTextList_77[] = {
	"`Hex' , when set, writes output in hexadecimal format.",
	"If the value will not fit in a 32 bit integer it is hard",
	"limited and a warning is generated.",
	0
};
static const char * HelpTextList_78[] = {
	"`NoGroup' , if set, writes data one word per line.",
	"The default is to write the words in a sample",
	"on a single line (up to 20 words per sample) and to put brackets `",
	"{",
	"}",
	"' around blocks if the block size is larger then the",
	"sample size. If",
	"`NoGroup'",
	"is set then the data",
	"is written one per line with no grouping information.",
	0
};
static const char * HelpTextList_79[] = {
	"The default is to write a data header that describes",
	"the data format, the time it was created and gives",
	"the names of the creating node and network. If this",
	"option is set this header is omitted.",
	0
};
static const char * HelpTextList_80[] = {
	"`Hex' , when set, writes output in hexadecimal format.",
	"If the value will not fit in a 32 bit integer it is hard",
	"limited and a warning is generated.",
	0
};
static const char * HelpTextList_81[] = {
	"`Hex' , when set, writes output in hexadecimal format.",
	"If the value will not fit in a 32 bit integer it is hard",
	"limited and a warning is generated.",
	0
};
static const char * HelpTextList_BlockMainHelpDefinition[] = {
	"`Block'",
	"converts its input stream to an output stream with",
	"`ElementSize'",
	"words per sample and",
	"`BlockSize'",
	"samples per block.",
	"The sample size and block size of the input data stream are",
	"ignored. The stream is treated as if it were an unblocked real",
	"data stream. On a 32 bit simulator",
	"`Block'",
	"can convert an",
	"integer or floating point input channel to floating point or",
	"integer output. If overflow occurs in converting integer to",
	"floating point the result will saturate and no warning message",
	"will be given.",
	"Some nodes that read disk files only generate",
	"a real data stream. If such a node is used to read complex data",
	"`Block'",
	"can do the needed transformation.",
	"If a node is used to",
	"read FFT output from another process you can use",
	"`BlockSize'",
	"to structure the data so it will be plotted correctly with one",
	"FFT window per plot. If",
	"`BlockSize'",
	"is 1 the output is not blocked.",
	0
};
static const char * HelpTextList_82[] = {
	"`ElementSize'",
	"is the number of words in each output sample",
	"(1 for real, 2 for complex or larger for other purposes).",
	0
};
static const char * HelpTextList_83[] = {
	"`BlockSize'",
	"is the number of samples in each output block. If",
	"set to 1 the output is not blocked.",
	0
};
static const char * HelpTextList_84[] = {
	"`Block'",
	"can read data from any input arithmetic type.",
	"`OutputArithmetic'",
	"selects the output arithmetic type. On a",
	"32 bit simulator",
	"`Block'",
	"can write output as either 32 bit",
	"floating point or 32 bit fixed point. Choose 0 to write",
	"output in the default type of the simulator, 1 for 32 bit",
	"integers and 2 for 32 bit floating point.",
	0
};
static const char * HelpTextList_85[] = {
	"`ElementSize'",
	"is the number of words in each output sample",
	"(1 for real, 2 for complex or larger for other purposes).",
	0
};
static const char * HelpTextList_86[] = {
	"`BlockSize'",
	"is the number of samples in each output block. If",
	"set to 1 the output is not blocked.",
	0
};
static const char * HelpTextList_87[] = {
	"`Block'",
	"can read data from any input arithmetic type.",
	"`OutputArithmetic'",
	"selects the output arithmetic type. On a",
	"32 bit simulator",
	"`Block'",
	"can write output as either 32 bit",
	"floating point or 32 bit fixed point. Choose 0 to write",
	"output in the default type of the simulator, 1 for 32 bit",
	"integers and 2 for 32 bit floating point.",
	0
};
static const char * HelpTextList_CircBufDesMainHelpDefinition[] = {
	"After a network has been completely described, it is necessary",
	"to provide physical buffers for all the connection paths between",
	"nodes. This is done by first defining a",
	"`BufferDescriptor'.",
	"And then using this descriptor in the network member function",
	"`AssignBuffers'. (If you do not do this manually it will",
	"be done automatically before executing a network using",
	"the default buffer descriptor.) `CircBufDes'",
	"describes circular buffers. There",
	"is a single parameter for this descriptor. It specifies the size (",
	"`Size' ) of the buffer. Other parameters describe",
	"the constraints on buffer size for generating target processor code.",
	0
};
static const char * HelpTextList_88[] = {
	"`AssignToEdit'",
	"makes this the descriptor for the network currently",
	"being edited. If a previous descriptor was assigned it will be",
	"overwritten.",
	0
};
static const char * HelpTextList_89[] = {
	"`Size'",
	"determines the buffer size for interactive execution.",
	"The larger the buffer is the more efficiently the nodes can execute",
	"and the greater the delay that is possible in the",
	"network. If the buffers are too small the network may",
	"lock up without processing all input data.",
	0
};
static const char * HelpTextList_90[] = {
	"`TargetSize'",
	"is the desired size of the buffer used in code",
	"prepared for execution on the target processor.",
	"An analysis will determine if this size is adequate",
	"and if it is larger than will be of benefit. The",
	"size will be optimized based",
	"on this target size as an approximate goal.",
	0
};
static const char * HelpTextList_91[] = {
	"`TargetSizeGoal'",
	"determines whether the buffer will be made",
	"larger or smaller then the selected size when the selected",
	"size is not optimal. If",
	"`TargetSizeGoal'",
	"is 0 that space",
	"will be minimized. If",
	"`TargetSizeGoal'",
	"is 1 then execution",
	"overhead will be minimized.",
	0
};
static const char * HelpTextList_92[] = {
	"`TargetControlGoal'",
	"determines how execution is controlled.",
	"If it is 0 then the buffer size is fixed and the amount",
	"of data available in the buffer is computed before each",
	"execution step. If",
	"`TargetControlGoal'",
	"is 1 then each",
	"node is executed according to a fixed predetermined",
	"schedule and the buffer size is optimized to this schedule.",
	"Nodes with feedback or that require excessively large",
	"buffers are defaulted to execute without fixed",
	"sequences. Fixed sequence execution provides more efficient",
	"execution at the expense of larger buffer requirements.",
	0
};
static const char * HelpTextList_93[] = {
	"`MaxTargetSize'",
	"specifies the maximum size allowed for any",
	"single buffer. It can force the use of a non fixed sequence",
	"scheduler or even result in an error message if the network",
	"cannot run without deadlock with this size buffer.",
	0
};
static const char * HelpTextList_94[] = {
	"`MinTargetSize'",
	"specifies the minimum size allowed for any",
	"single buffer. Setting this to a larger value can improve",
	"execution efficiency at the cost of more memory.",
	0
};
static const char * HelpTextList_95[] = {
	"`TargetSize'",
	"is the desired size of the buffer used in code",
	"prepared for execution on the target processor.",
	"An analysis will determine if this size is adequate",
	"and if it is larger than will be of benefit. The",
	"size will be optimized based",
	"on this target size as an approximate goal.",
	0
};
static const char * HelpTextList_96[] = {
	"`TargetSizeGoal'",
	"determines whether the buffer will be made",
	"larger or smaller then the selected size when the selected",
	"size is not optimal. If",
	"`TargetSizeGoal'",
	"is 0 that space",
	"will be minimized. If",
	"`TargetSizeGoal'",
	"is 1 then execution",
	"overhead will be minimized.",
	0
};
static const char * HelpTextList_97[] = {
	"`TargetControlGoal'",
	"determines how execution is controlled.",
	"If it is 0 then the buffer size is fixed and the amount",
	"of data available in the buffer is computed before each",
	"execution step. If",
	"`TargetControlGoal'",
	"is 1 then each",
	"node is executed according to a fixed predetermined",
	"schedule and the buffer size is optimized to this schedule.",
	"Nodes with feedback or that require excessively large",
	"buffers are defaulted to execute without fixed",
	"sequences. Fixed sequence execution provides more efficient",
	"execution at the expense of larger buffer requirements.",
	0
};
static const char * HelpTextList_98[] = {
	"`MaxTargetSize'",
	"specifies the maximum size allowed for any",
	"single buffer. It can force the use of a non fixed sequence",
	"scheduler or even result in an error message if the network",
	"cannot run without deadlock with this size buffer.",
	0
};
static const char * HelpTextList_99[] = {
	"`MinTargetSize'",
	"specifies the minimum size allowed for any",
	"single buffer. Setting this to a larger value can improve",
	"execution efficiency at the cost of more memory.",
	0
};
static const char * HelpTextList_100[] = {
	"`Size'",
	"determines the buffer size for interactive execution.",
	"The larger the buffer is the more efficiently the nodes can execute",
	"and the greater the delay that is possible in the",
	"network. If the buffers are too small the network may",
	"lock up without processing all input data.",
	0
};
static const char * HelpTextList_101[] = {
	"`TargetSize'",
	"is the desired size of the buffer used in code",
	"prepared for execution on the target processor.",
	"An analysis will determine if this size is adequate",
	"and if it is larger than will be of benefit. The",
	"size will be optimized based",
	"on this target size as an approximate goal.",
	0
};
static const char * HelpTextList_102[] = {
	"`TargetSizeGoal'",
	"determines whether the buffer will be made",
	"larger or smaller then the selected size when the selected",
	"size is not optimal. If",
	"`TargetSizeGoal'",
	"is 0 that space",
	"will be minimized. If",
	"`TargetSizeGoal'",
	"is 1 then execution",
	"overhead will be minimized.",
	0
};
static const char * HelpTextList_103[] = {
	"`TargetControlGoal'",
	"determines how execution is controlled.",
	"If it is 0 then the buffer size is fixed and the amount",
	"of data available in the buffer is computed before each",
	"execution step. If",
	"`TargetControlGoal'",
	"is 1 then each",
	"node is executed according to a fixed predetermined",
	"schedule and the buffer size is optimized to this schedule.",
	"Nodes with feedback or that require excessively large",
	"buffers are defaulted to execute without fixed",
	"sequences. Fixed sequence execution provides more efficient",
	"execution at the expense of larger buffer requirements.",
	0
};
static const char * HelpTextList_104[] = {
	"`MaxTargetSize'",
	"specifies the maximum size allowed for any",
	"single buffer. It can force the use of a non fixed sequence",
	"scheduler or even result in an error message if the network",
	"cannot run without deadlock with this size buffer.",
	0
};
static const char * HelpTextList_105[] = {
	"`MinTargetSize'",
	"specifies the minimum size allowed for any",
	"single buffer. Setting this to a larger value can improve",
	"execution efficiency at the cost of more memory.",
	0
};
static const char * HelpTextList_106[] = {
	"`TargetSize'",
	"is the desired size of the buffer used in code",
	"prepared for execution on the target processor.",
	"An analysis will determine if this size is adequate",
	"and if it is larger than will be of benefit. The",
	"size will be optimized based",
	"on this target size as an approximate goal.",
	0
};
static const char * HelpTextList_107[] = {
	"`TargetSizeGoal'",
	"determines whether the buffer will be made",
	"larger or smaller then the selected size when the selected",
	"size is not optimal. If",
	"`TargetSizeGoal'",
	"is 0 that space",
	"will be minimized. If",
	"`TargetSizeGoal'",
	"is 1 then execution",
	"overhead will be minimized.",
	0
};
static const char * HelpTextList_108[] = {
	"`TargetControlGoal'",
	"determines how execution is controlled.",
	"If it is 0 then the buffer size is fixed and the amount",
	"of data available in the buffer is computed before each",
	"execution step. If",
	"`TargetControlGoal'",
	"is 1 then each",
	"node is executed according to a fixed predetermined",
	"schedule and the buffer size is optimized to this schedule.",
	"Nodes with feedback or that require excessively large",
	"buffers are defaulted to execute without fixed",
	"sequences. Fixed sequence execution provides more efficient",
	"execution at the expense of larger buffer requirements.",
	0
};
static const char * HelpTextList_109[] = {
	"`MaxTargetSize'",
	"specifies the maximum size allowed for any",
	"single buffer. It can force the use of a non fixed sequence",
	"scheduler or even result in an error message if the network",
	"cannot run without deadlock with this size buffer.",
	0
};
static const char * HelpTextList_110[] = {
	"`MinTargetSize'",
	"specifies the minimum size allowed for any",
	"single buffer. Setting this to a larger value can improve",
	"execution efficiency at the cost of more memory.",
	0
};
static const char * HelpTextList_111[] = {
	"`TargetSize'",
	"is the desired size of the buffer used in code",
	"prepared for execution on the target processor.",
	"An analysis will determine if this size is adequate",
	"and if it is larger than will be of benefit. The",
	"size will be optimized based",
	"on this target size as an approximate goal.",
	0
};
static const char * HelpTextList_112[] = {
	"`TargetSizeGoal'",
	"determines whether the buffer will be made",
	"larger or smaller then the selected size when the selected",
	"size is not optimal. If",
	"`TargetSizeGoal'",
	"is 0 that space",
	"will be minimized. If",
	"`TargetSizeGoal'",
	"is 1 then execution",
	"overhead will be minimized.",
	0
};
static const char * HelpTextList_113[] = {
	"`TargetControlGoal'",
	"determines how execution is controlled.",
	"If it is 0 then the buffer size is fixed and the amount",
	"of data available in the buffer is computed before each",
	"execution step. If",
	"`TargetControlGoal'",
	"is 1 then each",
	"node is executed according to a fixed predetermined",
	"schedule and the buffer size is optimized to this schedule.",
	"Nodes with feedback or that require excessively large",
	"buffers are defaulted to execute without fixed",
	"sequences. Fixed sequence execution provides more efficient",
	"execution at the expense of larger buffer requirements.",
	0
};
static const char * HelpTextList_114[] = {
	"`MaxTargetSize'",
	"specifies the maximum size allowed for any",
	"single buffer. It can force the use of a non fixed sequence",
	"scheduler or even result in an error message if the network",
	"cannot run without deadlock with this size buffer.",
	0
};
static const char * HelpTextList_115[] = {
	"`MinTargetSize'",
	"specifies the minimum size allowed for any",
	"single buffer. Setting this to a larger value can improve",
	"execution efficiency at the cost of more memory.",
	0
};
static const char * HelpTextList_CompareDiskMainHelpDefinition[] = {
	"`CompareDisk'",
	"compares the contents of disk file",
	"`FileName'",
	"with data from its input channels. All discrepancies",
	"are reported in a text window.",
	"`CompareDisk' 's primary purpose",
	"is for regression testing.",
	"The number of channels and the number of multiplexed elements",
	"in a sample are read from the header of the disk file.",
	"Member function",
	"`DisplayHeader'",
	"will give the values of all the",
	"information read from the disk file header.",
	0
};
static const char * HelpTextList_116[] = {
	"`DisplayHeader'",
	"displays the parameters read from file",
	"`FileName'.",
	"These include the original node name that generated the file,",
	"the caption for this node, the number of input channels,",
	"and the number of scalar elements in a sample. The arithmetic",
	"type is also shown. The output channels and",
	"sample size for this node are determined by these values. If the",
	"data in the file is in a different arithmetic format",
	"than that currently in use, the file data will be converted.",
	0
};
static const char * HelpTextList_117[] = {
	"The data file header contains a count of the number of",
	"machine words in each channel. This count is written at",
	"the time the node creating the file is deleted. If ObjectProDSP",
	"exits abnormally then these counts may never be set",
	"and one will not be able to read any of the data in the",
	"file. This option causes these counts to be ignored.",
	"The result is that data will be read until the physical",
	"end of file. This may result in samples of all 0 being",
	"read at the end of the file that were never written to it.",
	0
};
static const char * HelpTextList_118[] = {
	"`FileName'",
	"specifies the name of the disk file",
	"to be compared with the data read from the input channels.",
	0
};
static const char * HelpTextList_119[] = {
	"Only the first",
	"`MaxReport'",
	"errors will be reported.",
	0
};
static const char * HelpTextList_120[] = {
	"`Tolerance'",
	"is the absolute value of the smallest difference",
	"that constitutes an error. Ordinarily this value is 0.0.",
	"It might be set to a value larger than 0 to compare",
	"slightly different algorithms",
	"or results on two different computers with different arithmetic.",
	0
};
static const char * HelpTextList_121[] = {
	"`ErrorFile'",
	"is a file in which errors will be reported instead",
	"of displaying them in a window.",
	0
};
static const char * HelpTextList_122[] = {
	"`FileName'",
	"specifies the name of the disk file",
	"to be compared with the data read from the input channels.",
	0
};
static const char * HelpTextList_123[] = {
	"Only the first",
	"`MaxReport'",
	"errors will be reported.",
	0
};
static const char * HelpTextList_124[] = {
	"`Tolerance'",
	"is the absolute value of the smallest difference",
	"that constitutes an error. Ordinarily this value is 0.0.",
	"It might be set to a value larger than 0 to compare",
	"slightly different algorithms",
	"or results on two different computers with different arithmetic.",
	0
};
static const char * HelpTextList_125[] = {
	"`ErrorFile'",
	"is a file in which errors will be reported instead",
	"of displaying them in a window.",
	0
};
static const char * HelpTextList_ConstantDataMainHelpDefinition[] = {
	"`ConstantData'",
	"writes parameter",
	"`Value'",
	"to the output stream",
	"repeatedly. It is written as a binary integer constant.",
	0
};
static const char * HelpTextList_126[] = {
	"`Value'",
	"is output as an an `MachWord' constant.",
	0
};
static const char * HelpTextList_127[] = {
	"`Value'",
	"is output as an an `MachWord' constant.",
	0
};
static const char * HelpTextList_128[] = {
	"`Value'",
	"is output as an an `MachWord' constant.",
	0
};
static const char * HelpTextList_129[] = {
	"`Value'",
	"is output as an an `MachWord' constant.",
	0
};
static const char * HelpTextList_130[] = {
	"`Value'",
	"is output as an an `MachWord' constant.",
	0
};
static const char * HelpTextList_CosMainHelpDefinition[] = {
	"`Cos'",
	"generates the sampled real function: `Amplitude'",
	"cos(",
	"`Phase'",
	"+ N",
	"`Frequency' ). N is the sample index that",
	"starts with N = 0.",
	0
};
static const char * HelpTextList_131[] = {
	"`Frequency'",
	"specifies the signal frequency in radians per",
	"sample. In other words the phase of a given sample is `Frequency'",
	"radians plus the phase of the previous sample.",
	0
};
static const char * HelpTextList_132[] = {
	"`Phase'",
	"specifies the initial phase of the first sample",
	"of the signal.",
	0
};
static const char * HelpTextList_133[] = {
	"`Amplitude'",
	"specifies the maximum amplitude of the continuous",
	"cosine function. This may not be the maximum",
	"amplitude of the samples generated. If the",
	"function is sampled at a phase that is an integer multiple",
	"of Pi, then the samples will obtain this maximum.",
	0
};
static const char * HelpTextList_134[] = {
	"`Frequency'",
	"specifies the signal frequency in radians per",
	"sample. In other words the phase of a given sample is `Frequency'",
	"radians plus the phase of the previous sample.",
	0
};
static const char * HelpTextList_135[] = {
	"`Phase'",
	"specifies the initial phase of the first sample",
	"of the signal.",
	0
};
static const char * HelpTextList_136[] = {
	"`Amplitude'",
	"specifies the maximum amplitude of the continuous",
	"cosine function. This may not be the maximum",
	"amplitude of the samples generated. If the",
	"function is sampled at a phase that is an integer multiple",
	"of Pi, then the samples will obtain this maximum.",
	0
};
static const char * HelpTextList_137[] = {
	"`Frequency'",
	"specifies the signal frequency in radians per",
	"sample. In other words the phase of a given sample is `Frequency'",
	"radians plus the phase of the previous sample.",
	0
};
static const char * HelpTextList_138[] = {
	"`Phase'",
	"specifies the initial phase of the first sample",
	"of the signal.",
	0
};
static const char * HelpTextList_139[] = {
	"`Amplitude'",
	"specifies the maximum amplitude of the continuous",
	"cosine function. This may not be the maximum",
	"amplitude of the samples generated. If the",
	"function is sampled at a phase that is an integer multiple",
	"of Pi, then the samples will obtain this maximum.",
	0
};
static const char * HelpTextList_140[] = {
	"`Frequency'",
	"specifies the signal frequency in radians per",
	"sample. In other words the phase of a given sample is `Frequency'",
	"radians plus the phase of the previous sample.",
	0
};
static const char * HelpTextList_141[] = {
	"`Phase'",
	"specifies the initial phase of the first sample",
	"of the signal.",
	0
};
static const char * HelpTextList_142[] = {
	"`Amplitude'",
	"specifies the maximum amplitude of the continuous",
	"cosine function. This may not be the maximum",
	"amplitude of the samples generated. If the",
	"function is sampled at a phase that is an integer multiple",
	"of Pi, then the samples will obtain this maximum.",
	0
};
static const char * HelpTextList_143[] = {
	"`Frequency'",
	"specifies the signal frequency in radians per",
	"sample. In other words the phase of a given sample is `Frequency'",
	"radians plus the phase of the previous sample.",
	0
};
static const char * HelpTextList_144[] = {
	"`Phase'",
	"specifies the initial phase of the first sample",
	"of the signal.",
	0
};
static const char * HelpTextList_145[] = {
	"`Amplitude'",
	"specifies the maximum amplitude of the continuous",
	"cosine function. This may not be the maximum",
	"amplitude of the samples generated. If the",
	"function is sampled at a phase that is an integer multiple",
	"of Pi, then the samples will obtain this maximum.",
	0
};
static const char * HelpTextList_CxCosMainHelpDefinition[] = {
	"`CxCos'",
	"generates the sampled complex function: `Amplitude'",
	"e^(2 Pi i( `Phase'",
	"+ N",
	"`Frequency' )).",
	"N is the sample index.",
	"It starts at 0.",
	0
};
static const char * HelpTextList_146[] = {
	"`Frequency'",
	"specifies the signal frequency in radians per",
	"sample. In other words the phase of a given sample is `Frequency'",
	"radians plus the phase of the previous sample.",
	0
};
static const char * HelpTextList_147[] = {
	"`Phase'",
	"specifies the initial phase of the first sample",
	"of the signal.",
	0
};
static const char * HelpTextList_148[] = {
	"`Amplitude'",
	"specifies the maximum amplitude of the continuous",
	"cosine function. This may not be the maximum",
	"amplitude of the samples generated. If the",
	"function is sampled at a phase that is an integer multiple",
	"of Pi, then the samples will obtain this maximum.",
	0
};
static const char * HelpTextList_149[] = {
	"`Frequency'",
	"specifies the signal frequency in radians per",
	"sample. In other words the phase of a given sample is `Frequency'",
	"radians plus the phase of the previous sample.",
	0
};
static const char * HelpTextList_150[] = {
	"`Phase'",
	"specifies the initial phase of the first sample",
	"of the signal.",
	0
};
static const char * HelpTextList_151[] = {
	"`Amplitude'",
	"specifies the maximum amplitude of the continuous",
	"cosine function. This may not be the maximum",
	"amplitude of the samples generated. If the",
	"function is sampled at a phase that is an integer multiple",
	"of Pi, then the samples will obtain this maximum.",
	0
};
static const char * HelpTextList_152[] = {
	"`Frequency'",
	"specifies the signal frequency in radians per",
	"sample. In other words the phase of a given sample is `Frequency'",
	"radians plus the phase of the previous sample.",
	0
};
static const char * HelpTextList_153[] = {
	"`Phase'",
	"specifies the initial phase of the first sample",
	"of the signal.",
	0
};
static const char * HelpTextList_154[] = {
	"`Amplitude'",
	"specifies the maximum amplitude of the continuous",
	"cosine function. This may not be the maximum",
	"amplitude of the samples generated. If the",
	"function is sampled at a phase that is an integer multiple",
	"of Pi, then the samples will obtain this maximum.",
	0
};
static const char * HelpTextList_155[] = {
	"`Frequency'",
	"specifies the signal frequency in radians per",
	"sample. In other words the phase of a given sample is `Frequency'",
	"radians plus the phase of the previous sample.",
	0
};
static const char * HelpTextList_156[] = {
	"`Phase'",
	"specifies the initial phase of the first sample",
	"of the signal.",
	0
};
static const char * HelpTextList_157[] = {
	"`Amplitude'",
	"specifies the maximum amplitude of the continuous",
	"cosine function. This may not be the maximum",
	"amplitude of the samples generated. If the",
	"function is sampled at a phase that is an integer multiple",
	"of Pi, then the samples will obtain this maximum.",
	0
};
static const char * HelpTextList_158[] = {
	"`Frequency'",
	"specifies the signal frequency in radians per",
	"sample. In other words the phase of a given sample is `Frequency'",
	"radians plus the phase of the previous sample.",
	0
};
static const char * HelpTextList_159[] = {
	"`Phase'",
	"specifies the initial phase of the first sample",
	"of the signal.",
	0
};
static const char * HelpTextList_160[] = {
	"`Amplitude'",
	"specifies the maximum amplitude of the continuous",
	"cosine function. This may not be the maximum",
	"amplitude of the samples generated. If the",
	"function is sampled at a phase that is an integer multiple",
	"of Pi, then the samples will obtain this maximum.",
	0
};
static const char * HelpTextList_CxFFTMainHelpDefinition[] = {
	"`CxFFT'",
	"computes a series of complex FFTs of size N = 2 ^",
	"`LogSize'",
	"on",
	"a single complex input channel. A forward FFT is computed if",
	"`InverseFlag'",
	"is 0 and an inverse FFT if this parameter is 1.",
	"Successive FFTs have their first samples separated by by N *",
	"`Overlap'",
	"samples. If",
	"`Overlap'",
	"is 1.0 then successive inputs",
	"are separated by a single sample.",
	0
};
static const char * HelpTextList_161[] = {
	"`LogSize'",
	"is the log base 2 of the FFT size.",
	0
};
static const char * HelpTextList_162[] = {
	"`Overlap'",
	"specifies the fractional overlap of successive",
	"FFTs. For example",
	"`Overlap'",
	"= .5 and",
	"`LogSize'",
	"= 64 would",
	"result in each FFT being 32 samples beyond the previous FFT. `Overlap'",
	"= 1.0 is interpreted to mean that successive FFTs",
	"having their inputs separated by a single sample.",
	0
};
static const char * HelpTextList_163[] = {
	"The true center frequency of the FFT is determined by",
	"the data entering it.",
	"`CenterFrequency'",
	"allows you to",
	"rotate the output bins to conform to this. The default",
	"value of .5 corresponds to a signal with center frequency",
	"of 0 hz in the input sample stream. This value should",
	"set to the relative position of the center",
	"frequency of the input sample stream.",
	0
};
static const char * HelpTextList_164[] = {
	"`InverseFlag'",
	"set to 1 selects an inverse FFT.",
	0
};
static const char * HelpTextList_165[] = {
	"The true center frequency of the FFT is determined by",
	"the data entering it.",
	"`CenterFrequency'",
	"allows you to",
	"rotate the output bins to conform to this. The default",
	"value of .5 corresponds to a signal with center frequency",
	"of 0 hz in the input sample stream. This value should",
	"set to the relative position of the center",
	"frequency of the input sample stream.",
	0
};
static const char * HelpTextList_166[] = {
	"`LogSize'",
	"is the log base 2 of the FFT size.",
	0
};
static const char * HelpTextList_167[] = {
	"`Overlap'",
	"specifies the fractional overlap of successive",
	"FFTs. For example",
	"`Overlap'",
	"= .5 and",
	"`LogSize'",
	"= 64 would",
	"result in each FFT being 32 samples beyond the previous FFT. `Overlap'",
	"= 1.0 is interpreted to mean that successive FFTs",
	"having their inputs separated by a single sample.",
	0
};
static const char * HelpTextList_168[] = {
	"The true center frequency of the FFT is determined by",
	"the data entering it.",
	"`CenterFrequency'",
	"allows you to",
	"rotate the output bins to conform to this. The default",
	"value of .5 corresponds to a signal with center frequency",
	"of 0 hz in the input sample stream. This value should",
	"set to the relative position of the center",
	"frequency of the input sample stream.",
	0
};
static const char * HelpTextList_169[] = {
	"`InverseFlag'",
	"set to 1 selects an inverse FFT.",
	0
};
static const char * HelpTextList_170[] = {
	"The true center frequency of the FFT is determined by",
	"the data entering it.",
	"`CenterFrequency'",
	"allows you to",
	"rotate the output bins to conform to this. The default",
	"value of .5 corresponds to a signal with center frequency",
	"of 0 hz in the input sample stream. This value should",
	"set to the relative position of the center",
	"frequency of the input sample stream.",
	0
};
static const char * HelpTextList_171[] = {
	"The true center frequency of the FFT is determined by",
	"the data entering it.",
	"`CenterFrequency'",
	"allows you to",
	"rotate the output bins to conform to this. The default",
	"value of .5 corresponds to a signal with center frequency",
	"of 0 hz in the input sample stream. This value should",
	"set to the relative position of the center",
	"frequency of the input sample stream.",
	0
};
static const char * HelpTextList_CxFirMainHelpDefinition[] = {
	"`CxFir'",
	"implements two parallel real symmetric FIR filters that",
	"operate on a complex data stream. Optional",
	"complex demodulation multiplies the input by a complex cosine",
	"with phase increment - `DemodFreq'",
	"radians between each pair of",
	"samples. Input samples can have",
	"`ZeroPad'",
	"0's interpolated",
	"between them. Output sample can be generated for every",
	"`Resample'",
	"input (or zero pad) sample. The",
	"`Coeff'",
	"array contains half of",
	"the symmetric coefficients.",
	"`Odd'",
	"indicates if there are an even(0) or",
	"odd(1) total number of coefficients.",
	0
};
static const char * HelpTextList_172[] = {
	"`Resample'",
	"specifies the filter resampling factor.",
	"This is the ratio of the input sampling rate to the",
	"output sampling rate.",
	0
};
static const char * HelpTextList_173[] = {
	"`ZeroPad'",
	"specifies the number of 0's that are",
	"added after each input sample. If Zero padding is done the filter",
	"must be designed as an interpolation filter.",
	0
};
static const char * HelpTextList_174[] = {
	"`DemodFreq'",
	"is the demodulation frequency in radians per",
	"sample. Input sample N is multiplied by e^(-i * 2 * Pi *",
	"`DemodFreq'",
	"* N) before the filtering operation.",
	"If",
	"`DemodFreq'",
	"is 0 then the demodulation step is skipped.",
	0
};
static const char * HelpTextList_175[] = {
	"`Odd'",
	"determines if the filter is odd ( `Odd' =1) or even ( `Odd'",
	"=0).",
	0
};
static const char * HelpTextList_176[] = {
	"`Coeff'",
	"is the list of filter coefficients. The filter is",
	"symmetric and only half (or half plus one",
	"for odd length filters) are specified. The first",
	"in the list is the first coefficient of the filter.",
	"The middle coefficient is at the end of the list.",
	"The default values for the coefficients define a low pass",
	"FIR filter with a pass band of .125 times the sample rate",
	"and transition band of .375 times the sample rate. The",
	"pass band is extremely flat and the stop band is down over",
	"100 db. This is an overdesigned filter for most practical",
	"applications but it provides a good test case. The performance",
	"will be degraded by 16 bit integer arithmetic.",
	0
};
static const char * HelpTextList_177[] = {
	"`Resample'",
	"specifies the filter resampling factor.",
	"This is the ratio of the input sampling rate to the",
	"output sampling rate.",
	0
};
static const char * HelpTextList_178[] = {
	"`ZeroPad'",
	"specifies the number of 0's that are",
	"added after each input sample. If Zero padding is done the filter",
	"must be designed as an interpolation filter.",
	0
};
static const char * HelpTextList_179[] = {
	"`DemodFreq'",
	"is the demodulation frequency in radians per",
	"sample. Input sample N is multiplied by e^(-i * 2 * Pi *",
	"`DemodFreq'",
	"* N) before the filtering operation.",
	"If",
	"`DemodFreq'",
	"is 0 then the demodulation step is skipped.",
	0
};
static const char * HelpTextList_180[] = {
	"`Odd'",
	"determines if the filter is odd ( `Odd' =1) or even ( `Odd'",
	"=0).",
	0
};
static const char * HelpTextList_181[] = {
	"`Coeff'",
	"is the list of filter coefficients. The filter is",
	"symmetric and only half (or half plus one",
	"for odd length filters) are specified. The first",
	"in the list is the first coefficient of the filter.",
	"The middle coefficient is at the end of the list.",
	"The default values for the coefficients define a low pass",
	"FIR filter with a pass band of .125 times the sample rate",
	"and transition band of .375 times the sample rate. The",
	"pass band is extremely flat and the stop band is down over",
	"100 db. This is an overdesigned filter for most practical",
	"applications but it provides a good test case. The performance",
	"will be degraded by 16 bit integer arithmetic.",
	0
};
static const char * HelpTextList_CxImpMainHelpDefinition[] = {
	"`CxImp'",
	"generates a periodic impulse or square every",
	"`Period'",
	"samples. The impulse amplitude is",
	"`Amplitude'",
	"e^(2 Pi i",
	"`Phase' ). The first",
	"transition for 0 to this amplitude occurs at sample",
	"`Transition'.",
	"The nonzero amplitude is maintained for",
	"`Width'",
	"*",
	"`Period'",
	"samples where",
	"`Width'",
	"is between 0 and 1. If",
	"`Width'",
	"= 1.0 then the signal is a constant after the first transition.",
	0
};
static const char * HelpTextList_182[] = {
	"`Period'",
	"specifies the number of samples before the",
	"impulse is repeated.",
	0
};
static const char * HelpTextList_183[] = {
	"`Phase'",
	"the relative amplitude of the real and imaginary",
	"components of the signal. With",
	"`Phase'",
	"= 0 all the energy",
	"is in the real part. With",
	"`Phase'",
	"= pi/2 all the energy",
	"is in the imaginary part.",
	0
};
static const char * HelpTextList_184[] = {
	"`Amplitude'",
	"specifies the the magnitude of the impulse",
	"amplitude. It is the square root of the sum of the",
	"squares of the real and imaginary amplitudes.",
	0
};
static const char * HelpTextList_185[] = {
	"`Width'",
	"specifies the peak width as a fraction of sample period.",
	"`Width'",
	"= 0 produces an impulse one sample wide. `Width'",
	"= 1 results in a constant amplitude and phase signal. `Width'",
	"= .5 results in a standard square wave.",
	0
};
static const char * HelpTextList_186[] = {
	"`Transition'",
	"specifies the sample index where the",
	"first signal transition from 0 occurs. This may be",
	"longer than the sample",
	"`Period'.",
	0
};
static const char * HelpTextList_187[] = {
	"`Period'",
	"specifies the number of samples before the",
	"impulse is repeated.",
	0
};
static const char * HelpTextList_188[] = {
	"`Phase'",
	"the relative amplitude of the real and imaginary",
	"components of the signal. With",
	"`Phase'",
	"= 0 all the energy",
	"is in the real part. With",
	"`Phase'",
	"= pi/2 all the energy",
	"is in the imaginary part.",
	0
};
static const char * HelpTextList_189[] = {
	"`Amplitude'",
	"specifies the the magnitude of the impulse",
	"amplitude. It is the square root of the sum of the",
	"squares of the real and imaginary amplitudes.",
	0
};
static const char * HelpTextList_190[] = {
	"`Width'",
	"specifies the peak width as a fraction of sample period.",
	"`Width'",
	"= 0 produces an impulse one sample wide. `Width'",
	"= 1 results in a constant amplitude and phase signal. `Width'",
	"= .5 results in a standard square wave.",
	0
};
static const char * HelpTextList_191[] = {
	"`Transition'",
	"specifies the sample index where the",
	"first signal transition from 0 occurs. This may be",
	"longer than the sample",
	"`Period'.",
	0
};
static const char * HelpTextList_DataFlowMainHelpDefinition[] = {
	"`DataFlow'",
	"is a `Scheduler' based on a data flow model. Its Only",
	"argument is the",
	"`TheNet'",
	"to control.",
	0
};
static const char * HelpTextList_192[] = {
	"Member function",
	"`GraphDisplay'",
	"displays the network topology",
	"and timing.",
	0
};
static const char * HelpTextList_193[] = {
	"Member function",
	"`Execute'",
	"executes the network being controlled.",
	"It causes the signal generator (or first node in the network)",
	"to produce a specified number",
	"of input samples. Each node is executed for as many iterations",
	"as possible given the available input data and output buffer",
	"space. Execution halts when no node generates any new samples",
	"after a complete pass throughout the network.",
	0
};
static const char * HelpTextList_194[] = {
	"Member function",
	"`AssignBuffers'",
	"buffers to a completely defined",
	"data flow network. The network is first checked for completeness.",
	"Buffers will not be assigned if the network fails this test.",
	"The single parameter of this function specifies the buffer",
	"characteristics.",
	0
};
static const char * HelpTextList_195[] = {
	"You can not change the topology of a network while buffers are",
	"assigned. Member function",
	"`ClearBuffers'",
	"removes all buffers",
	"so that the network can be edited or different buffers assigned.",
	0
};
static const char * HelpTextList_196[] = {
	"Member function",
	"`ClearNetwork'",
	"removes all links in the network",
	"being controlled. The nodes freed in this way can then be used",
	"in a different network.",
	0
};
static const char * HelpTextList_197[] = {
	"`TheNet'",
	"is the `Network' to be controlled.",
	0
};
static const char * HelpTextList_198[] = {
	"`TheNet'",
	"is the `Network' to be controlled.",
	0
};
static const char * HelpTextList_DemodMainHelpDefinition[] = {
	"`Demod'",
	"is a complex modulation or demodulation function.",
	"Its input can be real or complex as can its output.",
	0
};
static const char * HelpTextList_199[] = {
	"`DataType'",
	"selects complex input and complex output (0),",
	"complex input and real output (1),",
	"real input and complex output (2) or real input and real output (3).",
	0
};
static const char * HelpTextList_200[] = {
	"`DemodFreq'",
	"is the demodulation frequency in radians/sample.",
	"Input sample N is multiplied by e^(-i * N * 2 * Pi *",
	"`DemodFreq' )",
	0
};
static const char * HelpTextList_201[] = {
	"`DemodFreq'",
	"is the demodulation frequency in radians/sample.",
	"Input sample N is multiplied by e^(-i * N * 2 * Pi *",
	"`DemodFreq' )",
	0
};
static const char * HelpTextList_202[] = {
	"`DataType'",
	"selects complex input and complex output (0),",
	"complex input and real output (1),",
	"real input and complex output (2) or real input and real output (3).",
	0
};
static const char * HelpTextList_203[] = {
	"`DemodFreq'",
	"is the demodulation frequency in radians/sample.",
	"Input sample N is multiplied by e^(-i * N * 2 * Pi *",
	"`DemodFreq' )",
	0
};
static const char * HelpTextList_204[] = {
	"`DemodFreq'",
	"is the demodulation frequency in radians/sample.",
	"Input sample N is multiplied by e^(-i * N * 2 * Pi *",
	"`DemodFreq' )",
	0
};
static const char * HelpTextList_205[] = {
	"`DemodFreq'",
	"is the demodulation frequency in radians/sample.",
	"Input sample N is multiplied by e^(-i * N * 2 * Pi *",
	"`DemodFreq' )",
	0
};
static const char * HelpTextList_DemuxMainHelpDefinition[] = {
	"`Demux'",
	"takes one input channel and demultiplexes it onto",
	"`Channels'",
	"output channels. The input channel must have samples consisting of",
	"`InputElementSize'",
	"words. For example, complex data streams",
	"will generally have two words in each sample. The output data",
	"stream will have samples or",
	"`OutputElementSize'",
	"words.",
	"`InputElementSize'",
	"and",
	"`OutputElementSize'",
	"do not affect the kernel loop execution.",
	"`InputSampleSize'",
	"words are taken from the input",
	"and written to the first output channel. The next",
	"`InputSampleSize'",
	"words of input are written to the next channel. This is done for",
	"all output channels and then begins again with the first output channel.",
	0
};
static const char * HelpTextList_206[] = {
	"`Demux'",
	"demultiplexes a single input channel into",
	"`Channels'",
	"output channels.",
	0
};
static const char * HelpTextList_207[] = {
	"The input channel has samples of",
	"`InputSampleSize'",
	"words.",
	0
};
static const char * HelpTextList_208[] = {
	"The parameter does not affect the demultiplexing loop.",
	"The input channel must have this value for",
	"`InputElementSize'.",
	"If you are demultiplexing an element into its component",
	"parts (such as demultiplexing complex data to real and",
	"imaginary streams)",
	"`Channels'",
	"and",
	"`InputElementSize'",
	"must have the same value.",
	0
};
static const char * HelpTextList_209[] = {
	"The parameter does not affect the demultiplexing loop.",
	"All output channels have this value for",
	"`OutputElementSize'.",
	0
};
static const char * HelpTextList_210[] = {
	"`Demux'",
	"demultiplexes a single input channel into",
	"`Channels'",
	"output channels.",
	0
};
static const char * HelpTextList_211[] = {
	"The input channel has samples of",
	"`InputSampleSize'",
	"words.",
	0
};
static const char * HelpTextList_212[] = {
	"The parameter does not affect the demultiplexing loop.",
	"The input channel must have this value for",
	"`InputElementSize'.",
	"If you are demultiplexing an element into its component",
	"parts (such as demultiplexing complex data to real and",
	"imaginary streams)",
	"`Channels'",
	"and",
	"`InputElementSize'",
	"must have the same value.",
	0
};
static const char * HelpTextList_213[] = {
	"The parameter does not affect the demultiplexing loop.",
	"All output channels have this value for",
	"`OutputElementSize'.",
	0
};
static const char * HelpTextList_214[] = {
	"`Raise'",
	"will cause a window displaying this network to be raised",
	"to the top level over any overlapping windows.",
	"Examples of windows that will be affected are a network display",
	"containing this node or a plot window for this node.",
	0
};
static const char * HelpTextList_215[] = {
	"Member function",
	"`DisplayInputTiming'",
	"displays the timing",
	"of the selects input channel for this node.",
	0
};
static const char * HelpTextList_216[] = {
	"If this node is not linked in an existing network it will be",
	"added to the display of the network currently being edited. If",
	"there is no such network one will be created.",
	0
};
static const char * HelpTextList_217[] = {
	"Member function",
	"`Unlink'",
	"disconnects this node from the",
	"DSP network it is linked in.",
	0
};
static const char * HelpTextList_218[] = {
	"The",
	"`LinkIn'",
	"member function selects the",
	"next input channel to link to. It's single parameter ( `Channel' )",
	"specifies the channel index. Ordinarily the",
	"first unused channel is linked to. This function",
	"overrides that default.",
	0
};
static const char * HelpTextList_219[] = {
	"This function displays the next available input link for this node.",
	0
};
static const char * HelpTextList_EyePlotMainHelpDefinition[] = {
	"`EyePlot'",
	"displays a complex signal on a single",
	"eye plot or X versus Y format. The real value of a sample determines",
	"the X coordinate and the imaginary value determines the Y coordinate.",
	0
};
static const char * HelpTextList_220[] = {
	"`EyePlot'",
	"generates a series of plots with `SamplesPerPlot'",
	"in each display. If the input block size",
	"is not 1 then that value is overrides this parameter.",
	0
};
static const char * HelpTextList_221[] = {
	"The plot caption is a string that will be displayed",
	"at the base of the plot. The default value of 0",
	"causes the plot node name to be used for the caption.",
	0
};
static const char * HelpTextList_222[] = {
	"`EyePlot'",
	"generates a series of plots with `SamplesPerPlot'",
	"in each display. If the input block size",
	"is not 1 then that value is overrides this parameter.",
	0
};
static const char * HelpTextList_223[] = {
	"The plot caption is a string that will be displayed",
	"at the base of the plot. The default value of 0",
	"causes the plot node name to be used for the caption.",
	0
};
static const char * HelpTextList_FindStartTailMainHelpDefinition[] = {
	"`FindStartTail'",
	"copies its input to its output. Data is copied",
	"at the first sample with value >",
	"`LowerBound'",
	"and < `UpperBound'.",
	"If the input data is integer type on a floating point",
	"simulator signed input is assumed.",
	"If the data is complex then the magnitude of each component of the",
	"each sample is checked. The first full sample after the test is",
	"passed is output.",
	0
};
static const char * HelpTextList_224[] = {
	"A sample containing an initial element >",
	"`LowerBound'",
	"will be ignored.",
	"Once one element of a sample has passed both bound tests",
	"all later samples will be passed to the next node. If the first element in",
	"a sample passes the tests then that sample will be passed.",
	0
};
static const char * HelpTextList_225[] = {
	"An initial element <",
	"`UpperBound'",
	"will be ignored.",
	"Once one element of a sample has passed both bound tests it and",
	"all later samples will be passed to the next node. If the first element in",
	"a sample passes the tests then that sample will be passed.",
	0
};
static const char * HelpTextList_226[] = {
	"If bit 2 is set then the first bounds test is ignored.",
	"If bit 3 is set the second test is ignored.",
	"If both bits 2 and 3 are set you can skip a fixed number",
	"of samples by setting",
	"`Skip'.",
	0
};
static const char * HelpTextList_227[] = {
	"The first",
	"`Skip'",
	"samples are read but not written.",
	0
};
static const char * HelpTextList_228[] = {
	"A sample containing an initial element >",
	"`LowerBound'",
	"will be ignored.",
	"Once one element of a sample has passed both bound tests",
	"all later samples will be passed to the next node. If the first element in",
	"a sample passes the tests then that sample will be passed.",
	0
};
static const char * HelpTextList_229[] = {
	"An initial element <",
	"`UpperBound'",
	"will be ignored.",
	"Once one element of a sample has passed both bound tests it and",
	"all later samples will be passed to the next node. If the first element in",
	"a sample passes the tests then that sample will be passed.",
	0
};
static const char * HelpTextList_230[] = {
	"If bit 2 is set then the first bounds test is ignored.",
	"If bit 3 is set the second test is ignored.",
	"If both bits 2 and 3 are set you can skip a fixed number",
	"of samples by setting",
	"`Skip'.",
	0
};
static const char * HelpTextList_231[] = {
	"The first",
	"`Skip'",
	"samples are read but not written.",
	0
};
static const char * HelpTextList_GainMainHelpDefinition[] = {
	"`Gain'",
	"copies its input to its output after applying a liner",
	"scale factor ( `Scale' ) to each input sample element.",
	0
};
static const char * HelpTextList_232[] = {
	"`Scale'",
	"specifies the ratio of input amplitude to",
	"output amplitude. Integer overflows are prevented",
	"by clipping. The first",
	"time clipping occurs a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_233[] = {
	"`Scale'",
	"specifies the ratio of input amplitude to",
	"output amplitude. Integer overflows are prevented",
	"by clipping. The first",
	"time clipping occurs a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_234[] = {
	"`Scale'",
	"specifies the ratio of input amplitude to",
	"output amplitude. Integer overflows are prevented",
	"by clipping. The first",
	"time clipping occurs a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_235[] = {
	"`Scale'",
	"specifies the ratio of input amplitude to",
	"output amplitude. Integer overflows are prevented",
	"by clipping. The first",
	"time clipping occurs a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_236[] = {
	"`Scale'",
	"specifies the ratio of input amplitude to",
	"output amplitude. Integer overflows are prevented",
	"by clipping. The first",
	"time clipping occurs a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_GainPadMainHelpDefinition[] = {
	"`GainPad'",
	"copies its input to its output after applying a liner",
	"scale factor ( `Scale' ) to each input sample element. It will",
	"convert real to complex data by adding a 0 imaginary part",
	"to each sample. Set",
	"`ElementSize'",
	"to 1 for this purpose.",
	"Otherwise",
	"`ElementSize'",
	"is the number",
	"of values or elements in each sample.",
	0
};
static const char * HelpTextList_237[] = {
	"`Scale'",
	"specifies the ratio of input amplitude to",
	"output amplitude. Integer overflows are prevented",
	"by clipping. The first",
	"time clipping occurs a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_238[] = {
	"`ElementSize'",
	"specifies the sample size.",
	"The most common use of",
	"`ElementSize'",
	"is to",
	"set it to two for a complex data stream or",
	"1 for real data. Set it to 0 to convert real",
	"to complex data by padding the imaginary part with 0.",
	0
};
static const char * HelpTextList_239[] = {
	"If",
	"`NullOutputSample'",
	"is non zero then all samples after",
	"`NullOutputSample'",
	"will be zero. If",
	"`NullOutputSample'",
	"is 0 then the input is written to the output continuously.",
	0
};
static const char * HelpTextList_240[] = {
	"`Scale'",
	"specifies the ratio of input amplitude to",
	"output amplitude. Integer overflows are prevented",
	"by clipping. The first",
	"time clipping occurs a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_241[] = {
	"`Scale'",
	"specifies the ratio of input amplitude to",
	"output amplitude. Integer overflows are prevented",
	"by clipping. The first",
	"time clipping occurs a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_242[] = {
	"`ElementSize'",
	"specifies the sample size.",
	"The most common use of",
	"`ElementSize'",
	"is to",
	"set it to two for a complex data stream or",
	"1 for real data. Set it to 0 to convert real",
	"to complex data by padding the imaginary part with 0.",
	0
};
static const char * HelpTextList_243[] = {
	"If",
	"`NullOutputSample'",
	"is non zero then all samples after",
	"`NullOutputSample'",
	"will be zero. If",
	"`NullOutputSample'",
	"is 0 then the input is written to the output continuously.",
	0
};
static const char * HelpTextList_244[] = {
	"`Scale'",
	"specifies the ratio of input amplitude to",
	"output amplitude. Integer overflows are prevented",
	"by clipping. The first",
	"time clipping occurs a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_245[] = {
	"`Scale'",
	"specifies the ratio of input amplitude to",
	"output amplitude. Integer overflows are prevented",
	"by clipping. The first",
	"time clipping occurs a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_HexListMainHelpDefinition[] = {
	"`HexList'",
	"displays",
	"`Channels'",
	"signals on a single list.",
	"If you only want to display a single channel the `HexList'",
	"option in `Listing' may be more convenient.",
	"In a floating point simulator the input to",
	"`HexList'",
	"must",
	"be an integer format. You can use `ToInteger' to do the conversion.",
	"`BlockSize' and `ElementSize' are set when the first input",
	"channel is linked. All subsequent input channels must have the same values.",
	0
};
static const char * HelpTextList_246[] = {
	"`HexList'",
	"lists",
	"`Channels'",
	"signals of integer data in",
	"a",
	"hexadecimal format.",
	0
};
static const char * HelpTextList_247[] = {
	"`Caption'",
	"specifies a caption that will appear at the",
	"head of the listing. If no caption is specified",
	"(default 0) then the node name will be used.",
	"The caption cannot contain blanks. Use underscore instead.",
	0
};
static const char * HelpTextList_248[] = {
	"`HexList'",
	"lists",
	"`Channels'",
	"signals of integer data in",
	"a",
	"hexadecimal format.",
	0
};
static const char * HelpTextList_249[] = {
	"`Caption'",
	"specifies a caption that will appear at the",
	"head of the listing. If no caption is specified",
	"(default 0) then the node name will be used.",
	"The caption cannot contain blanks. Use underscore instead.",
	0
};
static const char * HelpTextList_ImportDataMainHelpDefinition[] = {
	"`ImportData'",
	"reads ascii data in a variety of formats.",
	"Selected columns can be be ignored. Each line is broken into",
	"fields. A field is a string that has a numeric value.",
	"These fields are separated by any characters",
	"that do not have an embedded numeric value. Selected fields can",
	"be ignored.",
	0
};
static const char * HelpTextList_250[] = {
	"`FileName'",
	"specifies the name of the disk file",
	"to be read. If no file name is specified (default 0)",
	"you will be prompted for a file name when execution starts.",
	0
};
static const char * HelpTextList_251[] = {
	"`Format'",
	"specifies the format to use in reading data.",
	"Any standard `C' input format can be used.",
	"The default, `%d' for integer decimal data,",
	"for octal data. If the format string ends in `X' or `x'",
	"integer data is written to the output stream on a floating point",
	"simulator. If the last character is an `s' and the format",
	"is a floating point format the data will be normalized",
	"on the 16 bit integer simulator, i. e. .5 will be converted",
	"to 16384 or half of full scale.",
	"If the last two characters of the format string",
	"are an underscore (_) and any other character they will be deleted",
	"from the format. You can use this to control the type",
	"of output or scaling independent of the format for reading data.",
	"The type of format is determined by looking for the first occurrence",
	"of `%' ad then the first occurrence of one the letters `x',",
	"`d', `o' ,`f' or `e' after that. Floating point format",
	"characters must be preceded by a `l' and others must not.",
	"The letter can be in either",
	"upper or lower case. If the format is not recognized",
	"and error will be generated. `x' and `o' formats will read",
	"data as unsigned 32 bit integers. `d' will it as signed 32",
	"bit integers. `e' and 'f' will read it as a double floating point",
	"value. Overflows will be reported as warnings.",
	0
};
static const char * HelpTextList_252[] = {
	"`Fields'",
	"specifies the number of data fields on each line.",
	"If set to 0 then all data fields that are found on a line",
	"will be read (up to a maximum line width of 1024 characters.)",
	"A data field is any contiguous string",
	"of legal digits separated by white space (blank, tab,",
	"the beginning of a line or the end of a line)",
	"from other data fields or other information on the line.",
	"Decimal and octal fields can start with a `+' or `-'.",
	"Hexadecimal fields may start with an optional `0x' or",
	"`0X' provided the",
	"`Format'",
	"string is `%x' or `%X'. The value",
	"`Fields'",
	"is an upper limit on the fields on a",
	"line. There may be fewer fields on a line and even",
	"lines with no valid numeric fields.",
	0
};
static const char * HelpTextList_253[] = {
	"Setting",
	"`RepeatFlag'",
	"causes the file to be read at",
	"the beginning once the end of file is encountered.",
	"If the file is short it will only be read once and",
	"the data will be retained in memory.",
	0
};
static const char * HelpTextList_254[] = {
	"`SkipFields'",
	"is a list of fields (in increasing order) to skip.",
	"Fields start at 1. If all values are 0 no fields are skipped.",
	0
};
static const char * HelpTextList_255[] = {
	"`SkipColumns'",
	"is a list of pairs of column numbers in increasing order.",
	"All data in columns starting at the first column number in the",
	"pair and ending at the next column number after the second",
	"element in the pair will be ignored. Thus the list",
	"{",
	"20, 24, 30, 32",
	"}",
	"would cause the five columns",
	"20 through 24 and the three columns 30 through 32 to",
	"be skipped. If there are an odd number of entries",
	"all columns at or following the last entry",
	"will be skipped. Columns start at 1. If only values of 0",
	"are entered no columns will be skipped.",
	0
};
static const char * HelpTextList_256[] = {
	"`FileName'",
	"specifies the name of the disk file",
	"to be read. If no file name is specified (default 0)",
	"you will be prompted for a file name when execution starts.",
	0
};
static const char * HelpTextList_257[] = {
	"`Format'",
	"specifies the format to use in reading data.",
	"Any standard `C' input format can be used.",
	"The default, `%d' for integer decimal data,",
	"for octal data. If the format string ends in `X' or `x'",
	"integer data is written to the output stream on a floating point",
	"simulator. If the last character is an `s' and the format",
	"is a floating point format the data will be normalized",
	"on the 16 bit integer simulator, i. e. .5 will be converted",
	"to 16384 or half of full scale.",
	"If the last two characters of the format string",
	"are an underscore (_) and any other character they will be deleted",
	"from the format. You can use this to control the type",
	"of output or scaling independent of the format for reading data.",
	"The type of format is determined by looking for the first occurrence",
	"of `%' ad then the first occurrence of one the letters `x',",
	"`d', `o' ,`f' or `e' after that. Floating point format",
	"characters must be preceded by a `l' and others must not.",
	"The letter can be in either",
	"upper or lower case. If the format is not recognized",
	"and error will be generated. `x' and `o' formats will read",
	"data as unsigned 32 bit integers. `d' will it as signed 32",
	"bit integers. `e' and 'f' will read it as a double floating point",
	"value. Overflows will be reported as warnings.",
	0
};
static const char * HelpTextList_258[] = {
	"`Fields'",
	"specifies the number of data fields on each line.",
	"If set to 0 then all data fields that are found on a line",
	"will be read (up to a maximum line width of 1024 characters.)",
	"A data field is any contiguous string",
	"of legal digits separated by white space (blank, tab,",
	"the beginning of a line or the end of a line)",
	"from other data fields or other information on the line.",
	"Decimal and octal fields can start with a `+' or `-'.",
	"Hexadecimal fields may start with an optional `0x' or",
	"`0X' provided the",
	"`Format'",
	"string is `%x' or `%X'. The value",
	"`Fields'",
	"is an upper limit on the fields on a",
	"line. There may be fewer fields on a line and even",
	"lines with no valid numeric fields.",
	0
};
static const char * HelpTextList_259[] = {
	"Setting",
	"`RepeatFlag'",
	"causes the file to be read at",
	"the beginning once the end of file is encountered.",
	"If the file is short it will only be read once and",
	"the data will be retained in memory.",
	0
};
static const char * HelpTextList_260[] = {
	"`SkipFields'",
	"is a list of fields (in increasing order) to skip.",
	"Fields start at 1. If all values are 0 no fields are skipped.",
	0
};
static const char * HelpTextList_261[] = {
	"`SkipColumns'",
	"is a list of pairs of column numbers in increasing order.",
	"All data in columns starting at the first column number in the",
	"pair and ending at the next column number after the second",
	"element in the pair will be ignored. Thus the list",
	"{",
	"20, 24, 30, 32",
	"}",
	"would cause the five columns",
	"20 through 24 and the three columns 30 through 32 to",
	"be skipped. If there are an odd number of entries",
	"all columns at or following the last entry",
	"will be skipped. Columns start at 1. If only values of 0",
	"are entered no columns will be skipped.",
	0
};
static const char * HelpTextList_InputNodeMainHelpDefinition[] = {
	"`InputNode'",
	"reads input from disk file",
	"`FileName'.",
	"The number of channels and the number of multiplexed elements",
	"in a sample are read from the header of the disk file.",
	"Member function",
	"`DisplayHeader'",
	"will give the values of all the",
	"information read from the disk file header.",
	0
};
static const char * HelpTextList_262[] = {
	"`DisplayHeader'",
	"displays the parameters read from file",
	"`FileName'.",
	"These include the original node name that generated the file,",
	"the caption for this node, the number of input channels,",
	"and the number of scalar elements in a sample. The arithmetic",
	"type is also shown. The output channels and",
	"sample size for this node are determined by these values. If the",
	"data in the file is in a different arithmetic format",
	"than that currently in use, the file data will be converted.",
	0
};
static const char * HelpTextList_263[] = {
	"The data file header contains a count of the number of",
	"machine words in each channel. This count is written at",
	"the time the node creating the file is deleted. If ObjectProDSP",
	"exits abnormally then these counts may never be set",
	"and one will not be able to read any of the data in the",
	"file. This option causes these counts to be ignored.",
	"The result is that data will be read until the physical",
	"end of file. This may result in samples of all 0 being",
	"read at the end of the file that were never written to it.",
	0
};
static const char * HelpTextList_264[] = {
	"`FileName'",
	"specifies the name of the disk file",
	"to be read. If no file name is specified",
	"(default 0) then the node name will be used.",
	0
};
static const char * HelpTextList_265[] = {
	"If",
	"`Flags'",
	"& 4 is set the sample rate is forced to",
	"1, overwriting the default values.",
	0
};
static const char * HelpTextList_266[] = {
	"`DeltaOut'",
	"is the minimum output size. The node is not",
	"scheduled until space for",
	"`DeltaOut'",
	"words is available",
	"in the output buffer. It will only write multiples of",
	"`DeltaOut'",
	"samples.",
	0
};
static const char * HelpTextList_267[] = {
	"`FileName'",
	"specifies the name of the disk file",
	"to be read. If no file name is specified",
	"(default 0) then the node name will be used.",
	0
};
static const char * HelpTextList_268[] = {
	"If",
	"`Flags'",
	"& 4 is set the sample rate is forced to",
	"1, overwriting the default values.",
	0
};
static const char * HelpTextList_269[] = {
	"`DeltaOut'",
	"is the minimum output size. The node is not",
	"scheduled until space for",
	"`DeltaOut'",
	"words is available",
	"in the output buffer. It will only write multiples of",
	"`DeltaOut'",
	"samples.",
	0
};
static const char * HelpTextList_InputWordMainHelpDefinition[] = {
	"`InputWord'",
	"reads words from a binary input file. It is intended",
	"for importing data to other processes.",
	"`OutputWord'",
	"writes",
	"files that can be read by",
	"`InputWord'. However",
	"`OutputNode'",
	"and `InputNode'",
	"are better",
	"for preserving data for later use in ObjecProDSP because these",
	"retain sample rate, timing, block size and sample size information.",
	"You can manually specify the sample and block size of the",
	"data in the file with parameters",
	"`ElementSize'",
	"and",
	"`BlockSize'.",
	"Each output word is read in a format determined by",
	"`FormatIn'.",
	"The options are:",
	"`MachWord' (0),",
	"`int8' (1),",
	"`int16' (2),",
	"`int32' (3), `float' (4),",
	"`double'",
	"(5). Integer words are assumed in two's compliment",
	"format.",
	"You can skip a header or initial segment of a",
	"file by setting",
	"`InitialSkip'",
	"to the number bytes to skip.",
	"`IntegerOut'",
	"is nonzero the output stream is written as",
	"`IntegerMachWord' , otherwise it is written as `MachWord'.",
	"Integer output values ( `IntegerMachWord' ) are treated as signed.",
	"If overflow occurs the data is hard limited and a warning",
	"is given. The output stream can have any value for sample size, (",
	"`ElementSize' ) or",
	"`BlockSize'",
	"but these are not preserved in",
	"the output file as they are with",
	"`InputNode'.",
	0
};
static const char * HelpTextList_270[] = {
	"`FileName'",
	"is the binary input file",
	"to read. If no default(0) is given the node name will be used.",
	0
};
static const char * HelpTextList_271[] = {
	"`FormatIn'",
	"is the binary input format. The options are:",
	"`MachWord' (0),",
	"`int8' (1),",
	"`int16' (2),",
	"`int32' (3), `float'",
	"(4),",
	"`double' (5). Integer words are written in two's compliment",
	"format. Integer input values ( `IntegerMachWord'",
	") are treated as signed.",
	"If overflow occurs the data is hard limited and a warning",
	"is given. The input stream can have any value for sample size, (",
	"`ElementSize' )",
	0
};
static const char * HelpTextList_272[] = {
	"If",
	"`IntegerOut'",
	"is nonzero the output stream is written as",
	"`IntegerMachWord'. Otherwise it is written as `MachWord'.",
	"If overflow occurs the data is hard limited",
	"and a warning is given.",
	0
};
static const char * HelpTextList_273[] = {
	"The first",
	"`InitialSkip'",
	"bytes of the file are ignored.",
	0
};
static const char * HelpTextList_274[] = {
	"`ElementSize'",
	"is the number of words per sample in the input file.",
	0
};
static const char * HelpTextList_275[] = {
	"`BlockSize'",
	"is the number of samples per block in the",
	"input file.",
	0
};
static const char * HelpTextList_276[] = {
	"`FileName'",
	"is the binary input file",
	"to read. If no default(0) is given the node name will be used.",
	0
};
static const char * HelpTextList_277[] = {
	"`FormatIn'",
	"is the binary input format. The options are:",
	"`MachWord' (0),",
	"`int8' (1),",
	"`int16' (2),",
	"`int32' (3), `float'",
	"(4),",
	"`double' (5). Integer words are written in two's compliment",
	"format. Integer input values ( `IntegerMachWord'",
	") are treated as signed.",
	"If overflow occurs the data is hard limited and a warning",
	"is given. The input stream can have any value for sample size, (",
	"`ElementSize' )",
	0
};
static const char * HelpTextList_278[] = {
	"If",
	"`IntegerOut'",
	"is nonzero the output stream is written as",
	"`IntegerMachWord'. Otherwise it is written as `MachWord'.",
	"If overflow occurs the data is hard limited",
	"and a warning is given.",
	0
};
static const char * HelpTextList_279[] = {
	"The first",
	"`InitialSkip'",
	"bytes of the file are ignored.",
	0
};
static const char * HelpTextList_280[] = {
	"`ElementSize'",
	"is the number of words per sample in the input file.",
	0
};
static const char * HelpTextList_281[] = {
	"`BlockSize'",
	"is the number of samples per block in the",
	"input file.",
	0
};
static const char * HelpTextList_IntegrateMainHelpDefinition[] = {
	"`Integrate'",
	"sums",
	"`IntegrationSize'",
	"consecutive samples and",
	"outputs this sum for every",
	"`OutputStep'",
	"input samples.",
	"In effect it is a Fir filter with all the coefficients equal to 1.",
	"If",
	"`IntegrationSize'",
	"is 0 then the sum is continuous and",
	"the output is normalized by the number of samples. The",
	"summation is done in double floating point. The output is scaled by",
	"`Scale'",
	"before being converted to `MachWord'.",
	0
};
static const char * HelpTextList_282[] = {
	"`IntegrationSize'",
	"is the number of samples to sum.",
	0
};
static const char * HelpTextList_283[] = {
	"An output is generated for every",
	"`OutputStep'",
	"inputs.",
	"The number of buffers that must be maintained is",
	"`IntegrationSize'",
	"/",
	"`OutputStep'.",
	0
};
static const char * HelpTextList_284[] = {
	"`Scale'",
	"multiplies each output sample.",
	"The intermediate arithmetic is done in double floating point point.",
	"`Scale'",
	"is applied to the final output",
	"point before it is converted to MachWord.",
	0
};
static const char * HelpTextList_285[] = {
	"`Scale'",
	"multiplies each output sample.",
	"The intermediate arithmetic is done in double floating point point.",
	"`Scale'",
	"is applied to the final output",
	"point before it is converted to MachWord.",
	0
};
static const char * HelpTextList_286[] = {
	"`IntegrationSize'",
	"is the number of samples to sum.",
	0
};
static const char * HelpTextList_287[] = {
	"An output is generated for every",
	"`OutputStep'",
	"inputs.",
	"The number of buffers that must be maintained is",
	"`IntegrationSize'",
	"/",
	"`OutputStep'.",
	0
};
static const char * HelpTextList_288[] = {
	"`Scale'",
	"multiplies each output sample.",
	"The intermediate arithmetic is done in double floating point point.",
	"`Scale'",
	"is applied to the final output",
	"point before it is converted to MachWord.",
	0
};
static const char * HelpTextList_289[] = {
	"`Scale'",
	"multiplies each output sample.",
	"The intermediate arithmetic is done in double floating point point.",
	"`Scale'",
	"is applied to the final output",
	"point before it is converted to MachWord.",
	0
};
static const char * HelpTextList_290[] = {
	"`Scale'",
	"multiplies each output sample.",
	"The intermediate arithmetic is done in double floating point point.",
	"`Scale'",
	"is applied to the final output",
	"point before it is converted to MachWord.",
	0
};
static const char * HelpTextList_InterpolateMainHelpDefinition[] = {
	"`Interpolate'",
	"does linear interpolation and sample rate conversion.",
	"Each element in a sample is interpolated independently, i. e. for",
	"a complex data stream the real and imaginary parts are interpolated",
	"independently. For every",
	"`DeltaIn'",
	"input samples",
	"`DeltaOut'",
	"output samples are written.",
	"Output samples that fall between input samples are computed by linear",
	"interpolation between the two nearest neighbors.",
	0
};
static const char * HelpTextList_291[] = {
	"`DeltaIn'",
	"is the number of input samples",
	"for",
	"`DeltaOut'",
	"output samples.",
	0
};
static const char * HelpTextList_292[] = {
	"`DeltaOut'",
	"is the number of output samples generated from",
	"`DeltaIn'",
	"input samples.",
	0
};
static const char * HelpTextList_293[] = {
	"`DeltaIn'",
	"is the number of input samples",
	"for",
	"`DeltaOut'",
	"output samples.",
	0
};
static const char * HelpTextList_294[] = {
	"`DeltaOut'",
	"is the number of output samples generated from",
	"`DeltaIn'",
	"input samples.",
	0
};
static const char * HelpTextList_ListingMainHelpDefinition[] = {
	"`Listing'",
	"displays its input data streams. The",
	"`ElementSize'",
	"words in each sample are enclosed",
	"in parenthesis and separated by commas. Each sample is",
	"given an index of one to three levels. These are the",
	"element within a block, the block index and the channel index.",
	"If the time flag is set then the time of each sample is listed. If",
	"`Hex'",
	"is set the data is displayed in hexadecimal format and",
	"hard limited if it cannot fit in a 32 bit integer.",
	"`Caption'",
	"is a label the listing window.",
	0
};
static const char * HelpTextList_295[] = {
	"`Hex' , when set, displays",
	"data in hexadecimal format.",
	"If a value will not fit in a 32 bit integer it is hard limited.",
	0
};
static const char * HelpTextList_296[] = {
	"`Caption'",
	"specifies a caption that will appear at the",
	"head of the listing. If no caption is specified",
	"(default 0) then the node name will be used. The",
	"caption cannot contain blanks. Use underscore instead.",
	0
};
static const char * HelpTextList_297[] = {
	"`Hex' , when set, displays",
	"data in hexadecimal format.",
	"If a value will not fit in a 32 bit integer it is hard limited.",
	0
};
static const char * HelpTextList_298[] = {
	"`Hex' , when set, displays",
	"data in hexadecimal format.",
	"If a value will not fit in a 32 bit integer it is hard limited.",
	0
};
static const char * HelpTextList_299[] = {
	"`Caption'",
	"specifies a caption that will appear at the",
	"head of the listing. If no caption is specified",
	"(default 0) then the node name will be used. The",
	"caption cannot contain blanks. Use underscore instead.",
	0
};
static const char * HelpTextList_300[] = {
	"`Hex' , when set, displays",
	"data in hexadecimal format.",
	"If a value will not fit in a 32 bit integer it is hard limited.",
	0
};
static const char * HelpTextList_301[] = {
	"`Hex' , when set, displays",
	"data in hexadecimal format.",
	"If a value will not fit in a 32 bit integer it is hard limited.",
	0
};
static const char * HelpTextList_MaskWordMainHelpDefinition[] = {
	"`MaskWord'",
	"copies its input to its output after applying a the",
	"mask",
	"`Mask'",
	"to each sample.",
	0
};
static const char * HelpTextList_302[] = {
	"`Mask'",
	"will be applied to each input sample to",
	"create an output sample.",
	0
};
static const char * HelpTextList_303[] = {
	"`Mask'",
	"will be applied to each input sample to",
	"create an output sample.",
	0
};
static const char * HelpTextList_MuxMainHelpDefinition[] = {
	"`Mux'",
	"takes",
	"`Channels'",
	"input channels and multiplexes these onto",
	"a single output channel. Each input channel must have samples",
	"consisting of `InputSampleSize'",
	"words. For example, complex data streams",
	"will generally have two words in each sample. The output",
	"channel will have samples of",
	"`OutputSampleSize'",
	"words.",
	0
};
static const char * HelpTextList_304[] = {
	"`Mux'",
	"combines",
	"`Channels'",
	"input channels into",
	"a single output channel.",
	0
};
static const char * HelpTextList_305[] = {
	"For each input channel it is assumed that a",
	"single sample is made up of",
	"`InputSampleSize'",
	"words.",
	0
};
static const char * HelpTextList_306[] = {
	"The number of words in an output channel sample is",
	"`OutputSampleSize'.",
	0
};
static const char * HelpTextList_307[] = {
	"`MinimumChunk'",
	"can be set to a minimum number of input",
	"samples to be processed. This allows for greater",
	"efficiency but limits the degree to which data can be flushed.",
	0
};
static const char * HelpTextList_308[] = {
	"`Mux'",
	"combines",
	"`Channels'",
	"input channels into",
	"a single output channel.",
	0
};
static const char * HelpTextList_309[] = {
	"For each input channel it is assumed that a",
	"single sample is made up of",
	"`InputSampleSize'",
	"words.",
	0
};
static const char * HelpTextList_310[] = {
	"The number of words in an output channel sample is",
	"`OutputSampleSize'.",
	0
};
static const char * HelpTextList_311[] = {
	"`MinimumChunk'",
	"can be set to a minimum number of input",
	"samples to be processed. This allows for greater",
	"efficiency but limits the degree to which data can be flushed.",
	0
};
static const char * HelpTextList_NetworkMainHelpDefinition[] = {
	"`Network'",
	"is the class that allows you to combine",
	"nodes to form a DSP process. Member functions allow you",
	"to add threads (`operator+') and add nodes (`operator>>').",
	"It is easiest to use these functions by editing a network",
	"graphically. There are other member functions for editing",
	"and manipulating networks. Most of these can also be called",
	"by graphically editing a network. Member function",
	"`Execute'",
	"executes a network for a specified number of input blocks.",
	"It can only be accesses from the menu data base.",
	0
};
static const char * HelpTextList_312[] = {
	"Member function",
	"`GraphDisplay'",
	"displays network topology.",
	0
};
static const char * HelpTextList_313[] = {
	"Member function",
	"`Execute'",
	"executes this network.",
	"It causes the first node in the network",
	"to produce a specified number",
	"of input blocks. Each node is executed for as many iterations",
	"as possible given the available input data and output buffer",
	"space. Execution halts when no node generates any new samples",
	"after a complete pass throughout the network.",
	0
};
static const char * HelpTextList_314[] = {
	"`Raise'",
	"will cause a window displaying this network to be raised",
	"to the top level over any overlapping windows.",
	0
};
static const char * HelpTextList_315[] = {
	"`ReplaceNode'",
	"will substitute node",
	"`Replacement'",
	"for node",
	"`ToReplace'",
	"in the network. The nodes must have the same number of input and",
	"output channels and be compatible in all other respects. If an",
	"error occurs the original node will remain in the network.",
	0
};
static const char * HelpTextList_316[] = {
	"Member function",
	"`MakeTarget'",
	"will create source and executable",
	"code for this network for a supported target.",
	"See the description of parameter",
	"`Target'",
	"for a list of",
	"the available targets. See parameter",
	"`Directory'",
	"for a description of the files created.",
	0
};
static const char * HelpTextList_317[] = {
	"Member function",
	"`MakeValidate'",
	"first replaces each display output",
	"node in this network (such as plotting or listing nodes) with an",
	"`OutputNode'. This network is then saved to directory `DirName'.",
	"Next the same nodes are replaced with a",
	"`CompareDisk'",
	"node. This new network is written to the same directory under",
	"a different name. The first network saved state will include a",
	"statement to execute for",
	"`ExecuteCount'",
	"+",
	"`ExtraCountCreator'",
	"blocks of input. The second network will execute for",
	"`ExecuteCount'",
	"blocks. These networks",
	"are used to generate baseline regression test data and",
	"to run tests against this data.",
	0
};
static const char * HelpTextList_318[] = {
	"Member function",
	"`TargetValidate'",
	"first replaces each display output",
	"node in this network (such as plotting or listing nodes) with an",
	"`OutputNode'. This network is then used to generate",
	"a target system in directory",
	"`DirName' /create'. Next the",
	"same nodes are replaced with a",
	"`CompareDisk'",
	"node. The code for this network is written to the directory `DirName'",
	"/test. Shell scripts will be written to directory",
	"`DirName'",
	"to execute the networks for",
	"`ExecuteCount'",
	"blocks",
	"(test network) and ( `ExecuteCount'",
	"+",
	"`ExtraCountCreator' )",
	"blocks (test data creation network).",
	"`DirName'",
	"will contain",
	"all test data and error files and network state descriptions.",
	0
};
static const char * HelpTextList_319[] = {
	"If the timing analysis cannot resolve a network it may still",
	"execute correctly. If",
	"`Exact'",
	"is one no attempt will be made to",
	"execute the network. Instead an error will be generated. This is",
	"usually set for for validation tests to make sure that timing",
	"analysis errors are not overlooked.",
	0
};
static const char * HelpTextList_320[] = {
	"Member function",
	"`ReplaceWithOutput'",
	"replaces all plot and listing",
	"nodes with a new output node with a name derived from the",
	"node it is replacing. The file name is the same as the node name.",
	"This is used to create regression tests. First",
	"`ReplaceWithOutput'",
	"creates a network to generate test data. Then",
	"`ReplaceWithCompare'",
	"creates a network for running a regression",
	"test against the data. All three networks should be saved in",
	"separate state files.",
	0
};
static const char * HelpTextList_321[] = {
	"Member function",
	"`ReplaceWithCompare'",
	"replaces each",
	"`OutputNode' in a network with a",
	"`CompareDisk'",
	"node. If an",
	"`OutputNode'",
	"has more than one input channel the operation will fail.",
	"This is useful in converting a network used to generate",
	"a regression test case to a network for running the",
	"regression test. The new node name is created from",
	"the node replaced. The file name is the output file",
	"written by the node being replaced. The other parameters are set",
	"to be the same as the corresponding parameters of this function.",
	0
};
static const char * HelpTextList_322[] = {
	"The `+' operator appends its right operand (a signal",
	"generation node)",
	"`TheNode' to its left operand (a data flow",
	"`Network' ).",
	0
};
static const char * HelpTextList_323[] = {
	"The `>>' operator appends its right operand (a processing",
	"or signal generation node)",
	"`TheNode' to its left operand (a",
	"`DataFlow'",
	"Network).",
	0
};
static const char * HelpTextList_324[] = {
	"Member function",
	"`GraphDisplay'",
	"displays the network topology.",
	"In a window of up to",
	"`Width'",
	"x",
	"`Height'",
	"pixels.",
	"The window",
	"may start out smaller and grow larger as nodes are added",
	"to it but it will not exceed these dimensions. (If needed",
	"a vertical scrollbar will be added to the window.)",
	0
};
static const char * HelpTextList_325[] = {
	"Member function",
	"`DisplayNames'",
	"displays the names of the controller",
	"and buffer descriptor for this node in the help window.",
	0
};
static const char * HelpTextList_326[] = {
	"`SetBufferDescriptor'",
	"assigns descriptor",
	"`Descriptor'",
	"to this",
	"network. The network need not be complete. No buffers are allocated.",
	0
};
static const char * HelpTextList_327[] = {
	"`AssociateNode'",
	"associates node",
	"`TheNode'",
	"with this network. It does",
	"not link the node into the network. Its only effect is to have the node",
	"displayed in the window in which the network appears.",
	0
};
static const char * HelpTextList_328[] = {
	"In building a data flow topology network the connection operator",
	"`>>' always links the output of the last node accessed (from",
	"the network to the left of `>>') to the node on the right side of",
	"`>>'. For simple linear networks this is adequate. For nodes",
	"with more than one output",
	"one must specify when to use channels other than 0 using",
	"`Link'.",
	"`Link'",
	"causes the next link from the network to begin at the",
	"specified",
	"`TheNode'",
	"and",
	"`OutChannel'.",
	0
};
static const char * HelpTextList_329[] = {
	"`SelfLink'",
	"establishes a feedback link in a data flow",
	"network. Input parameters include the source node and its output channel",
	"and the destination node and its input channel.",
	0
};
static const char * HelpTextList_330[] = {
	"Member function",
	"`AssignBuffers'",
	"buffers to a complete network.",
	"Buffers will not be assigned if the network is not complete.",
	"`Descriptor'",
	"determines the buffer characteristics.",
	0
};
static const char * HelpTextList_331[] = {
	"Member function",
	"`GetBufferDescriptor'",
	"returns the buffer descriptor associated with this network.",
	0
};
static const char * HelpTextList_332[] = {
	"You can not change the topology of a network while buffers are",
	"assigned. Member function",
	"`ClearBuffers'",
	"removes all buffers",
	"so that the network can be edited or different buffers assigned.",
	0
};
static const char * HelpTextList_333[] = {
	"Member function",
	"`GetNetController'",
	"returns the network controller associated with this network.",
	0
};
static const char * HelpTextList_334[] = {
	"Member function",
	"`ClearNetwork'",
	"removes all links in the network",
	"being controlled. The nodes freed in this way can then be used",
	"in a different network.",
	0
};
static const char * HelpTextList_NormalMainHelpDefinition[] = {
	"`Normal'",
	"generates noise samples from a normal distribution.",
	"Let Z be samples from the standard normal distribution. This",
	"process generates samples as",
	"`Mean'",
	"+",
	"`Sigma'",
	"* Z.",
	"A vector of",
	"`ElementSize'",
	"samples is generated.",
	"`ElementSize'",
	"is ordinarily set to 1 for real data and 2 for complex data. `Seed'",
	"determines the sequence generated.",
	"Each object instance maintains it a separate state for the",
	"random number generator.",
	0
};
static const char * HelpTextList_335[] = {
	"`Sigma'",
	"specifies the standard deviation of the normally",
	"distributed samples created by this generator.",
	"`Sigma'",
	"is a",
	"scale factor for values generated in the standard normal",
	"distribution.",
	0
};
static const char * HelpTextList_336[] = {
	"`Mean'",
	"specifies the mean of the normally distributed samples",
	"created by this generator.",
	"`Mean'",
	"is an offset for the",
	"values generated in the standard normal distribution.",
	0
};
static const char * HelpTextList_337[] = {
	"`ElementSize'",
	"specifies the number of words in a single sample.",
	"It is most commonly 1 for real data or 2 for complex data.",
	0
};
static const char * HelpTextList_338[] = {
	"`Seed'",
	"seeds the random number generator. Each object instance",
	"maintains a separate history state for the random number",
	"generator. If the same value of",
	"`Seed'",
	"is used in different object instances",
	"they will generate the same sequence.",
	0
};
static const char * HelpTextList_339[] = {
	"`Sigma'",
	"specifies the standard deviation of the normally",
	"distributed samples created by this generator.",
	"`Sigma'",
	"is a",
	"scale factor for values generated in the standard normal",
	"distribution.",
	0
};
static const char * HelpTextList_340[] = {
	"`Mean'",
	"specifies the mean of the normally distributed samples",
	"created by this generator.",
	"`Mean'",
	"is an offset for the",
	"values generated in the standard normal distribution.",
	0
};
static const char * HelpTextList_341[] = {
	"`Sigma'",
	"specifies the standard deviation of the normally",
	"distributed samples created by this generator.",
	"`Sigma'",
	"is a",
	"scale factor for values generated in the standard normal",
	"distribution.",
	0
};
static const char * HelpTextList_342[] = {
	"`Mean'",
	"specifies the mean of the normally distributed samples",
	"created by this generator.",
	"`Mean'",
	"is an offset for the",
	"values generated in the standard normal distribution.",
	0
};
static const char * HelpTextList_343[] = {
	"`ElementSize'",
	"specifies the number of words in a single sample.",
	"It is most commonly 1 for real data or 2 for complex data.",
	0
};
static const char * HelpTextList_344[] = {
	"`Seed'",
	"seeds the random number generator. Each object instance",
	"maintains a separate history state for the random number",
	"generator. If the same value of",
	"`Seed'",
	"is used in different object instances",
	"they will generate the same sequence.",
	0
};
static const char * HelpTextList_345[] = {
	"`Sigma'",
	"specifies the standard deviation of the normally",
	"distributed samples created by this generator.",
	"`Sigma'",
	"is a",
	"scale factor for values generated in the standard normal",
	"distribution.",
	0
};
static const char * HelpTextList_346[] = {
	"`Mean'",
	"specifies the mean of the normally distributed samples",
	"created by this generator.",
	"`Mean'",
	"is an offset for the",
	"values generated in the standard normal distribution.",
	0
};
static const char * HelpTextList_347[] = {
	"`Sigma'",
	"specifies the standard deviation of the normally",
	"distributed samples created by this generator.",
	"`Sigma'",
	"is a",
	"scale factor for values generated in the standard normal",
	"distribution.",
	0
};
static const char * HelpTextList_348[] = {
	"`Mean'",
	"specifies the mean of the normally distributed samples",
	"created by this generator.",
	"`Mean'",
	"is an offset for the",
	"values generated in the standard normal distribution.",
	0
};
static const char * HelpTextList_OutputNodeMainHelpDefinition[] = {
	"`OutputNode'",
	"writes",
	"`Channels'",
	"of input to disk file",
	"`FileName'. Each channel",
	"contains `ElementSize' multiplexed elements. The data is blocked in",
	"as",
	"`FileBlockSize'",
	"consecutive samples from each channel. An",
	"`Caption'",
	"can be used to provide annotation of the file contents. If a reset",
	"is done after the output file is opened the last character of the",
	"file name is changed by adding 1 to it in the character sequence",
	"0-9,A-Z,a-z. Once the last character `z' is reached the next character",
	"is `0'. If the option is set not to overwrite a file then the open",
	"will fail if a file with the new name already exists.",
	"This cycling though file names allows testing of reset in a stand alone",
	"program that may need to process some data and then be reset to process",
	"the next input stream. cycle through the sequence 0-9,A-Z,-a-z",
	"or numeric that is the new file name. If not",
	0
};
static const char * HelpTextList_349[] = {
	"`FileName'",
	"specifies the name of the disk file",
	"to be created. If no caption is specified",
	"(default 0) then the node name will be used.",
	0
};
static const char * HelpTextList_350[] = {
	"if bit 1 of",
	"`Flags'",
	"is set then an existing file with",
	"the same name is overwritten without comment.",
	"If the overwrite option is",
	"not set and a file with the same name exists",
	"this node will not be initialized properly in non interactive",
	"mode and network execution will fail. In interactive mode,",
	"you will be asked to supply a new name.",
	"if bit 8 is set (Flags&8) is true then the data will be",
	"converted from whatever format the input channel is to",
	"32 bit integer data and written in that format. The data",
	"is hard limited.",
	0
};
static const char * HelpTextList_351[] = {
	"`OutputNode'",
	"writes",
	"`Channels'",
	"of data to a disk file.",
	0
};
static const char * HelpTextList_352[] = {
	"`FileBlockSize'",
	"determines the number of consecutive",
	"samples written to each channel. Making this larger",
	"reduces the number of disk accesses at the cost of",
	"larger memory buffers.",
	0
};
static const char * HelpTextList_353[] = {
	"`Caption'",
	"is a one line description of the contents",
	"of the file. It is displayed by executing a member",
	"function of an input node that reads this file.",
	0
};
static const char * HelpTextList_354[] = {
	"The node will read chunks of multiples of",
	"`DeltaIn'",
	"samples. Note for complex data there are two words in",
	"each sample. The node will not be executed unless `DeltaIn'",
	"input samples are available.",
	0
};
static const char * HelpTextList_355[] = {
	"`FileName'",
	"specifies the name of the disk file",
	"to be created. If no caption is specified",
	"(default 0) then the node name will be used.",
	0
};
static const char * HelpTextList_356[] = {
	"if bit 1 of",
	"`Flags'",
	"is set then an existing file with",
	"the same name is overwritten without comment.",
	"If the overwrite option is",
	"not set and a file with the same name exists",
	"this node will not be initialized properly in non interactive",
	"mode and network execution will fail. In interactive mode,",
	"you will be asked to supply a new name.",
	"if bit 8 is set (Flags&8) is true then the data will be",
	"converted from whatever format the input channel is to",
	"32 bit integer data and written in that format. The data",
	"is hard limited.",
	0
};
static const char * HelpTextList_357[] = {
	"`OutputNode'",
	"writes",
	"`Channels'",
	"of data to a disk file.",
	0
};
static const char * HelpTextList_358[] = {
	"`FileBlockSize'",
	"determines the number of consecutive",
	"samples written to each channel. Making this larger",
	"reduces the number of disk accesses at the cost of",
	"larger memory buffers.",
	0
};
static const char * HelpTextList_359[] = {
	"`Caption'",
	"is a one line description of the contents",
	"of the file. It is displayed by executing a member",
	"function of an input node that reads this file.",
	0
};
static const char * HelpTextList_360[] = {
	"The node will read chunks of multiples of",
	"`DeltaIn'",
	"samples. Note for complex data there are two words in",
	"each sample. The node will not be executed unless `DeltaIn'",
	"input samples are available.",
	0
};
static const char * HelpTextList_OutputWordMainHelpDefinition[] = {
	"`OutputWord'",
	"writes words to a binary file. It is intended",
	"for exporting data to other processes.",
	"`OutputNode'",
	"is better",
	"for preserving data for later use in ObjectProDSP because",
	"`Outputnode'",
	"retains sample rate, timing, block size and sample size information.",
	"Each input word is written in a format determined by",
	"`FormatOut'.",
	"The options are:",
	"`MachWord' (0),",
	"`int8' (1),",
	"`int16' (2),",
	"`int32' (3), `float' (4),",
	"`double'",
	"(5). Integer words are written in two's compliment",
	"format. Integer input values ( `IntegerMachWord'",
	") are treated as signed.",
	"If overflow occurs the data is hard limited and a warning",
	"is given. The input stream can have any value for sample size, (",
	"`ElementSize' ) or",
	"`BlockSize'",
	"but these are not preserved in",
	"the output file as they are with",
	"`OutputNode'.",
	0
};
static const char * HelpTextList_361[] = {
	"`FileName'",
	"is the file to be created. If no default(0) is given",
	"the node name will be used.",
	0
};
static const char * HelpTextList_362[] = {
	"`FormatOut'",
	"is the binary output format. The options are:",
	"`MachWord' (0),",
	"`int8' (1),",
	"`int16' (2),",
	"`int32' (3), `float'",
	"(4),",
	"`double' (5). Integer words are written in two's compliment",
	"format. Integer input values ( `IntegerMachWord'",
	") are treated as signed.",
	"If overflow occurs the data is hard limited and a warning",
	"is given. The input stream can have any value for sample size, (",
	"`ElementSize' )",
	0
};
static const char * HelpTextList_363[] = {
	"`FileName'",
	"is the file to be created. If no default(0) is given",
	"the node name will be used.",
	0
};
static const char * HelpTextList_364[] = {
	"`FormatOut'",
	"is the binary output format. The options are:",
	"`MachWord' (0),",
	"`int8' (1),",
	"`int16' (2),",
	"`int32' (3), `float'",
	"(4),",
	"`double' (5). Integer words are written in two's compliment",
	"format. Integer input values ( `IntegerMachWord'",
	") are treated as signed.",
	"If overflow occurs the data is hard limited and a warning",
	"is given. The input stream can have any value for sample size, (",
	"`ElementSize' )",
	0
};
static const char * HelpTextList_PackWordMainHelpDefinition[] = {
	"`PackWord'",
	"packs the least significant",
	"`InputWordSize'",
	"bits",
	"of",
	"`InputsPerOutput'",
	"consecutive input words to a single",
	"output word. The first input word is placed in the least",
	"significant output bits. The physical word size",
	"must be at least as large as",
	"`InputWordSize'",
	"*",
	"`InputsPerOutput'.",
	"If it is not an error is generated and the node will not",
	"be usable. The inverse of this operation is",
	"`UnpackWord'.",
	"`RepackStream'",
	"is a",
	"a more general but less efficient operation that is its own inverse.",
	0
};
static const char * HelpTextList_365[] = {
	"`InputWordSize'",
	"is the number of bits in each input",
	"word to pack into the output word.",
	0
};
static const char * HelpTextList_366[] = {
	"`InputsPerOutput'",
	"is the number of input words combined",
	"to form a single output word.",
	0
};
static const char * HelpTextList_367[] = {
	"`InputWordSize'",
	"is the number of bits in each input",
	"word to pack into the output word.",
	0
};
static const char * HelpTextList_368[] = {
	"`InputsPerOutput'",
	"is the number of input words combined",
	"to form a single output word.",
	0
};
static const char * HelpTextList_PlotMainHelpDefinition[] = {
	"`Plot'",
	"displays signals in graphical form.",
	"The plot can be captioned by setting",
	"`Caption'. If",
	"`Caption'",
	"is the default (0) a caption is constructed",
	"from the plot node name and the name of its driver node.",
	"The data is auto-scaled. You can display it with a fixed scale and",
	"alternate between the default full scale display and a",
	"fixed scale.",
	"See the help file on `change plot detail' accessible under `Help' in the menu bar",
	"in any plot window.",
	0
};
static const char * HelpTextList_369[] = {
	"The",
	"`Caption'",
	"is displayed",
	"at the base of the plot. The default value of 0",
	"causes the plot node name to be used for the caption.",
	"The caption cannot contain blanks. Use underscore instead.",
	0
};
static const char * HelpTextList_370[] = {
	"The",
	"`Caption'",
	"is displayed",
	"at the base of the plot. The default value of 0",
	"causes the plot node name to be used for the caption.",
	"The caption cannot contain blanks. Use underscore instead.",
	0
};
static const char * HelpTextList_PowerMainHelpDefinition[] = {
	"`Power'",
	"computes the sum of the squares of each input sample",
	"element. Before summing the power in each channel",
	"is multiplied by a linear scale factor",
	"`Scale'.",
	"The most common use is to compute the power of a complex signal.",
	"The linear scaling and the summation can cause an arithmetic overflow.",
	"Overflows cannot occur in the squaring operation",
	"(with integer arithmetic)",
	"because double precision integer arithmetic is used.",
	"Floating point overflows generate an interrupt and end",
	"node execution. Integer overflows are prevented by clipping. The first",
	"time clipping occurs a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_371[] = {
	"If",
	"`Amplitude'",
	"is set to 1, the output will be the square",
	"root of the power and not the power.",
	0
};
static const char * HelpTextList_372[] = {
	"`Scale'",
	"is a linear scale factor applied before",
	"summing the squared elements in a sample. For integer arithmetic,",
	"`Scale'",
	"should be",
	"set to prevent overflows. Note the squaring operation",
	"(in the integer arithmetic model) is",
	"done in double precision integer arithmetic. Thus if one is taking",
	"the amplitude as the final output ( `Amplitude'",
	"=1), overflows",
	"can only occur from the summation step. If integer overflows",
	"do occur the output signal is clipped. The first",
	"time clipping occurs, a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_373[] = {
	"`Scale'",
	"is a linear scale factor applied before",
	"summing the squared elements in a sample. For integer arithmetic,",
	"`Scale'",
	"should be",
	"set to prevent overflows. Note the squaring operation",
	"(in the integer arithmetic model) is",
	"done in double precision integer arithmetic. Thus if one is taking",
	"the amplitude as the final output ( `Amplitude'",
	"=1), overflows",
	"can only occur from the summation step. If integer overflows",
	"do occur the output signal is clipped. The first",
	"time clipping occurs, a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_374[] = {
	"If",
	"`Amplitude'",
	"is set to 1, the output will be the square",
	"root of the power and not the power.",
	0
};
static const char * HelpTextList_375[] = {
	"`Scale'",
	"is a linear scale factor applied before",
	"summing the squared elements in a sample. For integer arithmetic,",
	"`Scale'",
	"should be",
	"set to prevent overflows. Note the squaring operation",
	"(in the integer arithmetic model) is",
	"done in double precision integer arithmetic. Thus if one is taking",
	"the amplitude as the final output ( `Amplitude'",
	"=1), overflows",
	"can only occur from the summation step. If integer overflows",
	"do occur the output signal is clipped. The first",
	"time clipping occurs, a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_376[] = {
	"`Scale'",
	"is a linear scale factor applied before",
	"summing the squared elements in a sample. For integer arithmetic,",
	"`Scale'",
	"should be",
	"set to prevent overflows. Note the squaring operation",
	"(in the integer arithmetic model) is",
	"done in double precision integer arithmetic. Thus if one is taking",
	"the amplitude as the final output ( `Amplitude'",
	"=1), overflows",
	"can only occur from the summation step. If integer overflows",
	"do occur the output signal is clipped. The first",
	"time clipping occurs, a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_377[] = {
	"`Scale'",
	"is a linear scale factor applied before",
	"summing the squared elements in a sample. For integer arithmetic,",
	"`Scale'",
	"should be",
	"set to prevent overflows. Note the squaring operation",
	"(in the integer arithmetic model) is",
	"done in double precision integer arithmetic. Thus if one is taking",
	"the amplitude as the final output ( `Amplitude'",
	"=1), overflows",
	"can only occur from the summation step. If integer overflows",
	"do occur the output signal is clipped. The first",
	"time clipping occurs, a help message is generated. A new help",
	"message is generated after every 400 clippings.",
	0
};
static const char * HelpTextList_378[] = {
	"`Raise'",
	"will cause a displayed window referencing this node to raised",
	"to the top level over any overlapping windows.",
	"Examples of windows that will be affected are a network display",
	"containing this node or a plot window for this node.",
	0
};
static const char * HelpTextList_379[] = {
	"The",
	"`SetSampleRate'",
	"member function sets the sample",
	"rate for the specified output channel of this node.",
	"In turn the rates for all input and output channels connected",
	"to this node are adjusted with one exception.",
	"The adjustment will * b + c",
	"not be made through a node output channel that specifies",
	"a timing relationship of",
	"`TimingTypeRandom'.",
	0
};
static const char * HelpTextList_380[] = {
	"Member function",
	"`DisplayInputTiming'",
	"displays the timing",
	"of the selected input channel for this node.",
	0
};
static const char * HelpTextList_381[] = {
	"Member function",
	"`DisplayOutputTiming'",
	"displays the timing",
	"of the selected output channel for this node.",
	0
};
static const char * HelpTextList_382[] = {
	"If this node is not linked in an existing network it will be",
	"added to the display of the network currently being edited. If",
	"there is no such network one will be created.",
	0
};
static const char * HelpTextList_383[] = {
	"Member function",
	"`Unlink'",
	"disconnects this node from the",
	"DSP network it is linked in. All nodes that are connected",
	"as outputs from this node will be unlinked. This process",
	"continues recursively up to the terminal output nodes of all",
	"affected threads. Unlinking the first node in a single",
	"thread network will unlink every node in the network.",
	"If a node has two or more inputs and only one of these is unlinked",
	"the node will remain connected to the network",
	"on the unaffected input channel or channels.",
	0
};
static const char * HelpTextList_384[] = {
	"The",
	"`LinkIn'",
	"member function selects the",
	"next input channel to link to. It's single parameter ( `Channel' )",
	"specifies the channel index. Ordinarily the",
	"first unused channel is linked to. This function",
	"overrides that default.",
	0
};
static const char * HelpTextList_385[] = {
	"This function displays the next available input link for this node.",
	0
};
static const char * HelpTextList_386[] = {
	"This function displays the next available output link for this node.",
	0
};
static const char * HelpTextList_RampMainHelpDefinition[] = {
	"`Ramp'",
	"generates a linear ramp function with the initial value",
	"of",
	"`Min' , and increment between samples of",
	"`Increment'",
	"and",
	"upper bound on the output of",
	"`Max'. At the point where the",
	"next output would exceed",
	"`Max'",
	"it is reset to",
	"`Min'.",
	0
};
static const char * HelpTextList_387[] = {
	"`Min'",
	"is the minimum and initial value of the ramp function.",
	0
};
static const char * HelpTextList_388[] = {
	"`Max'",
	"is an upper bound on the ramp function. Before exceeding",
	"`Max'",
	"a sample will be reset to",
	"`Min'.",
	0
};
static const char * HelpTextList_389[] = {
	"`Increment'",
	"is the amount added to the previous sample",
	"to generate the next sample.",
	0
};
static const char * HelpTextList_390[] = {
	"`Min'",
	"is the minimum and initial value of the ramp function.",
	0
};
static const char * HelpTextList_391[] = {
	"`Max'",
	"is an upper bound on the ramp function. Before exceeding",
	"`Max'",
	"a sample will be reset to",
	"`Min'.",
	0
};
static const char * HelpTextList_392[] = {
	"`Increment'",
	"is the amount added to the previous sample",
	"to generate the next sample.",
	0
};
static const char * HelpTextList_393[] = {
	"`Min'",
	"is the minimum and initial value of the ramp function.",
	0
};
static const char * HelpTextList_394[] = {
	"`Max'",
	"is an upper bound on the ramp function. Before exceeding",
	"`Max'",
	"a sample will be reset to",
	"`Min'.",
	0
};
static const char * HelpTextList_395[] = {
	"`Increment'",
	"is the amount added to the previous sample",
	"to generate the next sample.",
	0
};
static const char * HelpTextList_396[] = {
	"`Min'",
	"is the minimum and initial value of the ramp function.",
	0
};
static const char * HelpTextList_397[] = {
	"`Max'",
	"is an upper bound on the ramp function. Before exceeding",
	"`Max'",
	"a sample will be reset to",
	"`Min'.",
	0
};
static const char * HelpTextList_398[] = {
	"`Increment'",
	"is the amount added to the previous sample",
	"to generate the next sample.",
	0
};
static const char * HelpTextList_399[] = {
	"`Min'",
	"is the minimum and initial value of the ramp function.",
	0
};
static const char * HelpTextList_400[] = {
	"`Max'",
	"is an upper bound on the ramp function. Before exceeding",
	"`Max'",
	"a sample will be reset to",
	"`Min'.",
	0
};
static const char * HelpTextList_401[] = {
	"`Increment'",
	"is the amount added to the previous sample",
	"to generate the next sample.",
	0
};
static const char * HelpTextList_ReadFloatMainHelpDefinition[] = {
	"`ReadFloat'",
	"reads a file of floating point ascii formatted values",
	"and writes them to a data stream of type `MachWord'.",
	"You can have as many values as you want on each line but there",
	"can only be white space as defined in the",
	"C++ input stream functions between numbers.",
	0
};
static const char * HelpTextList_402[] = {
	"`FileName'",
	"specifies the disk file",
	"to be read. If no name is specified the node name will be used.",
	0
};
static const char * HelpTextList_403[] = {
	"`FileName'",
	"specifies the disk file",
	"to be read. If no name is specified the node name will be used.",
	0
};
static const char * HelpTextList_ReadIntMainHelpDefinition[] = {
	"`ReadInt'",
	"read a file containing ascii formatted integers and",
	"writes the values to a",
	"`MachWord'",
	"data stream. If",
	"`Flags'",
	"&2 is",
	"set on a 32 bit simulator 32 bit integer values will be written.",
	"You can have as many values is you want on each line but there",
	"can only be white space as defined in the",
	"C++ input stream functions between numbers.",
	"`ImportData'",
	"can",
	"process more complex input files. If",
	"`Flags'",
	"&1 is set a hexadecimal input will be read as",
	"unsigned integers and converted as needed.",
	0
};
static const char * HelpTextList_404[] = {
	"`FileName'",
	"specifies the the disk file",
	"to be read. If no name is specified the node name will be used.",
	0
};
static const char * HelpTextList_405[] = {
	"`Flags' &1 specifies hex format file with optional",
	"0x or 0X prefix for each value.",
	"`Flags' &2 will write",
	"32 bit integer data on a floating point simulator.",
	"Decimal format files are read as signed integers and",
	"hexadecimal format as unsigned.",
	0
};
static const char * HelpTextList_406[] = {
	"`FileName'",
	"specifies the the disk file",
	"to be read. If no name is specified the node name will be used.",
	0
};
static const char * HelpTextList_407[] = {
	"`Flags' &1 specifies hex format file with optional",
	"0x or 0X prefix for each value.",
	"`Flags' &2 will write",
	"32 bit integer data on a floating point simulator.",
	"Decimal format files are read as signed integers and",
	"hexadecimal format as unsigned.",
	0
};
static const char * HelpTextList_RealFirMainHelpDefinition[] = {
	"`RealFir'",
	"implements a symmetric FIR filter.",
	"Input samples can have",
	"`ZeroPad'",
	"0's interpolated",
	"between them. Output sample can be generated for every",
	"`Resample'",
	"input (or zero pad) sample. The",
	"`Coeff'",
	"array contains half of",
	"the symmetric coefficients.",
	"`Odd'",
	"indicates if there are an even(0) or",
	"odd(1) total number of coefficients.",
	0
};
static const char * HelpTextList_408[] = {
	"`Resample'",
	"specifies the filter resampling factor.",
	"This is the ratio of the input sampling rate to the",
	"output sampling rate.",
	0
};
static const char * HelpTextList_409[] = {
	"`ZeroPad'",
	"specifies the number of 0's that are",
	"added after each input sample.",
	0
};
static const char * HelpTextList_410[] = {
	"`Odd'",
	"determines if the filter is if odd ( `Odd' =1) or even (",
	"`Odd' =0).",
	0
};
static const char * HelpTextList_411[] = {
	"`Coeff'",
	"is the list of filter coefficients. The filter is",
	"symmetric and only half (or half plus one",
	"for odd length filters) are specified. The first",
	"in the list is the first coefficient of the filter.",
	"The middle coefficient is at the end of the list.",
	"The default values for the coefficients define a low pass",
	"FIR filter with a pass band of .125 times the total bandwidth",
	"and transition band of .375 times the bandwidth. The",
	"pass band is extremely flat and the stop band is down over",
	"100 db. This is an overdesigned filter for most practical",
	"applications but it provides a good test case. The performance",
	"will be degraded by 16 bit integer arithmetic.",
	0
};
static const char * HelpTextList_412[] = {
	"`Resample'",
	"specifies the filter resampling factor.",
	"This is the ratio of the input sampling rate to the",
	"output sampling rate.",
	0
};
static const char * HelpTextList_413[] = {
	"`ZeroPad'",
	"specifies the number of 0's that are",
	"added after each input sample.",
	0
};
static const char * HelpTextList_414[] = {
	"`Odd'",
	"determines if the filter is if odd ( `Odd' =1) or even (",
	"`Odd' =0).",
	0
};
static const char * HelpTextList_415[] = {
	"`Coeff'",
	"is the list of filter coefficients. The filter is",
	"symmetric and only half (or half plus one",
	"for odd length filters) are specified. The first",
	"in the list is the first coefficient of the filter.",
	"The middle coefficient is at the end of the list.",
	"The default values for the coefficients define a low pass",
	"FIR filter with a pass band of .125 times the total bandwidth",
	"and transition band of .375 times the bandwidth. The",
	"pass band is extremely flat and the stop band is down over",
	"100 db. This is an overdesigned filter for most practical",
	"applications but it provides a good test case. The performance",
	"will be degraded by 16 bit integer arithmetic.",
	0
};
static const char * HelpTextList_RepackStreamMainHelpDefinition[] = {
	"`RepackStream'",
	"repacks a bit stream from",
	"an input physical word size,",
	"`InputWordSize'",
	"to",
	"an output physical word size,",
	"`OutputWordSize'. If",
	"`SignedOutput'",
	"is set the output will be written as a signed",
	"two's compliment value in the full physical word size.",
	"Both input and output",
	"are treated as continuous bit streams made up of physical words",
	"of the specified number of bits. The least significant physical",
	"bits occur logically first in the continuous stream.",
	"Logical words can cross physical word",
	"boundaries on both the input and output streams.",
	"One can use this to repack bit streams containing logical words of",
	"any length to a different physical word size. One can also use",
	"it to unpack a continuous stream of bits of any",
	"logical word size (up to 32 bits) to a stream of one physical",
	"output word for each each logical input word. Similarly on can",
	"pack a stream of physical words into a continuous bit stream,",
	"By setting",
	"`OutputWordSize'",
	"to the logical word size in the continuous input bit stream you unpack that",
	"stream placing one logical input word in each physical output word.",
	"By setting",
	"`InputWordSize'",
	"to the input logical word size",
	"you pack an input stream that has one logical word in each",
	"physical word into a continuous output bit stream. Neither",
	"`InputWordSize'",
	"and",
	"`OutputWordSize'",
	"can be greater then the",
	"physical word size. If either is the node will not be usable. If",
	"`InputWordSize'",
	"is an exact multiple of",
	"`OutputWordSize'",
	"(or",
	"vice versa)",
	"`UnpackWord'",
	"( `PackWord'",
	") is a more efficient process that does the same operation.",
	0
};
static const char * HelpTextList_416[] = {
	"`OutputWordSize'",
	"is the number of bits in each output",
	"word. The output is treated as a continuous stream of bits",
	"made up of the least significant",
	"`OutputWordSize'",
	"bits",
	"from each physical output word.",
	0
};
static const char * HelpTextList_417[] = {
	"`InputWordSize'",
	"is the number of bits in the input",
	"word. The input is treated as a continuous stream of bits",
	"made up of the least significant",
	"`OutputWordSize'",
	"bits",
	"from each physical output word.",
	0
};
static const char * HelpTextList_418[] = {
	"If",
	"`SignedOutput'",
	"is set the output will be written as a signed",
	"two's compliment value in the full physical word size.",
	0
};
static const char * HelpTextList_419[] = {
	"`OutputWordSize'",
	"is the number of bits in each output",
	"word. The output is treated as a continuous stream of bits",
	"made up of the least significant",
	"`OutputWordSize'",
	"bits",
	"from each physical output word.",
	0
};
static const char * HelpTextList_420[] = {
	"`InputWordSize'",
	"is the number of bits in the input",
	"word. The input is treated as a continuous stream of bits",
	"made up of the least significant",
	"`OutputWordSize'",
	"bits",
	"from each physical output word.",
	0
};
static const char * HelpTextList_421[] = {
	"If",
	"`SignedOutput'",
	"is set the output will be written as a signed",
	"two's compliment value in the full physical word size.",
	0
};
static const char * HelpTextList_SampleDelayMainHelpDefinition[] = {
	"`SampleDelay'",
	"initially copies",
	"`Delta'",
	"samples (with all components set equal to",
	"`FillValue'",
	") to its output. After that it simply",
	"copies its input to its output. This results in a delay if",
	"`Delta'",
	"samples.",
	0
};
static const char * HelpTextList_422[] = {
	"`Delta'",
	"specifies the number of samples the",
	"output signal will be delayed relative to the input.",
	0
};
static const char * HelpTextList_423[] = {
	"`FillValue'",
	"is the value to be output for each",
	"sample component for the first",
	"`Delta'",
	"samples.",
	0
};
static const char * HelpTextList_424[] = {
	"`Delta'",
	"specifies the number of samples the",
	"output signal will be delayed relative to the input.",
	0
};
static const char * HelpTextList_425[] = {
	"`FillValue'",
	"is the value to be output for each",
	"sample component for the first",
	"`Delta'",
	"samples.",
	0
};
static const char * HelpTextList_426[] = {
	"`Raise'",
	"will cause a window displaying this network to be raised",
	"to the top level over any overlapping windows.",
	"Examples of windows that will be affected are a network display",
	"containing this node or a plot window for this node.",
	0
};
static const char * HelpTextList_427[] = {
	"The",
	"`SetSampleRate'",
	"member function sets the sample",
	"rate for the specified output channel of this node.",
	"In turn the rates for all input and output channels connected",
	"to this node are adjusted with one exception. The adjustment will",
	"not be made through a node output channel that specifies",
	"a timing relationship of",
	"`TimingTypeRandom'.",
	0
};
static const char * HelpTextList_428[] = {
	"Member function",
	"`DisplayOutputTiming'",
	"displays the timing",
	"of the selected output channel for this node.",
	0
};
static const char * HelpTextList_429[] = {
	"If this node is not linked in an existing network it will be",
	"added to the display of the network currently being edited. If",
	"there is no such network one will be created.",
	0
};
static const char * HelpTextList_430[] = {
	"Member function",
	"`Unlink'",
	"disconnects this node from the",
	"DSP network it is linked in. All nodes that are connected",
	"as outputs from this node will be unlinked. This process",
	"continues recursively up to the terminal output nodes of all",
	"affected threads. Unlinking the first node in a single",
	"thread network will unlink every node in the network.",
	"If a node has two or more inputs and only one of these is unlinked",
	"the node will remain connected to the network",
	"on the unaffected input channel or channels.",
	0
};
static const char * HelpTextList_431[] = {
	"This function displays the next available output link for this node.",
	0
};
static const char * HelpTextList_ToIntegerMainHelpDefinition[] = {
	"`ToInteger'",
	"converts a MachWord data stream to integer format.",
	"The inverse operation can be done with node `ToMachWord'.",
	"This class is not available with the 16 bit arithmetic version",
	"of ObjectProDSP. Saturated output is produced on overflow.",
	"Overflows are not reported.",
	0
};
static const char * HelpTextList_ToMachMainHelpDefinition[] = {
	"`ToMach'",
	"converts a binary data stream to type",
	"`MachWord'. If",
	"`SignedConversion'",
	"is set the input will be treated as",
	"two's compliment signed values. Otherwise it will be treated",
	"as unsigned. The inverse operation is",
	"`ToInteger'. `ToInteger'",
	"and",
	"`ToMach'",
	"are meaningless and not available on the 16 bit",
	"integer simulator.",
	0
};
static const char * HelpTextList_432[] = {
	"If",
	"`SignedConversion'",
	"is set the input integer will treated as",
	"a two's compliment signed value. Otherwise it will be considered",
	"unsigned.",
	0
};
static const char * HelpTextList_433[] = {
	"If",
	"`SignedConversion'",
	"is set the input integer will treated as",
	"a two's compliment signed value. Otherwise it will be considered",
	"unsigned.",
	0
};
static const char * HelpTextList_TruncateMainHelpDefinition[] = {
	"`Truncate'",
	"converts the MachWord input data to a 32 bit integer",
	"(after checking for overflow). On the floating point simulator",
	"the input can also be 32 bit integers. The dynamic range is then",
	"restricted to",
	"`Range'. The number of significant bits",
	"is restricted to",
	"`Accuracy'. Neither",
	"`Range'",
	"nor",
	"`Accuracy'",
	"include",
	"the sign bit. Although integers are represented is twos compliment format",
	"truncation can be thought of as working on signed magnitude data.",
	"Overflow will saturate if",
	"`OverflowMode'",
	"is 0 and cause the high order bits to be ignored if",
	"`OverflowMode'",
	"is 1. The output is converted back to MachWord format.",
	0
};
static const char * HelpTextList_434[] = {
	"`Range'",
	"is the number of bits in the dynamic range of the output",
	"(not counting the sign bit).",
	0
};
static const char * HelpTextList_435[] = {
	"`Accuracy'",
	"is the number of significant bits retained in the output",
	"(not counting the sign bit).",
	"`Accuracy'",
	"will always be <=",
	"`Range'.",
	"If you specify more accuracy then range accuracy will equal range.",
	0
};
static const char * HelpTextList_436[] = {
	"`OverflowMode'",
	"selects saturation (0) or truncation (1) mode.",
	"In saturation mode an overflow is replaced by the largest positive",
	"or negative number representable depending on the sign of the input",
	"value. In Truncation mode the high order bits are truncated as if",
	"the number was in sign magnitude form.",
	0
};
static const char * HelpTextList_437[] = {
	"`Round'",
	"if set rounds the result. Otherwise it is",
	"truncated. Truncation is always towards 0 and not two's compliment",
	"truncation.",
	0
};
static const char * HelpTextList_438[] = {
	"`Range'",
	"is the number of bits in the dynamic range of the output",
	"(not counting the sign bit).",
	0
};
static const char * HelpTextList_439[] = {
	"`Accuracy'",
	"is the number of significant bits retained in the output",
	"(not counting the sign bit).",
	"`Accuracy'",
	"will always be <=",
	"`Range'.",
	"If you specify more accuracy then range accuracy will equal range.",
	0
};
static const char * HelpTextList_440[] = {
	"`OverflowMode'",
	"selects saturation (0) or truncation (1) mode.",
	"In saturation mode an overflow is replaced by the largest positive",
	"or negative number representable depending on the sign of the input",
	"value. In Truncation mode the high order bits are truncated as if",
	"the number was in sign magnitude form.",
	0
};
static const char * HelpTextList_441[] = {
	"`Round'",
	"if set rounds the result. Otherwise it is",
	"truncated. Truncation is always towards 0 and not two's compliment",
	"truncation.",
	0
};
static const char * HelpTextList_442[] = {
	"`Range'",
	"is the number of bits in the dynamic range of the output",
	"(not counting the sign bit).",
	0
};
static const char * HelpTextList_443[] = {
	"`Accuracy'",
	"is the number of significant bits retained in the output",
	"(not counting the sign bit).",
	"`Accuracy'",
	"will always be <=",
	"`Range'.",
	"If you specify more accuracy then range accuracy will equal range.",
	0
};
static const char * HelpTextList_444[] = {
	"`OverflowMode'",
	"selects saturation (0) or truncation (1) mode.",
	"In saturation mode an overflow is replaced by the largest positive",
	"or negative number representable depending on the sign of the input",
	"value. In Truncation mode the high order bits are truncated as if",
	"the number was in sign magnitude form.",
	0
};
static const char * HelpTextList_445[] = {
	"`Round'",
	"if set rounds the result. Otherwise it is",
	"truncated. Truncation is always towards 0 and not two's compliment",
	"truncation.",
	0
};
static const char * HelpTextList_446[] = {
	"`Range'",
	"is the number of bits in the dynamic range of the output",
	"(not counting the sign bit).",
	0
};
static const char * HelpTextList_447[] = {
	"`Accuracy'",
	"is the number of significant bits retained in the output",
	"(not counting the sign bit).",
	"`Accuracy'",
	"will always be <=",
	"`Range'.",
	"If you specify more accuracy then range accuracy will equal range.",
	0
};
static const char * HelpTextList_448[] = {
	"`OverflowMode'",
	"selects saturation (0) or truncation (1) mode.",
	"In saturation mode an overflow is replaced by the largest positive",
	"or negative number representable depending on the sign of the input",
	"value. In Truncation mode the high order bits are truncated as if",
	"the number was in sign magnitude form.",
	0
};
static const char * HelpTextList_449[] = {
	"`Round'",
	"if set rounds the result. Otherwise it is",
	"truncated. Truncation is always towards 0 and not two's compliment",
	"truncation.",
	0
};
static const char * HelpTextList_450[] = {
	"`Range'",
	"is the number of bits in the dynamic range of the output",
	"(not counting the sign bit).",
	0
};
static const char * HelpTextList_451[] = {
	"`Accuracy'",
	"is the number of significant bits retained in the output",
	"(not counting the sign bit).",
	"`Accuracy'",
	"will always be <=",
	"`Range'.",
	"If you specify more accuracy then range accuracy will equal range.",
	0
};
static const char * HelpTextList_452[] = {
	"`OverflowMode'",
	"selects saturation (0) or truncation (1) mode.",
	"In saturation mode an overflow is replaced by the largest positive",
	"or negative number representable depending on the sign of the input",
	"value. In Truncation mode the high order bits are truncated as if",
	"the number was in sign magnitude form.",
	0
};
static const char * HelpTextList_453[] = {
	"`Round'",
	"if set rounds the result. Otherwise it is",
	"truncated. Truncation is always towards 0 and not two's compliment",
	"truncation.",
	0
};
static const char * HelpTextList_UniformNoiseMainHelpDefinition[] = {
	"`UniformNoise'",
	"generates noise samples of",
	"`ElementSize'",
	"elements from a uniform distribution. Set",
	"`ElementSize'",
	"to 1 for real data or 2 for complex.",
	"The values generated range between `Minimum'",
	"and",
	"`Maximum'.",
	"`Seed'",
	"determines the sequence generated.",
	"Each object instance maintains it a separate state for the",
	"random number generator.",
	0
};
static const char * HelpTextList_454[] = {
	"`Maximum'",
	"is the largest value of uniformly distributed noise.",
	0
};
static const char * HelpTextList_455[] = {
	"`Minimum'",
	"is the smallest value of uniformly distributed",
	"noise. Most commonly",
	"`Minimum'",
	"= -",
	"`Maximum'.",
	0
};
static const char * HelpTextList_456[] = {
	"`ElementSize'",
	"specifies the number of words in a single sample.",
	"It is most commonly 1 for real data or 2 for complex data.",
	0
};
static const char * HelpTextList_457[] = {
	"`Seed'",
	"seeds the random number generator. Each object instance",
	"maintains a separate history state for the random number",
	"generator. If the same value of",
	"`Seed'",
	"is used in different object instances they will generate the same.",
	0
};
static const char * HelpTextList_458[] = {
	"`Maximum'",
	"is the largest value of uniformly distributed noise.",
	0
};
static const char * HelpTextList_459[] = {
	"`Minimum'",
	"is the smallest value of uniformly distributed",
	"noise. Most commonly",
	"`Minimum'",
	"= -",
	"`Maximum'.",
	0
};
static const char * HelpTextList_460[] = {
	"`Maximum'",
	"is the largest value of uniformly distributed noise.",
	0
};
static const char * HelpTextList_461[] = {
	"`Minimum'",
	"is the smallest value of uniformly distributed",
	"noise. Most commonly",
	"`Minimum'",
	"= -",
	"`Maximum'.",
	0
};
static const char * HelpTextList_462[] = {
	"`ElementSize'",
	"specifies the number of words in a single sample.",
	"It is most commonly 1 for real data or 2 for complex data.",
	0
};
static const char * HelpTextList_463[] = {
	"`Seed'",
	"seeds the random number generator. Each object instance",
	"maintains a separate history state for the random number",
	"generator. If the same value of",
	"`Seed'",
	"is used in different object instances they will generate the same.",
	0
};
static const char * HelpTextList_464[] = {
	"`Maximum'",
	"is the largest value of uniformly distributed noise.",
	0
};
static const char * HelpTextList_465[] = {
	"`Minimum'",
	"is the smallest value of uniformly distributed",
	"noise. Most commonly",
	"`Minimum'",
	"= -",
	"`Maximum'.",
	0
};
static const char * HelpTextList_466[] = {
	"`Maximum'",
	"is the largest value of uniformly distributed noise.",
	0
};
static const char * HelpTextList_467[] = {
	"`Minimum'",
	"is the smallest value of uniformly distributed",
	"noise. Most commonly",
	"`Minimum'",
	"= -",
	"`Maximum'.",
	0
};
static const char * HelpTextList_UnpackWordMainHelpDefinition[] = {
	"`UnpackWord'",
	"unpacks each input word to",
	"`OutputsPerInput'",
	"output words each containing",
	"`OutputWordSize'",
	"bits. If",
	"`SignedOutput'",
	"is set the output will be written as a signed",
	"two's compliment value in the full physical word size.",
	"The least significant bits of each input word are written first.",
	"The physical word size must be at least as large as",
	"`OutputWordSize'",
	"*",
	"`OutputsPerInput'.",
	"If not an error will be generated and the node will be unusable. The",
	"inverse of this operation is",
	"`PackWord'.",
	"`RepackStream'",
	"is a",
	"more general but less efficient operation that is its own inverse.",
	0
};
static const char * HelpTextList_468[] = {
	"`OutputWordSize'",
	"is the number of bits in the output word.",
	0
};
static const char * HelpTextList_469[] = {
	"`OutputsPerInput'",
	"is the number of output words",
	"unpacked from each input word.",
	0
};
static const char * HelpTextList_470[] = {
	"If",
	"`SignedOutput'",
	"is set the output will be written as a signed",
	"two's compliment value in the full physical word size.",
	0
};
static const char * HelpTextList_471[] = {
	"`OutputWordSize'",
	"is the number of bits in the output word.",
	0
};
static const char * HelpTextList_472[] = {
	"`OutputsPerInput'",
	"is the number of output words",
	"unpacked from each input word.",
	0
};
static const char * HelpTextList_473[] = {
	"If",
	"`SignedOutput'",
	"is set the output will be written as a signed",
	"two's compliment value in the full physical word size.",
	0
};
static const char * HelpTextList_VoiceNodeMainHelpDefinition[] = {
	"`VoiceNode'",
	"reads `Creative Voice' format files.",
	"Only files containing uncompressed sampled data",
	"are supported. This format has one sample per",
	"each byte in offset format, i. e. 128 is subtracted",
	"from each unsigned byte to create a signed sample.",
	"In the 16 bit integer simulator you will probably need",
	"to rescale the data (most likely by dividing by 128)",
	"before writing it in this format. Member function",
	"`DisplayHeader'",
	"displays the file header. If",
	"`NoHeader'",
	"is set then no header is read. Node",
	"`VoiceStripOut'",
	"writes files in this format.",
	0
};
static const char * HelpTextList_474[] = {
	"`DisplayHeader'",
	"displays the information in the file header.",
	0
};
static const char * HelpTextList_475[] = {
	"`FileName'",
	"must be the name of an existing file",
	"in the Creative Voice File Format.",
	"Only uncompressed files of block type 1 (New Voice Block)",
	"are supported.",
	0
};
static const char * HelpTextList_476[] = {
	"`NoHeader'",
	"if set to 1 indicates the file does not contain",
	"a header.",
	"`VoiceStripOut'",
	"writes files in Creative Voice format",
	"files with no header.",
	0
};
static const char * HelpTextList_477[] = {
	"`FileName'",
	"must be the name of an existing file",
	"in the Creative Voice File Format.",
	"Only uncompressed files of block type 1 (New Voice Block)",
	"are supported.",
	0
};
static const char * HelpTextList_478[] = {
	"`NoHeader'",
	"if set to 1 indicates the file does not contain",
	"a header.",
	"`VoiceStripOut'",
	"writes files in Creative Voice format",
	"files with no header.",
	0
};
static const char * HelpTextList_VoiceStripOutMainHelpDefinition[] = {
	"`VoiceStripOut'",
	"writes its input to disk file",
	"`FileName'",
	"in Creative Voice file format but with no header.",
	"This format has one sample per",
	"each byte in offset format, i. e. 128 is added",
	"to each input sample. (After this sum any value < 0 is",
	"set to 0 and any value > 255 is set to 255 producing",
	"hard limit on overflows.",
	"In the 16 bit integer simulator you will probably need",
	"to rescale the data (most likely by dividing by 128)",
	"before processing it. Input can be",
	"`MachWord'",
	"or",
	"`IntegerMachWord'. ( `IntegerMachWord'",
	"values",
	"are treated as signed integers.) Input have any value for",
	"`BlockSize'",
	"and sample size ( `ElementSize' ) but",
	"these values will not be recorded in the file as they are with",
	"`OutputNode'.",
	0
};
static const char * HelpTextList_479[] = {
	"`FileName'",
	"is the file to be created. If no default(0) is given",
	"the node name will be used.",
	0
};
static const char * HelpTextList_480[] = {
	"`FileName'",
	"is the file to be created. If no default(0) is given",
	"the node name will be used.",
	0
};
static const char * HelpTextList_ZFde0MainHelpDefinition[] = {
	"`ZFde0'",
	"generates outputs form a discretized and exact finite",
	"difference equation. The discretized solution is output as",
	"the real part and the exact solution as the imaginary part.",
	"This is intended as a demonstration of the combinatorial",
	"complexity of the discretized finite difference equation",
	"as compared to the continuous solution. The output stops",
	"once the initial state is repeated.",
	0
};
static const char * HelpTextList_481[] = {
	"`Time0'",
	"is the first of two samples that (along with the",
	"frequency coefficient) that determine the time sequence.",
	0
};
static const char * HelpTextList_482[] = {
	"`Time1'",
	"is the second of two samples that (along with the",
	"frequency coefficient) that determine the time sequence.",
	0
};
static const char * HelpTextList_483[] = {
	"`Factor'",
	"determines the frequency of the exact solution of",
	"the difference equation and the approximate frequency of",
	"the iterated solution.",
	0
};
static const char * HelpTextList_484[] = {
	"`Time0'",
	"is the first of two samples that (along with the",
	"frequency coefficient) that determine the time sequence.",
	0
};
static const char * HelpTextList_485[] = {
	"`Time1'",
	"is the second of two samples that (along with the",
	"frequency coefficient) that determine the time sequence.",
	0
};
static const char * HelpTextList_486[] = {
	"`Factor'",
	"determines the frequency of the exact solution of",
	"the difference equation and the approximate frequency of",
	"the iterated solution.",
	0
};
static const char * HelpTextList_ZFde1MainHelpDefinition[] = {
	"`ZFde1'",
	"generates outputs form a 1 dimensional finite difference",
	"approximation to the wave equation. Each step generates a linear",
	"array of outputs as a function of the two previous linear arrays.",
	"The initial disturbance",
	"will spread in space until it reaches the boundaries of a predefined",
	"array. At that point the output stops. This example illustrates",
	"some of the properties of discretized finite difference equations.",
	0
};
static const char * HelpTextList_487[] = {
	"`Factor'",
	"determines the velocity of propagation in the",
	"the difference equation",
	0
};
static const char * HelpTextList_488[] = {
	"Every",
	"`Interval'",
	"time steps an output is generated. Only",
	"values between the first and last nonzero value are displayed.",
	0
};
static const char * HelpTextList_489[] = {
	"`MaxSize'",
	"is the maximum array size or the maximum length",
	"and initial disturbance can spread out.",
	0
};
static const char * HelpTextList_490[] = {
	"`Time0'",
	"is the array of values at the first time step.",
	0
};
static const char * HelpTextList_491[] = {
	"`Time1'",
	"is the array of values at the first time step.",
	0
};
static const char * HelpTextList_492[] = {
	"`DoubMaxSteps'",
	"limits the number of steps for the",
	"double simulation. This can be decreased to turn off",
	"simulation but not increased. If it is 0 initially no",
	"double array will be declared.",
	0
};
static const char * HelpTextList_493[] = {
	"`DiscrScheme'",
	"selects the discretization scheme.",
	"The default (0) truncates towards 0.",
	"1 rounds up to the largest magnitude integer value.",
	"2 does conventional rounding.",
	0
};
static const char * HelpTextList_494[] = {
	"Every",
	"`Interval'",
	"time steps an output is generated. Only",
	"values between the first and last nonzero value are displayed.",
	0
};
static const char * HelpTextList_495[] = {
	"`DoubMaxSteps'",
	"limits the number of steps for the",
	"double simulation. This can be decreased to turn off",
	"simulation but not increased. If it is 0 initially no",
	"double array will be declared.",
	0
};
static const char * HelpTextList_496[] = {
	"`DiscrScheme'",
	"selects the discretization scheme.",
	"The default (0) truncates towards 0.",
	"1 rounds up to the largest magnitude integer value.",
	"2 does conventional rounding.",
	0
};
static const char * HelpTextList_497[] = {
	"`Factor'",
	"determines the velocity of propagation in the",
	"the difference equation",
	0
};
static const char * HelpTextList_498[] = {
	"Every",
	"`Interval'",
	"time steps an output is generated. Only",
	"values between the first and last nonzero value are displayed.",
	0
};
static const char * HelpTextList_499[] = {
	"`MaxSize'",
	"is the maximum array size or the maximum length",
	"and initial disturbance can spread out.",
	0
};
static const char * HelpTextList_500[] = {
	"`Time0'",
	"is the array of values at the first time step.",
	0
};
static const char * HelpTextList_501[] = {
	"`Time1'",
	"is the array of values at the first time step.",
	0
};
static const char * HelpTextList_502[] = {
	"`DoubMaxSteps'",
	"limits the number of steps for the",
	"double simulation. This can be decreased to turn off",
	"simulation but not increased. If it is 0 initially no",
	"double array will be declared.",
	0
};
static const char * HelpTextList_503[] = {
	"`DiscrScheme'",
	"selects the discretization scheme.",
	"The default (0) truncates towards 0.",
	"1 rounds up to the largest magnitude integer value.",
	"2 does conventional rounding.",
	0
};
static const char * HelpTextList_504[] = {
	"Every",
	"`Interval'",
	"time steps an output is generated. Only",
	"values between the first and last nonzero value are displayed.",
	0
};
static const char * HelpTextList_505[] = {
	"`DoubMaxSteps'",
	"limits the number of steps for the",
	"double simulation. This can be decreased to turn off",
	"simulation but not increased. If it is 0 initially no",
	"double array will be declared.",
	0
};
static const char * HelpTextList_506[] = {
	"`DiscrScheme'",
	"selects the discretization scheme.",
	"The default (0) truncates towards 0.",
	"1 rounds up to the largest magnitude integer value.",
	"2 does conventional rounding.",
	0
};
static const char * HelpTextList_507[] = {
	"Every",
	"`Interval'",
	"time steps an output is generated. Only",
	"values between the first and last nonzero value are displayed.",
	0
};
static const char * HelpTextList_508[] = {
	"`DoubMaxSteps'",
	"limits the number of steps for the",
	"double simulation. This can be decreased to turn off",
	"simulation but not increased. If it is 0 initially no",
	"double array will be declared.",
	0
};
static const char * HelpTextList_509[] = {
	"`DiscrScheme'",
	"selects the discretization scheme.",
	"The default (0) truncates towards 0.",
	"1 rounds up to the largest magnitude integer value.",
	"2 does conventional rounding.",
	0
};
MenuLine MainCgiMenuLine[] = {
	{"help",
	"Main help menu",
	MenuTypeMenu, (void *) &HelpMenu, 0, 0, HelpTextList_1, "help"},
	{"objects",
	"Display and describe existing objects",
	MenuTypeMenu, (void *) &AllCls, 0, 0, HelpTextList_2, "objects"},
	{"setup",
	"Read state and plot files, debugging",
	MenuTypeMenu, (void *) &FilesMenu, 0, 0, HelpTextList_3, "setup"},
	{"state",
	"Program state menu",
	MenuTypeMenu, (void *) &CGIStateMenu, 0, 0, HelpTextList_4, "statesv"},
	{"save and exit",
	"Save program state and exit",
	MenuTypeCommand, (void *) &DoSaveExit_Loc_Call_Struct, 0, 0, HelpTextList_5, "statesv"},
	{0}
};

MenuLine HelpMenuMenuLine[] = {
	{"introduction",
	"Basic information for the new user",
	MenuTypeHelp, 0, 0, 0, HelpTextList_6, "introd"},
	{"copying",
	"THERE IS NO WARRANTY and information about copying",
	MenuTypeHelp, 0, 0, 0, HelpTextList_7, "copy"},
	{"manual",
	"Online ObjectProDSP manual",
	MenuTypeMenu, (void *) &DetailedHelp, 0, 0, HelpTextList_8, "help"},
	{"examples",
	"Display and execute examples",
	MenuTypeMenu, (void *) &ExampleMenu, 0, 0, HelpTextList_9, "examp"},
	{"help levels",
	"Control the display of help information",
	MenuTypeMenu, (void *) &HelpLevels, 0, 0, HelpTextList_10, "help"},
	{0}
};

MenuLine DetailedHelpMenuLine[] = {
	{"about help",
	"Describe the help facilities",
	MenuTypeHelp, 0, 0, 0, HelpTextList_11, "help"},
	{"DSP nets",
	"Graphically creating and editing networks",
	MenuTypeHelp, 0, 0, 0, HelpTextList_12, "net_edit"},
	{"DSP++",
	"ObjectProDSP language",
	MenuTypeMenu, (void *) &HelpDspPPMenu, 0, 0, HelpTextList_13, "help"},
	{"commands",
	"Data base commands, record and playback a session",
	MenuTypeHelp, 0, 0, 0, HelpTextList_14, "cmd"},
	{"release",
	"Release notes for this version",
	MenuTypeHelp, 0, 0, 0, HelpTextList_15, "release"},
	{0}
};

MenuLine HelpDspPPMenuMenuLine[] = {
	{"network help",
	"ObjectProDSP networks",
	MenuTypeHelp, 0, 0, 0, HelpTextList_16, "net"},
	{"object help",
	"DSP processing objects",
	MenuTypeHelp, 0, 0, 0, HelpTextList_17, "dspnode"},
	{"plot help",
	"Plotting objects",
	MenuTypeHelp, 0, 0, 0, HelpTextList_18, "plots"},
	{"syntax",
	"ObjectProDSP language syntax",
	MenuTypeHelp, 0, 0, 0, HelpTextList_19, "dspintr"},
	{"validation",
	"ObjectProDSP validation suites",
	MenuTypeHelp, 0, 0, 0, HelpTextList_20, "valid"},
	{0}
};

MenuLine HelpLevelsMenuLine[] = {
	{"help none",
	"Display no help information",
	MenuTypeCommand, (void *) &SetHelpLevelNone_Loc_Call_Struct, 0, 0, HelpTextList_21, "help"},
	{"help confirm",
	"Display action confirmation messages only",
	MenuTypeCommand, (void *) &SetHelpLevelConfirm_Loc_Call_Struct, 0, 0, HelpTextList_22, "help"},
	{"help all",
	"Display all help messages",
	MenuTypeCommand, (void *) &SetHelpLevelAll_Loc_Call_Struct, 0, 0, HelpTextList_23, "help"},
	{0}
};

MenuLine FilesMenuMenuLine[] = {
	{"read state",
	"Read a program state file",
	MenuTypeCommand, (void *) &ReadState_Loc_Call_Struct, 0, 0, HelpTextList_24, "setup"},
	{"read over state",
	"Read a program state file",
	MenuTypeCommand, (void *) &ReadOverState_Loc_Call_Struct, 0, 0, HelpTextList_25, "setup"},
	{"read plot",
	"Read and display a saved plot file",
	MenuTypeCommand, (void *) &ReadPlot_Loc_Call_Struct, 0, 0, HelpTextList_26, "plots"},
	{"debug",
	"control debugging options",
	MenuTypeMenu, (void *) &DebugOptionsMenu, 0, 0, HelpTextList_27, "debug"},
	{0}
};

MenuLine DebugOptionsMenuMenuLine[] = {
	{"trace",
	"Turn on node tracing",
	MenuTypeCommand, (void *) &node_trace_on_Rem_Call_Struct, 0, 0, HelpTextList_28, "debug"},
	{"trace off",
	"Turn off node tracing",
	MenuTypeCommand, (void *) &node_trace_off_Rem_Call_Struct, 0, 0, HelpTextList_29, "debug"},
	{"heap ck",
	"Turn on heap integrity checking",
	MenuTypeCommand, (void *) &heap_check_on_Rem_Call_Struct, 0, 0, HelpTextList_30, "debug"},
	{"heap ck off",
	"Turn off heap checking",
	MenuTypeCommand, (void *) &heap_check_off_Rem_Call_Struct, 0, 0, HelpTextList_31, "debug"},
	{"over lim",
	"Control overflow reporting",
	MenuTypeCommand, (void *) &set_report_overflow_limit_Rem_Call_Struct, 0, 0, HelpTextList_32, "debug"},
	{0}
};

MenuLine SimpleVariableMenuMenuLine[] = {
	{"list int",
	"List integer variables",
	MenuTypeCommand, (void *) &ListInt_Rem_Call_Struct, 0, 0, HelpTextList_33, "variable"},
	{"list float",
	"List floating point variables",
	MenuTypeCommand, (void *) &ListDouble_Rem_Call_Struct, 0, 0, HelpTextList_34, "variable"},
	{"list mach",
	"List MachWord variables",
	MenuTypeCommand, (void *) &ListMachWord_Rem_Call_Struct, 0, 0, HelpTextList_35, "variable"},
	{"list accmach",
	"List AccMachWord variables",
	MenuTypeCommand, (void *) &ListAccMachWord_Rem_Call_Struct, 0, 0, HelpTextList_36, "variable"},
	{0}
};

MenuLine AllClsMenuLine[] = {
	{"dsp processing",
	"DSP processing objects",
	MenuTypeMenu, (void *) &DspNodesMenu, 0, 0, HelpTextList_37, "dspnode"},
	{"signal",
	"Signal generation objects",
	MenuTypeMenu, (void *) &SignalNodesMenu, 0, 0, HelpTextList_38, "signalT"},
	{"plot",
	"Plotting objects",
	MenuTypeMenu, (void *) &PlotNodesMenu, 0, 0, HelpTextList_39, "plots"},
	{"list",
	"Listing objects",
	MenuTypeMenu, (void *) &ListNodesMenu, 0, 0, HelpTextList_40, "txt_out"},
	{"disk",
	"Read and write disk files",
	MenuTypeMenu, (void *) &DiskMenu, 0, 0, HelpTextList_41, "files"},
	{"network",
	"Network and system objects",
	MenuTypeMenu, (void *) &NetworkMenu, 0, 0, HelpTextList_42, "net"},
	{"variables",
	"Simple variables",
	MenuTypeMenu, (void *) &SimpleVariableMenu, 0, 0, HelpTextList_43, "simvar"},
	{0}
};

MenuLine DiskMenuMenuLine[] = {
	{"ascii",
	"Nodes to read files",
	MenuTypeMenu, (void *) &AsciiDiskNodesMenu, 0, 0, HelpTextList_44, "files"},
	{"binary",
	"Nodes to write files",
	MenuTypeMenu, (void *) &BinaryDiskNodesMenu, 0, 0, HelpTextList_45, "files"},
	{0}
};

MenuLine AsciiDiskNodesMenuMenuLine[] = {
	{"AsciiFile",
	"`AsciiFile' writes an ascii file of data sent to it",
	MenuTypeMenu, (void *) &AsciiFileNodeOptMenu, 0, 0, HelpTextList_AsciiFileMainHelpDefinition, "files"},
	{"ImportData",
	"`ImportData' reads an ascii input file",
	MenuTypeMenu, (void *) &ImportDataNodeOptMenu, 0, 0, HelpTextList_ImportDataMainHelpDefinition, "import"},
	{"ReadFloat",
	"`ReadFloat' reads an ascii float input file",
	MenuTypeMenu, (void *) &ReadFloatNodeOptMenu, 0, 0, HelpTextList_ReadFloatMainHelpDefinition, "import"},
	{"ReadInt",
	"`ReadInt' reads an ascii integer input file",
	MenuTypeMenu, (void *) &ReadIntNodeOptMenu, 0, 0, HelpTextList_ReadIntMainHelpDefinition, "import"},
	{0}
};

MenuLine BinaryDiskNodesMenuMenuLine[] = {
	{"CompareDisk",
	"`CompareDisk' compares input to a file written by an `OutputNode'",
	MenuTypeMenu, (void *) &CompareDiskNodeOptMenu, 0, 0, HelpTextList_CompareDiskMainHelpDefinition, "valid"},
	{"InputNode",
	"`InputNode' reads a disk file written by an `OutputNode'",
	MenuTypeMenu, (void *) &InputNodeNodeOptMenu, 0, 0, HelpTextList_InputNodeMainHelpDefinition, "ionodT"},
	{"InputWord",
	"`InputWord' reads words in a selected format from a binary file",
	MenuTypeMenu, (void *) &InputWordNodeOptMenu, 0, 0, HelpTextList_InputWordMainHelpDefinition, "binin"},
	{"OutputNode",
	"`OutputNode' writes a specified number of channels to a disk file",
	MenuTypeMenu, (void *) &OutputNodeNodeOptMenu, 0, 0, HelpTextList_OutputNodeMainHelpDefinition, "ionodT"},
	{"OutputWord",
	"`OutputWord' writes words in a selected format to a binary file",
	MenuTypeMenu, (void *) &OutputWordNodeOptMenu, 0, 0, HelpTextList_OutputWordMainHelpDefinition, "binin"},
	{"VoiceNode",
	"`VoiceNode' reads `Creative Voice' format files",
	MenuTypeMenu, (void *) &VoiceNodeNodeOptMenu, 0, 0, HelpTextList_VoiceNodeMainHelpDefinition, "binin"},
	{"VoiceStripOut",
	"`VoiceStripOut' writes a Creative Voice format file with no header",
	MenuTypeMenu, (void *) &VoiceStripOutNodeOptMenu, 0, 0, HelpTextList_VoiceStripOutMainHelpDefinition, "binin"},
	{0}
};

MenuLine DspNodesMenuMenuLine[] = {
	{"Add",
	"`Add' sums two or more input channels",
	MenuTypeMenu, (void *) &AddNodeOptMenu, 0, 0, HelpTextList_AddMainHelpDefinition, "add"},
	{"Block",
	"Converts an input stream to a new blocking and sample size",
	MenuTypeMenu, (void *) &BlockNodeOptMenu, 0, 0, HelpTextList_BlockMainHelpDefinition, "block"},
	{"CxFFT",
	"`CxFFT' computes the complex FFT of a single input channel",
	MenuTypeMenu, (void *) &CxFFTNodeOptMenu, 0, 0, HelpTextList_CxFFTMainHelpDefinition, "cxfft"},
	{"CxFir",
	"`CxFir' is a complex symmetric (even or odd) fir filter",
	MenuTypeMenu, (void *) &CxFirNodeOptMenu, 0, 0, HelpTextList_CxFirMainHelpDefinition, "filters"},
	{"Demod",
	"`DemodFreq' is a complex modulation/demodulation function",
	MenuTypeMenu, (void *) &DemodNodeOptMenu, 0, 0, HelpTextList_DemodMainHelpDefinition, "filters"},
	{"Demux",
	"Demultiplexes 1 input channel to `Channels' output channels.",
	MenuTypeMenu, (void *) &DemuxNodeOptMenu, 0, 0, HelpTextList_DemuxMainHelpDefinition, "mux"},
	{"FindStartTail",
	"discard initial input data within bounds",
	MenuTypeMenu, (void *) &FindStartTailNodeOptMenu, 0, 0, HelpTextList_FindStartTailMainHelpDefinition, "misc"},
	{"Gain",
	"Gain provides a linear gain",
	MenuTypeMenu, (void *) &GainNodeOptMenu, 0, 0, HelpTextList_GainMainHelpDefinition, "mux"},
	{"GainPad",
	"`GainPad' provides a linear gain",
	MenuTypeMenu, (void *) &GainPadNodeOptMenu, 0, 0, HelpTextList_GainPadMainHelpDefinition, "mux"},
	{"Integrate",
	"`Integrate' sums consecutive input vector.",
	MenuTypeMenu, (void *) &IntegrateNodeOptMenu, 0, 0, HelpTextList_IntegrateMainHelpDefinition, "filters"},
	{"Interpolate",
	"sample rate conversion with linear interpolation",
	MenuTypeMenu, (void *) &InterpolateNodeOptMenu, 0, 0, HelpTextList_InterpolateMainHelpDefinition, "filters"},
	{"MaskWord",
	"applies a mask to a binary data stream",
	MenuTypeMenu, (void *) &MaskWordNodeOptMenu, 0, 0, HelpTextList_MaskWordMainHelpDefinition, "mux"},
	{"Mux",
	"Multiplexes `Channels' inputs into 1 output channel.",
	MenuTypeMenu, (void *) &MuxNodeOptMenu, 0, 0, HelpTextList_MuxMainHelpDefinition, "mux"},
	{"PackWord",
	"packs multiple input words to a single output word",
	MenuTypeMenu, (void *) &PackWordNodeOptMenu, 0, 0, HelpTextList_PackWordMainHelpDefinition, "mux"},
	{"Power",
	"Power computes and scales the power in each sample",
	MenuTypeMenu, (void *) &PowerNodeOptMenu, 0, 0, HelpTextList_PowerMainHelpDefinition, "convert"},
	{"RealFir",
	"`RealFir' is a real symmetric (even or odd) fir filter",
	MenuTypeMenu, (void *) &RealFirNodeOptMenu, 0, 0, HelpTextList_RealFirMainHelpDefinition, "filters"},
	{"RepackStream",
	"repack bit streams to different physical word sizes",
	MenuTypeMenu, (void *) &RepackStreamNodeOptMenu, 0, 0, HelpTextList_RepackStreamMainHelpDefinition, "mux"},
	{"SampleDelay",
	"delays the output by a selected number of samples",
	MenuTypeMenu, (void *) &SampleDelayNodeOptMenu, 0, 0, HelpTextList_SampleDelayMainHelpDefinition, "misc"},
	{"ToInteger",
	"converts MachWord data stream to integer",
	MenuTypeMenu, (void *) &ToIntegerNodeOptMenu, 0, 0, HelpTextList_ToIntegerMainHelpDefinition, "convert"},
	{"ToMach",
	"converts binary data stream to `MachWord'",
	MenuTypeMenu, (void *) &ToMachNodeOptMenu, 0, 0, HelpTextList_ToMachMainHelpDefinition, "convert"},
	{"Truncate",
	"Limit the dynamic range and significant bits in a stream",
	MenuTypeMenu, (void *) &TruncateNodeOptMenu, 0, 0, HelpTextList_TruncateMainHelpDefinition, "convert"},
	{"UnpackWord",
	"unpack a single input word to multiple output words",
	MenuTypeMenu, (void *) &UnpackWordNodeOptMenu, 0, 0, HelpTextList_UnpackWordMainHelpDefinition, "mux"},
	{0}
};

MenuLine SignalNodesMenuMenuLine[] = {
	{"ConstantData",
	"generate a `MachWord' constant",
	MenuTypeMenu, (void *) &ConstantDataNodeOptMenu, 0, 0, HelpTextList_ConstantDataMainHelpDefinition, "signalT"},
	{"Cos",
	"Generates the real function `Amplitude' cos(`Phase' + N `Frequency')",
	MenuTypeMenu, (void *) &CosNodeOptMenu, 0, 0, HelpTextList_CosMainHelpDefinition, "signalT"},
	{"CxCos",
	"Generates the function `Amplitude' e^(2 Pi i(`Phase' + N `Frequency'))",
	MenuTypeMenu, (void *) &CxCosNodeOptMenu, 0, 0, HelpTextList_CxCosMainHelpDefinition, "signalT"},
	{"CxImp",
	"Generates a periodic impulse or square wave",
	MenuTypeMenu, (void *) &CxImpNodeOptMenu, 0, 0, HelpTextList_CxImpMainHelpDefinition, "signalT"},
	{"Normal",
	"Generate normally distributed noise samples",
	MenuTypeMenu, (void *) &NormalNodeOptMenu, 0, 0, HelpTextList_NormalMainHelpDefinition, "signalT"},
	{"Ramp",
	"generates a linear ramp function",
	MenuTypeMenu, (void *) &RampNodeOptMenu, 0, 0, HelpTextList_RampMainHelpDefinition, "signalT"},
	{"UniformNoise",
	"Generate uniformly distributed noise samples",
	MenuTypeMenu, (void *) &UniformNoiseNodeOptMenu, 0, 0, HelpTextList_UniformNoiseMainHelpDefinition, "signalT"},
	{"ZFde0",
	"`ZFde0' generates sequences form a finite difference equation",
	MenuTypeMenu, (void *) &ZFde0NodeOptMenu, 0, 0, HelpTextList_ZFde0MainHelpDefinition, "disc_fde"},
	{"ZFde1",
	"`ZFde1' generates sequences form a finite difference equation",
	MenuTypeMenu, (void *) &ZFde1NodeOptMenu, 0, 0, HelpTextList_ZFde1MainHelpDefinition, "disc_fde"},
	{0}
};

MenuLine ListNodesMenuMenuLine[] = {
	{"HexList",
	"`HexList' lists a specified number of channels to a display window",
	MenuTypeMenu, (void *) &HexListNodeOptMenu, 0, 0, HelpTextList_HexListMainHelpDefinition, "txt_out"},
	{"Listing",
	"`Listing' lists a specified number of channels to a display window",
	MenuTypeMenu, (void *) &ListingNodeOptMenu, 0, 0, HelpTextList_ListingMainHelpDefinition, "txt_out"},
	{0}
};

MenuLine NetworkMenuMenuLine[] = {
	{"CircBufDes",
	"Circular buffer descriptor",
	MenuTypeMenu, (void *) &CircBufDesNodeOptMenu, 0, 0, HelpTextList_CircBufDesMainHelpDefinition, "buf"},
	{"DataFlow",
	"Data flow based network control and scheduling",
	MenuTypeMenu, (void *) &DataFlowNodeOptMenu, 0, 0, HelpTextList_DataFlowMainHelpDefinition, "net"},
	{"Network",
	"Data flow network objects",
	MenuTypeMenu, (void *) &NetworkNodeOptMenu, 0, 0, HelpTextList_NetworkMainHelpDefinition, "net"},
	{0}
};

MenuLine PlotNodesMenuMenuLine[] = {
	{"EyePlot",
	"`EyePlot' plots complex signal in eye plot (X versus Y) form",
	MenuTypeMenu, (void *) &EyePlotNodeOptMenu, 0, 0, HelpTextList_EyePlotMainHelpDefinition, "plots"},
	{"Plot",
	"`Plot' creates graphs of real, complex and two dimensional data streams",
	MenuTypeMenu, (void *) &PlotNodeOptMenu, 0, 0, HelpTextList_PlotMainHelpDefinition, "plots"},
	{0}
};

MenuLine ExampOptMenuMenuLine[] = {
	{"desc",
	"Describe this example",
	MenuTypeCommand, (void *) &DescribeExample__STACK_Loc_Call_Struct, 0, 0, 0, "examp"},
	{"execute",
	"Execute this example",
	MenuTypeCommand, (void *) &ExecuteExample__STACK_no_Loc_Call_Struct, 0, 0, HelpTextList_46, "examp"},
	{"execute over",
	"Execute this example overwriting existing objects",
	MenuTypeCommand, (void *) &ExecuteExample__STACK_over_Loc_Call_Struct, 0, 0, HelpTextList_47, "examp"},
	{0}
};

MenuLine CGIStateMenuMenuLine[] = {
	{"save",
	"Save state",
	MenuTypeCommand, (void *) &DoSave_Rem_Call_Struct, 0, 0, HelpTextList_48, "statesv"},
	{"save as",
	"Save state with prompt for file",
	MenuTypeCommand, (void *) &DoSaveAs_Rem_Call_Struct, 0, 0, HelpTextList_49},
	{"auto save",
	"Save state periodically",
	MenuTypeCommand, (void *) &DoSavePeriod_Rem_Call_Struct, 0, 0, HelpTextList_StateSavePeriodicHelp, "statesv"},
	{"set name",
	"Display or change state file name and number of backups",
	MenuTypeCommand, (void *) &SetStateSaveFile_Rem_Call_Struct, 0, 0, HelpTextList_50, "statesv"},
	{"session",
	"Record and playback sessions",
	MenuTypeMenu, (void *) &RecordSession, 0, 0, HelpTextList_51, "actions"},
	{"abort dsp",
	"Abort DSP execution",
	MenuTypeCommand, (void *) &AbortDspExecution_Loc_Call_Struct, 0, 0, HelpTextList_52, "abort"},
	{"plot err",
	"display plot data error counts",
	MenuTypeCommand, (void *) &PlotErr_Loc_Call_Struct, 0, 0, HelpTextList_53, "plots"},
	{"freeze",
	"Freeze DSP execution",
	MenuTypeCommand, (void *) &FreezeDsp_Loc_Call_Struct, 0, 0, HelpTextList_54, "abort"},
	{"thaw",
	"Thaw DSP execution",
	MenuTypeCommand, (void *) &ThawDsp_Loc_Call_Struct, 0, 0, HelpTextList_55, "abort"},
	{"exit",
	"Exit ObjectProDSP with optional state save",
	MenuTypeCommand, (void *) &DoExit_Loc_Call_Struct, 0, 0, HelpTextList_56, "statesv"},
	{0}
};

MenuLine RecordSessionMenuLine[] = {
	{"rec",
	"Begin recording all session inputs",
	MenuTypeCommand, (void *) &RecordActions_Loc_Call_Struct, 0, 0, HelpTextList_57, "actions"},
	{"rec off",
	"Stop recording",
	MenuTypeCommand, (void *) &RecordOff_Loc_Call_Struct, 0, 0, HelpTextList_58, "actions"},
	{"rec close",
	"Stop recording and close the file",
	MenuTypeCommand, (void *) &RecordFlush_Loc_Call_Struct, 0, 0, HelpTextList_59, "actions"},
	{"play",
	"Play back a recorded session",
	MenuTypeCommand, (void *) &PlayActions_Loc_Call_Struct, 0, 0, HelpTextList_60, "actions"},
	{"pause",
	"Specify delay in seconds between commands",
	MenuTypeCommand, (void *) &PlayPause_Loc_Call_Struct, 0, 0, HelpTextList_61, "actions"},
	{0}
};

MenuLine AddNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Add'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_AddMainHelpDefinition, "add"},
	{"param",
	"Parameters of `Add'",
	MenuTypeMenu, (void *) &AddParamMenu, 0, 0, HelpTextList_NodeParamHelp, "add"},
	{"variables",
	"Changeable variables of `Add'",
	MenuTypeMenu, (void *) &AddVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "add"},
	{"members",
	"Members of `Add'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "add"},
	{"instance",
	"Describe or delete an instance of `Add'",
	MenuTypeMenu, (void *) &AddInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "add"},
	{"create default",
	"Create instance of `Add' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Add_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "add"},
	{"create",
	"Create instance of `Add'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Add_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "add"},
	{0}
};

MenuLine AddInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Add'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Add_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "add"},
	{"param",
	"Describe parameters of this `Add'",
	MenuTypeMenu, (void *) &AddInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "add"},
	{"exec",
	"Select a member of `Add' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "add"},
	{"variables",
	"Describe variables of this `Add'",
	MenuTypeMenu, (void *) &AddInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "add"},
	{"set",
	"Set variable values of this `Add'",
	MenuTypeMenu, (void *) &AddSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "add"},
	{"delete",
	"Delete this `Add'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Add_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "add"},
	{0}
};

MenuLine AddParamMenuMenuLine[] = {
	{"Channels",
	"Parameter `Channels' of `Add' object",
	MenuTypeCommand, (void *) &DescribeParam__Add_Channels_Rem_Call_Struct, 0, 0, HelpTextList_62, "add"},
	{"ElementSize",
	"Parameter `ElementSize' of `Add' object",
	MenuTypeCommand, (void *) &DescribeParam__Add_ElementSize_Rem_Call_Struct, 0, 0, HelpTextList_63, "add"},
	{"Scale",
	"Parameter `Scale' of `Add' object",
	MenuTypeCommand, (void *) &DescribeParam__Add_Scale_Rem_Call_Struct, 0, 0, HelpTextList_64, "add"},
	{0}
};

MenuLine AddVariableMenuMenuLine[] = {
	{"Scale",
	"Changeable variable `Scale' of `Add' object",
	MenuTypeCommand, (void *) &DescribeParam__Add_Scale_Rem_Call_Struct, 0, 0, HelpTextList_65, "add"},
	{0}
};

MenuLine AddInstanceParamMenuMenuLine[] = {
	{"Channels",
	"Parameter `Channels' of `Add' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Add_STACK_Channels_Rem_Call_Struct, 0, 0, HelpTextList_66, "add"},
	{"ElementSize",
	"Parameter `ElementSize' of `Add' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Add_STACK_ElementSize_Rem_Call_Struct, 0, 0, HelpTextList_67, "add"},
	{"Scale",
	"Parameter `Scale' of `Add' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Add_STACK_Scale_Rem_Call_Struct, 0, 0, HelpTextList_68, "add"},
	{0}
};

MenuLine AddInstanceVariableMenuMenuLine[] = {
	{"Scale",
	"Changeable variable `Scale' of `Add' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Add_STACK_Scale_Rem_Call_Struct, 0, 0, HelpTextList_69, "add"},
	{0}
};

MenuLine AddSetInstanceVariableMenuMenuLine[] = {
	{"set Scale",
	"Change value of variable `Scale' for an instance of `Add'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Add_STACK_Scale_Rem_Call_Struct, 0, 0, HelpTextList_70, "add"},
	{0}
};

MenuLine AsciiFileNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `AsciiFile'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_AsciiFileMainHelpDefinition, "files"},
	{"param",
	"Parameters of `AsciiFile'",
	MenuTypeMenu, (void *) &AsciiFileParamMenu, 0, 0, HelpTextList_NodeParamHelp, "files"},
	{"variables",
	"Changeable variables of `AsciiFile'",
	MenuTypeMenu, (void *) &AsciiFileVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "files"},
	{"members",
	"Members of `AsciiFile'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "files"},
	{"instance",
	"Describe or delete an instance of `AsciiFile'",
	MenuTypeMenu, (void *) &AsciiFileInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "files"},
	{"create default",
	"Create instance of `AsciiFile' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__AsciiFile_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "files"},
	{"create",
	"Create instance of `AsciiFile'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__AsciiFile_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "files"},
	{0}
};

MenuLine AsciiFileInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `AsciiFile'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__AsciiFile_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "files"},
	{"param",
	"Describe parameters of this `AsciiFile'",
	MenuTypeMenu, (void *) &AsciiFileInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "files"},
	{"exec",
	"Select a member of `AsciiFile' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "files"},
	{"variables",
	"Describe variables of this `AsciiFile'",
	MenuTypeMenu, (void *) &AsciiFileInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "files"},
	{"set",
	"Set variable values of this `AsciiFile'",
	MenuTypeMenu, (void *) &AsciiFileSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "files"},
	{"delete",
	"Delete this `AsciiFile'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__AsciiFile_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "files"},
	{0}
};

MenuLine AsciiFileParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `AsciiFile' object",
	MenuTypeCommand, (void *) &DescribeParam__AsciiFile_FileName_Rem_Call_Struct, 0, 0, HelpTextList_71, "files"},
	{"Hex",
	"Parameter `Hex' of `AsciiFile' object",
	MenuTypeCommand, (void *) &DescribeParam__AsciiFile_Hex_Rem_Call_Struct, 0, 0, HelpTextList_72, "files"},
	{"NoGroup",
	"Parameter `NoGroup' of `AsciiFile' object",
	MenuTypeCommand, (void *) &DescribeParam__AsciiFile_NoGroup_Rem_Call_Struct, 0, 0, HelpTextList_73, "files"},
	{"NoHeader",
	"Parameter `NoHeader' of `AsciiFile' object",
	MenuTypeCommand, (void *) &DescribeParam__AsciiFile_NoHeader_Rem_Call_Struct, 0, 0, HelpTextList_74, "files"},
	{0}
};

MenuLine AsciiFileVariableMenuMenuLine[] = {
	{"Hex",
	"Changeable variable `Hex' of `AsciiFile' object",
	MenuTypeCommand, (void *) &DescribeParam__AsciiFile_Hex_Rem_Call_Struct, 0, 0, HelpTextList_75, "files"},
	{0}
};

MenuLine AsciiFileInstanceParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `AsciiFile' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__AsciiFile_STACK_FileName_Rem_Call_Struct, 0, 0, HelpTextList_76, "files"},
	{"Hex",
	"Parameter `Hex' of `AsciiFile' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__AsciiFile_STACK_Hex_Rem_Call_Struct, 0, 0, HelpTextList_77, "files"},
	{"NoGroup",
	"Parameter `NoGroup' of `AsciiFile' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__AsciiFile_STACK_NoGroup_Rem_Call_Struct, 0, 0, HelpTextList_78, "files"},
	{"NoHeader",
	"Parameter `NoHeader' of `AsciiFile' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__AsciiFile_STACK_NoHeader_Rem_Call_Struct, 0, 0, HelpTextList_79, "files"},
	{0}
};

MenuLine AsciiFileInstanceVariableMenuMenuLine[] = {
	{"Hex",
	"Changeable variable `Hex' of `AsciiFile' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__AsciiFile_STACK_Hex_Rem_Call_Struct, 0, 0, HelpTextList_80, "files"},
	{0}
};

MenuLine AsciiFileSetInstanceVariableMenuMenuLine[] = {
	{"set Hex",
	"Change value of variable `Hex' for an instance of `AsciiFile'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__AsciiFile_STACK_Hex_Rem_Call_Struct, 0, 0, HelpTextList_81, "files"},
	{0}
};

MenuLine BlockNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Block'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_BlockMainHelpDefinition, "block"},
	{"param",
	"Parameters of `Block'",
	MenuTypeMenu, (void *) &BlockParamMenu, 0, 0, HelpTextList_NodeParamHelp, "block"},
	{"members",
	"Members of `Block'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "block"},
	{"instance",
	"Describe or delete an instance of `Block'",
	MenuTypeMenu, (void *) &BlockInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "block"},
	{"create default",
	"Create instance of `Block' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Block_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "block"},
	{"create",
	"Create instance of `Block'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Block_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "block"},
	{0}
};

MenuLine BlockInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Block'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Block_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "block"},
	{"param",
	"Describe parameters of this `Block'",
	MenuTypeMenu, (void *) &BlockInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "block"},
	{"exec",
	"Select a member of `Block' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "block"},
	{"delete",
	"Delete this `Block'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Block_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "block"},
	{0}
};

MenuLine BlockParamMenuMenuLine[] = {
	{"ElementSize",
	"Parameter `ElementSize' of `Block' object",
	MenuTypeCommand, (void *) &DescribeParam__Block_ElementSize_Rem_Call_Struct, 0, 0, HelpTextList_82, "block"},
	{"BlockSize",
	"Parameter `BlockSize' of `Block' object",
	MenuTypeCommand, (void *) &DescribeParam__Block_BlockSize_Rem_Call_Struct, 0, 0, HelpTextList_83, "block"},
	{"OutputArithmetic",
	"Parameter `OutputArithmetic' of `Block' object",
	MenuTypeCommand, (void *) &DescribeParam__Block_OutputArithmetic_Rem_Call_Struct, 0, 0, HelpTextList_84, "block"},
	{0}
};

MenuLine BlockInstanceParamMenuMenuLine[] = {
	{"ElementSize",
	"Parameter `ElementSize' of `Block' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Block_STACK_ElementSize_Rem_Call_Struct, 0, 0, HelpTextList_85, "block"},
	{"BlockSize",
	"Parameter `BlockSize' of `Block' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Block_STACK_BlockSize_Rem_Call_Struct, 0, 0, HelpTextList_86, "block"},
	{"OutputArithmetic",
	"Parameter `OutputArithmetic' of `Block' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Block_STACK_OutputArithmetic_Rem_Call_Struct, 0, 0, HelpTextList_87, "block"},
	{0}
};

MenuLine CircBufDesNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `CircBufDes'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_CircBufDesMainHelpDefinition, "buf"},
	{"param",
	"Parameters of `CircBufDes'",
	MenuTypeMenu, (void *) &CircBufDesParamMenu, 0, 0, HelpTextList_NodeParamHelp, "buf"},
	{"variables",
	"Changeable variables of `CircBufDes'",
	MenuTypeMenu, (void *) &CircBufDesVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "buf"},
	{"members",
	"Members of `CircBufDes'",
	MenuTypeMenu, (void *) &SelectCircBufDesMemberDescribe, 0, 0, HelpTextList_MemberMenuHelp, "buf"},
	{"instance",
	"Describe or delete an instance of `CircBufDes'",
	MenuTypeMenu, (void *) &CircBufDesInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "buf"},
	{"create default",
	"Create instance of `CircBufDes' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__CircBufDes_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "buf"},
	{"create",
	"Create instance of `CircBufDes'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__CircBufDes_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "buf"},
	{0}
};

MenuLine SelectCircBufDesMemberDescribeMenuLine[] = {
	{"AssignToEdit",
	"Describe member `AssignToEdit' of `CircBufDes'",
	MenuTypeMenu, (void *) &AssignToEditCircBufDesNodeMemberMenu, 0, 0, HelpTextList_88, "buf"},
	{0}
};

MenuLine AssignToEditCircBufDesNodeMemberMenuMenuLine[] = {
	{"desc AssignToEdit",
	"Describe selected member of `CircBufDes'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__CircBufDes_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "buf"},
	{0}
};

MenuLine CircBufDesInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `CircBufDes'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__CircBufDes_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "buf"},
	{"param",
	"Describe parameters of this `CircBufDes'",
	MenuTypeMenu, (void *) &CircBufDesInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "buf"},
	{"exec",
	"Select a member of `CircBufDes' to execute",
	MenuTypeMenu, (void *) &SelectCircBufDesMemberExecute, 0, 0, HelpTextList_HelpMemberExecute, "buf"},
	{"variables",
	"Describe variables of this `CircBufDes'",
	MenuTypeMenu, (void *) &CircBufDesInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "buf"},
	{"set",
	"Set variable values of this `CircBufDes'",
	MenuTypeMenu, (void *) &CircBufDesSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "buf"},
	{"delete",
	"Delete this `CircBufDes'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__CircBufDes_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "buf"},
	{0}
};

MenuLine SelectCircBufDesMemberExecuteMenuLine[] = {
	{"AssignToEdit",
	"Execute selected member of `CircBufDes'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_AssignToEdit_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "buf"},
	{0}
};

MenuLine CircBufDesParamMenuMenuLine[] = {
	{"Size",
	"Parameter `Size' of `CircBufDes' object",
	MenuTypeCommand, (void *) &DescribeParam__CircBufDes_Size_Rem_Call_Struct, 0, 0, HelpTextList_89, "buf"},
	{"TargetSize",
	"Parameter `TargetSize' of `CircBufDes' object",
	MenuTypeCommand, (void *) &DescribeParam__CircBufDes_TargetSize_Rem_Call_Struct, 0, 0, HelpTextList_90, "buf"},
	{"TargetSizeGoal",
	"Parameter `TargetSizeGoal' of `CircBufDes' object",
	MenuTypeCommand, (void *) &DescribeParam__CircBufDes_TargetSizeGoal_Rem_Call_Struct, 0, 0, HelpTextList_91, "buf"},
	{"TargetControlGoal",
	"Parameter `TargetControlGoal' of `CircBufDes' object",
	MenuTypeCommand, (void *) &DescribeParam__CircBufDes_TargetControlGoal_Rem_Call_Struct, 0, 0, HelpTextList_92, "buf"},
	{"MaxTargetSize",
	"Parameter `MaxTargetSize' of `CircBufDes' object",
	MenuTypeCommand, (void *) &DescribeParam__CircBufDes_MaxTargetSize_Rem_Call_Struct, 0, 0, HelpTextList_93, "buf"},
	{"MinTargetSize",
	"Parameter `MinTargetSize' of `CircBufDes' object",
	MenuTypeCommand, (void *) &DescribeParam__CircBufDes_MinTargetSize_Rem_Call_Struct, 0, 0, HelpTextList_94, "buf"},
	{0}
};

MenuLine CircBufDesVariableMenuMenuLine[] = {
	{"TargetSize",
	"Changeable variable `TargetSize' of `CircBufDes' object",
	MenuTypeCommand, (void *) &DescribeParam__CircBufDes_TargetSize_Rem_Call_Struct, 0, 0, HelpTextList_95, "buf"},
	{"TargetSizeGoal",
	"Changeable variable `TargetSizeGoal' of `CircBufDes' object",
	MenuTypeCommand, (void *) &DescribeParam__CircBufDes_TargetSizeGoal_Rem_Call_Struct, 0, 0, HelpTextList_96, "buf"},
	{"TargetControlGoal",
	"Changeable variable `TargetControlGoal' of `CircBufDes' object",
	MenuTypeCommand, (void *) &DescribeParam__CircBufDes_TargetControlGoal_Rem_Call_Struct, 0, 0, HelpTextList_97, "buf"},
	{"MaxTargetSize",
	"Changeable variable `MaxTargetSize' of `CircBufDes' object",
	MenuTypeCommand, (void *) &DescribeParam__CircBufDes_MaxTargetSize_Rem_Call_Struct, 0, 0, HelpTextList_98, "buf"},
	{"MinTargetSize",
	"Changeable variable `MinTargetSize' of `CircBufDes' object",
	MenuTypeCommand, (void *) &DescribeParam__CircBufDes_MinTargetSize_Rem_Call_Struct, 0, 0, HelpTextList_99, "buf"},
	{0}
};

MenuLine CircBufDesInstanceParamMenuMenuLine[] = {
	{"Size",
	"Parameter `Size' of `CircBufDes' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CircBufDes_STACK_Size_Rem_Call_Struct, 0, 0, HelpTextList_100, "buf"},
	{"TargetSize",
	"Parameter `TargetSize' of `CircBufDes' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CircBufDes_STACK_TargetSize_Rem_Call_Struct, 0, 0, HelpTextList_101, "buf"},
	{"TargetSizeGoal",
	"Parameter `TargetSizeGoal' of `CircBufDes' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CircBufDes_STACK_TargetSizeGoal_Rem_Call_Struct, 0, 0, HelpTextList_102, "buf"},
	{"TargetControlGoal",
	"Parameter `TargetControlGoal' of `CircBufDes' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CircBufDes_STACK_TargetControlGoal_Rem_Call_Struct, 0, 0, HelpTextList_103, "buf"},
	{"MaxTargetSize",
	"Parameter `MaxTargetSize' of `CircBufDes' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CircBufDes_STACK_MaxTargetSize_Rem_Call_Struct, 0, 0, HelpTextList_104, "buf"},
	{"MinTargetSize",
	"Parameter `MinTargetSize' of `CircBufDes' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CircBufDes_STACK_MinTargetSize_Rem_Call_Struct, 0, 0, HelpTextList_105, "buf"},
	{0}
};

MenuLine CircBufDesInstanceVariableMenuMenuLine[] = {
	{"TargetSize",
	"Changeable variable `TargetSize' of `CircBufDes' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CircBufDes_STACK_TargetSize_Rem_Call_Struct, 0, 0, HelpTextList_106, "buf"},
	{"TargetSizeGoal",
	"Changeable variable `TargetSizeGoal' of `CircBufDes' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CircBufDes_STACK_TargetSizeGoal_Rem_Call_Struct, 0, 0, HelpTextList_107, "buf"},
	{"TargetControlGoal",
	"Changeable variable `TargetControlGoal' of `CircBufDes' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CircBufDes_STACK_TargetControlGoal_Rem_Call_Struct, 0, 0, HelpTextList_108, "buf"},
	{"MaxTargetSize",
	"Changeable variable `MaxTargetSize' of `CircBufDes' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CircBufDes_STACK_MaxTargetSize_Rem_Call_Struct, 0, 0, HelpTextList_109, "buf"},
	{"MinTargetSize",
	"Changeable variable `MinTargetSize' of `CircBufDes' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CircBufDes_STACK_MinTargetSize_Rem_Call_Struct, 0, 0, HelpTextList_110, "buf"},
	{0}
};

MenuLine CircBufDesSetInstanceVariableMenuMenuLine[] = {
	{"set TargetSize",
	"Change value of variable `TargetSize' for an instance of `CircBufDes'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__CircBufDes_STACK_TargetSize_Rem_Call_Struct, 0, 0, HelpTextList_111, "buf"},
	{"set TargetSizeGoal",
	"Change value of variable `TargetSizeGoal' for an instance of `CircBufDes'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__CircBufDes_STACK_TargetSizeGoal_Rem_Call_Struct, 0, 0, HelpTextList_112, "buf"},
	{"set TargetControlGoal",
	"Change value of variable `TargetControlGoal' for an instance of `CircBufDes'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__CircBufDes_STACK_TargetControlGoal_Rem_Call_Struct, 0, 0, HelpTextList_113, "buf"},
	{"set MaxTargetSize",
	"Change value of variable `MaxTargetSize' for an instance of `CircBufDes'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__CircBufDes_STACK_MaxTargetSize_Rem_Call_Struct, 0, 0, HelpTextList_114, "buf"},
	{"set MinTargetSize",
	"Change value of variable `MinTargetSize' for an instance of `CircBufDes'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__CircBufDes_STACK_MinTargetSize_Rem_Call_Struct, 0, 0, HelpTextList_115, "buf"},
	{0}
};

MenuLine CompareDiskNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `CompareDisk'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_CompareDiskMainHelpDefinition, "valid"},
	{"param",
	"Parameters of `CompareDisk'",
	MenuTypeMenu, (void *) &CompareDiskParamMenu, 0, 0, HelpTextList_NodeParamHelp, "valid"},
	{"members",
	"Members of `CompareDisk'",
	MenuTypeMenu, (void *) &SelectCompareDiskMemberDescribe, 0, 0, HelpTextList_MemberMenuHelp, "valid"},
	{"instance",
	"Describe or delete an instance of `CompareDisk'",
	MenuTypeMenu, (void *) &CompareDiskInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "valid"},
	{"create default",
	"Create instance of `CompareDisk' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__CompareDisk_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "valid"},
	{"create",
	"Create instance of `CompareDisk'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__CompareDisk_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "valid"},
	{0}
};

MenuLine SelectCompareDiskMemberDescribeMenuLine[] = {
	{"DisplayHeader",
	"Describe member `DisplayHeader' of `CompareDisk'",
	MenuTypeMenu, (void *) &DisplayHeaderCompareDiskNodeMemberMenu, 0, 0, HelpTextList_116, "valid"},
	{"IgnoreHeaderCount",
	"Describe member `IgnoreHeaderCount' of `CompareDisk'",
	MenuTypeMenu, (void *) &IgnoreHeaderCountCompareDiskNodeMemberMenu, 0, 0, HelpTextList_117, "valid"},
	{0}
};

MenuLine DisplayHeaderCompareDiskNodeMemberMenuMenuLine[] = {
	{"desc DisplayHeader",
	"Describe selected member of `CompareDisk'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__CompareDisk_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "valid"},
	{0}
};

MenuLine IgnoreHeaderCountCompareDiskNodeMemberMenuMenuLine[] = {
	{"desc IgnoreHeaderCount",
	"Describe selected member of `CompareDisk'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__CompareDisk_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "valid"},
	{0}
};

MenuLine CompareDiskInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `CompareDisk'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__CompareDisk_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "valid"},
	{"param",
	"Describe parameters of this `CompareDisk'",
	MenuTypeMenu, (void *) &CompareDiskInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "valid"},
	{"exec",
	"Select a member of `CompareDisk' to execute",
	MenuTypeMenu, (void *) &SelectCompareDiskMemberExecute, 0, 0, HelpTextList_HelpMemberExecute, "valid"},
	{"delete",
	"Delete this `CompareDisk'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__CompareDisk_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "valid"},
	{0}
};

MenuLine SelectCompareDiskMemberExecuteMenuLine[] = {
	{"DisplayHeader",
	"Execute selected member of `CompareDisk'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_DisplayHeader_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "valid"},
	{"IgnoreHeaderCount",
	"Execute selected member of `CompareDisk'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_IgnoreHeaderCount_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "valid"},
	{0}
};

MenuLine CompareDiskParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `CompareDisk' object",
	MenuTypeCommand, (void *) &DescribeParam__CompareDisk_FileName_Rem_Call_Struct, 0, 0, HelpTextList_118, "valid"},
	{"MaxReport",
	"Parameter `MaxReport' of `CompareDisk' object",
	MenuTypeCommand, (void *) &DescribeParam__CompareDisk_MaxReport_Rem_Call_Struct, 0, 0, HelpTextList_119, "valid"},
	{"Tolerance",
	"Parameter `Tolerance' of `CompareDisk' object",
	MenuTypeCommand, (void *) &DescribeParam__CompareDisk_Tolerance_Rem_Call_Struct, 0, 0, HelpTextList_120, "valid"},
	{"ErrorFile",
	"Parameter `ErrorFile' of `CompareDisk' object",
	MenuTypeCommand, (void *) &DescribeParam__CompareDisk_ErrorFile_Rem_Call_Struct, 0, 0, HelpTextList_121, "valid"},
	{0}
};

MenuLine CompareDiskInstanceParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `CompareDisk' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CompareDisk_STACK_FileName_Rem_Call_Struct, 0, 0, HelpTextList_122, "valid"},
	{"MaxReport",
	"Parameter `MaxReport' of `CompareDisk' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CompareDisk_STACK_MaxReport_Rem_Call_Struct, 0, 0, HelpTextList_123, "valid"},
	{"Tolerance",
	"Parameter `Tolerance' of `CompareDisk' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CompareDisk_STACK_Tolerance_Rem_Call_Struct, 0, 0, HelpTextList_124, "valid"},
	{"ErrorFile",
	"Parameter `ErrorFile' of `CompareDisk' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CompareDisk_STACK_ErrorFile_Rem_Call_Struct, 0, 0, HelpTextList_125, "valid"},
	{0}
};

MenuLine ConstantDataNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `ConstantData'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_ConstantDataMainHelpDefinition, "signalT"},
	{"param",
	"Parameters of `ConstantData'",
	MenuTypeMenu, (void *) &ConstantDataParamMenu, 0, 0, HelpTextList_NodeParamHelp, "signalT"},
	{"variables",
	"Changeable variables of `ConstantData'",
	MenuTypeMenu, (void *) &ConstantDataVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "signalT"},
	{"members",
	"Members of `ConstantData'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "signalT"},
	{"instance",
	"Describe or delete an instance of `ConstantData'",
	MenuTypeMenu, (void *) &ConstantDataInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "signalT"},
	{"create default",
	"Create instance of `ConstantData' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__ConstantData_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "signalT"},
	{"create",
	"Create instance of `ConstantData'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__ConstantData_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "signalT"},
	{0}
};

MenuLine ConstantDataInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `ConstantData'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__ConstantData_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "signalT"},
	{"param",
	"Describe parameters of this `ConstantData'",
	MenuTypeMenu, (void *) &ConstantDataInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "signalT"},
	{"exec",
	"Select a member of `ConstantData' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "signalT"},
	{"variables",
	"Describe variables of this `ConstantData'",
	MenuTypeMenu, (void *) &ConstantDataInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "signalT"},
	{"set",
	"Set variable values of this `ConstantData'",
	MenuTypeMenu, (void *) &ConstantDataSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "signalT"},
	{"delete",
	"Delete this `ConstantData'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__ConstantData_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "signalT"},
	{0}
};

MenuLine ConstantDataParamMenuMenuLine[] = {
	{"Value",
	"Parameter `Value' of `ConstantData' object",
	MenuTypeCommand, (void *) &DescribeParam__ConstantData_Value_Rem_Call_Struct, 0, 0, HelpTextList_126, "signalT"},
	{0}
};

MenuLine ConstantDataVariableMenuMenuLine[] = {
	{"Value",
	"Changeable variable `Value' of `ConstantData' object",
	MenuTypeCommand, (void *) &DescribeParam__ConstantData_Value_Rem_Call_Struct, 0, 0, HelpTextList_127, "signalT"},
	{0}
};

MenuLine ConstantDataInstanceParamMenuMenuLine[] = {
	{"Value",
	"Parameter `Value' of `ConstantData' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ConstantData_STACK_Value_Rem_Call_Struct, 0, 0, HelpTextList_128, "signalT"},
	{0}
};

MenuLine ConstantDataInstanceVariableMenuMenuLine[] = {
	{"Value",
	"Changeable variable `Value' of `ConstantData' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ConstantData_STACK_Value_Rem_Call_Struct, 0, 0, HelpTextList_129, "signalT"},
	{0}
};

MenuLine ConstantDataSetInstanceVariableMenuMenuLine[] = {
	{"set Value",
	"Change value of variable `Value' for an instance of `ConstantData'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__ConstantData_STACK_Value_Rem_Call_Struct, 0, 0, HelpTextList_130, "signalT"},
	{0}
};

MenuLine CosNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Cos'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_CosMainHelpDefinition, "signalT"},
	{"param",
	"Parameters of `Cos'",
	MenuTypeMenu, (void *) &CosParamMenu, 0, 0, HelpTextList_NodeParamHelp, "signalT"},
	{"variables",
	"Changeable variables of `Cos'",
	MenuTypeMenu, (void *) &CosVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "signalT"},
	{"members",
	"Members of `Cos'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "signalT"},
	{"instance",
	"Describe or delete an instance of `Cos'",
	MenuTypeMenu, (void *) &CosInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "signalT"},
	{"create default",
	"Create instance of `Cos' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Cos_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "signalT"},
	{"create",
	"Create instance of `Cos'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Cos_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "signalT"},
	{0}
};

MenuLine CosInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Cos'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Cos_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "signalT"},
	{"param",
	"Describe parameters of this `Cos'",
	MenuTypeMenu, (void *) &CosInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "signalT"},
	{"exec",
	"Select a member of `Cos' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "signalT"},
	{"variables",
	"Describe variables of this `Cos'",
	MenuTypeMenu, (void *) &CosInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "signalT"},
	{"set",
	"Set variable values of this `Cos'",
	MenuTypeMenu, (void *) &CosSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "signalT"},
	{"delete",
	"Delete this `Cos'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Cos_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "signalT"},
	{0}
};

MenuLine CosParamMenuMenuLine[] = {
	{"Frequency",
	"Parameter `Frequency' of `Cos' object",
	MenuTypeCommand, (void *) &DescribeParam__Cos_Frequency_Rem_Call_Struct, 0, 0, HelpTextList_131, "signalT"},
	{"Phase",
	"Parameter `Phase' of `Cos' object",
	MenuTypeCommand, (void *) &DescribeParam__Cos_Phase_Rem_Call_Struct, 0, 0, HelpTextList_132, "signalT"},
	{"Amplitude",
	"Parameter `Amplitude' of `Cos' object",
	MenuTypeCommand, (void *) &DescribeParam__Cos_Amplitude_Rem_Call_Struct, 0, 0, HelpTextList_133, "signalT"},
	{0}
};

MenuLine CosVariableMenuMenuLine[] = {
	{"Frequency",
	"Changeable variable `Frequency' of `Cos' object",
	MenuTypeCommand, (void *) &DescribeParam__Cos_Frequency_Rem_Call_Struct, 0, 0, HelpTextList_134, "signalT"},
	{"Phase",
	"Changeable variable `Phase' of `Cos' object",
	MenuTypeCommand, (void *) &DescribeParam__Cos_Phase_Rem_Call_Struct, 0, 0, HelpTextList_135, "signalT"},
	{"Amplitude",
	"Changeable variable `Amplitude' of `Cos' object",
	MenuTypeCommand, (void *) &DescribeParam__Cos_Amplitude_Rem_Call_Struct, 0, 0, HelpTextList_136, "signalT"},
	{0}
};

MenuLine CosInstanceParamMenuMenuLine[] = {
	{"Frequency",
	"Parameter `Frequency' of `Cos' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Cos_STACK_Frequency_Rem_Call_Struct, 0, 0, HelpTextList_137, "signalT"},
	{"Phase",
	"Parameter `Phase' of `Cos' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Cos_STACK_Phase_Rem_Call_Struct, 0, 0, HelpTextList_138, "signalT"},
	{"Amplitude",
	"Parameter `Amplitude' of `Cos' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Cos_STACK_Amplitude_Rem_Call_Struct, 0, 0, HelpTextList_139, "signalT"},
	{0}
};

MenuLine CosInstanceVariableMenuMenuLine[] = {
	{"Frequency",
	"Changeable variable `Frequency' of `Cos' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Cos_STACK_Frequency_Rem_Call_Struct, 0, 0, HelpTextList_140, "signalT"},
	{"Phase",
	"Changeable variable `Phase' of `Cos' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Cos_STACK_Phase_Rem_Call_Struct, 0, 0, HelpTextList_141, "signalT"},
	{"Amplitude",
	"Changeable variable `Amplitude' of `Cos' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Cos_STACK_Amplitude_Rem_Call_Struct, 0, 0, HelpTextList_142, "signalT"},
	{0}
};

MenuLine CosSetInstanceVariableMenuMenuLine[] = {
	{"set Frequency",
	"Change value of variable `Frequency' for an instance of `Cos'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Cos_STACK_Frequency_Rem_Call_Struct, 0, 0, HelpTextList_143, "signalT"},
	{"set Phase",
	"Change value of variable `Phase' for an instance of `Cos'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Cos_STACK_Phase_Rem_Call_Struct, 0, 0, HelpTextList_144, "signalT"},
	{"set Amplitude",
	"Change value of variable `Amplitude' for an instance of `Cos'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Cos_STACK_Amplitude_Rem_Call_Struct, 0, 0, HelpTextList_145, "signalT"},
	{0}
};

MenuLine CxCosNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `CxCos'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_CxCosMainHelpDefinition, "signalT"},
	{"param",
	"Parameters of `CxCos'",
	MenuTypeMenu, (void *) &CxCosParamMenu, 0, 0, HelpTextList_NodeParamHelp, "signalT"},
	{"variables",
	"Changeable variables of `CxCos'",
	MenuTypeMenu, (void *) &CxCosVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "signalT"},
	{"members",
	"Members of `CxCos'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "signalT"},
	{"instance",
	"Describe or delete an instance of `CxCos'",
	MenuTypeMenu, (void *) &CxCosInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "signalT"},
	{"create default",
	"Create instance of `CxCos' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__CxCos_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "signalT"},
	{"create",
	"Create instance of `CxCos'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__CxCos_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "signalT"},
	{0}
};

MenuLine CxCosInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `CxCos'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__CxCos_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "signalT"},
	{"param",
	"Describe parameters of this `CxCos'",
	MenuTypeMenu, (void *) &CxCosInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "signalT"},
	{"exec",
	"Select a member of `CxCos' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "signalT"},
	{"variables",
	"Describe variables of this `CxCos'",
	MenuTypeMenu, (void *) &CxCosInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "signalT"},
	{"set",
	"Set variable values of this `CxCos'",
	MenuTypeMenu, (void *) &CxCosSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "signalT"},
	{"delete",
	"Delete this `CxCos'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__CxCos_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "signalT"},
	{0}
};

MenuLine CxCosParamMenuMenuLine[] = {
	{"Frequency",
	"Parameter `Frequency' of `CxCos' object",
	MenuTypeCommand, (void *) &DescribeParam__CxCos_Frequency_Rem_Call_Struct, 0, 0, HelpTextList_146, "signalT"},
	{"Phase",
	"Parameter `Phase' of `CxCos' object",
	MenuTypeCommand, (void *) &DescribeParam__CxCos_Phase_Rem_Call_Struct, 0, 0, HelpTextList_147, "signalT"},
	{"Amplitude",
	"Parameter `Amplitude' of `CxCos' object",
	MenuTypeCommand, (void *) &DescribeParam__CxCos_Amplitude_Rem_Call_Struct, 0, 0, HelpTextList_148, "signalT"},
	{0}
};

MenuLine CxCosVariableMenuMenuLine[] = {
	{"Frequency",
	"Changeable variable `Frequency' of `CxCos' object",
	MenuTypeCommand, (void *) &DescribeParam__CxCos_Frequency_Rem_Call_Struct, 0, 0, HelpTextList_149, "signalT"},
	{"Phase",
	"Changeable variable `Phase' of `CxCos' object",
	MenuTypeCommand, (void *) &DescribeParam__CxCos_Phase_Rem_Call_Struct, 0, 0, HelpTextList_150, "signalT"},
	{"Amplitude",
	"Changeable variable `Amplitude' of `CxCos' object",
	MenuTypeCommand, (void *) &DescribeParam__CxCos_Amplitude_Rem_Call_Struct, 0, 0, HelpTextList_151, "signalT"},
	{0}
};

MenuLine CxCosInstanceParamMenuMenuLine[] = {
	{"Frequency",
	"Parameter `Frequency' of `CxCos' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxCos_STACK_Frequency_Rem_Call_Struct, 0, 0, HelpTextList_152, "signalT"},
	{"Phase",
	"Parameter `Phase' of `CxCos' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxCos_STACK_Phase_Rem_Call_Struct, 0, 0, HelpTextList_153, "signalT"},
	{"Amplitude",
	"Parameter `Amplitude' of `CxCos' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxCos_STACK_Amplitude_Rem_Call_Struct, 0, 0, HelpTextList_154, "signalT"},
	{0}
};

MenuLine CxCosInstanceVariableMenuMenuLine[] = {
	{"Frequency",
	"Changeable variable `Frequency' of `CxCos' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxCos_STACK_Frequency_Rem_Call_Struct, 0, 0, HelpTextList_155, "signalT"},
	{"Phase",
	"Changeable variable `Phase' of `CxCos' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxCos_STACK_Phase_Rem_Call_Struct, 0, 0, HelpTextList_156, "signalT"},
	{"Amplitude",
	"Changeable variable `Amplitude' of `CxCos' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxCos_STACK_Amplitude_Rem_Call_Struct, 0, 0, HelpTextList_157, "signalT"},
	{0}
};

MenuLine CxCosSetInstanceVariableMenuMenuLine[] = {
	{"set Frequency",
	"Change value of variable `Frequency' for an instance of `CxCos'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__CxCos_STACK_Frequency_Rem_Call_Struct, 0, 0, HelpTextList_158, "signalT"},
	{"set Phase",
	"Change value of variable `Phase' for an instance of `CxCos'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__CxCos_STACK_Phase_Rem_Call_Struct, 0, 0, HelpTextList_159, "signalT"},
	{"set Amplitude",
	"Change value of variable `Amplitude' for an instance of `CxCos'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__CxCos_STACK_Amplitude_Rem_Call_Struct, 0, 0, HelpTextList_160, "signalT"},
	{0}
};

MenuLine CxFFTNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `CxFFT'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_CxFFTMainHelpDefinition, "cxfft"},
	{"param",
	"Parameters of `CxFFT'",
	MenuTypeMenu, (void *) &CxFFTParamMenu, 0, 0, HelpTextList_NodeParamHelp, "cxfft"},
	{"variables",
	"Changeable variables of `CxFFT'",
	MenuTypeMenu, (void *) &CxFFTVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "cxfft"},
	{"members",
	"Members of `CxFFT'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "cxfft"},
	{"instance",
	"Describe or delete an instance of `CxFFT'",
	MenuTypeMenu, (void *) &CxFFTInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "cxfft"},
	{"create default",
	"Create instance of `CxFFT' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__CxFFT_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "cxfft"},
	{"create",
	"Create instance of `CxFFT'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__CxFFT_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "cxfft"},
	{0}
};

MenuLine CxFFTInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `CxFFT'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__CxFFT_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "cxfft"},
	{"param",
	"Describe parameters of this `CxFFT'",
	MenuTypeMenu, (void *) &CxFFTInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "cxfft"},
	{"exec",
	"Select a member of `CxFFT' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "cxfft"},
	{"variables",
	"Describe variables of this `CxFFT'",
	MenuTypeMenu, (void *) &CxFFTInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "cxfft"},
	{"set",
	"Set variable values of this `CxFFT'",
	MenuTypeMenu, (void *) &CxFFTSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "cxfft"},
	{"delete",
	"Delete this `CxFFT'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__CxFFT_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "cxfft"},
	{0}
};

MenuLine CxFFTParamMenuMenuLine[] = {
	{"LogSize",
	"Parameter `LogSize' of `CxFFT' object",
	MenuTypeCommand, (void *) &DescribeParam__CxFFT_LogSize_Rem_Call_Struct, 0, 0, HelpTextList_161, "cxfft"},
	{"Overlap",
	"Parameter `Overlap' of `CxFFT' object",
	MenuTypeCommand, (void *) &DescribeParam__CxFFT_Overlap_Rem_Call_Struct, 0, 0, HelpTextList_162, "cxfft"},
	{"CenterFrequency",
	"Parameter `CenterFrequency' of `CxFFT' object",
	MenuTypeCommand, (void *) &DescribeParam__CxFFT_CenterFrequency_Rem_Call_Struct, 0, 0, HelpTextList_163, "cxfft"},
	{"InverseFlag",
	"Parameter `InverseFlag' of `CxFFT' object",
	MenuTypeCommand, (void *) &DescribeParam__CxFFT_InverseFlag_Rem_Call_Struct, 0, 0, HelpTextList_164, "cxfft"},
	{0}
};

MenuLine CxFFTVariableMenuMenuLine[] = {
	{"CenterFrequency",
	"Changeable variable `CenterFrequency' of `CxFFT' object",
	MenuTypeCommand, (void *) &DescribeParam__CxFFT_CenterFrequency_Rem_Call_Struct, 0, 0, HelpTextList_165, "cxfft"},
	{0}
};

MenuLine CxFFTInstanceParamMenuMenuLine[] = {
	{"LogSize",
	"Parameter `LogSize' of `CxFFT' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxFFT_STACK_LogSize_Rem_Call_Struct, 0, 0, HelpTextList_166, "cxfft"},
	{"Overlap",
	"Parameter `Overlap' of `CxFFT' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxFFT_STACK_Overlap_Rem_Call_Struct, 0, 0, HelpTextList_167, "cxfft"},
	{"CenterFrequency",
	"Parameter `CenterFrequency' of `CxFFT' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxFFT_STACK_CenterFrequency_Rem_Call_Struct, 0, 0, HelpTextList_168, "cxfft"},
	{"InverseFlag",
	"Parameter `InverseFlag' of `CxFFT' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxFFT_STACK_InverseFlag_Rem_Call_Struct, 0, 0, HelpTextList_169, "cxfft"},
	{0}
};

MenuLine CxFFTInstanceVariableMenuMenuLine[] = {
	{"CenterFrequency",
	"Changeable variable `CenterFrequency' of `CxFFT' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxFFT_STACK_CenterFrequency_Rem_Call_Struct, 0, 0, HelpTextList_170, "cxfft"},
	{0}
};

MenuLine CxFFTSetInstanceVariableMenuMenuLine[] = {
	{"set CenterFrequency",
	"Change value of variable `CenterFrequency' for an instance of `CxFFT'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__CxFFT_STACK_CenterFrequency_Rem_Call_Struct, 0, 0, HelpTextList_171, "cxfft"},
	{0}
};

MenuLine CxFirNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `CxFir'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_CxFirMainHelpDefinition, "filters"},
	{"param",
	"Parameters of `CxFir'",
	MenuTypeMenu, (void *) &CxFirParamMenu, 0, 0, HelpTextList_NodeParamHelp, "filters"},
	{"members",
	"Members of `CxFir'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "filters"},
	{"instance",
	"Describe or delete an instance of `CxFir'",
	MenuTypeMenu, (void *) &CxFirInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "filters"},
	{"create default",
	"Create instance of `CxFir' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__CxFir_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "filters"},
	{"create",
	"Create instance of `CxFir'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__CxFir_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "filters"},
	{0}
};

MenuLine CxFirInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `CxFir'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__CxFir_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "filters"},
	{"param",
	"Describe parameters of this `CxFir'",
	MenuTypeMenu, (void *) &CxFirInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "filters"},
	{"exec",
	"Select a member of `CxFir' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "filters"},
	{"delete",
	"Delete this `CxFir'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__CxFir_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "filters"},
	{0}
};

MenuLine CxFirParamMenuMenuLine[] = {
	{"Resample",
	"Parameter `Resample' of `CxFir' object",
	MenuTypeCommand, (void *) &DescribeParam__CxFir_Resample_Rem_Call_Struct, 0, 0, HelpTextList_172, "filters"},
	{"ZeroPad",
	"Parameter `ZeroPad' of `CxFir' object",
	MenuTypeCommand, (void *) &DescribeParam__CxFir_ZeroPad_Rem_Call_Struct, 0, 0, HelpTextList_173, "filters"},
	{"DemodFreq",
	"Parameter `DemodFreq' of `CxFir' object",
	MenuTypeCommand, (void *) &DescribeParam__CxFir_DemodFreq_Rem_Call_Struct, 0, 0, HelpTextList_174, "filters"},
	{"Odd",
	"Parameter `Odd' of `CxFir' object",
	MenuTypeCommand, (void *) &DescribeParam__CxFir_Odd_Rem_Call_Struct, 0, 0, HelpTextList_175, "filters"},
	{"Coeff",
	"Parameter `Coeff' of `CxFir' object",
	MenuTypeCommand, (void *) &DescribeParam__CxFir_Coeff_Rem_Call_Struct, 0, 0, HelpTextList_176, "filters"},
	{0}
};

MenuLine CxFirInstanceParamMenuMenuLine[] = {
	{"Resample",
	"Parameter `Resample' of `CxFir' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxFir_STACK_Resample_Rem_Call_Struct, 0, 0, HelpTextList_177, "filters"},
	{"ZeroPad",
	"Parameter `ZeroPad' of `CxFir' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxFir_STACK_ZeroPad_Rem_Call_Struct, 0, 0, HelpTextList_178, "filters"},
	{"DemodFreq",
	"Parameter `DemodFreq' of `CxFir' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxFir_STACK_DemodFreq_Rem_Call_Struct, 0, 0, HelpTextList_179, "filters"},
	{"Odd",
	"Parameter `Odd' of `CxFir' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxFir_STACK_Odd_Rem_Call_Struct, 0, 0, HelpTextList_180, "filters"},
	{"Coeff",
	"Parameter `Coeff' of `CxFir' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxFir_STACK_Coeff_Rem_Call_Struct, 0, 0, HelpTextList_181, "filters"},
	{0}
};

MenuLine CxImpNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `CxImp'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_CxImpMainHelpDefinition, "signalT"},
	{"param",
	"Parameters of `CxImp'",
	MenuTypeMenu, (void *) &CxImpParamMenu, 0, 0, HelpTextList_NodeParamHelp, "signalT"},
	{"members",
	"Members of `CxImp'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "signalT"},
	{"instance",
	"Describe or delete an instance of `CxImp'",
	MenuTypeMenu, (void *) &CxImpInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "signalT"},
	{"create default",
	"Create instance of `CxImp' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__CxImp_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "signalT"},
	{"create",
	"Create instance of `CxImp'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__CxImp_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "signalT"},
	{0}
};

MenuLine CxImpInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `CxImp'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__CxImp_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "signalT"},
	{"param",
	"Describe parameters of this `CxImp'",
	MenuTypeMenu, (void *) &CxImpInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "signalT"},
	{"exec",
	"Select a member of `CxImp' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "signalT"},
	{"delete",
	"Delete this `CxImp'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__CxImp_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "signalT"},
	{0}
};

MenuLine CxImpParamMenuMenuLine[] = {
	{"Period",
	"Parameter `Period' of `CxImp' object",
	MenuTypeCommand, (void *) &DescribeParam__CxImp_Period_Rem_Call_Struct, 0, 0, HelpTextList_182, "signalT"},
	{"Phase",
	"Parameter `Phase' of `CxImp' object",
	MenuTypeCommand, (void *) &DescribeParam__CxImp_Phase_Rem_Call_Struct, 0, 0, HelpTextList_183, "signalT"},
	{"Amplitude",
	"Parameter `Amplitude' of `CxImp' object",
	MenuTypeCommand, (void *) &DescribeParam__CxImp_Amplitude_Rem_Call_Struct, 0, 0, HelpTextList_184, "signalT"},
	{"Width",
	"Parameter `Width' of `CxImp' object",
	MenuTypeCommand, (void *) &DescribeParam__CxImp_Width_Rem_Call_Struct, 0, 0, HelpTextList_185, "signalT"},
	{"Transition",
	"Parameter `Transition' of `CxImp' object",
	MenuTypeCommand, (void *) &DescribeParam__CxImp_Transition_Rem_Call_Struct, 0, 0, HelpTextList_186, "signalT"},
	{0}
};

MenuLine CxImpInstanceParamMenuMenuLine[] = {
	{"Period",
	"Parameter `Period' of `CxImp' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxImp_STACK_Period_Rem_Call_Struct, 0, 0, HelpTextList_187, "signalT"},
	{"Phase",
	"Parameter `Phase' of `CxImp' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxImp_STACK_Phase_Rem_Call_Struct, 0, 0, HelpTextList_188, "signalT"},
	{"Amplitude",
	"Parameter `Amplitude' of `CxImp' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxImp_STACK_Amplitude_Rem_Call_Struct, 0, 0, HelpTextList_189, "signalT"},
	{"Width",
	"Parameter `Width' of `CxImp' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxImp_STACK_Width_Rem_Call_Struct, 0, 0, HelpTextList_190, "signalT"},
	{"Transition",
	"Parameter `Transition' of `CxImp' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__CxImp_STACK_Transition_Rem_Call_Struct, 0, 0, HelpTextList_191, "signalT"},
	{0}
};

MenuLine DataFlowNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `DataFlow'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_DataFlowMainHelpDefinition, "net"},
	{"param",
	"Parameters of `DataFlow'",
	MenuTypeMenu, (void *) &DataFlowParamMenu, 0, 0, HelpTextList_NodeParamHelp, "net"},
	{"members",
	"Members of `DataFlow'",
	MenuTypeMenu, (void *) &SelectDataFlowMemberDescribe, 0, 0, HelpTextList_MemberMenuHelp, "net"},
	{"instance",
	"Describe or delete an instance of `DataFlow'",
	MenuTypeMenu, (void *) &DataFlowInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "net"},
	{"create",
	"Create instance of `DataFlow'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__DataFlow_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "net"},
	{0}
};

MenuLine SelectDataFlowMemberDescribeMenuLine[] = {
	{"GraphDisplay",
	"Describe member `GraphDisplay' of `DataFlow'",
	MenuTypeMenu, (void *) &GraphDisplayDataFlowNodeMemberMenu, 0, 0, HelpTextList_192, "graphd"},
	{"Execute",
	"Describe member `Execute' of `DataFlow'",
	MenuTypeMenu, (void *) &ExecuteDataFlowNodeMemberMenu, 0, 0, HelpTextList_193, "net_exe"},
	{"AssignBuffers",
	"Describe member `AssignBuffers' of `DataFlow'",
	MenuTypeMenu, (void *) &AssignBuffersDataFlowNodeMemberMenu, 0, 0, HelpTextList_194, "buf"},
	{"ClearBuffers",
	"Describe member `ClearBuffers' of `DataFlow'",
	MenuTypeMenu, (void *) &ClearBuffersDataFlowNodeMemberMenu, 0, 0, HelpTextList_195, "buf"},
	{"ClearNetwork",
	"Describe member `ClearNetwork' of `DataFlow'",
	MenuTypeMenu, (void *) &ClearNetworkDataFlowNodeMemberMenu, 0, 0, HelpTextList_196, "net_edit"},
	{0}
};

MenuLine GraphDisplayDataFlowNodeMemberMenuMenuLine[] = {
	{"desc GraphDisplay",
	"Describe selected member of `DataFlow'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__DataFlow_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "graphd"},
	{"param GraphDisplay",
	"Describe the parameters of member `GraphDisplay'",
	MenuTypeMenu, (void *) &DataFlowGraphDisplayMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "graphd"},
	{0}
};

MenuLine DataFlowGraphDisplayMemberParamMenuMenuLine[] = {
	{"Option",
	"Select this parameter of `DataFlow' member `GraphDisplay' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__DataFlow_STACK_Option_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "graphd"},
	{0}
};

MenuLine ExecuteDataFlowNodeMemberMenuMenuLine[] = {
	{"desc Execute",
	"Describe selected member of `DataFlow'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__DataFlow_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_exe"},
	{"param Execute",
	"Describe the parameters of member `Execute'",
	MenuTypeMenu, (void *) &DataFlowExecuteMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_exe"},
	{0}
};

MenuLine DataFlowExecuteMemberParamMenuMenuLine[] = {
	{"InputSamples",
	"Select this parameter of `DataFlow' member `Execute' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__DataFlow_STACK_InputSamples_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_exe"},
	{0}
};

MenuLine AssignBuffersDataFlowNodeMemberMenuMenuLine[] = {
	{"desc AssignBuffers",
	"Describe selected member of `DataFlow'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__DataFlow_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "buf"},
	{"param AssignBuffers",
	"Describe the parameters of member `AssignBuffers'",
	MenuTypeMenu, (void *) &DataFlowAssignBuffersMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "buf"},
	{0}
};

MenuLine DataFlowAssignBuffersMemberParamMenuMenuLine[] = {
	{"Descriptor",
	"Select this parameter of `DataFlow' member `AssignBuffers' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__DataFlow_STACK_Descriptor_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "buf"},
	{0}
};

MenuLine ClearBuffersDataFlowNodeMemberMenuMenuLine[] = {
	{"desc ClearBuffers",
	"Describe selected member of `DataFlow'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__DataFlow_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "buf"},
	{0}
};

MenuLine ClearNetworkDataFlowNodeMemberMenuMenuLine[] = {
	{"desc ClearNetwork",
	"Describe selected member of `DataFlow'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__DataFlow_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{0}
};

MenuLine DataFlowInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `DataFlow'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__DataFlow_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "net"},
	{"param",
	"Describe parameters of this `DataFlow'",
	MenuTypeMenu, (void *) &DataFlowInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "net"},
	{"exec",
	"Select a member of `DataFlow' to execute",
	MenuTypeMenu, (void *) &SelectDataFlowMemberExecute, 0, 0, HelpTextList_HelpMemberExecute, "net"},
	{"delete",
	"Delete this `DataFlow'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__DataFlow_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "net"},
	{0}
};

MenuLine SelectDataFlowMemberExecuteMenuLine[] = {
	{"GraphDisplay",
	"Execute selected member of `DataFlow'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_GraphDisplay_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "graphd"},
	{"Execute",
	"Execute selected member of `DataFlow'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_Execute_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_exe"},
	{"AssignBuffers",
	"Execute selected member of `DataFlow'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_AssignBuffers_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "buf"},
	{"ClearBuffers",
	"Execute selected member of `DataFlow'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_ClearBuffers_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "buf"},
	{"ClearNetwork",
	"Execute selected member of `DataFlow'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_ClearNetwork_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{0}
};

MenuLine DataFlowParamMenuMenuLine[] = {
	{"TheNet",
	"Parameter `TheNet' of `DataFlow' object",
	MenuTypeCommand, (void *) &DescribeParam__DataFlow_TheNet_Rem_Call_Struct, 0, 0, HelpTextList_197, "net"},
	{0}
};

MenuLine DataFlowInstanceParamMenuMenuLine[] = {
	{"TheNet",
	"Parameter `TheNet' of `DataFlow' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__DataFlow_STACK_TheNet_Rem_Call_Struct, 0, 0, HelpTextList_198, "net"},
	{0}
};

MenuLine DemodNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Demod'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_DemodMainHelpDefinition, "filters"},
	{"param",
	"Parameters of `Demod'",
	MenuTypeMenu, (void *) &DemodParamMenu, 0, 0, HelpTextList_NodeParamHelp, "filters"},
	{"variables",
	"Changeable variables of `Demod'",
	MenuTypeMenu, (void *) &DemodVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "filters"},
	{"members",
	"Members of `Demod'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "filters"},
	{"instance",
	"Describe or delete an instance of `Demod'",
	MenuTypeMenu, (void *) &DemodInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "filters"},
	{"create default",
	"Create instance of `Demod' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Demod_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "filters"},
	{"create",
	"Create instance of `Demod'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Demod_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "filters"},
	{0}
};

MenuLine DemodInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Demod'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Demod_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "filters"},
	{"param",
	"Describe parameters of this `Demod'",
	MenuTypeMenu, (void *) &DemodInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "filters"},
	{"exec",
	"Select a member of `Demod' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "filters"},
	{"variables",
	"Describe variables of this `Demod'",
	MenuTypeMenu, (void *) &DemodInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "filters"},
	{"set",
	"Set variable values of this `Demod'",
	MenuTypeMenu, (void *) &DemodSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "filters"},
	{"delete",
	"Delete this `Demod'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Demod_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "filters"},
	{0}
};

MenuLine DemodParamMenuMenuLine[] = {
	{"DataType",
	"Parameter `DataType' of `Demod' object",
	MenuTypeCommand, (void *) &DescribeParam__Demod_DataType_Rem_Call_Struct, 0, 0, HelpTextList_199, "filters"},
	{"DemodFreq",
	"Parameter `DemodFreq' of `Demod' object",
	MenuTypeCommand, (void *) &DescribeParam__Demod_DemodFreq_Rem_Call_Struct, 0, 0, HelpTextList_200, "filters"},
	{0}
};

MenuLine DemodVariableMenuMenuLine[] = {
	{"DemodFreq",
	"Changeable variable `DemodFreq' of `Demod' object",
	MenuTypeCommand, (void *) &DescribeParam__Demod_DemodFreq_Rem_Call_Struct, 0, 0, HelpTextList_201, "filters"},
	{0}
};

MenuLine DemodInstanceParamMenuMenuLine[] = {
	{"DataType",
	"Parameter `DataType' of `Demod' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Demod_STACK_DataType_Rem_Call_Struct, 0, 0, HelpTextList_202, "filters"},
	{"DemodFreq",
	"Parameter `DemodFreq' of `Demod' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Demod_STACK_DemodFreq_Rem_Call_Struct, 0, 0, HelpTextList_203, "filters"},
	{0}
};

MenuLine DemodInstanceVariableMenuMenuLine[] = {
	{"DemodFreq",
	"Changeable variable `DemodFreq' of `Demod' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Demod_STACK_DemodFreq_Rem_Call_Struct, 0, 0, HelpTextList_204, "filters"},
	{0}
};

MenuLine DemodSetInstanceVariableMenuMenuLine[] = {
	{"set DemodFreq",
	"Change value of variable `DemodFreq' for an instance of `Demod'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Demod_STACK_DemodFreq_Rem_Call_Struct, 0, 0, HelpTextList_205, "filters"},
	{0}
};

MenuLine DemuxNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Demux'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_DemuxMainHelpDefinition, "mux"},
	{"param",
	"Parameters of `Demux'",
	MenuTypeMenu, (void *) &DemuxParamMenu, 0, 0, HelpTextList_NodeParamHelp, "mux"},
	{"members",
	"Members of `Demux'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "mux"},
	{"instance",
	"Describe or delete an instance of `Demux'",
	MenuTypeMenu, (void *) &DemuxInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "mux"},
	{"create default",
	"Create instance of `Demux' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Demux_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "mux"},
	{"create",
	"Create instance of `Demux'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Demux_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "mux"},
	{0}
};

MenuLine DemuxInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Demux'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Demux_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "mux"},
	{"param",
	"Describe parameters of this `Demux'",
	MenuTypeMenu, (void *) &DemuxInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "mux"},
	{"exec",
	"Select a member of `Demux' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "mux"},
	{"delete",
	"Delete this `Demux'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Demux_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "mux"},
	{0}
};

MenuLine DemuxParamMenuMenuLine[] = {
	{"Channels",
	"Parameter `Channels' of `Demux' object",
	MenuTypeCommand, (void *) &DescribeParam__Demux_Channels_Rem_Call_Struct, 0, 0, HelpTextList_206, "mux"},
	{"InputSampleSize",
	"Parameter `InputSampleSize' of `Demux' object",
	MenuTypeCommand, (void *) &DescribeParam__Demux_InputSampleSize_Rem_Call_Struct, 0, 0, HelpTextList_207, "mux"},
	{"InputElementSize",
	"Parameter `InputElementSize' of `Demux' object",
	MenuTypeCommand, (void *) &DescribeParam__Demux_InputElementSize_Rem_Call_Struct, 0, 0, HelpTextList_208, "mux"},
	{"OutputElementSize",
	"Parameter `OutputElementSize' of `Demux' object",
	MenuTypeCommand, (void *) &DescribeParam__Demux_OutputElementSize_Rem_Call_Struct, 0, 0, HelpTextList_209, "mux"},
	{0}
};

MenuLine DemuxInstanceParamMenuMenuLine[] = {
	{"Channels",
	"Parameter `Channels' of `Demux' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Demux_STACK_Channels_Rem_Call_Struct, 0, 0, HelpTextList_210, "mux"},
	{"InputSampleSize",
	"Parameter `InputSampleSize' of `Demux' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Demux_STACK_InputSampleSize_Rem_Call_Struct, 0, 0, HelpTextList_211, "mux"},
	{"InputElementSize",
	"Parameter `InputElementSize' of `Demux' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Demux_STACK_InputElementSize_Rem_Call_Struct, 0, 0, HelpTextList_212, "mux"},
	{"OutputElementSize",
	"Parameter `OutputElementSize' of `Demux' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Demux_STACK_OutputElementSize_Rem_Call_Struct, 0, 0, HelpTextList_213, "mux"},
	{0}
};

MenuLine SelectDisplayNodeStrMemberDescribeMenuLine[] = {
	{"Raise",
	"Describe member `Raise' of `DisplayNodeStr'",
	MenuTypeMenu, (void *) &RaiseDisplayNodeStrNodeMemberMenu, 0, 0, HelpTextList_214, "mux"},
	{"DisplayInputTiming",
	"Describe member `DisplayInputTiming' of `DisplayNodeStr'",
	MenuTypeMenu, (void *) &DisplayInputTimingDisplayNodeStrNodeMemberMenu, 0, 0, HelpTextList_215, "mux"},
	{"Edit",
	"Describe member `Edit' of `DisplayNodeStr'",
	MenuTypeMenu, (void *) &EditDisplayNodeStrNodeMemberMenu, 0, 0, HelpTextList_216, "mux"},
	{"Unlink",
	"Describe member `Unlink' of `DisplayNodeStr'",
	MenuTypeMenu, (void *) &UnlinkDisplayNodeStrNodeMemberMenu, 0, 0, HelpTextList_217, "net_edit"},
	{"LinkIn",
	"Describe member `LinkIn' of `DisplayNodeStr'",
	MenuTypeMenu, (void *) &LinkInDisplayNodeStrNodeMemberMenu, 0, 0, HelpTextList_218, "net_edit"},
	{"NextFreeInput",
	"Describe member `NextFreeInput' of `DisplayNodeStr'",
	MenuTypeMenu, (void *) &NextFreeInputDisplayNodeStrNodeMemberMenu, 0, 0, HelpTextList_219, "net_edit"},
	{0}
};

MenuLine RaiseDisplayNodeStrNodeMemberMenuMenuLine[] = {
	{"desc Raise",
	"Describe selected member of `DisplayNodeStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__DisplayNodeStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "mux"},
	{0}
};

MenuLine DisplayInputTimingDisplayNodeStrNodeMemberMenuMenuLine[] = {
	{"desc DisplayInputTiming",
	"Describe selected member of `DisplayNodeStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__DisplayNodeStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "mux"},
	{"param DisplayInputTiming",
	"Describe the parameters of member `DisplayInputTiming'",
	MenuTypeMenu, (void *) &DisplayNodeStrDisplayInputTimingMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "mux"},
	{0}
};

MenuLine DisplayNodeStrDisplayInputTimingMemberParamMenuMenuLine[] = {
	{"Channel",
	"Select this parameter of `DisplayNodeStr' member `DisplayInputTiming' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__DisplayNodeStr_STACK_Channel_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "mux"},
	{0}
};

MenuLine EditDisplayNodeStrNodeMemberMenuMenuLine[] = {
	{"desc Edit",
	"Describe selected member of `DisplayNodeStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__DisplayNodeStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "mux"},
	{0}
};

MenuLine UnlinkDisplayNodeStrNodeMemberMenuMenuLine[] = {
	{"desc Unlink",
	"Describe selected member of `DisplayNodeStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__DisplayNodeStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{0}
};

MenuLine LinkInDisplayNodeStrNodeMemberMenuMenuLine[] = {
	{"desc LinkIn",
	"Describe selected member of `DisplayNodeStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__DisplayNodeStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{"param LinkIn",
	"Describe the parameters of member `LinkIn'",
	MenuTypeMenu, (void *) &DisplayNodeStrLinkInMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{0}
};

MenuLine DisplayNodeStrLinkInMemberParamMenuMenuLine[] = {
	{"Channel",
	"Select this parameter of `DisplayNodeStr' member `LinkIn' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__DisplayNodeStr_STACK_Channel_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{0}
};

MenuLine NextFreeInputDisplayNodeStrNodeMemberMenuMenuLine[] = {
	{"desc NextFreeInput",
	"Describe selected member of `DisplayNodeStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__DisplayNodeStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{0}
};

MenuLine SelectDisplayNodeStrMemberExecuteMenuLine[] = {
	{"Raise",
	"Execute selected member of `DisplayNodeStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_Raise_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "mux"},
	{"DisplayInputTiming",
	"Execute selected member of `DisplayNodeStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_DisplayInputTiming_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "mux"},
	{"Edit",
	"Execute selected member of `DisplayNodeStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_Edit_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "mux"},
	{"Unlink",
	"Execute selected member of `DisplayNodeStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_Unlink_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{"LinkIn",
	"Execute selected member of `DisplayNodeStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_LinkIn_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{"NextFreeInput",
	"Execute selected member of `DisplayNodeStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_NextFreeInput_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{0}
};

MenuLine EyePlotNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `EyePlot'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_EyePlotMainHelpDefinition, "plots"},
	{"param",
	"Parameters of `EyePlot'",
	MenuTypeMenu, (void *) &EyePlotParamMenu, 0, 0, HelpTextList_NodeParamHelp, "plots"},
	{"members",
	"Members of `EyePlot'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "plots"},
	{"instance",
	"Describe or delete an instance of `EyePlot'",
	MenuTypeMenu, (void *) &EyePlotInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "plots"},
	{"create default",
	"Create instance of `EyePlot' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__EyePlot_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "plots"},
	{"create",
	"Create instance of `EyePlot'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__EyePlot_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "plots"},
	{0}
};

MenuLine EyePlotInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `EyePlot'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__EyePlot_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "plots"},
	{"param",
	"Describe parameters of this `EyePlot'",
	MenuTypeMenu, (void *) &EyePlotInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "plots"},
	{"exec",
	"Select a member of `EyePlot' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "plots"},
	{"delete",
	"Delete this `EyePlot'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__EyePlot_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "plots"},
	{0}
};

MenuLine EyePlotParamMenuMenuLine[] = {
	{"SamplesPerPlot",
	"Parameter `SamplesPerPlot' of `EyePlot' object",
	MenuTypeCommand, (void *) &DescribeParam__EyePlot_SamplesPerPlot_Rem_Call_Struct, 0, 0, HelpTextList_220, "plots"},
	{"Caption",
	"Parameter `Caption' of `EyePlot' object",
	MenuTypeCommand, (void *) &DescribeParam__EyePlot_Caption_Rem_Call_Struct, 0, 0, HelpTextList_221, "plots"},
	{0}
};

MenuLine EyePlotInstanceParamMenuMenuLine[] = {
	{"SamplesPerPlot",
	"Parameter `SamplesPerPlot' of `EyePlot' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__EyePlot_STACK_SamplesPerPlot_Rem_Call_Struct, 0, 0, HelpTextList_222, "plots"},
	{"Caption",
	"Parameter `Caption' of `EyePlot' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__EyePlot_STACK_Caption_Rem_Call_Struct, 0, 0, HelpTextList_223, "plots"},
	{0}
};

MenuLine FindStartTailNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `FindStartTail'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_FindStartTailMainHelpDefinition, "misc"},
	{"param",
	"Parameters of `FindStartTail'",
	MenuTypeMenu, (void *) &FindStartTailParamMenu, 0, 0, HelpTextList_NodeParamHelp, "misc"},
	{"members",
	"Members of `FindStartTail'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "misc"},
	{"instance",
	"Describe or delete an instance of `FindStartTail'",
	MenuTypeMenu, (void *) &FindStartTailInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "misc"},
	{"create default",
	"Create instance of `FindStartTail' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__FindStartTail_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "misc"},
	{"create",
	"Create instance of `FindStartTail'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__FindStartTail_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "misc"},
	{0}
};

MenuLine FindStartTailInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `FindStartTail'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__FindStartTail_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "misc"},
	{"param",
	"Describe parameters of this `FindStartTail'",
	MenuTypeMenu, (void *) &FindStartTailInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "misc"},
	{"exec",
	"Select a member of `FindStartTail' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "misc"},
	{"delete",
	"Delete this `FindStartTail'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__FindStartTail_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "misc"},
	{0}
};

MenuLine FindStartTailParamMenuMenuLine[] = {
	{"LowerBound",
	"Parameter `LowerBound' of `FindStartTail' object",
	MenuTypeCommand, (void *) &DescribeParam__FindStartTail_LowerBound_Rem_Call_Struct, 0, 0, HelpTextList_224, "misc"},
	{"UpperBound",
	"Parameter `UpperBound' of `FindStartTail' object",
	MenuTypeCommand, (void *) &DescribeParam__FindStartTail_UpperBound_Rem_Call_Struct, 0, 0, HelpTextList_225, "misc"},
	{"Flags",
	"Parameter `Flags' of `FindStartTail' object",
	MenuTypeCommand, (void *) &DescribeParam__FindStartTail_Flags_Rem_Call_Struct, 0, 0, HelpTextList_226, "misc"},
	{"Skip",
	"Parameter `Skip' of `FindStartTail' object",
	MenuTypeCommand, (void *) &DescribeParam__FindStartTail_Skip_Rem_Call_Struct, 0, 0, HelpTextList_227, "misc"},
	{0}
};

MenuLine FindStartTailInstanceParamMenuMenuLine[] = {
	{"LowerBound",
	"Parameter `LowerBound' of `FindStartTail' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__FindStartTail_STACK_LowerBound_Rem_Call_Struct, 0, 0, HelpTextList_228, "misc"},
	{"UpperBound",
	"Parameter `UpperBound' of `FindStartTail' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__FindStartTail_STACK_UpperBound_Rem_Call_Struct, 0, 0, HelpTextList_229, "misc"},
	{"Flags",
	"Parameter `Flags' of `FindStartTail' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__FindStartTail_STACK_Flags_Rem_Call_Struct, 0, 0, HelpTextList_230, "misc"},
	{"Skip",
	"Parameter `Skip' of `FindStartTail' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__FindStartTail_STACK_Skip_Rem_Call_Struct, 0, 0, HelpTextList_231, "misc"},
	{0}
};

MenuLine GainNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Gain'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_GainMainHelpDefinition, "mux"},
	{"param",
	"Parameters of `Gain'",
	MenuTypeMenu, (void *) &GainParamMenu, 0, 0, HelpTextList_NodeParamHelp, "mux"},
	{"variables",
	"Changeable variables of `Gain'",
	MenuTypeMenu, (void *) &GainVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "mux"},
	{"members",
	"Members of `Gain'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "mux"},
	{"instance",
	"Describe or delete an instance of `Gain'",
	MenuTypeMenu, (void *) &GainInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "mux"},
	{"create default",
	"Create instance of `Gain' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Gain_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "mux"},
	{"create",
	"Create instance of `Gain'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Gain_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "mux"},
	{0}
};

MenuLine GainInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Gain'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Gain_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "mux"},
	{"param",
	"Describe parameters of this `Gain'",
	MenuTypeMenu, (void *) &GainInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "mux"},
	{"exec",
	"Select a member of `Gain' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "mux"},
	{"variables",
	"Describe variables of this `Gain'",
	MenuTypeMenu, (void *) &GainInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "mux"},
	{"set",
	"Set variable values of this `Gain'",
	MenuTypeMenu, (void *) &GainSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "mux"},
	{"delete",
	"Delete this `Gain'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Gain_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "mux"},
	{0}
};

MenuLine GainParamMenuMenuLine[] = {
	{"Scale",
	"Parameter `Scale' of `Gain' object",
	MenuTypeCommand, (void *) &DescribeParam__Gain_Scale_Rem_Call_Struct, 0, 0, HelpTextList_232, "mux"},
	{0}
};

MenuLine GainVariableMenuMenuLine[] = {
	{"Scale",
	"Changeable variable `Scale' of `Gain' object",
	MenuTypeCommand, (void *) &DescribeParam__Gain_Scale_Rem_Call_Struct, 0, 0, HelpTextList_233, "mux"},
	{0}
};

MenuLine GainInstanceParamMenuMenuLine[] = {
	{"Scale",
	"Parameter `Scale' of `Gain' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Gain_STACK_Scale_Rem_Call_Struct, 0, 0, HelpTextList_234, "mux"},
	{0}
};

MenuLine GainInstanceVariableMenuMenuLine[] = {
	{"Scale",
	"Changeable variable `Scale' of `Gain' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Gain_STACK_Scale_Rem_Call_Struct, 0, 0, HelpTextList_235, "mux"},
	{0}
};

MenuLine GainSetInstanceVariableMenuMenuLine[] = {
	{"set Scale",
	"Change value of variable `Scale' for an instance of `Gain'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Gain_STACK_Scale_Rem_Call_Struct, 0, 0, HelpTextList_236, "mux"},
	{0}
};

MenuLine GainPadNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `GainPad'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_GainPadMainHelpDefinition, "mux"},
	{"param",
	"Parameters of `GainPad'",
	MenuTypeMenu, (void *) &GainPadParamMenu, 0, 0, HelpTextList_NodeParamHelp, "mux"},
	{"variables",
	"Changeable variables of `GainPad'",
	MenuTypeMenu, (void *) &GainPadVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "mux"},
	{"members",
	"Members of `GainPad'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "mux"},
	{"instance",
	"Describe or delete an instance of `GainPad'",
	MenuTypeMenu, (void *) &GainPadInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "mux"},
	{"create default",
	"Create instance of `GainPad' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__GainPad_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "mux"},
	{"create",
	"Create instance of `GainPad'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__GainPad_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "mux"},
	{0}
};

MenuLine GainPadInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `GainPad'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__GainPad_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "mux"},
	{"param",
	"Describe parameters of this `GainPad'",
	MenuTypeMenu, (void *) &GainPadInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "mux"},
	{"exec",
	"Select a member of `GainPad' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "mux"},
	{"variables",
	"Describe variables of this `GainPad'",
	MenuTypeMenu, (void *) &GainPadInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "mux"},
	{"set",
	"Set variable values of this `GainPad'",
	MenuTypeMenu, (void *) &GainPadSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "mux"},
	{"delete",
	"Delete this `GainPad'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__GainPad_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "mux"},
	{0}
};

MenuLine GainPadParamMenuMenuLine[] = {
	{"Scale",
	"Parameter `Scale' of `GainPad' object",
	MenuTypeCommand, (void *) &DescribeParam__GainPad_Scale_Rem_Call_Struct, 0, 0, HelpTextList_237, "mux"},
	{"ElementSize",
	"Parameter `ElementSize' of `GainPad' object",
	MenuTypeCommand, (void *) &DescribeParam__GainPad_ElementSize_Rem_Call_Struct, 0, 0, HelpTextList_238, "mux"},
	{"NullOutputSample",
	"Parameter `NullOutputSample' of `GainPad' object",
	MenuTypeCommand, (void *) &DescribeParam__GainPad_NullOutputSample_Rem_Call_Struct, 0, 0, HelpTextList_239, "mux"},
	{0}
};

MenuLine GainPadVariableMenuMenuLine[] = {
	{"Scale",
	"Changeable variable `Scale' of `GainPad' object",
	MenuTypeCommand, (void *) &DescribeParam__GainPad_Scale_Rem_Call_Struct, 0, 0, HelpTextList_240, "mux"},
	{0}
};

MenuLine GainPadInstanceParamMenuMenuLine[] = {
	{"Scale",
	"Parameter `Scale' of `GainPad' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__GainPad_STACK_Scale_Rem_Call_Struct, 0, 0, HelpTextList_241, "mux"},
	{"ElementSize",
	"Parameter `ElementSize' of `GainPad' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__GainPad_STACK_ElementSize_Rem_Call_Struct, 0, 0, HelpTextList_242, "mux"},
	{"NullOutputSample",
	"Parameter `NullOutputSample' of `GainPad' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__GainPad_STACK_NullOutputSample_Rem_Call_Struct, 0, 0, HelpTextList_243, "mux"},
	{0}
};

MenuLine GainPadInstanceVariableMenuMenuLine[] = {
	{"Scale",
	"Changeable variable `Scale' of `GainPad' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__GainPad_STACK_Scale_Rem_Call_Struct, 0, 0, HelpTextList_244, "mux"},
	{0}
};

MenuLine GainPadSetInstanceVariableMenuMenuLine[] = {
	{"set Scale",
	"Change value of variable `Scale' for an instance of `GainPad'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__GainPad_STACK_Scale_Rem_Call_Struct, 0, 0, HelpTextList_245, "mux"},
	{0}
};

MenuLine HexListNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `HexList'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_HexListMainHelpDefinition, "txt_out"},
	{"param",
	"Parameters of `HexList'",
	MenuTypeMenu, (void *) &HexListParamMenu, 0, 0, HelpTextList_NodeParamHelp, "txt_out"},
	{"members",
	"Members of `HexList'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "txt_out"},
	{"instance",
	"Describe or delete an instance of `HexList'",
	MenuTypeMenu, (void *) &HexListInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "txt_out"},
	{"create default",
	"Create instance of `HexList' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__HexList_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "txt_out"},
	{"create",
	"Create instance of `HexList'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__HexList_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "txt_out"},
	{0}
};

MenuLine HexListInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `HexList'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__HexList_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "txt_out"},
	{"param",
	"Describe parameters of this `HexList'",
	MenuTypeMenu, (void *) &HexListInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "txt_out"},
	{"exec",
	"Select a member of `HexList' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "txt_out"},
	{"delete",
	"Delete this `HexList'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__HexList_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "txt_out"},
	{0}
};

MenuLine HexListParamMenuMenuLine[] = {
	{"Channels",
	"Parameter `Channels' of `HexList' object",
	MenuTypeCommand, (void *) &DescribeParam__HexList_Channels_Rem_Call_Struct, 0, 0, HelpTextList_246, "txt_out"},
	{"Caption",
	"Parameter `Caption' of `HexList' object",
	MenuTypeCommand, (void *) &DescribeParam__HexList_Caption_Rem_Call_Struct, 0, 0, HelpTextList_247, "txt_out"},
	{0}
};

MenuLine HexListInstanceParamMenuMenuLine[] = {
	{"Channels",
	"Parameter `Channels' of `HexList' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__HexList_STACK_Channels_Rem_Call_Struct, 0, 0, HelpTextList_248, "txt_out"},
	{"Caption",
	"Parameter `Caption' of `HexList' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__HexList_STACK_Caption_Rem_Call_Struct, 0, 0, HelpTextList_249, "txt_out"},
	{0}
};

MenuLine ImportDataNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `ImportData'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_ImportDataMainHelpDefinition, "import"},
	{"param",
	"Parameters of `ImportData'",
	MenuTypeMenu, (void *) &ImportDataParamMenu, 0, 0, HelpTextList_NodeParamHelp, "import"},
	{"members",
	"Members of `ImportData'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "import"},
	{"instance",
	"Describe or delete an instance of `ImportData'",
	MenuTypeMenu, (void *) &ImportDataInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "import"},
	{"create default",
	"Create instance of `ImportData' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__ImportData_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "import"},
	{"create",
	"Create instance of `ImportData'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__ImportData_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "import"},
	{0}
};

MenuLine ImportDataInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `ImportData'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__ImportData_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "import"},
	{"param",
	"Describe parameters of this `ImportData'",
	MenuTypeMenu, (void *) &ImportDataInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "import"},
	{"exec",
	"Select a member of `ImportData' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "import"},
	{"delete",
	"Delete this `ImportData'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__ImportData_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "import"},
	{0}
};

MenuLine ImportDataParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `ImportData' object",
	MenuTypeCommand, (void *) &DescribeParam__ImportData_FileName_Rem_Call_Struct, 0, 0, HelpTextList_250, "import"},
	{"Format",
	"Parameter `Format' of `ImportData' object",
	MenuTypeCommand, (void *) &DescribeParam__ImportData_Format_Rem_Call_Struct, 0, 0, HelpTextList_251, "import"},
	{"Fields",
	"Parameter `Fields' of `ImportData' object",
	MenuTypeCommand, (void *) &DescribeParam__ImportData_Fields_Rem_Call_Struct, 0, 0, HelpTextList_252, "import"},
	{"RepeatFlag",
	"Parameter `RepeatFlag' of `ImportData' object",
	MenuTypeCommand, (void *) &DescribeParam__ImportData_RepeatFlag_Rem_Call_Struct, 0, 0, HelpTextList_253, "import"},
	{"SkipFields",
	"Parameter `SkipFields' of `ImportData' object",
	MenuTypeCommand, (void *) &DescribeParam__ImportData_SkipFields_Rem_Call_Struct, 0, 0, HelpTextList_254, "import"},
	{"SkipColumns",
	"Parameter `SkipColumns' of `ImportData' object",
	MenuTypeCommand, (void *) &DescribeParam__ImportData_SkipColumns_Rem_Call_Struct, 0, 0, HelpTextList_255, "import"},
	{0}
};

MenuLine ImportDataInstanceParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `ImportData' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ImportData_STACK_FileName_Rem_Call_Struct, 0, 0, HelpTextList_256, "import"},
	{"Format",
	"Parameter `Format' of `ImportData' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ImportData_STACK_Format_Rem_Call_Struct, 0, 0, HelpTextList_257, "import"},
	{"Fields",
	"Parameter `Fields' of `ImportData' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ImportData_STACK_Fields_Rem_Call_Struct, 0, 0, HelpTextList_258, "import"},
	{"RepeatFlag",
	"Parameter `RepeatFlag' of `ImportData' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ImportData_STACK_RepeatFlag_Rem_Call_Struct, 0, 0, HelpTextList_259, "import"},
	{"SkipFields",
	"Parameter `SkipFields' of `ImportData' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ImportData_STACK_SkipFields_Rem_Call_Struct, 0, 0, HelpTextList_260, "import"},
	{"SkipColumns",
	"Parameter `SkipColumns' of `ImportData' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ImportData_STACK_SkipColumns_Rem_Call_Struct, 0, 0, HelpTextList_261, "import"},
	{0}
};

MenuLine InputNodeNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `InputNode'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_InputNodeMainHelpDefinition, "ionodT"},
	{"param",
	"Parameters of `InputNode'",
	MenuTypeMenu, (void *) &InputNodeParamMenu, 0, 0, HelpTextList_NodeParamHelp, "ionodT"},
	{"members",
	"Members of `InputNode'",
	MenuTypeMenu, (void *) &SelectInputNodeMemberDescribe, 0, 0, HelpTextList_MemberMenuHelp, "ionodT"},
	{"instance",
	"Describe or delete an instance of `InputNode'",
	MenuTypeMenu, (void *) &InputNodeInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "ionodT"},
	{"create default",
	"Create instance of `InputNode' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__InputNode_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "ionodT"},
	{"create",
	"Create instance of `InputNode'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__InputNode_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "ionodT"},
	{0}
};

MenuLine SelectInputNodeMemberDescribeMenuLine[] = {
	{"DisplayHeader",
	"Describe member `DisplayHeader' of `InputNode'",
	MenuTypeMenu, (void *) &DisplayHeaderInputNodeNodeMemberMenu, 0, 0, HelpTextList_262, "ionodT"},
	{"IgnoreHeaderCount",
	"Describe member `IgnoreHeaderCount' of `InputNode'",
	MenuTypeMenu, (void *) &IgnoreHeaderCountInputNodeNodeMemberMenu, 0, 0, HelpTextList_263, "ionodT"},
	{0}
};

MenuLine DisplayHeaderInputNodeNodeMemberMenuMenuLine[] = {
	{"desc DisplayHeader",
	"Describe selected member of `InputNode'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__InputNode_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "ionodT"},
	{0}
};

MenuLine IgnoreHeaderCountInputNodeNodeMemberMenuMenuLine[] = {
	{"desc IgnoreHeaderCount",
	"Describe selected member of `InputNode'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__InputNode_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "ionodT"},
	{0}
};

MenuLine InputNodeInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `InputNode'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__InputNode_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "ionodT"},
	{"param",
	"Describe parameters of this `InputNode'",
	MenuTypeMenu, (void *) &InputNodeInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "ionodT"},
	{"exec",
	"Select a member of `InputNode' to execute",
	MenuTypeMenu, (void *) &SelectInputNodeMemberExecute, 0, 0, HelpTextList_HelpMemberExecute, "ionodT"},
	{"delete",
	"Delete this `InputNode'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__InputNode_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "ionodT"},
	{0}
};

MenuLine SelectInputNodeMemberExecuteMenuLine[] = {
	{"DisplayHeader",
	"Execute selected member of `InputNode'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_DisplayHeader_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "ionodT"},
	{"IgnoreHeaderCount",
	"Execute selected member of `InputNode'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_IgnoreHeaderCount_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "ionodT"},
	{0}
};

MenuLine InputNodeParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `InputNode' object",
	MenuTypeCommand, (void *) &DescribeParam__InputNode_FileName_Rem_Call_Struct, 0, 0, HelpTextList_264, "ionodT"},
	{"Flags",
	"Parameter `Flags' of `InputNode' object",
	MenuTypeCommand, (void *) &DescribeParam__InputNode_Flags_Rem_Call_Struct, 0, 0, HelpTextList_265, "ionodT"},
	{"DeltaOut",
	"Parameter `DeltaOut' of `InputNode' object",
	MenuTypeCommand, (void *) &DescribeParam__InputNode_DeltaOut_Rem_Call_Struct, 0, 0, HelpTextList_266, "ionodT"},
	{0}
};

MenuLine InputNodeInstanceParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `InputNode' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__InputNode_STACK_FileName_Rem_Call_Struct, 0, 0, HelpTextList_267, "ionodT"},
	{"Flags",
	"Parameter `Flags' of `InputNode' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__InputNode_STACK_Flags_Rem_Call_Struct, 0, 0, HelpTextList_268, "ionodT"},
	{"DeltaOut",
	"Parameter `DeltaOut' of `InputNode' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__InputNode_STACK_DeltaOut_Rem_Call_Struct, 0, 0, HelpTextList_269, "ionodT"},
	{0}
};

MenuLine InputWordNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `InputWord'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_InputWordMainHelpDefinition, "binin"},
	{"param",
	"Parameters of `InputWord'",
	MenuTypeMenu, (void *) &InputWordParamMenu, 0, 0, HelpTextList_NodeParamHelp, "binin"},
	{"members",
	"Members of `InputWord'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "binin"},
	{"instance",
	"Describe or delete an instance of `InputWord'",
	MenuTypeMenu, (void *) &InputWordInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "binin"},
	{"create default",
	"Create instance of `InputWord' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__InputWord_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "binin"},
	{"create",
	"Create instance of `InputWord'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__InputWord_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "binin"},
	{0}
};

MenuLine InputWordInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `InputWord'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__InputWord_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "binin"},
	{"param",
	"Describe parameters of this `InputWord'",
	MenuTypeMenu, (void *) &InputWordInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "binin"},
	{"exec",
	"Select a member of `InputWord' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "binin"},
	{"delete",
	"Delete this `InputWord'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__InputWord_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "binin"},
	{0}
};

MenuLine InputWordParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `InputWord' object",
	MenuTypeCommand, (void *) &DescribeParam__InputWord_FileName_Rem_Call_Struct, 0, 0, HelpTextList_270, "binin"},
	{"FormatIn",
	"Parameter `FormatIn' of `InputWord' object",
	MenuTypeCommand, (void *) &DescribeParam__InputWord_FormatIn_Rem_Call_Struct, 0, 0, HelpTextList_271, "binin"},
	{"IntegerOut",
	"Parameter `IntegerOut' of `InputWord' object",
	MenuTypeCommand, (void *) &DescribeParam__InputWord_IntegerOut_Rem_Call_Struct, 0, 0, HelpTextList_272, "binin"},
	{"InitialSkip",
	"Parameter `InitialSkip' of `InputWord' object",
	MenuTypeCommand, (void *) &DescribeParam__InputWord_InitialSkip_Rem_Call_Struct, 0, 0, HelpTextList_273, "binin"},
	{"ElementSize",
	"Parameter `ElementSize' of `InputWord' object",
	MenuTypeCommand, (void *) &DescribeParam__InputWord_ElementSize_Rem_Call_Struct, 0, 0, HelpTextList_274, "binin"},
	{"BlockSize",
	"Parameter `BlockSize' of `InputWord' object",
	MenuTypeCommand, (void *) &DescribeParam__InputWord_BlockSize_Rem_Call_Struct, 0, 0, HelpTextList_275, "binin"},
	{0}
};

MenuLine InputWordInstanceParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `InputWord' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__InputWord_STACK_FileName_Rem_Call_Struct, 0, 0, HelpTextList_276, "binin"},
	{"FormatIn",
	"Parameter `FormatIn' of `InputWord' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__InputWord_STACK_FormatIn_Rem_Call_Struct, 0, 0, HelpTextList_277, "binin"},
	{"IntegerOut",
	"Parameter `IntegerOut' of `InputWord' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__InputWord_STACK_IntegerOut_Rem_Call_Struct, 0, 0, HelpTextList_278, "binin"},
	{"InitialSkip",
	"Parameter `InitialSkip' of `InputWord' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__InputWord_STACK_InitialSkip_Rem_Call_Struct, 0, 0, HelpTextList_279, "binin"},
	{"ElementSize",
	"Parameter `ElementSize' of `InputWord' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__InputWord_STACK_ElementSize_Rem_Call_Struct, 0, 0, HelpTextList_280, "binin"},
	{"BlockSize",
	"Parameter `BlockSize' of `InputWord' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__InputWord_STACK_BlockSize_Rem_Call_Struct, 0, 0, HelpTextList_281, "binin"},
	{0}
};

MenuLine IntegrateNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Integrate'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_IntegrateMainHelpDefinition, "filters"},
	{"param",
	"Parameters of `Integrate'",
	MenuTypeMenu, (void *) &IntegrateParamMenu, 0, 0, HelpTextList_NodeParamHelp, "filters"},
	{"variables",
	"Changeable variables of `Integrate'",
	MenuTypeMenu, (void *) &IntegrateVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "filters"},
	{"members",
	"Members of `Integrate'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "filters"},
	{"instance",
	"Describe or delete an instance of `Integrate'",
	MenuTypeMenu, (void *) &IntegrateInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "filters"},
	{"create default",
	"Create instance of `Integrate' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Integrate_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "filters"},
	{"create",
	"Create instance of `Integrate'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Integrate_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "filters"},
	{0}
};

MenuLine IntegrateInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Integrate'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Integrate_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "filters"},
	{"param",
	"Describe parameters of this `Integrate'",
	MenuTypeMenu, (void *) &IntegrateInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "filters"},
	{"exec",
	"Select a member of `Integrate' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "filters"},
	{"variables",
	"Describe variables of this `Integrate'",
	MenuTypeMenu, (void *) &IntegrateInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "filters"},
	{"set",
	"Set variable values of this `Integrate'",
	MenuTypeMenu, (void *) &IntegrateSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "filters"},
	{"delete",
	"Delete this `Integrate'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Integrate_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "filters"},
	{0}
};

MenuLine IntegrateParamMenuMenuLine[] = {
	{"IntegrationSize",
	"Parameter `IntegrationSize' of `Integrate' object",
	MenuTypeCommand, (void *) &DescribeParam__Integrate_IntegrationSize_Rem_Call_Struct, 0, 0, HelpTextList_282, "filters"},
	{"OutputStep",
	"Parameter `OutputStep' of `Integrate' object",
	MenuTypeCommand, (void *) &DescribeParam__Integrate_OutputStep_Rem_Call_Struct, 0, 0, HelpTextList_283, "filters"},
	{"Scale",
	"Parameter `Scale' of `Integrate' object",
	MenuTypeCommand, (void *) &DescribeParam__Integrate_Scale_Rem_Call_Struct, 0, 0, HelpTextList_284, "filters"},
	{0}
};

MenuLine IntegrateVariableMenuMenuLine[] = {
	{"Scale",
	"Changeable variable `Scale' of `Integrate' object",
	MenuTypeCommand, (void *) &DescribeParam__Integrate_Scale_Rem_Call_Struct, 0, 0, HelpTextList_285, "filters"},
	{0}
};

MenuLine IntegrateInstanceParamMenuMenuLine[] = {
	{"IntegrationSize",
	"Parameter `IntegrationSize' of `Integrate' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Integrate_STACK_IntegrationSize_Rem_Call_Struct, 0, 0, HelpTextList_286, "filters"},
	{"OutputStep",
	"Parameter `OutputStep' of `Integrate' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Integrate_STACK_OutputStep_Rem_Call_Struct, 0, 0, HelpTextList_287, "filters"},
	{"Scale",
	"Parameter `Scale' of `Integrate' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Integrate_STACK_Scale_Rem_Call_Struct, 0, 0, HelpTextList_288, "filters"},
	{0}
};

MenuLine IntegrateInstanceVariableMenuMenuLine[] = {
	{"Scale",
	"Changeable variable `Scale' of `Integrate' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Integrate_STACK_Scale_Rem_Call_Struct, 0, 0, HelpTextList_289, "filters"},
	{0}
};

MenuLine IntegrateSetInstanceVariableMenuMenuLine[] = {
	{"set Scale",
	"Change value of variable `Scale' for an instance of `Integrate'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Integrate_STACK_Scale_Rem_Call_Struct, 0, 0, HelpTextList_290, "filters"},
	{0}
};

MenuLine InterpolateNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Interpolate'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_InterpolateMainHelpDefinition, "filters"},
	{"param",
	"Parameters of `Interpolate'",
	MenuTypeMenu, (void *) &InterpolateParamMenu, 0, 0, HelpTextList_NodeParamHelp, "filters"},
	{"members",
	"Members of `Interpolate'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "filters"},
	{"instance",
	"Describe or delete an instance of `Interpolate'",
	MenuTypeMenu, (void *) &InterpolateInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "filters"},
	{"create default",
	"Create instance of `Interpolate' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Interpolate_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "filters"},
	{"create",
	"Create instance of `Interpolate'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Interpolate_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "filters"},
	{0}
};

MenuLine InterpolateInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Interpolate'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Interpolate_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "filters"},
	{"param",
	"Describe parameters of this `Interpolate'",
	MenuTypeMenu, (void *) &InterpolateInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "filters"},
	{"exec",
	"Select a member of `Interpolate' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "filters"},
	{"delete",
	"Delete this `Interpolate'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Interpolate_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "filters"},
	{0}
};

MenuLine InterpolateParamMenuMenuLine[] = {
	{"DeltaIn",
	"Parameter `DeltaIn' of `Interpolate' object",
	MenuTypeCommand, (void *) &DescribeParam__Interpolate_DeltaIn_Rem_Call_Struct, 0, 0, HelpTextList_291, "filters"},
	{"DeltaOut",
	"Parameter `DeltaOut' of `Interpolate' object",
	MenuTypeCommand, (void *) &DescribeParam__Interpolate_DeltaOut_Rem_Call_Struct, 0, 0, HelpTextList_292, "filters"},
	{0}
};

MenuLine InterpolateInstanceParamMenuMenuLine[] = {
	{"DeltaIn",
	"Parameter `DeltaIn' of `Interpolate' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Interpolate_STACK_DeltaIn_Rem_Call_Struct, 0, 0, HelpTextList_293, "filters"},
	{"DeltaOut",
	"Parameter `DeltaOut' of `Interpolate' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Interpolate_STACK_DeltaOut_Rem_Call_Struct, 0, 0, HelpTextList_294, "filters"},
	{0}
};

MenuLine ListingNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Listing'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_ListingMainHelpDefinition, "txt_out"},
	{"param",
	"Parameters of `Listing'",
	MenuTypeMenu, (void *) &ListingParamMenu, 0, 0, HelpTextList_NodeParamHelp, "txt_out"},
	{"variables",
	"Changeable variables of `Listing'",
	MenuTypeMenu, (void *) &ListingVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "txt_out"},
	{"members",
	"Members of `Listing'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "txt_out"},
	{"instance",
	"Describe or delete an instance of `Listing'",
	MenuTypeMenu, (void *) &ListingInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "txt_out"},
	{"create default",
	"Create instance of `Listing' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Listing_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "txt_out"},
	{"create",
	"Create instance of `Listing'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Listing_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "txt_out"},
	{0}
};

MenuLine ListingInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Listing'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Listing_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "txt_out"},
	{"param",
	"Describe parameters of this `Listing'",
	MenuTypeMenu, (void *) &ListingInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "txt_out"},
	{"exec",
	"Select a member of `Listing' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "txt_out"},
	{"variables",
	"Describe variables of this `Listing'",
	MenuTypeMenu, (void *) &ListingInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "txt_out"},
	{"set",
	"Set variable values of this `Listing'",
	MenuTypeMenu, (void *) &ListingSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "txt_out"},
	{"delete",
	"Delete this `Listing'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Listing_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "txt_out"},
	{0}
};

MenuLine ListingParamMenuMenuLine[] = {
	{"Hex",
	"Parameter `Hex' of `Listing' object",
	MenuTypeCommand, (void *) &DescribeParam__Listing_Hex_Rem_Call_Struct, 0, 0, HelpTextList_295, "txt_out"},
	{"Caption",
	"Parameter `Caption' of `Listing' object",
	MenuTypeCommand, (void *) &DescribeParam__Listing_Caption_Rem_Call_Struct, 0, 0, HelpTextList_296, "txt_out"},
	{0}
};

MenuLine ListingVariableMenuMenuLine[] = {
	{"Hex",
	"Changeable variable `Hex' of `Listing' object",
	MenuTypeCommand, (void *) &DescribeParam__Listing_Hex_Rem_Call_Struct, 0, 0, HelpTextList_297, "txt_out"},
	{0}
};

MenuLine ListingInstanceParamMenuMenuLine[] = {
	{"Hex",
	"Parameter `Hex' of `Listing' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Listing_STACK_Hex_Rem_Call_Struct, 0, 0, HelpTextList_298, "txt_out"},
	{"Caption",
	"Parameter `Caption' of `Listing' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Listing_STACK_Caption_Rem_Call_Struct, 0, 0, HelpTextList_299, "txt_out"},
	{0}
};

MenuLine ListingInstanceVariableMenuMenuLine[] = {
	{"Hex",
	"Changeable variable `Hex' of `Listing' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Listing_STACK_Hex_Rem_Call_Struct, 0, 0, HelpTextList_300, "txt_out"},
	{0}
};

MenuLine ListingSetInstanceVariableMenuMenuLine[] = {
	{"set Hex",
	"Change value of variable `Hex' for an instance of `Listing'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Listing_STACK_Hex_Rem_Call_Struct, 0, 0, HelpTextList_301, "txt_out"},
	{0}
};

MenuLine MaskWordNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `MaskWord'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_MaskWordMainHelpDefinition, "mux"},
	{"param",
	"Parameters of `MaskWord'",
	MenuTypeMenu, (void *) &MaskWordParamMenu, 0, 0, HelpTextList_NodeParamHelp, "mux"},
	{"members",
	"Members of `MaskWord'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "mux"},
	{"instance",
	"Describe or delete an instance of `MaskWord'",
	MenuTypeMenu, (void *) &MaskWordInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "mux"},
	{"create default",
	"Create instance of `MaskWord' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__MaskWord_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "mux"},
	{"create",
	"Create instance of `MaskWord'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__MaskWord_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "mux"},
	{0}
};

MenuLine MaskWordInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `MaskWord'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__MaskWord_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "mux"},
	{"param",
	"Describe parameters of this `MaskWord'",
	MenuTypeMenu, (void *) &MaskWordInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "mux"},
	{"exec",
	"Select a member of `MaskWord' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "mux"},
	{"delete",
	"Delete this `MaskWord'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__MaskWord_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "mux"},
	{0}
};

MenuLine MaskWordParamMenuMenuLine[] = {
	{"Mask",
	"Parameter `Mask' of `MaskWord' object",
	MenuTypeCommand, (void *) &DescribeParam__MaskWord_Mask_Rem_Call_Struct, 0, 0, HelpTextList_302, "mux"},
	{0}
};

MenuLine MaskWordInstanceParamMenuMenuLine[] = {
	{"Mask",
	"Parameter `Mask' of `MaskWord' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__MaskWord_STACK_Mask_Rem_Call_Struct, 0, 0, HelpTextList_303, "mux"},
	{0}
};

MenuLine MuxNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Mux'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_MuxMainHelpDefinition, "mux"},
	{"param",
	"Parameters of `Mux'",
	MenuTypeMenu, (void *) &MuxParamMenu, 0, 0, HelpTextList_NodeParamHelp, "mux"},
	{"members",
	"Members of `Mux'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "mux"},
	{"instance",
	"Describe or delete an instance of `Mux'",
	MenuTypeMenu, (void *) &MuxInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "mux"},
	{"create default",
	"Create instance of `Mux' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Mux_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "mux"},
	{"create",
	"Create instance of `Mux'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Mux_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "mux"},
	{0}
};

MenuLine MuxInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Mux'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Mux_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "mux"},
	{"param",
	"Describe parameters of this `Mux'",
	MenuTypeMenu, (void *) &MuxInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "mux"},
	{"exec",
	"Select a member of `Mux' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "mux"},
	{"delete",
	"Delete this `Mux'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Mux_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "mux"},
	{0}
};

MenuLine MuxParamMenuMenuLine[] = {
	{"Channels",
	"Parameter `Channels' of `Mux' object",
	MenuTypeCommand, (void *) &DescribeParam__Mux_Channels_Rem_Call_Struct, 0, 0, HelpTextList_304, "mux"},
	{"InputSampleSize",
	"Parameter `InputSampleSize' of `Mux' object",
	MenuTypeCommand, (void *) &DescribeParam__Mux_InputSampleSize_Rem_Call_Struct, 0, 0, HelpTextList_305, "mux"},
	{"OutputSampleSize",
	"Parameter `OutputSampleSize' of `Mux' object",
	MenuTypeCommand, (void *) &DescribeParam__Mux_OutputSampleSize_Rem_Call_Struct, 0, 0, HelpTextList_306, "mux"},
	{"MinimumChunk",
	"Parameter `MinimumChunk' of `Mux' object",
	MenuTypeCommand, (void *) &DescribeParam__Mux_MinimumChunk_Rem_Call_Struct, 0, 0, HelpTextList_307, "mux"},
	{0}
};

MenuLine MuxInstanceParamMenuMenuLine[] = {
	{"Channels",
	"Parameter `Channels' of `Mux' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Mux_STACK_Channels_Rem_Call_Struct, 0, 0, HelpTextList_308, "mux"},
	{"InputSampleSize",
	"Parameter `InputSampleSize' of `Mux' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Mux_STACK_InputSampleSize_Rem_Call_Struct, 0, 0, HelpTextList_309, "mux"},
	{"OutputSampleSize",
	"Parameter `OutputSampleSize' of `Mux' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Mux_STACK_OutputSampleSize_Rem_Call_Struct, 0, 0, HelpTextList_310, "mux"},
	{"MinimumChunk",
	"Parameter `MinimumChunk' of `Mux' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Mux_STACK_MinimumChunk_Rem_Call_Struct, 0, 0, HelpTextList_311, "mux"},
	{0}
};

MenuLine NetworkNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Network'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_NetworkMainHelpDefinition, "net"},
	{"members",
	"Members of `Network'",
	MenuTypeMenu, (void *) &SelectNetworkMemberDescribe, 0, 0, HelpTextList_MemberMenuHelp, "net"},
	{"instance",
	"Describe or delete an instance of `Network'",
	MenuTypeMenu, (void *) &NetworkInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "net"},
	{"create default",
	"Create instance of `Network' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Network_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "net"},
	{"create",
	"Create instance of `Network'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Network_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "net"},
	{0}
};

MenuLine SelectNetworkMemberDescribeMenuLine[] = {
	{"GraphDisplay",
	"Describe member `GraphDisplay' of `Network'",
	MenuTypeMenu, (void *) &GraphDisplayNetworkNodeMemberMenu, 0, 0, HelpTextList_312, "graphd"},
	{"Execute",
	"Describe member `Execute' of `Network'",
	MenuTypeMenu, (void *) &ExecuteNetworkNodeMemberMenu, 0, 0, HelpTextList_313, "net_exe"},
	{"Raise",
	"Describe member `Raise' of `Network'",
	MenuTypeMenu, (void *) &RaiseNetworkNodeMemberMenu, 0, 0, HelpTextList_314, "net"},
	{"ReplaceNode",
	"Describe member `ReplaceNode' of `Network'",
	MenuTypeMenu, (void *) &ReplaceNodeNetworkNodeMemberMenu, 0, 0, HelpTextList_315, "net"},
	{"MakeTarget",
	"Describe member `MakeTarget' of `Network'",
	MenuTypeMenu, (void *) &MakeTargetNetworkNodeMemberMenu, 0, 0, HelpTextList_316, "mk_tgt"},
	{"MakeValidate",
	"Describe member `MakeValidate' of `Network'",
	MenuTypeMenu, (void *) &MakeValidateNetworkNodeMemberMenu, 0, 0, HelpTextList_317, "valid"},
	{"TargetValidate",
	"Describe member `TargetValidate' of `Network'",
	MenuTypeMenu, (void *) &TargetValidateNetworkNodeMemberMenu, 0, 0, HelpTextList_318, "valid"},
	{"SetTimingExact",
	"Describe member `SetTimingExact' of `Network'",
	MenuTypeMenu, (void *) &SetTimingExactNetworkNodeMemberMenu, 0, 0, HelpTextList_319, "valid"},
	{"ReplaceWithOutput",
	"Describe member `ReplaceWithOutput' of `Network'",
	MenuTypeMenu, (void *) &ReplaceWithOutputNetworkNodeMemberMenu, 0, 0, HelpTextList_320, "valid"},
	{"ReplaceWithCompare",
	"Describe member `ReplaceWithCompare' of `Network'",
	MenuTypeMenu, (void *) &ReplaceWithCompareNetworkNodeMemberMenu, 0, 0, HelpTextList_321, "valid"},
	{"operator+",
	"Describe member `operator+' of `Network'",
	MenuTypeMenu, (void *) &Add_OpNetworkNodeMemberMenu, 0, 0, HelpTextList_322, "net_edit"},
	{"operator>>",
	"Describe member `operator>>' of `Network'",
	MenuTypeMenu, (void *) &RightShift_OpNetworkNodeMemberMenu, 0, 0, HelpTextList_323, "net_edit"},
	{"GraphDisplayWindow",
	"Describe member `GraphDisplayWindow' of `Network'",
	MenuTypeMenu, (void *) &GraphDisplayWindowNetworkNodeMemberMenu, 0, 0, HelpTextList_324, "graphd"},
	{"DisplayNames",
	"Describe member `DisplayNames' of `Network'",
	MenuTypeMenu, (void *) &DisplayNamesNetworkNodeMemberMenu, 0, 0, HelpTextList_325, "net"},
	{"SetBufferDescriptor",
	"Describe member `SetBufferDescriptor' of `Network'",
	MenuTypeMenu, (void *) &SetBufferDescriptorNetworkNodeMemberMenu, 0, 0, HelpTextList_326, "buf"},
	{"AssociateNode",
	"Describe member `AssociateNode' of `Network'",
	MenuTypeMenu, (void *) &AssociateNodeNetworkNodeMemberMenu, 0, 0, HelpTextList_327, "net"},
	{"Link",
	"Describe member `Link' of `Network'",
	MenuTypeMenu, (void *) &LinkNetworkNodeMemberMenu, 0, 0, HelpTextList_328, "net_edit"},
	{"SelfLink",
	"Describe member `SelfLink' of `Network'",
	MenuTypeMenu, (void *) &SelfLinkNetworkNodeMemberMenu, 0, 0, HelpTextList_329, "net_edit"},
	{"AssignBuffers",
	"Describe member `AssignBuffers' of `Network'",
	MenuTypeMenu, (void *) &AssignBuffersNetworkNodeMemberMenu, 0, 0, HelpTextList_330, "buf"},
	{"GetBufferDescriptor",
	"Describe member `GetBufferDescriptor' of `Network'",
	MenuTypeMenu, (void *) &GetBufferDescriptorNetworkNodeMemberMenu, 0, 0, HelpTextList_331, "buf"},
	{"ClearBuffers",
	"Describe member `ClearBuffers' of `Network'",
	MenuTypeMenu, (void *) &ClearBuffersNetworkNodeMemberMenu, 0, 0, HelpTextList_332, "buf"},
	{"GetNetController",
	"Describe member `GetNetController' of `Network'",
	MenuTypeMenu, (void *) &GetNetControllerNetworkNodeMemberMenu, 0, 0, HelpTextList_333, "net"},
	{"ClearNetwork",
	"Describe member `ClearNetwork' of `Network'",
	MenuTypeMenu, (void *) &ClearNetworkNetworkNodeMemberMenu, 0, 0, HelpTextList_334, "net_edit"},
	{0}
};

MenuLine GraphDisplayNetworkNodeMemberMenuMenuLine[] = {
	{"desc GraphDisplay",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "graphd"},
	{0}
};

MenuLine ExecuteNetworkNodeMemberMenuMenuLine[] = {
	{"desc Execute",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_exe"},
	{"param Execute",
	"Describe the parameters of member `Execute'",
	MenuTypeMenu, (void *) &NetworkExecuteMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_exe"},
	{0}
};

MenuLine NetworkExecuteMemberParamMenuMenuLine[] = {
	{"InputSamples",
	"Select this parameter of `Network' member `Execute' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_InputSamples_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_exe"},
	{0}
};

MenuLine RaiseNetworkNodeMemberMenuMenuLine[] = {
	{"desc Raise",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net"},
	{0}
};

MenuLine ReplaceNodeNetworkNodeMemberMenuMenuLine[] = {
	{"desc ReplaceNode",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net"},
	{"param ReplaceNode",
	"Describe the parameters of member `ReplaceNode'",
	MenuTypeMenu, (void *) &NetworkReplaceNodeMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "net"},
	{0}
};

MenuLine NetworkReplaceNodeMemberParamMenuMenuLine[] = {
	{"ToReplace",
	"Select this parameter of `Network' member `ReplaceNode' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_ToReplace_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "net"},
	{"Replacement",
	"Select this parameter of `Network' member `ReplaceNode' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_Replacement_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "net"},
	{0}
};

MenuLine MakeTargetNetworkNodeMemberMenuMenuLine[] = {
	{"desc MakeTarget",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "mk_tgt"},
	{"param MakeTarget",
	"Describe the parameters of member `MakeTarget'",
	MenuTypeMenu, (void *) &NetworkMakeTargetMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "mk_tgt"},
	{0}
};

MenuLine NetworkMakeTargetMemberParamMenuMenuLine[] = {
	{"Target",
	"Select this parameter of `Network' member `MakeTarget' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_Target_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "mk_tgt"},
	{"Create",
	"Select this parameter of `Network' member `MakeTarget' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_Create_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "mk_tgt"},
	{"Directory",
	"Select this parameter of `Network' member `MakeTarget' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_Directory_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "mk_tgt"},
	{0}
};

MenuLine MakeValidateNetworkNodeMemberMenuMenuLine[] = {
	{"desc MakeValidate",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "valid"},
	{"param MakeValidate",
	"Describe the parameters of member `MakeValidate'",
	MenuTypeMenu, (void *) &NetworkMakeValidateMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{0}
};

MenuLine NetworkMakeValidateMemberParamMenuMenuLine[] = {
	{"DirName",
	"Select this parameter of `Network' member `MakeValidate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_DirName_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{"ExecuteCount",
	"Select this parameter of `Network' member `MakeValidate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_ExecuteCount_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{"ExtraCountCreator",
	"Select this parameter of `Network' member `MakeValidate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_ExtraCountCreator_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{"MaxReport",
	"Select this parameter of `Network' member `MakeValidate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_MaxReport_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{"Tolerance",
	"Select this parameter of `Network' member `MakeValidate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_Tolerance_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{"errorFile",
	"Select this parameter of `Network' member `MakeValidate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_errorFile_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{0}
};

MenuLine TargetValidateNetworkNodeMemberMenuMenuLine[] = {
	{"desc TargetValidate",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "valid"},
	{"param TargetValidate",
	"Describe the parameters of member `TargetValidate'",
	MenuTypeMenu, (void *) &NetworkTargetValidateMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{0}
};

MenuLine NetworkTargetValidateMemberParamMenuMenuLine[] = {
	{"Target",
	"Select this parameter of `Network' member `TargetValidate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_Target_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{"Create",
	"Select this parameter of `Network' member `TargetValidate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_Create_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{"DirName",
	"Select this parameter of `Network' member `TargetValidate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_DirName_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{"ExecuteCount",
	"Select this parameter of `Network' member `TargetValidate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_ExecuteCount_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{"ExtraCountCreator",
	"Select this parameter of `Network' member `TargetValidate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_ExtraCountCreator_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{"MaxReport",
	"Select this parameter of `Network' member `TargetValidate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_MaxReport_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{"Tolerance",
	"Select this parameter of `Network' member `TargetValidate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_Tolerance_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{"ErrorFile",
	"Select this parameter of `Network' member `TargetValidate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_ErrorFile_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{0}
};

MenuLine SetTimingExactNetworkNodeMemberMenuMenuLine[] = {
	{"desc SetTimingExact",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "valid"},
	{"param SetTimingExact",
	"Describe the parameters of member `SetTimingExact'",
	MenuTypeMenu, (void *) &NetworkSetTimingExactMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{0}
};

MenuLine NetworkSetTimingExactMemberParamMenuMenuLine[] = {
	{"Exact",
	"Select this parameter of `Network' member `SetTimingExact' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_Exact_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{0}
};

MenuLine ReplaceWithOutputNetworkNodeMemberMenuMenuLine[] = {
	{"desc ReplaceWithOutput",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "valid"},
	{0}
};

MenuLine ReplaceWithCompareNetworkNodeMemberMenuMenuLine[] = {
	{"desc ReplaceWithCompare",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "valid"},
	{"param ReplaceWithCompare",
	"Describe the parameters of member `ReplaceWithCompare'",
	MenuTypeMenu, (void *) &NetworkReplaceWithCompareMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{0}
};

MenuLine NetworkReplaceWithCompareMemberParamMenuMenuLine[] = {
	{"MaxReport",
	"Select this parameter of `Network' member `ReplaceWithCompare' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_MaxReport_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{"Tolerance",
	"Select this parameter of `Network' member `ReplaceWithCompare' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_Tolerance_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{"ErrorFile",
	"Select this parameter of `Network' member `ReplaceWithCompare' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_ErrorFile_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "valid"},
	{0}
};

MenuLine Add_OpNetworkNodeMemberMenuMenuLine[] = {
	{"desc operator+",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{"param operator+",
	"Describe the parameters of member `operator+'",
	MenuTypeMenu, (void *) &NetworkAdd_OpMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{0}
};

MenuLine NetworkAdd_OpMemberParamMenuMenuLine[] = {
	{"TheNode",
	"Select this parameter of `Network' member `operator+' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_TheNode_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{0}
};

MenuLine RightShift_OpNetworkNodeMemberMenuMenuLine[] = {
	{"desc operator>>",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{"param operator>>",
	"Describe the parameters of member `operator>>'",
	MenuTypeMenu, (void *) &NetworkRightShift_OpMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{0}
};

MenuLine NetworkRightShift_OpMemberParamMenuMenuLine[] = {
	{"TheNode",
	"Select this parameter of `Network' member `operator>>' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_TheNode_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{0}
};

MenuLine GraphDisplayWindowNetworkNodeMemberMenuMenuLine[] = {
	{"desc GraphDisplayWindow",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "graphd"},
	{"param GraphDisplayWindow",
	"Describe the parameters of member `GraphDisplayWindow'",
	MenuTypeMenu, (void *) &NetworkGraphDisplayWindowMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "graphd"},
	{0}
};

MenuLine NetworkGraphDisplayWindowMemberParamMenuMenuLine[] = {
	{"Width",
	"Select this parameter of `Network' member `GraphDisplayWindow' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_Width_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "graphd"},
	{"Height",
	"Select this parameter of `Network' member `GraphDisplayWindow' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_Height_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "graphd"},
	{0}
};

MenuLine DisplayNamesNetworkNodeMemberMenuMenuLine[] = {
	{"desc DisplayNames",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net"},
	{0}
};

MenuLine SetBufferDescriptorNetworkNodeMemberMenuMenuLine[] = {
	{"desc SetBufferDescriptor",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "buf"},
	{"param SetBufferDescriptor",
	"Describe the parameters of member `SetBufferDescriptor'",
	MenuTypeMenu, (void *) &NetworkSetBufferDescriptorMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "buf"},
	{0}
};

MenuLine NetworkSetBufferDescriptorMemberParamMenuMenuLine[] = {
	{"Descriptor",
	"Select this parameter of `Network' member `SetBufferDescriptor' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_Descriptor_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "buf"},
	{0}
};

MenuLine AssociateNodeNetworkNodeMemberMenuMenuLine[] = {
	{"desc AssociateNode",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net"},
	{"param AssociateNode",
	"Describe the parameters of member `AssociateNode'",
	MenuTypeMenu, (void *) &NetworkAssociateNodeMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "net"},
	{0}
};

MenuLine NetworkAssociateNodeMemberParamMenuMenuLine[] = {
	{"TheNode",
	"Select this parameter of `Network' member `AssociateNode' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_TheNode_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "net"},
	{0}
};

MenuLine LinkNetworkNodeMemberMenuMenuLine[] = {
	{"desc Link",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{"param Link",
	"Describe the parameters of member `Link'",
	MenuTypeMenu, (void *) &NetworkLinkMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{0}
};

MenuLine NetworkLinkMemberParamMenuMenuLine[] = {
	{"TheNode",
	"Select this parameter of `Network' member `Link' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_TheNode_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{"OutChannel",
	"Select this parameter of `Network' member `Link' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_OutChannel_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{0}
};

MenuLine SelfLinkNetworkNodeMemberMenuMenuLine[] = {
	{"desc SelfLink",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{"param SelfLink",
	"Describe the parameters of member `SelfLink'",
	MenuTypeMenu, (void *) &NetworkSelfLinkMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{0}
};

MenuLine NetworkSelfLinkMemberParamMenuMenuLine[] = {
	{"NodeOut",
	"Select this parameter of `Network' member `SelfLink' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_NodeOut_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{"NodeIn",
	"Select this parameter of `Network' member `SelfLink' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_NodeIn_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{"ChannelOut",
	"Select this parameter of `Network' member `SelfLink' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_ChannelOut_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{"ChannelIn",
	"Select this parameter of `Network' member `SelfLink' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_ChannelIn_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{0}
};

MenuLine AssignBuffersNetworkNodeMemberMenuMenuLine[] = {
	{"desc AssignBuffers",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "buf"},
	{"param AssignBuffers",
	"Describe the parameters of member `AssignBuffers'",
	MenuTypeMenu, (void *) &NetworkAssignBuffersMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "buf"},
	{0}
};

MenuLine NetworkAssignBuffersMemberParamMenuMenuLine[] = {
	{"Descriptor",
	"Select this parameter of `Network' member `AssignBuffers' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__Network_STACK_Descriptor_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "buf"},
	{0}
};

MenuLine GetBufferDescriptorNetworkNodeMemberMenuMenuLine[] = {
	{"desc GetBufferDescriptor",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "buf"},
	{0}
};

MenuLine ClearBuffersNetworkNodeMemberMenuMenuLine[] = {
	{"desc ClearBuffers",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "buf"},
	{0}
};

MenuLine GetNetControllerNetworkNodeMemberMenuMenuLine[] = {
	{"desc GetNetController",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net"},
	{0}
};

MenuLine ClearNetworkNetworkNodeMemberMenuMenuLine[] = {
	{"desc ClearNetwork",
	"Describe selected member of `Network'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{0}
};

MenuLine NetworkInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Network'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "net"},
	{"exec",
	"Select a member of `Network' to execute",
	MenuTypeMenu, (void *) &SelectNetworkMemberExecute, 0, 0, HelpTextList_HelpMemberExecute, "net"},
	{"delete",
	"Delete this `Network'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Network_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "net"},
	{0}
};

MenuLine SelectNetworkMemberExecuteMenuLine[] = {
	{"GraphDisplay",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_GraphDisplay_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "graphd"},
	{"Execute",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_Execute_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_exe"},
	{"Raise",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_Raise_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net"},
	{"ReplaceNode",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_ReplaceNode_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net"},
	{"MakeTarget",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_MakeTarget_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "mk_tgt"},
	{"MakeValidate",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_MakeValidate_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "valid"},
	{"TargetValidate",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_TargetValidate_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "valid"},
	{"SetTimingExact",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_SetTimingExact_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "valid"},
	{"ReplaceWithOutput",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_ReplaceWithOutput_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "valid"},
	{"ReplaceWithCompare",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_ReplaceWithCompare_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "valid"},
	{"operator+",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_Add_Op_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{"operator>>",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_RightShift_Op_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{"GraphDisplayWindow",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_GraphDisplayWindow_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "graphd"},
	{"DisplayNames",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_DisplayNames_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net"},
	{"SetBufferDescriptor",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_SetBufferDescriptor_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "buf"},
	{"AssociateNode",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_AssociateNode_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net"},
	{"Link",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_Link_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{"SelfLink",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_SelfLink_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{"AssignBuffers",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_AssignBuffers_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "buf"},
	{"GetBufferDescriptor",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_GetBufferDescriptor_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "buf"},
	{"ClearBuffers",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_ClearBuffers_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "buf"},
	{"GetNetController",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_GetNetController_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net"},
	{"ClearNetwork",
	"Execute selected member of `Network'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_ClearNetwork_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{0}
};

MenuLine NormalNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Normal'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_NormalMainHelpDefinition, "signalT"},
	{"param",
	"Parameters of `Normal'",
	MenuTypeMenu, (void *) &NormalParamMenu, 0, 0, HelpTextList_NodeParamHelp, "signalT"},
	{"variables",
	"Changeable variables of `Normal'",
	MenuTypeMenu, (void *) &NormalVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "signalT"},
	{"members",
	"Members of `Normal'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "signalT"},
	{"instance",
	"Describe or delete an instance of `Normal'",
	MenuTypeMenu, (void *) &NormalInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "signalT"},
	{"create default",
	"Create instance of `Normal' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Normal_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "signalT"},
	{"create",
	"Create instance of `Normal'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Normal_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "signalT"},
	{0}
};

MenuLine NormalInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Normal'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Normal_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "signalT"},
	{"param",
	"Describe parameters of this `Normal'",
	MenuTypeMenu, (void *) &NormalInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "signalT"},
	{"exec",
	"Select a member of `Normal' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "signalT"},
	{"variables",
	"Describe variables of this `Normal'",
	MenuTypeMenu, (void *) &NormalInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "signalT"},
	{"set",
	"Set variable values of this `Normal'",
	MenuTypeMenu, (void *) &NormalSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "signalT"},
	{"delete",
	"Delete this `Normal'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Normal_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "signalT"},
	{0}
};

MenuLine NormalParamMenuMenuLine[] = {
	{"Sigma",
	"Parameter `Sigma' of `Normal' object",
	MenuTypeCommand, (void *) &DescribeParam__Normal_Sigma_Rem_Call_Struct, 0, 0, HelpTextList_335, "signalT"},
	{"Mean",
	"Parameter `Mean' of `Normal' object",
	MenuTypeCommand, (void *) &DescribeParam__Normal_Mean_Rem_Call_Struct, 0, 0, HelpTextList_336, "signalT"},
	{"ElementSize",
	"Parameter `ElementSize' of `Normal' object",
	MenuTypeCommand, (void *) &DescribeParam__Normal_ElementSize_Rem_Call_Struct, 0, 0, HelpTextList_337, "signalT"},
	{"Seed",
	"Parameter `Seed' of `Normal' object",
	MenuTypeCommand, (void *) &DescribeParam__Normal_Seed_Rem_Call_Struct, 0, 0, HelpTextList_338, "signalT"},
	{0}
};

MenuLine NormalVariableMenuMenuLine[] = {
	{"Sigma",
	"Changeable variable `Sigma' of `Normal' object",
	MenuTypeCommand, (void *) &DescribeParam__Normal_Sigma_Rem_Call_Struct, 0, 0, HelpTextList_339, "signalT"},
	{"Mean",
	"Changeable variable `Mean' of `Normal' object",
	MenuTypeCommand, (void *) &DescribeParam__Normal_Mean_Rem_Call_Struct, 0, 0, HelpTextList_340, "signalT"},
	{0}
};

MenuLine NormalInstanceParamMenuMenuLine[] = {
	{"Sigma",
	"Parameter `Sigma' of `Normal' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Normal_STACK_Sigma_Rem_Call_Struct, 0, 0, HelpTextList_341, "signalT"},
	{"Mean",
	"Parameter `Mean' of `Normal' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Normal_STACK_Mean_Rem_Call_Struct, 0, 0, HelpTextList_342, "signalT"},
	{"ElementSize",
	"Parameter `ElementSize' of `Normal' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Normal_STACK_ElementSize_Rem_Call_Struct, 0, 0, HelpTextList_343, "signalT"},
	{"Seed",
	"Parameter `Seed' of `Normal' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Normal_STACK_Seed_Rem_Call_Struct, 0, 0, HelpTextList_344, "signalT"},
	{0}
};

MenuLine NormalInstanceVariableMenuMenuLine[] = {
	{"Sigma",
	"Changeable variable `Sigma' of `Normal' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Normal_STACK_Sigma_Rem_Call_Struct, 0, 0, HelpTextList_345, "signalT"},
	{"Mean",
	"Changeable variable `Mean' of `Normal' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Normal_STACK_Mean_Rem_Call_Struct, 0, 0, HelpTextList_346, "signalT"},
	{0}
};

MenuLine NormalSetInstanceVariableMenuMenuLine[] = {
	{"set Sigma",
	"Change value of variable `Sigma' for an instance of `Normal'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Normal_STACK_Sigma_Rem_Call_Struct, 0, 0, HelpTextList_347, "signalT"},
	{"set Mean",
	"Change value of variable `Mean' for an instance of `Normal'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Normal_STACK_Mean_Rem_Call_Struct, 0, 0, HelpTextList_348, "signalT"},
	{0}
};

MenuLine OutputNodeNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `OutputNode'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_OutputNodeMainHelpDefinition, "ionodT"},
	{"param",
	"Parameters of `OutputNode'",
	MenuTypeMenu, (void *) &OutputNodeParamMenu, 0, 0, HelpTextList_NodeParamHelp, "ionodT"},
	{"members",
	"Members of `OutputNode'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "ionodT"},
	{"instance",
	"Describe or delete an instance of `OutputNode'",
	MenuTypeMenu, (void *) &OutputNodeInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "ionodT"},
	{"create default",
	"Create instance of `OutputNode' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__OutputNode_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "ionodT"},
	{"create",
	"Create instance of `OutputNode'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__OutputNode_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "ionodT"},
	{0}
};

MenuLine OutputNodeInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `OutputNode'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__OutputNode_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "ionodT"},
	{"param",
	"Describe parameters of this `OutputNode'",
	MenuTypeMenu, (void *) &OutputNodeInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "ionodT"},
	{"exec",
	"Select a member of `OutputNode' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "ionodT"},
	{"delete",
	"Delete this `OutputNode'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__OutputNode_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "ionodT"},
	{0}
};

MenuLine OutputNodeParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `OutputNode' object",
	MenuTypeCommand, (void *) &DescribeParam__OutputNode_FileName_Rem_Call_Struct, 0, 0, HelpTextList_349, "ionodT"},
	{"Flags",
	"Parameter `Flags' of `OutputNode' object",
	MenuTypeCommand, (void *) &DescribeParam__OutputNode_Flags_Rem_Call_Struct, 0, 0, HelpTextList_350, "ionodT"},
	{"Channels",
	"Parameter `Channels' of `OutputNode' object",
	MenuTypeCommand, (void *) &DescribeParam__OutputNode_Channels_Rem_Call_Struct, 0, 0, HelpTextList_351, "ionodT"},
	{"FileBlockSize",
	"Parameter `FileBlockSize' of `OutputNode' object",
	MenuTypeCommand, (void *) &DescribeParam__OutputNode_FileBlockSize_Rem_Call_Struct, 0, 0, HelpTextList_352, "ionodT"},
	{"Caption",
	"Parameter `Caption' of `OutputNode' object",
	MenuTypeCommand, (void *) &DescribeParam__OutputNode_Caption_Rem_Call_Struct, 0, 0, HelpTextList_353, "ionodT"},
	{"DeltaIn",
	"Parameter `DeltaIn' of `OutputNode' object",
	MenuTypeCommand, (void *) &DescribeParam__OutputNode_DeltaIn_Rem_Call_Struct, 0, 0, HelpTextList_354, "ionodT"},
	{0}
};

MenuLine OutputNodeInstanceParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `OutputNode' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__OutputNode_STACK_FileName_Rem_Call_Struct, 0, 0, HelpTextList_355, "ionodT"},
	{"Flags",
	"Parameter `Flags' of `OutputNode' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__OutputNode_STACK_Flags_Rem_Call_Struct, 0, 0, HelpTextList_356, "ionodT"},
	{"Channels",
	"Parameter `Channels' of `OutputNode' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__OutputNode_STACK_Channels_Rem_Call_Struct, 0, 0, HelpTextList_357, "ionodT"},
	{"FileBlockSize",
	"Parameter `FileBlockSize' of `OutputNode' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__OutputNode_STACK_FileBlockSize_Rem_Call_Struct, 0, 0, HelpTextList_358, "ionodT"},
	{"Caption",
	"Parameter `Caption' of `OutputNode' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__OutputNode_STACK_Caption_Rem_Call_Struct, 0, 0, HelpTextList_359, "ionodT"},
	{"DeltaIn",
	"Parameter `DeltaIn' of `OutputNode' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__OutputNode_STACK_DeltaIn_Rem_Call_Struct, 0, 0, HelpTextList_360, "ionodT"},
	{0}
};

MenuLine OutputWordNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `OutputWord'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_OutputWordMainHelpDefinition, "binin"},
	{"param",
	"Parameters of `OutputWord'",
	MenuTypeMenu, (void *) &OutputWordParamMenu, 0, 0, HelpTextList_NodeParamHelp, "binin"},
	{"members",
	"Members of `OutputWord'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "binin"},
	{"instance",
	"Describe or delete an instance of `OutputWord'",
	MenuTypeMenu, (void *) &OutputWordInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "binin"},
	{"create default",
	"Create instance of `OutputWord' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__OutputWord_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "binin"},
	{"create",
	"Create instance of `OutputWord'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__OutputWord_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "binin"},
	{0}
};

MenuLine OutputWordInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `OutputWord'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__OutputWord_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "binin"},
	{"param",
	"Describe parameters of this `OutputWord'",
	MenuTypeMenu, (void *) &OutputWordInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "binin"},
	{"exec",
	"Select a member of `OutputWord' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "binin"},
	{"delete",
	"Delete this `OutputWord'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__OutputWord_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "binin"},
	{0}
};

MenuLine OutputWordParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `OutputWord' object",
	MenuTypeCommand, (void *) &DescribeParam__OutputWord_FileName_Rem_Call_Struct, 0, 0, HelpTextList_361, "binin"},
	{"FormatOut",
	"Parameter `FormatOut' of `OutputWord' object",
	MenuTypeCommand, (void *) &DescribeParam__OutputWord_FormatOut_Rem_Call_Struct, 0, 0, HelpTextList_362, "binin"},
	{0}
};

MenuLine OutputWordInstanceParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `OutputWord' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__OutputWord_STACK_FileName_Rem_Call_Struct, 0, 0, HelpTextList_363, "binin"},
	{"FormatOut",
	"Parameter `FormatOut' of `OutputWord' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__OutputWord_STACK_FormatOut_Rem_Call_Struct, 0, 0, HelpTextList_364, "binin"},
	{0}
};

MenuLine PackWordNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `PackWord'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_PackWordMainHelpDefinition, "mux"},
	{"param",
	"Parameters of `PackWord'",
	MenuTypeMenu, (void *) &PackWordParamMenu, 0, 0, HelpTextList_NodeParamHelp, "mux"},
	{"members",
	"Members of `PackWord'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "mux"},
	{"instance",
	"Describe or delete an instance of `PackWord'",
	MenuTypeMenu, (void *) &PackWordInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "mux"},
	{"create default",
	"Create instance of `PackWord' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__PackWord_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "mux"},
	{"create",
	"Create instance of `PackWord'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__PackWord_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "mux"},
	{0}
};

MenuLine PackWordInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `PackWord'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__PackWord_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "mux"},
	{"param",
	"Describe parameters of this `PackWord'",
	MenuTypeMenu, (void *) &PackWordInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "mux"},
	{"exec",
	"Select a member of `PackWord' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "mux"},
	{"delete",
	"Delete this `PackWord'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__PackWord_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "mux"},
	{0}
};

MenuLine PackWordParamMenuMenuLine[] = {
	{"InputWordSize",
	"Parameter `InputWordSize' of `PackWord' object",
	MenuTypeCommand, (void *) &DescribeParam__PackWord_InputWordSize_Rem_Call_Struct, 0, 0, HelpTextList_365, "mux"},
	{"InputsPerOutput",
	"Parameter `InputsPerOutput' of `PackWord' object",
	MenuTypeCommand, (void *) &DescribeParam__PackWord_InputsPerOutput_Rem_Call_Struct, 0, 0, HelpTextList_366, "mux"},
	{0}
};

MenuLine PackWordInstanceParamMenuMenuLine[] = {
	{"InputWordSize",
	"Parameter `InputWordSize' of `PackWord' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__PackWord_STACK_InputWordSize_Rem_Call_Struct, 0, 0, HelpTextList_367, "mux"},
	{"InputsPerOutput",
	"Parameter `InputsPerOutput' of `PackWord' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__PackWord_STACK_InputsPerOutput_Rem_Call_Struct, 0, 0, HelpTextList_368, "mux"},
	{0}
};

MenuLine PlotNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Plot'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_PlotMainHelpDefinition, "plots"},
	{"param",
	"Parameters of `Plot'",
	MenuTypeMenu, (void *) &PlotParamMenu, 0, 0, HelpTextList_NodeParamHelp, "plots"},
	{"members",
	"Members of `Plot'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "plots"},
	{"instance",
	"Describe or delete an instance of `Plot'",
	MenuTypeMenu, (void *) &PlotInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "plots"},
	{"create default",
	"Create instance of `Plot' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Plot_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "plots"},
	{"create",
	"Create instance of `Plot'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Plot_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "plots"},
	{0}
};

MenuLine PlotInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Plot'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Plot_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "plots"},
	{"param",
	"Describe parameters of this `Plot'",
	MenuTypeMenu, (void *) &PlotInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "plots"},
	{"exec",
	"Select a member of `Plot' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "plots"},
	{"delete",
	"Delete this `Plot'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Plot_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "plots"},
	{0}
};

MenuLine PlotParamMenuMenuLine[] = {
	{"Caption",
	"Parameter `Caption' of `Plot' object",
	MenuTypeCommand, (void *) &DescribeParam__Plot_Caption_Rem_Call_Struct, 0, 0, HelpTextList_369, "plots"},
	{0}
};

MenuLine PlotInstanceParamMenuMenuLine[] = {
	{"Caption",
	"Parameter `Caption' of `Plot' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Plot_STACK_Caption_Rem_Call_Struct, 0, 0, HelpTextList_370, "plots"},
	{0}
};

MenuLine PowerNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Power'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_PowerMainHelpDefinition, "convert"},
	{"param",
	"Parameters of `Power'",
	MenuTypeMenu, (void *) &PowerParamMenu, 0, 0, HelpTextList_NodeParamHelp, "convert"},
	{"variables",
	"Changeable variables of `Power'",
	MenuTypeMenu, (void *) &PowerVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "convert"},
	{"members",
	"Members of `Power'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "convert"},
	{"instance",
	"Describe or delete an instance of `Power'",
	MenuTypeMenu, (void *) &PowerInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "convert"},
	{"create default",
	"Create instance of `Power' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Power_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "convert"},
	{"create",
	"Create instance of `Power'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Power_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "convert"},
	{0}
};

MenuLine PowerInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Power'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Power_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "convert"},
	{"param",
	"Describe parameters of this `Power'",
	MenuTypeMenu, (void *) &PowerInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "convert"},
	{"exec",
	"Select a member of `Power' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "convert"},
	{"variables",
	"Describe variables of this `Power'",
	MenuTypeMenu, (void *) &PowerInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "convert"},
	{"set",
	"Set variable values of this `Power'",
	MenuTypeMenu, (void *) &PowerSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "convert"},
	{"delete",
	"Delete this `Power'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Power_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "convert"},
	{0}
};

MenuLine PowerParamMenuMenuLine[] = {
	{"Amplitude",
	"Parameter `Amplitude' of `Power' object",
	MenuTypeCommand, (void *) &DescribeParam__Power_Amplitude_Rem_Call_Struct, 0, 0, HelpTextList_371, "convert"},
	{"Scale",
	"Parameter `Scale' of `Power' object",
	MenuTypeCommand, (void *) &DescribeParam__Power_Scale_Rem_Call_Struct, 0, 0, HelpTextList_372, "convert"},
	{0}
};

MenuLine PowerVariableMenuMenuLine[] = {
	{"Scale",
	"Changeable variable `Scale' of `Power' object",
	MenuTypeCommand, (void *) &DescribeParam__Power_Scale_Rem_Call_Struct, 0, 0, HelpTextList_373, "convert"},
	{0}
};

MenuLine PowerInstanceParamMenuMenuLine[] = {
	{"Amplitude",
	"Parameter `Amplitude' of `Power' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Power_STACK_Amplitude_Rem_Call_Struct, 0, 0, HelpTextList_374, "convert"},
	{"Scale",
	"Parameter `Scale' of `Power' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Power_STACK_Scale_Rem_Call_Struct, 0, 0, HelpTextList_375, "convert"},
	{0}
};

MenuLine PowerInstanceVariableMenuMenuLine[] = {
	{"Scale",
	"Changeable variable `Scale' of `Power' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Power_STACK_Scale_Rem_Call_Struct, 0, 0, HelpTextList_376, "convert"},
	{0}
};

MenuLine PowerSetInstanceVariableMenuMenuLine[] = {
	{"set Scale",
	"Change value of variable `Scale' for an instance of `Power'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Power_STACK_Scale_Rem_Call_Struct, 0, 0, HelpTextList_377, "convert"},
	{0}
};

MenuLine SelectProcessNodeStrMemberDescribeMenuLine[] = {
	{"Raise",
	"Describe member `Raise' of `ProcessNodeStr'",
	MenuTypeMenu, (void *) &RaiseProcessNodeStrNodeMemberMenu, 0, 0, HelpTextList_378, "nodem"},
	{"SetSampleRate",
	"Describe member `SetSampleRate' of `ProcessNodeStr'",
	MenuTypeMenu, (void *) &SetSampleRateProcessNodeStrNodeMemberMenu, 0, 0, HelpTextList_379, "nodem"},
	{"DisplayInputTiming",
	"Describe member `DisplayInputTiming' of `ProcessNodeStr'",
	MenuTypeMenu, (void *) &DisplayInputTimingProcessNodeStrNodeMemberMenu, 0, 0, HelpTextList_380, "nodem"},
	{"DisplayOutputTiming",
	"Describe member `DisplayOutputTiming' of `ProcessNodeStr'",
	MenuTypeMenu, (void *) &DisplayOutputTimingProcessNodeStrNodeMemberMenu, 0, 0, HelpTextList_381, "nodem"},
	{"Edit",
	"Describe member `Edit' of `ProcessNodeStr'",
	MenuTypeMenu, (void *) &EditProcessNodeStrNodeMemberMenu, 0, 0, HelpTextList_382, "net_edit"},
	{"Unlink",
	"Describe member `Unlink' of `ProcessNodeStr'",
	MenuTypeMenu, (void *) &UnlinkProcessNodeStrNodeMemberMenu, 0, 0, HelpTextList_383, "net_edit"},
	{"LinkIn",
	"Describe member `LinkIn' of `ProcessNodeStr'",
	MenuTypeMenu, (void *) &LinkInProcessNodeStrNodeMemberMenu, 0, 0, HelpTextList_384, "net_edit"},
	{"NextFreeInput",
	"Describe member `NextFreeInput' of `ProcessNodeStr'",
	MenuTypeMenu, (void *) &NextFreeInputProcessNodeStrNodeMemberMenu, 0, 0, HelpTextList_385, "net_edit"},
	{"NextFreeOutput",
	"Describe member `NextFreeOutput' of `ProcessNodeStr'",
	MenuTypeMenu, (void *) &NextFreeOutputProcessNodeStrNodeMemberMenu, 0, 0, HelpTextList_386, "net_edit"},
	{0}
};

MenuLine RaiseProcessNodeStrNodeMemberMenuMenuLine[] = {
	{"desc Raise",
	"Describe selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__ProcessNodeStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "nodem"},
	{0}
};

MenuLine SetSampleRateProcessNodeStrNodeMemberMenuMenuLine[] = {
	{"desc SetSampleRate",
	"Describe selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__ProcessNodeStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "nodem"},
	{"param SetSampleRate",
	"Describe the parameters of member `SetSampleRate'",
	MenuTypeMenu, (void *) &ProcessNodeStrSetSampleRateMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "nodem"},
	{0}
};

MenuLine ProcessNodeStrSetSampleRateMemberParamMenuMenuLine[] = {
	{"Rate",
	"Select this parameter of `ProcessNodeStr' member `SetSampleRate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__ProcessNodeStr_STACK_Rate_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "nodem"},
	{"Channel",
	"Select this parameter of `ProcessNodeStr' member `SetSampleRate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__ProcessNodeStr_STACK_Channel_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "nodem"},
	{0}
};

MenuLine DisplayInputTimingProcessNodeStrNodeMemberMenuMenuLine[] = {
	{"desc DisplayInputTiming",
	"Describe selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__ProcessNodeStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "nodem"},
	{"param DisplayInputTiming",
	"Describe the parameters of member `DisplayInputTiming'",
	MenuTypeMenu, (void *) &ProcessNodeStrDisplayInputTimingMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "nodem"},
	{0}
};

MenuLine ProcessNodeStrDisplayInputTimingMemberParamMenuMenuLine[] = {
	{"Channel",
	"Select this parameter of `ProcessNodeStr' member `DisplayInputTiming' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__ProcessNodeStr_STACK_Channel_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "nodem"},
	{0}
};

MenuLine DisplayOutputTimingProcessNodeStrNodeMemberMenuMenuLine[] = {
	{"desc DisplayOutputTiming",
	"Describe selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__ProcessNodeStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "nodem"},
	{"param DisplayOutputTiming",
	"Describe the parameters of member `DisplayOutputTiming'",
	MenuTypeMenu, (void *) &ProcessNodeStrDisplayOutputTimingMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "nodem"},
	{0}
};

MenuLine ProcessNodeStrDisplayOutputTimingMemberParamMenuMenuLine[] = {
	{"Channel",
	"Select this parameter of `ProcessNodeStr' member `DisplayOutputTiming' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__ProcessNodeStr_STACK_Channel_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "nodem"},
	{0}
};

MenuLine EditProcessNodeStrNodeMemberMenuMenuLine[] = {
	{"desc Edit",
	"Describe selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__ProcessNodeStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{0}
};

MenuLine UnlinkProcessNodeStrNodeMemberMenuMenuLine[] = {
	{"desc Unlink",
	"Describe selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__ProcessNodeStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{0}
};

MenuLine LinkInProcessNodeStrNodeMemberMenuMenuLine[] = {
	{"desc LinkIn",
	"Describe selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__ProcessNodeStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{"param LinkIn",
	"Describe the parameters of member `LinkIn'",
	MenuTypeMenu, (void *) &ProcessNodeStrLinkInMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{0}
};

MenuLine ProcessNodeStrLinkInMemberParamMenuMenuLine[] = {
	{"Channel",
	"Select this parameter of `ProcessNodeStr' member `LinkIn' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__ProcessNodeStr_STACK_Channel_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "net_edit"},
	{0}
};

MenuLine NextFreeInputProcessNodeStrNodeMemberMenuMenuLine[] = {
	{"desc NextFreeInput",
	"Describe selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__ProcessNodeStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{0}
};

MenuLine NextFreeOutputProcessNodeStrNodeMemberMenuMenuLine[] = {
	{"desc NextFreeOutput",
	"Describe selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__ProcessNodeStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{0}
};

MenuLine SelectProcessNodeStrMemberExecuteMenuLine[] = {
	{"Raise",
	"Execute selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_Raise_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "nodem"},
	{"SetSampleRate",
	"Execute selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_SetSampleRate_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "nodem"},
	{"DisplayInputTiming",
	"Execute selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_DisplayInputTiming_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "nodem"},
	{"DisplayOutputTiming",
	"Execute selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_DisplayOutputTiming_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "nodem"},
	{"Edit",
	"Execute selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_Edit_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{"Unlink",
	"Execute selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_Unlink_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{"LinkIn",
	"Execute selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_LinkIn_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{"NextFreeInput",
	"Execute selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_NextFreeInput_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{"NextFreeOutput",
	"Execute selected member of `ProcessNodeStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_NextFreeOutput_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{0}
};

MenuLine RampNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Ramp'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_RampMainHelpDefinition, "signalT"},
	{"param",
	"Parameters of `Ramp'",
	MenuTypeMenu, (void *) &RampParamMenu, 0, 0, HelpTextList_NodeParamHelp, "signalT"},
	{"variables",
	"Changeable variables of `Ramp'",
	MenuTypeMenu, (void *) &RampVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "signalT"},
	{"members",
	"Members of `Ramp'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "signalT"},
	{"instance",
	"Describe or delete an instance of `Ramp'",
	MenuTypeMenu, (void *) &RampInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "signalT"},
	{"create default",
	"Create instance of `Ramp' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Ramp_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "signalT"},
	{"create",
	"Create instance of `Ramp'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Ramp_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "signalT"},
	{0}
};

MenuLine RampInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Ramp'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Ramp_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "signalT"},
	{"param",
	"Describe parameters of this `Ramp'",
	MenuTypeMenu, (void *) &RampInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "signalT"},
	{"exec",
	"Select a member of `Ramp' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "signalT"},
	{"variables",
	"Describe variables of this `Ramp'",
	MenuTypeMenu, (void *) &RampInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "signalT"},
	{"set",
	"Set variable values of this `Ramp'",
	MenuTypeMenu, (void *) &RampSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "signalT"},
	{"delete",
	"Delete this `Ramp'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Ramp_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "signalT"},
	{0}
};

MenuLine RampParamMenuMenuLine[] = {
	{"Min",
	"Parameter `Min' of `Ramp' object",
	MenuTypeCommand, (void *) &DescribeParam__Ramp_Min_Rem_Call_Struct, 0, 0, HelpTextList_387, "signalT"},
	{"Max",
	"Parameter `Max' of `Ramp' object",
	MenuTypeCommand, (void *) &DescribeParam__Ramp_Max_Rem_Call_Struct, 0, 0, HelpTextList_388, "signalT"},
	{"Increment",
	"Parameter `Increment' of `Ramp' object",
	MenuTypeCommand, (void *) &DescribeParam__Ramp_Increment_Rem_Call_Struct, 0, 0, HelpTextList_389, "signalT"},
	{0}
};

MenuLine RampVariableMenuMenuLine[] = {
	{"Min",
	"Changeable variable `Min' of `Ramp' object",
	MenuTypeCommand, (void *) &DescribeParam__Ramp_Min_Rem_Call_Struct, 0, 0, HelpTextList_390, "signalT"},
	{"Max",
	"Changeable variable `Max' of `Ramp' object",
	MenuTypeCommand, (void *) &DescribeParam__Ramp_Max_Rem_Call_Struct, 0, 0, HelpTextList_391, "signalT"},
	{"Increment",
	"Changeable variable `Increment' of `Ramp' object",
	MenuTypeCommand, (void *) &DescribeParam__Ramp_Increment_Rem_Call_Struct, 0, 0, HelpTextList_392, "signalT"},
	{0}
};

MenuLine RampInstanceParamMenuMenuLine[] = {
	{"Min",
	"Parameter `Min' of `Ramp' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Ramp_STACK_Min_Rem_Call_Struct, 0, 0, HelpTextList_393, "signalT"},
	{"Max",
	"Parameter `Max' of `Ramp' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Ramp_STACK_Max_Rem_Call_Struct, 0, 0, HelpTextList_394, "signalT"},
	{"Increment",
	"Parameter `Increment' of `Ramp' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Ramp_STACK_Increment_Rem_Call_Struct, 0, 0, HelpTextList_395, "signalT"},
	{0}
};

MenuLine RampInstanceVariableMenuMenuLine[] = {
	{"Min",
	"Changeable variable `Min' of `Ramp' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Ramp_STACK_Min_Rem_Call_Struct, 0, 0, HelpTextList_396, "signalT"},
	{"Max",
	"Changeable variable `Max' of `Ramp' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Ramp_STACK_Max_Rem_Call_Struct, 0, 0, HelpTextList_397, "signalT"},
	{"Increment",
	"Changeable variable `Increment' of `Ramp' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Ramp_STACK_Increment_Rem_Call_Struct, 0, 0, HelpTextList_398, "signalT"},
	{0}
};

MenuLine RampSetInstanceVariableMenuMenuLine[] = {
	{"set Min",
	"Change value of variable `Min' for an instance of `Ramp'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Ramp_STACK_Min_Rem_Call_Struct, 0, 0, HelpTextList_399, "signalT"},
	{"set Max",
	"Change value of variable `Max' for an instance of `Ramp'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Ramp_STACK_Max_Rem_Call_Struct, 0, 0, HelpTextList_400, "signalT"},
	{"set Increment",
	"Change value of variable `Increment' for an instance of `Ramp'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Ramp_STACK_Increment_Rem_Call_Struct, 0, 0, HelpTextList_401, "signalT"},
	{0}
};

MenuLine ReadFloatNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `ReadFloat'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_ReadFloatMainHelpDefinition, "import"},
	{"param",
	"Parameters of `ReadFloat'",
	MenuTypeMenu, (void *) &ReadFloatParamMenu, 0, 0, HelpTextList_NodeParamHelp, "import"},
	{"members",
	"Members of `ReadFloat'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "import"},
	{"instance",
	"Describe or delete an instance of `ReadFloat'",
	MenuTypeMenu, (void *) &ReadFloatInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "import"},
	{"create default",
	"Create instance of `ReadFloat' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__ReadFloat_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "import"},
	{"create",
	"Create instance of `ReadFloat'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__ReadFloat_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "import"},
	{0}
};

MenuLine ReadFloatInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `ReadFloat'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__ReadFloat_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "import"},
	{"param",
	"Describe parameters of this `ReadFloat'",
	MenuTypeMenu, (void *) &ReadFloatInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "import"},
	{"exec",
	"Select a member of `ReadFloat' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "import"},
	{"delete",
	"Delete this `ReadFloat'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__ReadFloat_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "import"},
	{0}
};

MenuLine ReadFloatParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `ReadFloat' object",
	MenuTypeCommand, (void *) &DescribeParam__ReadFloat_FileName_Rem_Call_Struct, 0, 0, HelpTextList_402, "import"},
	{0}
};

MenuLine ReadFloatInstanceParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `ReadFloat' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ReadFloat_STACK_FileName_Rem_Call_Struct, 0, 0, HelpTextList_403, "import"},
	{0}
};

MenuLine ReadIntNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `ReadInt'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_ReadIntMainHelpDefinition, "import"},
	{"param",
	"Parameters of `ReadInt'",
	MenuTypeMenu, (void *) &ReadIntParamMenu, 0, 0, HelpTextList_NodeParamHelp, "import"},
	{"members",
	"Members of `ReadInt'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "import"},
	{"instance",
	"Describe or delete an instance of `ReadInt'",
	MenuTypeMenu, (void *) &ReadIntInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "import"},
	{"create default",
	"Create instance of `ReadInt' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__ReadInt_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "import"},
	{"create",
	"Create instance of `ReadInt'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__ReadInt_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "import"},
	{0}
};

MenuLine ReadIntInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `ReadInt'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__ReadInt_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "import"},
	{"param",
	"Describe parameters of this `ReadInt'",
	MenuTypeMenu, (void *) &ReadIntInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "import"},
	{"exec",
	"Select a member of `ReadInt' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "import"},
	{"delete",
	"Delete this `ReadInt'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__ReadInt_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "import"},
	{0}
};

MenuLine ReadIntParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `ReadInt' object",
	MenuTypeCommand, (void *) &DescribeParam__ReadInt_FileName_Rem_Call_Struct, 0, 0, HelpTextList_404, "import"},
	{"Flags",
	"Parameter `Flags' of `ReadInt' object",
	MenuTypeCommand, (void *) &DescribeParam__ReadInt_Flags_Rem_Call_Struct, 0, 0, HelpTextList_405, "import"},
	{0}
};

MenuLine ReadIntInstanceParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `ReadInt' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ReadInt_STACK_FileName_Rem_Call_Struct, 0, 0, HelpTextList_406, "import"},
	{"Flags",
	"Parameter `Flags' of `ReadInt' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ReadInt_STACK_Flags_Rem_Call_Struct, 0, 0, HelpTextList_407, "import"},
	{0}
};

MenuLine RealFirNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `RealFir'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_RealFirMainHelpDefinition, "filters"},
	{"param",
	"Parameters of `RealFir'",
	MenuTypeMenu, (void *) &RealFirParamMenu, 0, 0, HelpTextList_NodeParamHelp, "filters"},
	{"members",
	"Members of `RealFir'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "filters"},
	{"instance",
	"Describe or delete an instance of `RealFir'",
	MenuTypeMenu, (void *) &RealFirInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "filters"},
	{"create default",
	"Create instance of `RealFir' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__RealFir_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "filters"},
	{"create",
	"Create instance of `RealFir'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__RealFir_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "filters"},
	{0}
};

MenuLine RealFirInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `RealFir'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__RealFir_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "filters"},
	{"param",
	"Describe parameters of this `RealFir'",
	MenuTypeMenu, (void *) &RealFirInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "filters"},
	{"exec",
	"Select a member of `RealFir' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "filters"},
	{"delete",
	"Delete this `RealFir'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__RealFir_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "filters"},
	{0}
};

MenuLine RealFirParamMenuMenuLine[] = {
	{"Resample",
	"Parameter `Resample' of `RealFir' object",
	MenuTypeCommand, (void *) &DescribeParam__RealFir_Resample_Rem_Call_Struct, 0, 0, HelpTextList_408, "filters"},
	{"ZeroPad",
	"Parameter `ZeroPad' of `RealFir' object",
	MenuTypeCommand, (void *) &DescribeParam__RealFir_ZeroPad_Rem_Call_Struct, 0, 0, HelpTextList_409, "filters"},
	{"Odd",
	"Parameter `Odd' of `RealFir' object",
	MenuTypeCommand, (void *) &DescribeParam__RealFir_Odd_Rem_Call_Struct, 0, 0, HelpTextList_410, "filters"},
	{"Coeff",
	"Parameter `Coeff' of `RealFir' object",
	MenuTypeCommand, (void *) &DescribeParam__RealFir_Coeff_Rem_Call_Struct, 0, 0, HelpTextList_411, "filters"},
	{0}
};

MenuLine RealFirInstanceParamMenuMenuLine[] = {
	{"Resample",
	"Parameter `Resample' of `RealFir' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__RealFir_STACK_Resample_Rem_Call_Struct, 0, 0, HelpTextList_412, "filters"},
	{"ZeroPad",
	"Parameter `ZeroPad' of `RealFir' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__RealFir_STACK_ZeroPad_Rem_Call_Struct, 0, 0, HelpTextList_413, "filters"},
	{"Odd",
	"Parameter `Odd' of `RealFir' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__RealFir_STACK_Odd_Rem_Call_Struct, 0, 0, HelpTextList_414, "filters"},
	{"Coeff",
	"Parameter `Coeff' of `RealFir' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__RealFir_STACK_Coeff_Rem_Call_Struct, 0, 0, HelpTextList_415, "filters"},
	{0}
};

MenuLine RepackStreamNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `RepackStream'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_RepackStreamMainHelpDefinition, "mux"},
	{"param",
	"Parameters of `RepackStream'",
	MenuTypeMenu, (void *) &RepackStreamParamMenu, 0, 0, HelpTextList_NodeParamHelp, "mux"},
	{"members",
	"Members of `RepackStream'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "mux"},
	{"instance",
	"Describe or delete an instance of `RepackStream'",
	MenuTypeMenu, (void *) &RepackStreamInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "mux"},
	{"create default",
	"Create instance of `RepackStream' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__RepackStream_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "mux"},
	{"create",
	"Create instance of `RepackStream'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__RepackStream_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "mux"},
	{0}
};

MenuLine RepackStreamInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `RepackStream'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__RepackStream_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "mux"},
	{"param",
	"Describe parameters of this `RepackStream'",
	MenuTypeMenu, (void *) &RepackStreamInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "mux"},
	{"exec",
	"Select a member of `RepackStream' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "mux"},
	{"delete",
	"Delete this `RepackStream'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__RepackStream_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "mux"},
	{0}
};

MenuLine RepackStreamParamMenuMenuLine[] = {
	{"OutputWordSize",
	"Parameter `OutputWordSize' of `RepackStream' object",
	MenuTypeCommand, (void *) &DescribeParam__RepackStream_OutputWordSize_Rem_Call_Struct, 0, 0, HelpTextList_416, "mux"},
	{"InputWordSize",
	"Parameter `InputWordSize' of `RepackStream' object",
	MenuTypeCommand, (void *) &DescribeParam__RepackStream_InputWordSize_Rem_Call_Struct, 0, 0, HelpTextList_417, "mux"},
	{"SignedOutput",
	"Parameter `SignedOutput' of `RepackStream' object",
	MenuTypeCommand, (void *) &DescribeParam__RepackStream_SignedOutput_Rem_Call_Struct, 0, 0, HelpTextList_418, "mux"},
	{0}
};

MenuLine RepackStreamInstanceParamMenuMenuLine[] = {
	{"OutputWordSize",
	"Parameter `OutputWordSize' of `RepackStream' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__RepackStream_STACK_OutputWordSize_Rem_Call_Struct, 0, 0, HelpTextList_419, "mux"},
	{"InputWordSize",
	"Parameter `InputWordSize' of `RepackStream' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__RepackStream_STACK_InputWordSize_Rem_Call_Struct, 0, 0, HelpTextList_420, "mux"},
	{"SignedOutput",
	"Parameter `SignedOutput' of `RepackStream' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__RepackStream_STACK_SignedOutput_Rem_Call_Struct, 0, 0, HelpTextList_421, "mux"},
	{0}
};

MenuLine SampleDelayNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `SampleDelay'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_SampleDelayMainHelpDefinition, "misc"},
	{"param",
	"Parameters of `SampleDelay'",
	MenuTypeMenu, (void *) &SampleDelayParamMenu, 0, 0, HelpTextList_NodeParamHelp, "misc"},
	{"members",
	"Members of `SampleDelay'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "misc"},
	{"instance",
	"Describe or delete an instance of `SampleDelay'",
	MenuTypeMenu, (void *) &SampleDelayInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "misc"},
	{"create default",
	"Create instance of `SampleDelay' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__SampleDelay_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "misc"},
	{"create",
	"Create instance of `SampleDelay'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__SampleDelay_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "misc"},
	{0}
};

MenuLine SampleDelayInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `SampleDelay'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__SampleDelay_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "misc"},
	{"param",
	"Describe parameters of this `SampleDelay'",
	MenuTypeMenu, (void *) &SampleDelayInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "misc"},
	{"exec",
	"Select a member of `SampleDelay' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "misc"},
	{"delete",
	"Delete this `SampleDelay'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__SampleDelay_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "misc"},
	{0}
};

MenuLine SampleDelayParamMenuMenuLine[] = {
	{"Delta",
	"Parameter `Delta' of `SampleDelay' object",
	MenuTypeCommand, (void *) &DescribeParam__SampleDelay_Delta_Rem_Call_Struct, 0, 0, HelpTextList_422, "misc"},
	{"FillValue",
	"Parameter `FillValue' of `SampleDelay' object",
	MenuTypeCommand, (void *) &DescribeParam__SampleDelay_FillValue_Rem_Call_Struct, 0, 0, HelpTextList_423, "misc"},
	{0}
};

MenuLine SampleDelayInstanceParamMenuMenuLine[] = {
	{"Delta",
	"Parameter `Delta' of `SampleDelay' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__SampleDelay_STACK_Delta_Rem_Call_Struct, 0, 0, HelpTextList_424, "misc"},
	{"FillValue",
	"Parameter `FillValue' of `SampleDelay' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__SampleDelay_STACK_FillValue_Rem_Call_Struct, 0, 0, HelpTextList_425, "misc"},
	{0}
};

MenuLine SelectSignalStrMemberDescribeMenuLine[] = {
	{"Raise",
	"Describe member `Raise' of `SignalStr'",
	MenuTypeMenu, (void *) &RaiseSignalStrNodeMemberMenu, 0, 0, HelpTextList_426, "nodem"},
	{"SetSampleRate",
	"Describe member `SetSampleRate' of `SignalStr'",
	MenuTypeMenu, (void *) &SetSampleRateSignalStrNodeMemberMenu, 0, 0, HelpTextList_427, "nodem"},
	{"DisplayOutputTiming",
	"Describe member `DisplayOutputTiming' of `SignalStr'",
	MenuTypeMenu, (void *) &DisplayOutputTimingSignalStrNodeMemberMenu, 0, 0, HelpTextList_428, "nodem"},
	{"Edit",
	"Describe member `Edit' of `SignalStr'",
	MenuTypeMenu, (void *) &EditSignalStrNodeMemberMenu, 0, 0, HelpTextList_429, "net_edit"},
	{"Unlink",
	"Describe member `Unlink' of `SignalStr'",
	MenuTypeMenu, (void *) &UnlinkSignalStrNodeMemberMenu, 0, 0, HelpTextList_430, "net_edit"},
	{"NextFreeOutput",
	"Describe member `NextFreeOutput' of `SignalStr'",
	MenuTypeMenu, (void *) &NextFreeOutputSignalStrNodeMemberMenu, 0, 0, HelpTextList_431, "net_edit"},
	{0}
};

MenuLine RaiseSignalStrNodeMemberMenuMenuLine[] = {
	{"desc Raise",
	"Describe selected member of `SignalStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__SignalStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "nodem"},
	{0}
};

MenuLine SetSampleRateSignalStrNodeMemberMenuMenuLine[] = {
	{"desc SetSampleRate",
	"Describe selected member of `SignalStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__SignalStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "nodem"},
	{"param SetSampleRate",
	"Describe the parameters of member `SetSampleRate'",
	MenuTypeMenu, (void *) &SignalStrSetSampleRateMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "nodem"},
	{0}
};

MenuLine SignalStrSetSampleRateMemberParamMenuMenuLine[] = {
	{"Rate",
	"Select this parameter of `SignalStr' member `SetSampleRate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__SignalStr_STACK_Rate_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "nodem"},
	{"Channel",
	"Select this parameter of `SignalStr' member `SetSampleRate' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__SignalStr_STACK_Channel_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "nodem"},
	{0}
};

MenuLine DisplayOutputTimingSignalStrNodeMemberMenuMenuLine[] = {
	{"desc DisplayOutputTiming",
	"Describe selected member of `SignalStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__SignalStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "nodem"},
	{"param DisplayOutputTiming",
	"Describe the parameters of member `DisplayOutputTiming'",
	MenuTypeMenu, (void *) &SignalStrDisplayOutputTimingMemberParamMenu, 0, 0, HelpTextList_MemberParamDescribeHelp, "nodem"},
	{0}
};

MenuLine SignalStrDisplayOutputTimingMemberParamMenuMenuLine[] = {
	{"Channel",
	"Select this parameter of `SignalStr' member `DisplayOutputTiming' to describe",
	MenuTypeCommand, (void *) &DescribeMemberFunctionParameter__SignalStr_STACK_Channel_Rem_Call_Struct, 0, 0, HelpTextList_MemberParamDescribeHelp, "nodem"},
	{0}
};

MenuLine EditSignalStrNodeMemberMenuMenuLine[] = {
	{"desc Edit",
	"Describe selected member of `SignalStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__SignalStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{0}
};

MenuLine UnlinkSignalStrNodeMemberMenuMenuLine[] = {
	{"desc Unlink",
	"Describe selected member of `SignalStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__SignalStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{0}
};

MenuLine NextFreeOutputSignalStrNodeMemberMenuMenuLine[] = {
	{"desc NextFreeOutput",
	"Describe selected member of `SignalStr'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__SignalStr_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "net_edit"},
	{0}
};

MenuLine SelectSignalStrMemberExecuteMenuLine[] = {
	{"Raise",
	"Execute selected member of `SignalStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_Raise_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "nodem"},
	{"SetSampleRate",
	"Execute selected member of `SignalStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_SetSampleRate_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "nodem"},
	{"DisplayOutputTiming",
	"Execute selected member of `SignalStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_DisplayOutputTiming_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "nodem"},
	{"Edit",
	"Execute selected member of `SignalStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_Edit_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{"Unlink",
	"Execute selected member of `SignalStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_Unlink_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{"NextFreeOutput",
	"Execute selected member of `SignalStr'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_NextFreeOutput_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "net_edit"},
	{0}
};

MenuLine ToIntegerNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `ToInteger'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_ToIntegerMainHelpDefinition, "convert"},
	{"members",
	"Members of `ToInteger'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "convert"},
	{"instance",
	"Describe or delete an instance of `ToInteger'",
	MenuTypeMenu, (void *) &ToIntegerInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "convert"},
	{"create default",
	"Create instance of `ToInteger' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__ToInteger_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "convert"},
	{"create",
	"Create instance of `ToInteger'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__ToInteger_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "convert"},
	{0}
};

MenuLine ToIntegerInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `ToInteger'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__ToInteger_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "convert"},
	{"exec",
	"Select a member of `ToInteger' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "convert"},
	{"delete",
	"Delete this `ToInteger'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__ToInteger_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "convert"},
	{0}
};

MenuLine ToMachNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `ToMach'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_ToMachMainHelpDefinition, "convert"},
	{"param",
	"Parameters of `ToMach'",
	MenuTypeMenu, (void *) &ToMachParamMenu, 0, 0, HelpTextList_NodeParamHelp, "convert"},
	{"members",
	"Members of `ToMach'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "convert"},
	{"instance",
	"Describe or delete an instance of `ToMach'",
	MenuTypeMenu, (void *) &ToMachInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "convert"},
	{"create default",
	"Create instance of `ToMach' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__ToMach_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "convert"},
	{"create",
	"Create instance of `ToMach'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__ToMach_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "convert"},
	{0}
};

MenuLine ToMachInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `ToMach'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__ToMach_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "convert"},
	{"param",
	"Describe parameters of this `ToMach'",
	MenuTypeMenu, (void *) &ToMachInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "convert"},
	{"exec",
	"Select a member of `ToMach' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "convert"},
	{"delete",
	"Delete this `ToMach'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__ToMach_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "convert"},
	{0}
};

MenuLine ToMachParamMenuMenuLine[] = {
	{"SignedConversion",
	"Parameter `SignedConversion' of `ToMach' object",
	MenuTypeCommand, (void *) &DescribeParam__ToMach_SignedConversion_Rem_Call_Struct, 0, 0, HelpTextList_432, "convert"},
	{0}
};

MenuLine ToMachInstanceParamMenuMenuLine[] = {
	{"SignedConversion",
	"Parameter `SignedConversion' of `ToMach' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ToMach_STACK_SignedConversion_Rem_Call_Struct, 0, 0, HelpTextList_433, "convert"},
	{0}
};

MenuLine TruncateNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `Truncate'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_TruncateMainHelpDefinition, "convert"},
	{"param",
	"Parameters of `Truncate'",
	MenuTypeMenu, (void *) &TruncateParamMenu, 0, 0, HelpTextList_NodeParamHelp, "convert"},
	{"variables",
	"Changeable variables of `Truncate'",
	MenuTypeMenu, (void *) &TruncateVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "convert"},
	{"members",
	"Members of `Truncate'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "convert"},
	{"instance",
	"Describe or delete an instance of `Truncate'",
	MenuTypeMenu, (void *) &TruncateInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "convert"},
	{"create default",
	"Create instance of `Truncate' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__Truncate_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "convert"},
	{"create",
	"Create instance of `Truncate'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__Truncate_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "convert"},
	{0}
};

MenuLine TruncateInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `Truncate'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__Truncate_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "convert"},
	{"param",
	"Describe parameters of this `Truncate'",
	MenuTypeMenu, (void *) &TruncateInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "convert"},
	{"exec",
	"Select a member of `Truncate' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "convert"},
	{"variables",
	"Describe variables of this `Truncate'",
	MenuTypeMenu, (void *) &TruncateInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "convert"},
	{"set",
	"Set variable values of this `Truncate'",
	MenuTypeMenu, (void *) &TruncateSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "convert"},
	{"delete",
	"Delete this `Truncate'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__Truncate_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "convert"},
	{0}
};

MenuLine TruncateParamMenuMenuLine[] = {
	{"Range",
	"Parameter `Range' of `Truncate' object",
	MenuTypeCommand, (void *) &DescribeParam__Truncate_Range_Rem_Call_Struct, 0, 0, HelpTextList_434, "convert"},
	{"Accuracy",
	"Parameter `Accuracy' of `Truncate' object",
	MenuTypeCommand, (void *) &DescribeParam__Truncate_Accuracy_Rem_Call_Struct, 0, 0, HelpTextList_435, "convert"},
	{"OverflowMode",
	"Parameter `OverflowMode' of `Truncate' object",
	MenuTypeCommand, (void *) &DescribeParam__Truncate_OverflowMode_Rem_Call_Struct, 0, 0, HelpTextList_436, "convert"},
	{"Round",
	"Parameter `Round' of `Truncate' object",
	MenuTypeCommand, (void *) &DescribeParam__Truncate_Round_Rem_Call_Struct, 0, 0, HelpTextList_437, "convert"},
	{0}
};

MenuLine TruncateVariableMenuMenuLine[] = {
	{"Range",
	"Changeable variable `Range' of `Truncate' object",
	MenuTypeCommand, (void *) &DescribeParam__Truncate_Range_Rem_Call_Struct, 0, 0, HelpTextList_438, "convert"},
	{"Accuracy",
	"Changeable variable `Accuracy' of `Truncate' object",
	MenuTypeCommand, (void *) &DescribeParam__Truncate_Accuracy_Rem_Call_Struct, 0, 0, HelpTextList_439, "convert"},
	{"OverflowMode",
	"Changeable variable `OverflowMode' of `Truncate' object",
	MenuTypeCommand, (void *) &DescribeParam__Truncate_OverflowMode_Rem_Call_Struct, 0, 0, HelpTextList_440, "convert"},
	{"Round",
	"Changeable variable `Round' of `Truncate' object",
	MenuTypeCommand, (void *) &DescribeParam__Truncate_Round_Rem_Call_Struct, 0, 0, HelpTextList_441, "convert"},
	{0}
};

MenuLine TruncateInstanceParamMenuMenuLine[] = {
	{"Range",
	"Parameter `Range' of `Truncate' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Truncate_STACK_Range_Rem_Call_Struct, 0, 0, HelpTextList_442, "convert"},
	{"Accuracy",
	"Parameter `Accuracy' of `Truncate' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Truncate_STACK_Accuracy_Rem_Call_Struct, 0, 0, HelpTextList_443, "convert"},
	{"OverflowMode",
	"Parameter `OverflowMode' of `Truncate' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Truncate_STACK_OverflowMode_Rem_Call_Struct, 0, 0, HelpTextList_444, "convert"},
	{"Round",
	"Parameter `Round' of `Truncate' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Truncate_STACK_Round_Rem_Call_Struct, 0, 0, HelpTextList_445, "convert"},
	{0}
};

MenuLine TruncateInstanceVariableMenuMenuLine[] = {
	{"Range",
	"Changeable variable `Range' of `Truncate' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Truncate_STACK_Range_Rem_Call_Struct, 0, 0, HelpTextList_446, "convert"},
	{"Accuracy",
	"Changeable variable `Accuracy' of `Truncate' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Truncate_STACK_Accuracy_Rem_Call_Struct, 0, 0, HelpTextList_447, "convert"},
	{"OverflowMode",
	"Changeable variable `OverflowMode' of `Truncate' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Truncate_STACK_OverflowMode_Rem_Call_Struct, 0, 0, HelpTextList_448, "convert"},
	{"Round",
	"Changeable variable `Round' of `Truncate' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__Truncate_STACK_Round_Rem_Call_Struct, 0, 0, HelpTextList_449, "convert"},
	{0}
};

MenuLine TruncateSetInstanceVariableMenuMenuLine[] = {
	{"set Range",
	"Change value of variable `Range' for an instance of `Truncate'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Truncate_STACK_Range_Rem_Call_Struct, 0, 0, HelpTextList_450, "convert"},
	{"set Accuracy",
	"Change value of variable `Accuracy' for an instance of `Truncate'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Truncate_STACK_Accuracy_Rem_Call_Struct, 0, 0, HelpTextList_451, "convert"},
	{"set OverflowMode",
	"Change value of variable `OverflowMode' for an instance of `Truncate'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Truncate_STACK_OverflowMode_Rem_Call_Struct, 0, 0, HelpTextList_452, "convert"},
	{"set Round",
	"Change value of variable `Round' for an instance of `Truncate'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__Truncate_STACK_Round_Rem_Call_Struct, 0, 0, HelpTextList_453, "convert"},
	{0}
};

MenuLine UniformNoiseNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `UniformNoise'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_UniformNoiseMainHelpDefinition, "signalT"},
	{"param",
	"Parameters of `UniformNoise'",
	MenuTypeMenu, (void *) &UniformNoiseParamMenu, 0, 0, HelpTextList_NodeParamHelp, "signalT"},
	{"variables",
	"Changeable variables of `UniformNoise'",
	MenuTypeMenu, (void *) &UniformNoiseVariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "signalT"},
	{"members",
	"Members of `UniformNoise'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "signalT"},
	{"instance",
	"Describe or delete an instance of `UniformNoise'",
	MenuTypeMenu, (void *) &UniformNoiseInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "signalT"},
	{"create default",
	"Create instance of `UniformNoise' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__UniformNoise_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "signalT"},
	{"create",
	"Create instance of `UniformNoise'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__UniformNoise_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "signalT"},
	{0}
};

MenuLine UniformNoiseInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `UniformNoise'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__UniformNoise_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "signalT"},
	{"param",
	"Describe parameters of this `UniformNoise'",
	MenuTypeMenu, (void *) &UniformNoiseInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "signalT"},
	{"exec",
	"Select a member of `UniformNoise' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "signalT"},
	{"variables",
	"Describe variables of this `UniformNoise'",
	MenuTypeMenu, (void *) &UniformNoiseInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "signalT"},
	{"set",
	"Set variable values of this `UniformNoise'",
	MenuTypeMenu, (void *) &UniformNoiseSetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "signalT"},
	{"delete",
	"Delete this `UniformNoise'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__UniformNoise_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "signalT"},
	{0}
};

MenuLine UniformNoiseParamMenuMenuLine[] = {
	{"Maximum",
	"Parameter `Maximum' of `UniformNoise' object",
	MenuTypeCommand, (void *) &DescribeParam__UniformNoise_Maximum_Rem_Call_Struct, 0, 0, HelpTextList_454, "signalT"},
	{"Minimum",
	"Parameter `Minimum' of `UniformNoise' object",
	MenuTypeCommand, (void *) &DescribeParam__UniformNoise_Minimum_Rem_Call_Struct, 0, 0, HelpTextList_455, "signalT"},
	{"ElementSize",
	"Parameter `ElementSize' of `UniformNoise' object",
	MenuTypeCommand, (void *) &DescribeParam__UniformNoise_ElementSize_Rem_Call_Struct, 0, 0, HelpTextList_456, "signalT"},
	{"Seed",
	"Parameter `Seed' of `UniformNoise' object",
	MenuTypeCommand, (void *) &DescribeParam__UniformNoise_Seed_Rem_Call_Struct, 0, 0, HelpTextList_457, "signalT"},
	{0}
};

MenuLine UniformNoiseVariableMenuMenuLine[] = {
	{"Maximum",
	"Changeable variable `Maximum' of `UniformNoise' object",
	MenuTypeCommand, (void *) &DescribeParam__UniformNoise_Maximum_Rem_Call_Struct, 0, 0, HelpTextList_458, "signalT"},
	{"Minimum",
	"Changeable variable `Minimum' of `UniformNoise' object",
	MenuTypeCommand, (void *) &DescribeParam__UniformNoise_Minimum_Rem_Call_Struct, 0, 0, HelpTextList_459, "signalT"},
	{0}
};

MenuLine UniformNoiseInstanceParamMenuMenuLine[] = {
	{"Maximum",
	"Parameter `Maximum' of `UniformNoise' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__UniformNoise_STACK_Maximum_Rem_Call_Struct, 0, 0, HelpTextList_460, "signalT"},
	{"Minimum",
	"Parameter `Minimum' of `UniformNoise' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__UniformNoise_STACK_Minimum_Rem_Call_Struct, 0, 0, HelpTextList_461, "signalT"},
	{"ElementSize",
	"Parameter `ElementSize' of `UniformNoise' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__UniformNoise_STACK_ElementSize_Rem_Call_Struct, 0, 0, HelpTextList_462, "signalT"},
	{"Seed",
	"Parameter `Seed' of `UniformNoise' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__UniformNoise_STACK_Seed_Rem_Call_Struct, 0, 0, HelpTextList_463, "signalT"},
	{0}
};

MenuLine UniformNoiseInstanceVariableMenuMenuLine[] = {
	{"Maximum",
	"Changeable variable `Maximum' of `UniformNoise' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__UniformNoise_STACK_Maximum_Rem_Call_Struct, 0, 0, HelpTextList_464, "signalT"},
	{"Minimum",
	"Changeable variable `Minimum' of `UniformNoise' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__UniformNoise_STACK_Minimum_Rem_Call_Struct, 0, 0, HelpTextList_465, "signalT"},
	{0}
};

MenuLine UniformNoiseSetInstanceVariableMenuMenuLine[] = {
	{"set Maximum",
	"Change value of variable `Maximum' for an instance of `UniformNoise'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__UniformNoise_STACK_Maximum_Rem_Call_Struct, 0, 0, HelpTextList_466, "signalT"},
	{"set Minimum",
	"Change value of variable `Minimum' for an instance of `UniformNoise'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__UniformNoise_STACK_Minimum_Rem_Call_Struct, 0, 0, HelpTextList_467, "signalT"},
	{0}
};

MenuLine UnpackWordNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `UnpackWord'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_UnpackWordMainHelpDefinition, "mux"},
	{"param",
	"Parameters of `UnpackWord'",
	MenuTypeMenu, (void *) &UnpackWordParamMenu, 0, 0, HelpTextList_NodeParamHelp, "mux"},
	{"members",
	"Members of `UnpackWord'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "mux"},
	{"instance",
	"Describe or delete an instance of `UnpackWord'",
	MenuTypeMenu, (void *) &UnpackWordInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "mux"},
	{"create default",
	"Create instance of `UnpackWord' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__UnpackWord_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "mux"},
	{"create",
	"Create instance of `UnpackWord'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__UnpackWord_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "mux"},
	{0}
};

MenuLine UnpackWordInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `UnpackWord'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__UnpackWord_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "mux"},
	{"param",
	"Describe parameters of this `UnpackWord'",
	MenuTypeMenu, (void *) &UnpackWordInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "mux"},
	{"exec",
	"Select a member of `UnpackWord' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "mux"},
	{"delete",
	"Delete this `UnpackWord'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__UnpackWord_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "mux"},
	{0}
};

MenuLine UnpackWordParamMenuMenuLine[] = {
	{"OutputWordSize",
	"Parameter `OutputWordSize' of `UnpackWord' object",
	MenuTypeCommand, (void *) &DescribeParam__UnpackWord_OutputWordSize_Rem_Call_Struct, 0, 0, HelpTextList_468, "mux"},
	{"OutputsPerInput",
	"Parameter `OutputsPerInput' of `UnpackWord' object",
	MenuTypeCommand, (void *) &DescribeParam__UnpackWord_OutputsPerInput_Rem_Call_Struct, 0, 0, HelpTextList_469, "mux"},
	{"SignedOutput",
	"Parameter `SignedOutput' of `UnpackWord' object",
	MenuTypeCommand, (void *) &DescribeParam__UnpackWord_SignedOutput_Rem_Call_Struct, 0, 0, HelpTextList_470, "mux"},
	{0}
};

MenuLine UnpackWordInstanceParamMenuMenuLine[] = {
	{"OutputWordSize",
	"Parameter `OutputWordSize' of `UnpackWord' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__UnpackWord_STACK_OutputWordSize_Rem_Call_Struct, 0, 0, HelpTextList_471, "mux"},
	{"OutputsPerInput",
	"Parameter `OutputsPerInput' of `UnpackWord' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__UnpackWord_STACK_OutputsPerInput_Rem_Call_Struct, 0, 0, HelpTextList_472, "mux"},
	{"SignedOutput",
	"Parameter `SignedOutput' of `UnpackWord' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__UnpackWord_STACK_SignedOutput_Rem_Call_Struct, 0, 0, HelpTextList_473, "mux"},
	{0}
};

MenuLine VoiceNodeNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `VoiceNode'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_VoiceNodeMainHelpDefinition, "binin"},
	{"param",
	"Parameters of `VoiceNode'",
	MenuTypeMenu, (void *) &VoiceNodeParamMenu, 0, 0, HelpTextList_NodeParamHelp, "binin"},
	{"members",
	"Members of `VoiceNode'",
	MenuTypeMenu, (void *) &SelectVoiceNodeMemberDescribe, 0, 0, HelpTextList_MemberMenuHelp, "binin"},
	{"instance",
	"Describe or delete an instance of `VoiceNode'",
	MenuTypeMenu, (void *) &VoiceNodeInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "binin"},
	{"create default",
	"Create instance of `VoiceNode' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__VoiceNode_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "binin"},
	{"create",
	"Create instance of `VoiceNode'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__VoiceNode_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "binin"},
	{0}
};

MenuLine SelectVoiceNodeMemberDescribeMenuLine[] = {
	{"DisplayHeader",
	"Describe member `DisplayHeader' of `VoiceNode'",
	MenuTypeMenu, (void *) &DisplayHeaderVoiceNodeNodeMemberMenu, 0, 0, HelpTextList_474, "binin"},
	{0}
};

MenuLine DisplayHeaderVoiceNodeNodeMemberMenuMenuLine[] = {
	{"desc DisplayHeader",
	"Describe selected member of `VoiceNode'",
	MenuTypeCommand, (void *) &MemberFunctionDescribe__VoiceNode_STACK_Rem_Call_Struct, 0, 0, HelpTextList_MemberHelp, "binin"},
	{0}
};

MenuLine VoiceNodeInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `VoiceNode'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__VoiceNode_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "binin"},
	{"param",
	"Describe parameters of this `VoiceNode'",
	MenuTypeMenu, (void *) &VoiceNodeInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "binin"},
	{"exec",
	"Select a member of `VoiceNode' to execute",
	MenuTypeMenu, (void *) &SelectVoiceNodeMemberExecute, 0, 0, HelpTextList_HelpMemberExecute, "binin"},
	{"delete",
	"Delete this `VoiceNode'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__VoiceNode_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "binin"},
	{0}
};

MenuLine SelectVoiceNodeMemberExecuteMenuLine[] = {
	{"DisplayHeader",
	"Execute selected member of `VoiceNode'",
	MenuTypeCommand, (void *) &ExecuteMemberFunction__STACK_STACK_DisplayHeader_Rem_Call_Struct, 0, 0, HelpTextList_HelpMemberExecute, "binin"},
	{0}
};

MenuLine VoiceNodeParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `VoiceNode' object",
	MenuTypeCommand, (void *) &DescribeParam__VoiceNode_FileName_Rem_Call_Struct, 0, 0, HelpTextList_475, "binin"},
	{"NoHeader",
	"Parameter `NoHeader' of `VoiceNode' object",
	MenuTypeCommand, (void *) &DescribeParam__VoiceNode_NoHeader_Rem_Call_Struct, 0, 0, HelpTextList_476, "binin"},
	{0}
};

MenuLine VoiceNodeInstanceParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `VoiceNode' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__VoiceNode_STACK_FileName_Rem_Call_Struct, 0, 0, HelpTextList_477, "binin"},
	{"NoHeader",
	"Parameter `NoHeader' of `VoiceNode' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__VoiceNode_STACK_NoHeader_Rem_Call_Struct, 0, 0, HelpTextList_478, "binin"},
	{0}
};

MenuLine VoiceStripOutNodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `VoiceStripOut'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_VoiceStripOutMainHelpDefinition, "binin"},
	{"param",
	"Parameters of `VoiceStripOut'",
	MenuTypeMenu, (void *) &VoiceStripOutParamMenu, 0, 0, HelpTextList_NodeParamHelp, "binin"},
	{"members",
	"Members of `VoiceStripOut'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "binin"},
	{"instance",
	"Describe or delete an instance of `VoiceStripOut'",
	MenuTypeMenu, (void *) &VoiceStripOutInstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "binin"},
	{"create default",
	"Create instance of `VoiceStripOut' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__VoiceStripOut_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "binin"},
	{"create",
	"Create instance of `VoiceStripOut'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__VoiceStripOut_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "binin"},
	{0}
};

MenuLine VoiceStripOutInstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `VoiceStripOut'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__VoiceStripOut_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "binin"},
	{"param",
	"Describe parameters of this `VoiceStripOut'",
	MenuTypeMenu, (void *) &VoiceStripOutInstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "binin"},
	{"exec",
	"Select a member of `VoiceStripOut' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "binin"},
	{"delete",
	"Delete this `VoiceStripOut'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__VoiceStripOut_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "binin"},
	{0}
};

MenuLine VoiceStripOutParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `VoiceStripOut' object",
	MenuTypeCommand, (void *) &DescribeParam__VoiceStripOut_FileName_Rem_Call_Struct, 0, 0, HelpTextList_479, "binin"},
	{0}
};

MenuLine VoiceStripOutInstanceParamMenuMenuLine[] = {
	{"FileName",
	"Parameter `FileName' of `VoiceStripOut' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__VoiceStripOut_STACK_FileName_Rem_Call_Struct, 0, 0, HelpTextList_480, "binin"},
	{0}
};

MenuLine ZFde0NodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `ZFde0'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_ZFde0MainHelpDefinition, "disc_fde"},
	{"param",
	"Parameters of `ZFde0'",
	MenuTypeMenu, (void *) &ZFde0ParamMenu, 0, 0, HelpTextList_NodeParamHelp, "disc_fde"},
	{"members",
	"Members of `ZFde0'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "disc_fde"},
	{"instance",
	"Describe or delete an instance of `ZFde0'",
	MenuTypeMenu, (void *) &ZFde0InstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "disc_fde"},
	{"create default",
	"Create instance of `ZFde0' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__ZFde0_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "disc_fde"},
	{"create",
	"Create instance of `ZFde0'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__ZFde0_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "disc_fde"},
	{0}
};

MenuLine ZFde0InstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `ZFde0'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__ZFde0_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "disc_fde"},
	{"param",
	"Describe parameters of this `ZFde0'",
	MenuTypeMenu, (void *) &ZFde0InstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "disc_fde"},
	{"exec",
	"Select a member of `ZFde0' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "disc_fde"},
	{"delete",
	"Delete this `ZFde0'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__ZFde0_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "disc_fde"},
	{0}
};

MenuLine ZFde0ParamMenuMenuLine[] = {
	{"Time0",
	"Parameter `Time0' of `ZFde0' object",
	MenuTypeCommand, (void *) &DescribeParam__ZFde0_Time0_Rem_Call_Struct, 0, 0, HelpTextList_481, "disc_fde"},
	{"Time1",
	"Parameter `Time1' of `ZFde0' object",
	MenuTypeCommand, (void *) &DescribeParam__ZFde0_Time1_Rem_Call_Struct, 0, 0, HelpTextList_482, "disc_fde"},
	{"Factor",
	"Parameter `Factor' of `ZFde0' object",
	MenuTypeCommand, (void *) &DescribeParam__ZFde0_Factor_Rem_Call_Struct, 0, 0, HelpTextList_483, "disc_fde"},
	{0}
};

MenuLine ZFde0InstanceParamMenuMenuLine[] = {
	{"Time0",
	"Parameter `Time0' of `ZFde0' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ZFde0_STACK_Time0_Rem_Call_Struct, 0, 0, HelpTextList_484, "disc_fde"},
	{"Time1",
	"Parameter `Time1' of `ZFde0' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ZFde0_STACK_Time1_Rem_Call_Struct, 0, 0, HelpTextList_485, "disc_fde"},
	{"Factor",
	"Parameter `Factor' of `ZFde0' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ZFde0_STACK_Factor_Rem_Call_Struct, 0, 0, HelpTextList_486, "disc_fde"},
	{0}
};

MenuLine ZFde1NodeOptMenuMenuLine[] = {
	{"help",
	"Explain the use of `ZFde1'",
	MenuTypeHelp, 0, 0, 0, HelpTextList_ZFde1MainHelpDefinition, "disc_fde"},
	{"param",
	"Parameters of `ZFde1'",
	MenuTypeMenu, (void *) &ZFde1ParamMenu, 0, 0, HelpTextList_NodeParamHelp, "disc_fde"},
	{"variables",
	"Changeable variables of `ZFde1'",
	MenuTypeMenu, (void *) &ZFde1VariableMenu, 0, 0, HelpTextList_NodeVariableHelp, "disc_fde"},
	{"members",
	"Members of `ZFde1'",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_MemberMenuHelp, "disc_fde"},
	{"instance",
	"Describe or delete an instance of `ZFde1'",
	MenuTypeMenu, (void *) &ZFde1InstancesMenu, 0, 0, HelpTextList_NodeInstanceHelp, "disc_fde"},
	{"create default",
	"Create instance of `ZFde1' with default parameters",
	MenuTypeCommand, (void *) &CreateDefaultNodeInteractiveEntity__ZFde1_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateDefaultHelp, "disc_fde"},
	{"create",
	"Create instance of `ZFde1'",
	MenuTypeCommand, (void *) &CreateNodeInteractiveEntity__ZFde1_Rem_Call_Struct, 0, 0, HelpTextList_NodeCreateHelp, "disc_fde"},
	{0}
};

MenuLine ZFde1InstanceAccessMenuMenuLine[] = {
	{"desc",
	"Describe this instance of `ZFde1'",
	MenuTypeCommand, (void *) &DescribeNodeInstance__ZFde1_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeInstanceDescribeHelp, "disc_fde"},
	{"param",
	"Describe parameters of this `ZFde1'",
	MenuTypeMenu, (void *) &ZFde1InstanceParamMenu, 0, 0, HelpTextList_ParamInstanceDescribeHelp, "disc_fde"},
	{"exec",
	"Select a member of `ZFde1' to execute",
	MenuTypeMenu, Orphan, 0, 0, HelpTextList_HelpMemberExecute, "disc_fde"},
	{"variables",
	"Describe variables of this `ZFde1'",
	MenuTypeMenu, (void *) &ZFde1InstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "disc_fde"},
	{"set",
	"Set variable values of this `ZFde1'",
	MenuTypeMenu, (void *) &ZFde1SetInstanceVariableMenu, 0, 0, HelpTextList_VariableInstanceDescribeHelp, "disc_fde"},
	{"delete",
	"Delete this `ZFde1'",
	MenuTypeCommand, (void *) &DeleteNodeInteractiveEntity__ZFde1_STACK_Rem_Call_Struct, 0, 0, HelpTextList_NodeDeleteHelp, "disc_fde"},
	{0}
};

MenuLine ZFde1ParamMenuMenuLine[] = {
	{"Factor",
	"Parameter `Factor' of `ZFde1' object",
	MenuTypeCommand, (void *) &DescribeParam__ZFde1_Factor_Rem_Call_Struct, 0, 0, HelpTextList_487, "disc_fde"},
	{"Interval",
	"Parameter `Interval' of `ZFde1' object",
	MenuTypeCommand, (void *) &DescribeParam__ZFde1_Interval_Rem_Call_Struct, 0, 0, HelpTextList_488, "disc_fde"},
	{"MaxSize",
	"Parameter `MaxSize' of `ZFde1' object",
	MenuTypeCommand, (void *) &DescribeParam__ZFde1_MaxSize_Rem_Call_Struct, 0, 0, HelpTextList_489, "disc_fde"},
	{"Time0",
	"Parameter `Time0' of `ZFde1' object",
	MenuTypeCommand, (void *) &DescribeParam__ZFde1_Time0_Rem_Call_Struct, 0, 0, HelpTextList_490, "disc_fde"},
	{"Time1",
	"Parameter `Time1' of `ZFde1' object",
	MenuTypeCommand, (void *) &DescribeParam__ZFde1_Time1_Rem_Call_Struct, 0, 0, HelpTextList_491, "disc_fde"},
	{"DoubMaxSteps",
	"Parameter `DoubMaxSteps' of `ZFde1' object",
	MenuTypeCommand, (void *) &DescribeParam__ZFde1_DoubMaxSteps_Rem_Call_Struct, 0, 0, HelpTextList_492, "disc_fde"},
	{"DiscrScheme",
	"Parameter `DiscrScheme' of `ZFde1' object",
	MenuTypeCommand, (void *) &DescribeParam__ZFde1_DiscrScheme_Rem_Call_Struct, 0, 0, HelpTextList_493, "disc_fde"},
	{0}
};

MenuLine ZFde1VariableMenuMenuLine[] = {
	{"Interval",
	"Changeable variable `Interval' of `ZFde1' object",
	MenuTypeCommand, (void *) &DescribeParam__ZFde1_Interval_Rem_Call_Struct, 0, 0, HelpTextList_494, "disc_fde"},
	{"DoubMaxSteps",
	"Changeable variable `DoubMaxSteps' of `ZFde1' object",
	MenuTypeCommand, (void *) &DescribeParam__ZFde1_DoubMaxSteps_Rem_Call_Struct, 0, 0, HelpTextList_495, "disc_fde"},
	{"DiscrScheme",
	"Changeable variable `DiscrScheme' of `ZFde1' object",
	MenuTypeCommand, (void *) &DescribeParam__ZFde1_DiscrScheme_Rem_Call_Struct, 0, 0, HelpTextList_496, "disc_fde"},
	{0}
};

MenuLine ZFde1InstanceParamMenuMenuLine[] = {
	{"Factor",
	"Parameter `Factor' of `ZFde1' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ZFde1_STACK_Factor_Rem_Call_Struct, 0, 0, HelpTextList_497, "disc_fde"},
	{"Interval",
	"Parameter `Interval' of `ZFde1' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ZFde1_STACK_Interval_Rem_Call_Struct, 0, 0, HelpTextList_498, "disc_fde"},
	{"MaxSize",
	"Parameter `MaxSize' of `ZFde1' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ZFde1_STACK_MaxSize_Rem_Call_Struct, 0, 0, HelpTextList_499, "disc_fde"},
	{"Time0",
	"Parameter `Time0' of `ZFde1' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ZFde1_STACK_Time0_Rem_Call_Struct, 0, 0, HelpTextList_500, "disc_fde"},
	{"Time1",
	"Parameter `Time1' of `ZFde1' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ZFde1_STACK_Time1_Rem_Call_Struct, 0, 0, HelpTextList_501, "disc_fde"},
	{"DoubMaxSteps",
	"Parameter `DoubMaxSteps' of `ZFde1' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ZFde1_STACK_DoubMaxSteps_Rem_Call_Struct, 0, 0, HelpTextList_502, "disc_fde"},
	{"DiscrScheme",
	"Parameter `DiscrScheme' of `ZFde1' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ZFde1_STACK_DiscrScheme_Rem_Call_Struct, 0, 0, HelpTextList_503, "disc_fde"},
	{0}
};

MenuLine ZFde1InstanceVariableMenuMenuLine[] = {
	{"Interval",
	"Changeable variable `Interval' of `ZFde1' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ZFde1_STACK_Interval_Rem_Call_Struct, 0, 0, HelpTextList_504, "disc_fde"},
	{"DoubMaxSteps",
	"Changeable variable `DoubMaxSteps' of `ZFde1' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ZFde1_STACK_DoubMaxSteps_Rem_Call_Struct, 0, 0, HelpTextList_505, "disc_fde"},
	{"DiscrScheme",
	"Changeable variable `DiscrScheme' of `ZFde1' object instance",
	MenuTypeCommand, (void *) &DescribeParamInstance__ZFde1_STACK_DiscrScheme_Rem_Call_Struct, 0, 0, HelpTextList_506, "disc_fde"},
	{0}
};

MenuLine ZFde1SetInstanceVariableMenuMenuLine[] = {
	{"set Interval",
	"Change value of variable `Interval' for an instance of `ZFde1'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__ZFde1_STACK_Interval_Rem_Call_Struct, 0, 0, HelpTextList_507, "disc_fde"},
	{"set DoubMaxSteps",
	"Change value of variable `DoubMaxSteps' for an instance of `ZFde1'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__ZFde1_STACK_DoubMaxSteps_Rem_Call_Struct, 0, 0, HelpTextList_508, "disc_fde"},
	{"set DiscrScheme",
	"Change value of variable `DiscrScheme' for an instance of `ZFde1'",
	MenuTypeCommand, (void *) &ExecuteSetParameter__ZFde1_STACK_DiscrScheme_Rem_Call_Struct, 0, 0, HelpTextList_509, "disc_fde"},
	{0}
};

AllMenus AllCgiMenus(MainCgi);
