#include <string.h>
#include <stream.h>

#include <ctype.h>

#include "debug.h"
#include "baseio.h"
#include "outtok.h"
#include "usercom.h"

#include "menu.h"
#include "menuspc.h"

static void OutMenuLine(MenuLine *ThisItem, int& i)
{
	cout << "    " << i++ <<" " << ThisItem->Line <<
		" (" << ThisItem->Command << ")\n" ;
}


static void MenuHelp(Menu&)
{
	cout << "No Help Yet.\n" ;
	ReturnToContinue(OutputHelp) ;
}


DoMenuReturn MenuDriver(Menu& ThisMenu,const char * GotHere, 
	GenericOptions& Gen,const char * Input)
{
	// LogOut << "MenuDriver - entry\n" ;
	DoMenuReturn ReturnValue ;
	ThisMenu.GetMenuLine(MenuInit);
	// LogOut << "MenuDriver - after GetMenuLine\n" ;
	MenuLine * ThisItem ;
	int i = 1;
	while (ThisItem = ThisMenu.GetMenuLine()) i++ ;
	//	OutMenuLine(ThisItem,i);
	//	int j = 0;
	//	while (Gen.Lines[j++].Command) i++ ;
	//	OutMenuLine(Gen.Lines+j++,i);
	// LogOut << "Before DoMenuItem\n" ;
	ReturnValue=DoMenuItem(ThisMenu,GotHere,i,Gen,Input) ;
	// LogOut << "After DoMenuItem\n" ;
	switch (ReturnValue) {
case DoMenuPrevious:
		return DoMenuCurrent ;
case DoMenuMain:
		return DoMenuMain ;
case DoMenuHelp:	
		MenuHelp(ThisMenu) ;
		return DoMenuCurrent ;
case DoMenuCurrent: 
		return DoMenuCurrent ;
default:
		DbgError("MenuDriver", "invalid DoMenuItem return");

	}
	return DoMenuCurrent ; // dummy to avoid compiler warning
}

void DoMainMenu()
{
	cout << "DSP++\n\nProviding Elegant Solutions\n" <<
		"For DSP System Design and Implementation\n\n" ;
	cout << "Copyright 1989 Mountain Math Software\n" ;
	cout << "All Rights Reserved\n" ;
	ReturnToContinue(OutputHelp) ;
	for (;;) (void) MenuDriver(*(TheCurrentMenus->GetMainMenu()),"",
		GenericMain);
}


