#include "ObjProGen/cpyrght_exe.h"
#include <stream.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

void main()
{
	const buf_size = 4096 ;
	char buf[buf_size] ;
	int not_found = 1 ;
	const char * bounding_box = "%%BoundingBox:" ;
	int length = strlen(bounding_box);
	while (fgets(buf,buf_size,stdin)) {
		if (not_found) if(!strncmp(buf,bounding_box,length)) {
			not_found = 0 ;
			fprintf(stdout,"%s 0 0",bounding_box);
			int numbers_read = 0 ;
			int reading_number = 0 ;
			for (const char * pt = buf + length; *pt ;pt++) {
				if (isdigit(*pt)) reading_number = 1;
				else if (*pt == ' ' || *pt == '\n') {
					if (reading_number) numbers_read++;
					reading_number = 0;
				} else {
					numbers_read = -1 ;
					break ;
				}
				if (numbers_read > 1) fputc(*pt,stdout);
			}
			if (numbers_read != 4) {
				cerr << "Bad bounding box line.\n" ;
				exit(1);
			}
			continue ;
		}
		fputs(buf,stdout);
	}
	if (not_found) {
		cerr << "No bounding box found.\n" ;
		exit(1);
	}
	exit(0);	
}
