/*
 *  domenus.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  domenus.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#ifndef DOMENUS_DOT_H
#define DOMENUS_DOT_H
#include "mentyp.h"

struct ParameterizedAction ;
class MenuItemList ;
class MenuItem ;
class ConstStringList ;
class TextFragmentList ;
class Compound ;
struct HelpText ;

struct InitValue {
	int Type ;
	ParameterizedAction * Action ;
	InitValue(int t, ParameterizedAction *act) {Type = t; Action = act;}
} ;

union Value {
	const char * Name;
	int Token ;
	MenuItemList * List ;
	MenuItem * Item ;
	ConstStringList * Strings ;
	InitValue * Init ;
	ParameterizedAction * Action;

	Value(const char *nm)		{Name =nm;}
	Value(int Tk)			{Token =Tk;}
	Value(MenuItemList * Lst)	{List = Lst;}
	Value(MenuItem * It)		{Item=It;}
	Value(ConstStringList * StrList)
					{Strings = StrList;}
	Value(InitValue * init) 	{Init = init;}
	Value(ParameterizedAction * action)
					{Action = action;}
} ;



void Menu(MenuType Type, Value *,Value *, Value *, Value *) ;
void Conflict(Value *,Value *,Value *) ;
void MenuAddition(Value *Menu, Value * ItemList);

Value * StartItemList() ;

Value * MakeValue (int) ;
Value * MakeValue (const char *) ;

// void FoundInitCode(TextFragmentList *Code);
Value * FoundItemRef(Value  *Cmd);
Value * MakeNullValue();
Value * FirstConflict(Value *) ;

void SetUserCopyright();
void NoUserCopyright();

Value * MakeMenuInit(Compound *,int) ;
void MainEntry(Value *, Value *) ;
void DefinedName(Value * Name) ;
// void DefinedMenuName(Value * Name) ;
void FoundHelpDef(const char * Name, TextFragmentList * );
void FoundInclude(int Type, const char * FileName);

extern ConstStringList TheDefinedHelpTextNames ;
extern ConstStringList TheDefinedHelpReferences ;
extern ConstStringList * TempCmdList ;

const char * MakeHelpTextName(const char * Suffix = 0) ;
void NewHelpFileName( const char * Name) ;
HelpText * MakeHelpList (TextFragmentList * Text, const char * Suffix = 0) ;

extern ostream * Herr ; 	// Help file error messages written separately
				// on a temporary basis

const char * RemFile(const char * name) ;
const char * LocFile(const char * name) ;

ostream * OpenFile(const char * Name);

inline ostream * OpenRemFile(const char * name)
{
	return OpenFile(RemFile(name));
}

inline ostream * OpenLocFile(const char * name)
{
	return OpenFile(LocFile(name));
}

#endif /* #ifdef DOMENUS_DOT_H */
