/*  menmain.C   */
/*  Copyright 1991 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "ObjProGen/cpyrght_exe.h"
#include <stdlib.h>
#include <fstream.h>
#include <string.h>
#include <unistd.h>
#include <stream.h>
#include "menmain.h"
#include "mendir.h"
#include "stdyac.h"
#include "texmenu.h"
#include "menustr.h"
#include "mkstr.h"
#include "cgidbg.h"
#include "yacio.h"
#include "texmenu.h"



const char * const Suffix = ".menu" ;

const char * TeXDirectory = 0 ;

void TeXProcess()
{
	static DynamicMenusToPrint DynamicPrint[] = {
		{"AddNodeOptMenu","Add"},
		{"InputNodeNodeOptMenu","InputNode"},
		{0,0}
	};
	static const ForceSectionLevel ForcedLevels[] = {
		{"AllCls",1},
		{0,0}
	};
	if (!TeXDirectory) return ;
	char * Temp = RemoveSuffix(CurrentFileName,Suffix);

	char * BaseName = ReplaceDirectory(TeXDirectory,Temp) ;
	delete Temp ;
	Temp = 0 ;
	
	TheTeXMenus = new TeXMenus(TheMenuDefs, DynamicPrint,ForcedLevels);

	// base.cls
	char * FileName = AddSuffix(BaseName,".cls");
	{
			ofstream Out(FileName);
			add_copyright_notice(FileName,Out);
			TheTeXMenus->TeXPrintClassHierarchy(Out);
	}

	// base.men
	delete FileName ;
	FileName = AddSuffix(BaseName,".men");
	{	
		ofstream Out(FileName);
		add_copyright_notice(FileName,Out);
		TheTeXMenus->TeXPrintMenuFile(Out);
	}

/*
 *	// base.ref
 *	delete FileName ;
 *	FileName = AddSuffix(BaseName,".ref");
 *	{
 *		ofstream Out(FileName);
 *		TheTeXMenus->TeXPrintMenuRefFile(Out);
 *	}
 *
 */
	// base.cmd
	delete FileName ;
	FileName = AddSuffix(BaseName,".cmd");
	{
		ofstream Out(FileName);
		add_copyright_notice(FileName,Out);
		cerr << "Print Command Ref File\n" ;
		TheTeXMenus->TeXPrintCommandRefFile(Out);
	}
	delete FileName ;
	// delete BaseName ;
}

static void Usage(const char * Cmd, int ExitCode=0)
{
	if (ExitCode) cerr << "Invalid command line.\n" ;
	cerr << " Usage is: " << Cmd <<
		" [-r][-l][-u UsrIncludeDir][-t TeXDirectory] File\n" ;
	cerr << " In addition -d enables yacc debugging.\n" ;
	exit(ExitCode);
}

#ifdef YYDEBUG
extern int yydebug ; // Yacc debugging flag.
#else
static int yydebug ;
#endif

void main(int argc, char ** argv)
{
	yydebug = 0 ;
	SetNewHandler();
	int c;
	int errflg = 0;
	if (argc < 2) Usage(argv[0]);
	while (( c = getopt(argc,argv,"drlu:t:")) != EOF) switch(c) {
case 'l' :	RemoteFileFlag = 0;
		break ;
case 'r' :	LocalFileFlag = 0;
		break ;
case 'd' :
		yydebug = 1 ;
		break ;
case 't' :
		if (TeXDirectory) errflg ++ ;
		else TeXDirectory = optarg ;
		break ;
case 'u':
		if (!UsrInc) {
			UsrInc = optarg ;
			break ;
		}
default:
		errflg++;
		break ;
	}
	if (errflg) Usage(argv[0],1);
	int OneName = 0;
	for (; optind < argc; optind++) {
		if (OneName) {
			cerr << "Only one input file is allowed.\n" ;
			Usage(argv[0],1);
		}
		OneName = 1;
/*
 *		char * InputFileName = new char[strlen(argv[optind])+1];
 *		strcpy(InputFileName,argv[optind]);
 */
		char * InputFileName = ForceSuffix(argv[optind],Suffix);
	
		FILE * Temp = freopen(InputFileName,"r",stdin);
		if (!Temp) {
			cerr << "Cannot open input file `" << InputFileName <<
				"'\n" ;
			exit(2);
		}
		CurrentFileName = InputFileName ;
	}
	Process();
}

