/*  menuprsy.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <string.h>
#include <stream.h>
#include "menuprsy.h"
#include "y.tab.h"
#include "debug.h"
#include "domenus.h"
#include "menustr.h"
#include "classrel.h"
#include "mkstr.h"

#define INIT_DEFAULT_HELP "_DF"

char * the_help_default_file = INIT_DEFAULT_HELP ;

void FoundHelpDefaultFile(const char * name)
{
	the_help_default_file = Concatenate(name) ;
	NewHelpFileName(the_help_default_file);
}

Value * AddToWordString(Value * WordString,const char * Str,int NotConcat)
{
	const char * OldString = WordString->Name ;
	char * Expanded = new char [strlen(OldString)+strlen(Str)+1+NotConcat];
	strcpy(Expanded,OldString);
	if (NotConcat) strcat(Expanded," ");
	strcat(Expanded,Str);
	delete (char *) OldString;
	WordString->Name = Expanded;
	return WordString ;
}


Value * CreateWordString(const char * Str)
{
	return new Value(Str);
}


Value * ConcatWordString(Value * WordString, int chr )
{
	char Dum[2];
	Dum[0] = chr ;
	Dum[1] = '\0' ;
	return AddToWordString(WordString,Dum,0);
}

const char * GetNodeName(const char * TheName, const char * Prefix,
	const char * Suffix)
{
	// cout << "GetNodeName(" << TheName << ", " << Prefix << ", "
	//	<< Suffix << ")\n" ;
	if (!TheName) return 0;
	int PreLength = 0 ;
	if (Prefix) {
		PreLength = strlen(Prefix);
		if (strncmp(Prefix,TheName,PreLength)) return 0;
	}
	int SufLength = 0;
	int Length = strlen(TheName);
	if (Suffix) {
		SufLength = strlen(Suffix);
		if (strcmp(TheName+Length-SufLength,Suffix)) return 0;
	}

	int NodeNameLength = Length - SufLength - PreLength ;
	if (NodeNameLength < 1) return 0;

	const int BufSize = 128;
	static char buf[BufSize+1] ;
	if (NodeNameLength > BufSize) DbgError("GetNodeName", "too long");
	strncpy(buf,TheName+PreLength,NodeNameLength);
	buf[NodeNameLength] = '\0' ;
	return buf ;
}

const char * GetNodeNameFromAction(const char * TheName)
{
	const char * Return = GetNodeName(TheName,"Select","MemberDescribe");
	if (!Return) Return = GetNodeName(TheName,"Select","MemberExecute");
	return Return ;
}


void FoundClassRelation(const char * Derived, const char * Base)
{
	
	ClassRelation * Rel = new ClassRelation(Derived,Base);
	TheClassRelations.SetCurrentClass(Rel);
	TheClassRelations.Append(Rel);
}

int SkipAnItem(MenuItem * AnItem, const char * MenuName)
{
// Skip "SelectXXXXMemberDescribe=Menu" and  "SelectXXXXMemberExecute=Menu"
// if there are no direct or base class member functions of XXXXX
	if (!AnItem) return 1;
	// cout << "SkipAnItem called for `" << AnItem->GetCommand() << "\n" ;
	if (!AnItem->GetAction()) return 1;
	int ActionType = AnItem->GetActionType();
	if (ActionType != NEW_MENU && ActionType != DYNAMIC_MENU ) return 0 ;
	const char * TheName = AnItem->GetAction()->Name;
	const char * NodeName = 0;
	if (!strcmp(TheName,"Orphan")) {
		NodeName = GetNodeName(MenuName, 0,"NodeOptMenu");
		if (!NodeName) NodeName = GetNodeName(MenuName,0,
			"InstanceAccessMenu");
	} else NodeName = GetNodeNameFromAction(TheName);
	if (!NodeName) return 0;
	return !TheClassRelations.DoesClassHaveMembers(NodeName);
}

