/*
 *  domknode.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  domknode.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#ifndef DOMKNODE_DOT_H
#define DOMKNODE_DOT_H
#include "slist.h"
#include "portable.h"


class TextFragmentList ;
class MemberFunction ;
struct NodeParameter ;
class MofStream ;
class OutTokens ;

enum ItemType {TypeInt, TypeDouble, TypeString, TypeName, TypeText,
	TypeTerm, TypeCompound, TypeDescription, TypeList, TypeParamFunc,
	TypeParameter, TypeSize, TypeScaledType} ;

struct Description {
	TextFragmentList * HelpLine ;
	TextFragmentList * Full ;
	const char * HelpFileName ;
	const char * MenuName ;
	Description (TextFragmentList * menu, TextFragmentList * full,
		const char * menu_name = 0, const char * Help=0)
		{HelpLine = menu; Full = full; MenuName = menu_name;
		HelpFileName = Help;}
	~Description() ;
	void SetHelpFileName(const char * Name) {HelpFileName = Name;}
	void SetMenuName(const char * Name) {MenuName = Name;}
	void SetFullDescription(TextFragmentList * full) { Full = full;}
};

struct Double {
	double Value ;
	const char * String ;
	Double(double value, const char * string) {Value=value; String=string;}
	~Double() {delete[] (void *) String;}
	void Negate();
	void EmitValue(class MofStream * Out) const ; 
} ;

struct ParameterFunction {
	class CompoundList * NameList ;
	TextFragmentList * Code ;
	ParameterFunction (CompoundList * list, TextFragmentList * code)
		{NameList = list ; Code = code ;}
	~ParameterFunction() ;
};

struct ArraySize {
	int32 Lower ;
	int32 Upper ;
	ArraySize(int32 l = 1, int32 u = 0) {Lower =l; Upper = u;}
	// 0 indicates NO limit specified and not limit of 0 for Upper!
};

struct ScaledType {
	int ChangeableFlag;
	int Type ;
	struct Double * Value ;
	ScaledType(int typ, Double * dbl, int flg) {Type = typ; Value = dbl;
		ChangeableFlag = flg;}
};

union Object {
	const char * Str ;
	int32 Int ;
	Double * Dbl ;
	int Terminal ;
	struct Compound * Tree ;
	Description * Desc ;
	class TextFragmentList * Text ;
	class CompoundList * List ;
	ParameterFunction * ParamFunc ;
	ArraySize * Size ;
	ScaledType * TheScaledType ;
	NodeParameter * TheParameter ;
	Object(const char * str) {Str = str;}
	Object(int32 num) {Int = num;}
	Object(Double * flt) {Dbl = flt;}
	Object(Compound *cmpd) {Tree = cmpd;}
	Object(Description *desc) {Desc = desc;}
	Object(TextFragmentList *text){Text = text;}
	Object(CompoundList * list) {List = list;}
	Object(ParameterFunction * param) {ParamFunc = param;}
	Object(ArraySize * s) {Size = s;}
	Object(ScaledType * ScT) {TheScaledType = ScT;}
	Object(NodeParameter * Param) {TheParameter = Param;}
	Object(){}
} ;

struct Compound {
	ItemType Type ;
	Object Item ;
	Compound(ItemType typ, Object item) {Type=typ; Item=item; }
	~Compound();
	void EmitValue(MofStream * Out) const ;
	void ExpOut(MofStream * Out) const ;
	void TeXOut(OutTokens& Out, int Type);
	int IsValueDefined() ;
	void TeXOutList(OutTokens& Out) ;
} ;

class CompoundList: public SingleList {
public:
	ErrCode Insert(Compound *nt) {return SingleList::Insert(nt);}
	ErrCode Append(Compound *nt) {return SingleList::Append(nt);}
	Compound * Get()   {return (Compound *) SingleList::Get();}
	Compound * Pop() {return (Compound *) SingleList::Pop();}
	Compound * GetNFromTop(int N) ;
	Compound * GetNthEntry(int N) ;
	CompoundList(){}
	CompoundList(Compound * obj) {Append(obj);}
	~CompoundList();
	int Size(){return SingleList::Size();}
} ;

class CompoundListIterator: public SingleListIterator {
public:
	CompoundListIterator(CompoundList& df):
		SingleListIterator((SingleList&) df){}
	Compound * operator()()
		{return (Compound *) Next();}
};


void SetNodeParameterInstanceRemoteFunctionOut(
	const char * SetNodeInstance, const char * ParamName) ;
void DescribeNodeInstanceRemoteFunctionOut(const char * DescribeNodeInstance);
void DescribeNodeParameterInstanceRemoteFunctionOut(const char *, const char *);
void EmitNodeDescribeGeneric() ;

extern int GlobalFlag ;

extern char * HeaderName;
extern const char * NodeName ;

enum InitFlagType
	{DataDecType,DataPhonyDecType,DataDecEnumType,DataDecPrefixType};
// DataDecType -	string that declares object
// DataPhoneDecType -	declaration that allows array initialization
// DataDecEnumType -	type from enum DecType in `yachead.h'.

const char * WhatTypeString(int Type, enum InitFlagType InitFlag=DataDecType) ;
const char * WhatTypeString(NodeParameter * Param,int AlwaysPtr=0) ;
const char * TeXOutType(NodeParameter * Param) ;

extern MemberFunction * TheNodeCtor ;

int IsVoidNumericType(NodeParameter * Param) ;
int IsVoidNumericType(int Type) ;
const char * DecTypeSuffix(int Token) ;

enum OutputFile {OutputHeader,OutputCpp,OutputEnd};

void EmitCode(TextFragmentList * code, OutputFile FileType) ;

const char * TypePrefix(int Type) ;
const char * GetOneParType(int Type) ;

void EmitCppCode(TextFragmentList *code) ;

int32 GetDefaultArraySize(NodeParameter * Param) ;
void EmitScaledValue(Compound * Value, const char * StrScaleFac, int Type) ;
void EmitScaledValue(Compound * Value) ;
void EmitQuotedHelpLine(MofStream& Out,TextFragmentList * Text) ;
void TextOut (TextFragmentList * Text) ;
extern int NetworkRefFlag ;

extern const char * InteractiveEntityListName ;

extern const char * InputFileNameBase ;
const char * GetBaseClassName() ;
int CheckBase(const char *WhatFound) ;

extern int user_copyright_flag ;

#endif /* #ifdef DOMKNODE_DOT_H */
