/* this file is a part of amp software, (C) tomislav uzelac 1996,1997
*/

/* audio.c  main amp source file 
 *
 * Created by: tomislav uzelac  Apr 1996 
 * Last modified by: tomislav uzelac  Mar  1 97
 */ 
#include <unistd.h>

#ifdef A_SIF_LINUX
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <linux/soundcard.h>
#endif /* A_SIF_LINUX */

#ifdef A_SIF_ULTRA
#include <sys/types.h>
#include <sys/stropts.h>
#include <fcntl.h>
#include <sys/audioio.h>
#endif /* A_SIF_ULTRA */

#define AUDIO
#include "audio.h"
#include "formats.h"
#include "getbits.h"
#include "huffman.h"
#include "layer3.h"

int main(int argc,char **argv)
{
struct AUDIO_HEADER header;
int cnt=0;

/* process command line arguments
*/
        args(argc,argv);
 
/* print a warm, friendly message
*/
	if (!A_SUPRESS_STDOUT) {
		printf(" amp %d.%d.%d, (C) Tomislav Uzelac 1996,1997\n",MAJOR,MINOR,PATCH);
		printf(" THIS PROGRAM COMES WITH ABSOLUTELY NO WARRANTY\n");
		printf(" PLEASE READ THE DOCUMENTATION FOR DETAILS\n\n");
	}

/* initialize huffman tables, this is clumsy and should go away
*/
	huffman_init();

/* initialize globals
*/
	append=data=nch=0;

/* make room for the wave header if needed
*/
	if (A_FORMAT_WAVE) wav_begin();

/* _the_ loop
 */
	for (cnt=0;;cnt++) {
		if (A_SHOW_CNT /* && !(cnt%10)*/ ) {
			printf("\r {%d} ",cnt);
			fflush(stdout);
		}
	 	/* getbits funcs expect first four bytes after BUFFER_SIZE have same contents
		 * as the first four bytes of the buffer. fillbfr() normally takes care of
		 * this when it hits the end of the buffer, but not this first time
		 */
		if (cnt==1) memcpy(&buffer[BUFFER_SIZE],buffer,4); 

		if (gethdr(&header)) {
			if (A_FORMAT_WAVE) wav_end(&header);
			if (!A_SUPRESS_STDOUT) printf(" thank you for using amp!\n");
			exit(0);

			/* this message should appear if we didn't reach the end of the file
			*/
			if (!A_SUPRESS_STDOUT) {
				printf(" amp encountered a synchronization error\n");
				printf(" sorry.\n");
			}
			exit(-1);
		} 

		if (!cnt && A_WRITE_TO_AUDIO) {
#ifdef A_SIF_LINUX
		int play_precision=16;
		int play_stereo;
		int play_sample_rate=t_sampling_frequency[header.ID][header.sampling_frequency];
			if (header.mode==3) play_stereo=0;
			else play_stereo=1;
			if ( ioctl(audio_fd, SNDCTL_DSP_SAMPLESIZE,&play_precision) ||
			     ioctl(audio_fd, SNDCTL_DSP_STEREO, &play_stereo) ||
			     ioctl(audio_fd, SNDCTL_DSP_SPEED, &play_sample_rate)) {
				if (!A_SUPRESS_STDOUT) printf(" could not open /dev/dsp. exiting\n");
				exit(-1);
			}
#endif /* A_SIF_LINUX */
#ifdef A_SIF_ULTRA
		audio_info_t auinfo;
			printf("GI=%d\n",ioctl(audio_fd,AUDIO_GETINFO,&auinfo));
			auinfo.play.sample_rate=t_sampling_frequency[header.ID][header.sampling_frequency];
			if (header.mode==3) auinfo.play.channels=1;
			else auinfo.play.channels=2;
			auinfo.play.precision=16;
			auinfo.play.encoding=AUDIO_ENCODING_LINEAR;
			auinfo.play.gain=230;
			printf("SI=%d\n",ioctl(audio_fd,AUDIO_SETINFO,&auinfo));
#endif /* A_SIF_ULTRA */
		}
			
		if (layer3_frame(&header)) {
			if (!A_SUPRESS_STDOUT) printf(" error. blip.\n");
			exit(-1);
		} 
	}
}

static inline void args(int argc,char **argv)
{
/* if the number of these variables gets out of hand, convert them to flags
 * variables without A_ prepended don't have an option letter assigned, but
 * you could do so within this func. (they work otherwise)
 */
	SHOW_HEADER=SHOW_HEADER_DETAIL=FALSE;
	SHOW_SIDE_INFO=SHOW_SIDE_INFO_DETAIL=FALSE;
	SHOW_MDB=SHOW_MDB_DETAIL=FALSE;
	SHOW_HUFFMAN_ERRORS=FALSE;
	SHOW_HUFFBITS=FALSE;
	SHOW_SCFSI=SHOW_BLOCK_TYPE=SHOW_TABLES=SHOW_BITRATE=FALSE;

	A_DUMP_BINARY=FALSE;
	A_SUPRESS_STDOUT=FALSE;
	A_FORMAT_WAVE=FALSE;
	A_SHOW_CNT=FALSE;
	A_WRITE_TO_FILE=TRUE;
	A_WRITE_TO_AUDIO=FALSE;

	if (argc >= 2) {
		while (1) {
			int c=getopt(argc,argv,"scwdp");
			if (c==-1) break;
			switch (c) {
				case 's': A_SUPRESS_STDOUT=TRUE; break;
				case 'c': A_SHOW_CNT=TRUE; break;
				case 'w': A_FORMAT_WAVE=TRUE; break;
				case 'd': A_DUMP_BINARY=TRUE; break;
				case 'p': A_WRITE_TO_AUDIO=TRUE;A_WRITE_TO_FILE=FALSE;break;
				case '?': printf(" unrecognized option -%c\n",c);
			}
		}
		if ((in_file=fopen(argv[optind],"r"))==NULL) {
			printf("error opening infile, optind=%d arg=%s",optind,argv[optind]);
			exit(-1);
		}
 		if (A_WRITE_TO_FILE) if ((out_file=fopen(argv[optind+1],"w"))==NULL) {
			printf("error opening outfile, optind=%d arg=%s",optind,argv[optind+1]);
			exit(-1);
		}
		if (A_WRITE_TO_AUDIO) {
#ifdef A_SIF_LINUX
			if ((audio_fd = open ("/dev/dsp", O_WRONLY, 0)) == -1) {
				printf(" unable to open the audio device\n");
				exit(-1);
			}
#endif /* A_SIF_LINUX */
#ifdef A_SIF_ULTRA
			if ((audio_fd = open("/dev/audio",O_RDWR))==-1) {
				printf(" unable to open the audio device\n");
				exit(-1);
			}
#endif /* A_SIF_ULTRA */
			}
 	} else {
		printf(" usage: amp [options] [ MPEG audio bitstream ] [ wave file ]\n");
		printf(" -s	supress writing to stdout\n");
		printf(" -c	display a frame counter\n");
		printf(" -w	write a wave file\n");
		printf(" -d	dump binary data to stdout\n");
		printf(" -p	play the file directly\n");
		printf("\n");
		exit (0);
	}  	
}
