
#
#  @(#) configuration.sh 1.5, last edit: 2/17/94 18:21:44
#  @(#) Copyright (C) 1993, 1994 Tobias Bading (bading@cs.tu-berlin.de)
#  @(#) Berlin University of Technology
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

###*** Please modify the entries for your machine: ***###
# please execute "make clean" after changing some values, then execute "make"
case `uname -sr` in
  "IRIX 4.0.5F")
     COMPILER=g++
     COMPILERFLAGS='-O2 -Wall -DIRIX -DIndigo'
     INCLUDEDIRS='-I/homes/cadillac/bading/IRIX/g++-include -I/homes/cadillac/bading/IRIX/include'
     LIBRARIES=-laudio
     AUDIO_INCLUDES='#include <audio.h>' ;;
  "SunOS 5.2")
     COMPILER=g++
     COMPILERFLAGS='-O2 -Wall -DSolaris -DSPARC'
     INCLUDEDIRS='-I/usr/gnu/lib/g++-include -I/usr/gnu/lib/gcc-lib/sol2/2.5.4/include'
     LIBRARIES=
     AUDIO_INCLUDES='#include <sys/audioio.h>' ;;
  "SunOS 4.1.3")
     COMPILER=g++
     COMPILERFLAGS='-O2 -Wall -DSunOS -DSPARC'
     INCLUDEDIRS='-I/usr/gnu/lib/g++-include -I/usr/gnu/lib/gcc-lib/sparc-sun-sunos4.1/2.5.1/include'
     LIBRARIES=
     AUDIO_INCLUDES='#include <sun/audioio.h>' ;;
  "ULTRIX 4.2")
     COMPILER=g++
     COMPILERFLAGS='-O2 -Wall -DULTRIX -DDEC -DDAMN_INTEL_BYTE_ORDER'
     INCLUDEDIRS='-I/usr/gnu/lib/g++-include -I/usr/gnu/lib/gcc-lib/decstation/2.5.8/include'
     LIBRARIES=
     AUDIO_INCLUDES= ;;
  *) echo "This programm has not been tested on your type of machine yet!"
     echo "Please modify the file configuration.sh according to your needs!"
     exit
esac

export COMPILER COMPILERFLAGS INCLUDEDIRS LIBRARIES

if [ ! -f makedepend_done ]; then
  echo $AUDIO_INCLUDES >audio_includes.h
  if make depend; then
    touch makedepend_done
  else
    rm -f makedepend_done
    exit 1;
  fi
fi
make all
