// Input.CC

#include "bbitstream.h"

/************************/
/* Input bitstrem class */
/************************/
bool Bufferinputbitstream::openfile(char *filename)
{
  bitindex=point=buffersize=0;

  if(filename==NULL)fp=stdin;
  else if((fp=fopen(filename,"r"))<0)
  {
    errorcode=BBITSTREAM_ERROR_OPENFAIL;
    return false;
  }

  return true;
}

int Bufferinputbitstream::getbytedirect(void)
{
  int c;

  if((c=getc(fp))<0)
  {
    errorcode=BBITSTREAM_ERROR_READFAIL;
    fclose(fp);fp=NULL;

    return -1;
  }

  return c;
}

bool Bufferinputbitstream::readbuffer(int size)
{
  if(fread(buffer,size,1,fp)!=1)
  {
    errorcode=BBITSTREAM_ERROR_READFAIL;
    fclose(fp);fp=NULL;
    return false;
  }
  buffersize=size;
  point=0;
  return true;
}

int Bufferinputbitstream::getbyte(void)
{
  if(point<buffersize)
    return (unsigned char)buffer[point++];
  errorcode=BBITSTREAM_ERROR_READFAIL;
  return -1;
}

#ifndef WORDS_BIGENDIAN
#define _KEY 0
#else
#define _KEY 3
#endif

int Bufferinputbitstream::getbits(int bits)
{
  int c;

  u.store[1]=u.store[2]=u.store[3-_KEY]=0;

  while(bits)
  {
    if(!bitindex)                    // Charge
    {
      if((c=getbyte())==-1)return -1;
      u.store[_KEY]=c;
      bitindex=8;
    }

    if(bits>=bitindex)
    {
      u.current<<=bitindex;
      bits-=bitindex;
      bitindex=0;
    }
    else
    {
      u.current<<=bits;
      bitindex-=bits;
      bits=0;
    }
  }

  return (u.current>>8);
}
