/* Splay Version 0.3

   Copyright (C) 1997 by Jung woo-jae */

// It's an example of using MPEG/WAVE Sound library

// Anyone can use MPEG/WAVE Sound library under GPL

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#include <mpegsound.h>

static char *Sounderrors[SOUND_ERROR_UNKNOWN]=
{ "Failed to open sound device.",
  "Sound device is busy.",
  "Buffersize of sound device is wrong.",
  "Sound device control error.",

  "Failed to open file for reading.",
  "Failed to read file.",

  "Memory is not enough.",
  "Unexpected EOF.",
  "Bad sound file format.",

  "Cannot make thread.",

  "Unknown error.",
};

static int verbose=0;
static const char *package=PACKAGE;
static const char *version=VERSION;
static char *devicename=NULL;
static char *progname;
static bool forcetomonoflag=false;

#ifdef PTHREADEDMPEG
static int threadstore=0;
#endif

inline void error(int n)
{
  fprintf(stderr,"%s: %s\n",progname,Sounderrors[n-1]);
  return;
}

#ifdef PTHREADEDMPEG
void playingthread(Mpegfileplayer *player)
{
  if(player->geterrorcode()>0)error(player->geterrorcode());
  else
  {
    player->setforcetomono(forcetomonoflag);
    player->playingwiththread(verbose-1,threadstore);
    if(player->geterrorcode()>0)error(player->geterrorcode());
  }
}
#endif

void playing(Fileplayer *player)
{
  if(player->geterrorcode()>0)error(player->geterrorcode());
  else
  {
    player->setforcetomono(forcetomonoflag);
    player->playing(verbose-1);
    if(player->geterrorcode()>0)error(player->geterrorcode());
  }
}

void play(char *filename)
{
  Fileplayer *player;

  if(verbose)
    fprintf(stderr,"%s: \n",filename);
  if(strstr(filename,".mp") || strstr(filename,".MP"))
  {
    player=new Mpegfileplayer;
    player->openfile(filename,devicename);
#ifdef PTHREADEDMPEG
    playingthread((Mpegfileplayer *)player);
#else
    playing(player);
#endif
  }
  else
  {
    player=new Wavefileplayer;
    player->openfile(filename,devicename);
    playing(player);
  }
  delete player;
}

int main(int argc,char *argv[])
{
  bool shuffle=false;
  int c;

  progname=argv[0];
  if(argc<2)
  {
    printf("%s %s"
#ifdef PTHREADEDMPEG
	   " with pthread"
#endif
	   "\n"
	   "Usage : splay [-msvMVW] [-d device] "
#ifdef PTHREADEDMPEG
	   "[-t number] "
#endif
	   "files ...\n"
	   "\n"
	   "\tif filename contains \".mp\" or \".MP\",  MPEG player\n"
	   "\tothers, Wave player\n\n"
	   " -m : force to mono\n"
	   " -s : shuffle play\n"
	   " -v : verbose, Very verbose\n"
	   " -M : playing mpeg as standard input\n"
	   " -W : playing wave as standard input\n"
	   " -V : show version\n"
	   " -d device : play raw data(Not wave format) to device\n"
	   "             default : /dev/dsp\n"
	   "\t\tIf first character of devicename \'/\',\n"
	   "\t\t\tregard device,\n"
	   "\t\tIf first character of devicename \'-\',\n"
	   "\t\t\tregard standard output,\n"
	   "\t\tOtherwise, regard general file.\n"
#ifdef PTHREADEDMPEG
	   " -t number : Making thread and\n"
	   "             store a number of frames before playing\n"
	   "             If number is less than 20, no thread\n\n"
#endif
	   ,package,version);
    return 0;
  }

  while((c=getopt(argc,argv,"d:msvMVWt:"))>=0)
  {
    switch(c)
    {
      case 'm':forcetomonoflag=true;break;
      case 'M':
	{
	  Mpegfileplayer player;

	  player.openfile(NULL,devicename);
	  playing(&player);
	}break;
      case 'W':
	{
	  Wavefileplayer player;

	  player.openfile(NULL,devicename);
	  playing(&player);
	}break;
      case 'v':verbose++;break;
      case 'd':devicename=optarg;break;
#ifdef PTHREADEDMPEG
      case 't':
	sscanf(optarg,"%d",&threadstore);
	break;
#endif
      case 's':shuffle=true;break;
      case 'V':printf("%s %s"
#ifdef PTHREADEDMPEG
		      " with pthread"
#endif
		      "\n",package,version);exit(0);
      default:fprintf(stderr,"Bad argument.\n");
    }
  }

  if(shuffle && optind<argc)
  {
    int *list;
    int listsize=argc-optind;

    if((list=(int *)malloc(listsize*sizeof(int))))
    {
      int i,j=0;
      time_t t;

      if(verbose)
	fprintf(stderr,"Shuffle play\n");

      for(i=optind;i<argc;i++,j++)list[j]=i;
      srandom(time(&t));

      while(listsize)
      {
	i=random()%listsize;
	play(argv[list[i]]);
	listsize--;
	list[i]=list[listsize];
      }

      return false;
    }
  }

  for(int i=optind;i<argc;i++)
    play(argv[i]);

  return 0;
}
