// array.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// These are "smart" arrays which are used in at least one filter or analysis
// routine.

#ifndef ARRAY_H
#ifdef __GNUG__
#pragma interface
#endif
#define ARRAY_H

#include <assert.h>

class OneDimensionalArray {
public:
	OneDimensionalArray(int cols) : columns(cols) { array = new double[cols]; }
	~OneDimensionalArray() { delete [] array; }
	double& operator [] (int column) {
		assert(column < columns);
		return *(array + column);
	}
	const OneDimensionalArray& operator = (const OneDimensionalArray& rhs);
private:
	short columns;
	double *array;
};

class TwoDimensionalArray {
public:
	TwoDimensionalArray(int rws, int cols);
	~TwoDimensionalArray();
	OneDimensionalArray& operator [] (int row) {
		assert(row < rows);
		return *(*(arrays + row));
	}
	const TwoDimensionalArray& operator = (const TwoDimensionalArray& rhs);
private:
	short rows;
	OneDimensionalArray** arrays;
};

extern double** create2DArray(int rows, int cols);

#endif

