// smpte.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "smpte.h"

SMPTE::Format
SMPTE::current_Format = SMPTE::Film;

double
SMPTE::frames_PerSecond[] = {
	24.0,		// Film
	25.0, 		// PAL/SECAM Video
	29.97,		// NTSC Color Video
	29.97,		// NTSC Wall Clock Color Video (Drop-Frame)
	30.0,		// 30 Frame
	30.0		// 30 Drop-Frame
};

const char *
SMPTE::formatNames() {
	return "|Film|PAL/SECAM Video|NTSC Color Video|NTSC Wall Clock Color Video|30 Frame|30 Drop-Frame|";
};

double
SMPTE::frames(double time) {
	return time * framesPerSecond();
}

double
SMPTE::framesPerSecond() { return frames_PerSecond[int(current_Format) - 1]; }

