/*********************************************************************

	mini.windows.c
	
	window functions for Miniedit
	
*********************************************************************/
#include <MacHeaders>

#ifdef OLDWINDOWS
#include "QuickDraw.h"
#include "MacTypes.h"
#include "WindowMgr.h"
#include "TextEdit.h"
#include "ControlMgr.h"
#include "EventMgr.h"
#endif

#include "macstuff.h"

#define windowID 		128

extern WindowRecord	 wRecord;
extern WindowPtr	 myWindow;
extern ControlHandle vScroll;
extern TEHandle 	 TEH;
extern char			 dirty;
extern Str255 		 theFileName;
extern int			 linesInFolder;

Point	theOrigin;

SetUpWindows()
{
	Rect	destRect, viewRect;
	Rect	vScrollRect;
	FontInfo	myInfo;
	int		height;
	
	SetPort((myWindow = GetNewWindow( windowID, &wRecord, (WindowPtr) -1L )));
	TextFont(4);
	TextSize(9);
	vScrollRect = (*myWindow).portRect;
	vScrollRect.left = vScrollRect.right-15;
	vScrollRect.right += 1;
	vScrollRect.bottom -= 14;
	vScrollRect.top -= 1;
	vScroll = NewControl( myWindow, &vScrollRect, "\p", 1, 0, 0, 0,
		scrollBarProc, 0L);
	viewRect = (*thePort).portRect;
	viewRect.right -= SBarWidth;
	viewRect.bottom -= SBarWidth;
	destRect = viewRect;
	InsetRect( &destRect, 4, 0 );
	GetFontInfo( &myInfo );
	height = myInfo.ascent+myInfo.descent+myInfo.leading;
	linesInFolder = 
		(viewRect.bottom-viewRect.top)/height;
	viewRect.bottom = linesInFolder*height;
	TEH = TENew( &destRect, &viewRect );
	SetPt( &theOrigin, 0, 0 );
	dirty = 0;
}

CloseMyWindow()
{
	HideWindow( myWindow );
	TESetSelect( 0, (**TEH).teLength, TEH );
	TEDelete( TEH );
	SetVScroll();
	SetUpFiles();
}

UpdateWindow(theWindow)
WindowPtr	theWindow;
{
	GrafPtr	savePort;
	
	GetPort( &savePort );
	SetPort( theWindow );
	SetVScroll();
	ScrollBits(theWindow);
	BeginUpdate( theWindow );
	DrawGrowIcon( theWindow );
	TEUpdate( &(**TEH).viewRect, TEH );
	DrawControls( theWindow );
	EndUpdate( theWindow );
	SetPort( savePort );
}

ScrollBits(theWindow)
WindowPtr	theWindow;
{
	Point		oldOrigin;
	RgnHandle	tmpRgn;
	int			dv;
	
	oldOrigin = theOrigin;
	theOrigin.v = (**TEH).lineHeight*GetCtlValue(vScroll);
	dv = oldOrigin.v - theOrigin.v;
	
	OffsetRect(&(**TEH).destRect, 0, dv);
	tmpRgn=NewRgn();
	if (dv!=0) {
		ScrollRect( &(**TEH).viewRect, 0, dv, tmpRgn );
		InvalRgn( tmpRgn );
	}
	DisposeRgn( tmpRgn );
}

SetVScroll()
{
	register int max, n;
	
	n=(**TEH).nLines-linesInFolder;
	if ( ((**TEH).teLength>0) &&
		( (*((**TEH).hText))[(**TEH).teLength-1]=='\r' )) n += 1;
	max = ( n>0 ? n : 0 ); 
		SetCtlMax( vScroll, max );
}

int	scrollCode;
int scrollAmt;

pascal void ScrollProc(ControlHandle theControl, int theCode)
/* ControlHandle	theControl;
int				theCode; 
*/
{
	int locVal;
	GrafPtr theWindow;
	
	if (theCode==scrollCode) {
		locVal = GetCtlValue(theControl);
		GetPort( &theWindow );
		SetVScroll();
		SetCtlValue( theControl, locVal+scrollAmt );
		UpdateWindow(myWindow);
	}
}

DoContent(theWindow, theEvent)
WindowPtr	theWindow;
EventRecord	*theEvent;
{
	int				cntlCode;
	ControlHandle 	theControl;
	int				pageSize;
	GrafPtr			savePort;
	
	GetPort(&savePort);
	SetPort(theWindow);
	GlobalToLocal( &(*theEvent).where );
	switch ( cntlCode = FindControl( (*theEvent).where, theWindow, &theControl ) ) {
	case inUpButton:
	case inDownButton:
	case inPageUp:
	case inPageDown:
		if (theControl==vScroll) {
			pageSize = ((**TEH).viewRect.bottom-(**TEH).viewRect.top) / 
					(**TEH).lineHeight - 1;
			switch (cntlCode) {
			case inUpButton: 
				scrollAmt = -1;
				break;
			case inDownButton: 
				scrollAmt = 1;
				break;
			case inPageUp: 
				scrollAmt = -pageSize;
				break;
			case inPageDown: 
				scrollAmt = pageSize;
				break;
			}
			scrollCode = cntlCode;
			if (TrackControl(theControl, (*theEvent).where, &ScrollProc)) ;
		}
		break;
	case inThumb:
		if (TrackControl(theControl, (*theEvent).where, 0L )) ;
		UpdateWindow(theWindow);
		break;
	default:
		if (PtInRect( (*theEvent).where, &(**TEH).viewRect ))
			TEClick( (*theEvent).where,
				(((*theEvent).modifiers & shiftKey )!=0), TEH);
	}
	SetPort(savePort);
}

MyGrowWindow( w, p )
WindowPtr w;
Point p;
{
	GrafPtr	savePort;
	Rect	oldRect, tempRect;
	long	theResult;
	Point	thePt;
	Rect 	r;
	
	GetPort( &savePort );
	SetPort( w );
	oldRect = (*w).portRect;
	SetRect(&tempRect, 80, 80, screenBits.bounds.right, 
			screenBits.bounds.bottom);
	theResult = GrowWindow( w, p, &tempRect );
	thePt.h = LoWord( theResult );
	thePt.v = HiWord( theResult );
	SizeWindow( w, thePt.h, thePt.v, 1 );
	InvalRect( &(*w).portRect );
	MoveControl( vScroll, (*w).portRect.right-SBarWidth, 
		(*w).portRect.top-1);
	SizeControl( vScroll, SBarWidth+1, 
		(*w).portRect.bottom-(*w).portRect.top-(SBarWidth-2));
	(**TEH).viewRect = (*w).portRect;
	(**TEH).viewRect.right -= SBarWidth+1;
	(**TEH).viewRect.bottom -= SBarWidth+1;
	(**TEH).destRect.right = (**TEH).viewRect.right;
	linesInFolder = 
		((**TEH).viewRect.bottom-(**TEH).viewRect.top)/(**TEH).lineHeight;
	(**TEH).viewRect.bottom = (**TEH).viewRect.top + 
				(**TEH).lineHeight*linesInFolder;
	EraseRect(&(*w).portRect);
	r = (*w).portRect;
	r.top = r.bottom - (SBarWidth+1);
	InvalRect(&r);
	TECalText( TEH );
	UpdateWindow(w);
	SetPort( savePort );
}

ShowSelect()
{
	register int	theLine, point;
	int				curLine, adjust;
	
	SetVScroll();
	curLine = GetCtlValue( vScroll );
	point = (**TEH).selStart;
	for (theLine=0; 
		((point<(**TEH).lineStarts[theLine]) || 
		(point>=(**TEH).lineStarts[theLine+1]))
		; theLine++ ) ;
	if ( (theLine<curLine ) || (theLine>(curLine+linesInFolder))) {
		adjust = (linesInFolder-1)/2;
		SetCtlValue( vScroll, theLine-adjust );
		}
	UpdateWindow(myWindow);
}